/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.keystore;

import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$ListFilter;
import com.ibm.gsk.ikeyman.command.FilterFactory;
import com.ibm.gsk.ikeyman.command.FilterFactory$Filter;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.keystore.CertSortComparator;
import com.ibm.gsk.ikeyman.keystore.EntryInterfaceFactory$AbstractEntryInterface;
import com.ibm.gsk.ikeyman.keystore.EntryInterfaceFactory$EntryInterface;
import com.ibm.gsk.ikeyman.keystore.EntryValidatorFactory;
import com.ibm.gsk.ikeyman.keystore.EntryValidatorFactory$EntryValidator;
import com.ibm.gsk.ikeyman.keystore.KeyCreatorFactory$KeyCreator;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateRequestKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.EntryFactory;
import com.ibm.gsk.ikeyman.keystore.entry.PrivateKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.PublicKeyItem;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem$ValidationMode;
import com.ibm.gsk.ikeyman.util.ComparatorFactory;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

class KeyStoreItemFactory$KeyStoreItemImpl
extends EntryInterfaceFactory$AbstractEntryInterface
implements KeyStoreItem {
    private static final Map entryValidators = new HashMap();
    protected EntryInterfaceFactory$EntryInterface entryInterface;
    private final Class castClass;
    private final KeyCreatorFactory$KeyCreator keyCreator;

    public KeyStoreItemFactory$KeyStoreItemImpl(EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface, DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, KeyCreatorFactory$KeyCreator keyCreatorFactory$KeyCreator, Class clazz) {
        super(entryInterfaceFactory$EntryInterface, databaseDescriptorFactory$DatabaseDescriptor);
        this.entryInterface = entryInterfaceFactory$EntryInterface;
        this.keyCreator = keyCreatorFactory$KeyCreator;
        this.castClass = clazz;
    }

    protected void addValidItem(Entry entry) throws KeyManagerException {
        this.entryInterface.add(entry);
        try {
            this.save();
        }
        catch (KeyManagerException keyManagerException) {
            this.entryInterface.delete(entry);
            throw keyManagerException;
        }
    }

    private void validateEntry(Entry entry, KeyStoreItem$ValidationMode keyStoreItem$ValidationMode) throws KeyManagerException {
        List list = this.getEntryValidators(keyStoreItem$ValidationMode);
        for (EntryValidatorFactory$EntryValidator entryValidatorFactory$EntryValidator : list) {
            entryValidatorFactory$EntryValidator.validate(entry, this);
        }
    }

    protected List getEntryValidators(KeyStoreItem$ValidationMode keyStoreItem$ValidationMode) {
        return (List)entryValidators.get((Object)keyStoreItem$ValidationMode);
    }

    public void addAll(Collection collection, boolean bl, boolean bl2, KeyStoreItem$ValidationMode keyStoreItem$ValidationMode) throws KeyManagerException {
        for (Entry entry : collection) {
            try {
                this.validateEntry(entry, keyStoreItem$ValidationMode);
                this.entryInterface.add(entry);
            }
            catch (KeyManagerException keyManagerException) {
                if (keyManagerException.getReason() == KeyManagerException$ExceptionReason.ENTRY_EXISTS_FOR_KEY && bl || keyManagerException.getReason() == KeyManagerException$ExceptionReason.INVALID_ENTRY_TYPE && bl2) continue;
                throw keyManagerException;
            }
        }
        this.save();
    }

    public void changePassword(CommandParameters commandParameters) throws KeyManagerException {
        this.entryInterface.changePassword(commandParameters);
        this.save();
    }

    public void addAllMissingSigners(CommandParameters commandParameters) throws KeyManagerException {
        this.entryInterface.addAllMissingSigners(commandParameters);
        this.save();
    }

    public boolean checkPassword(String string) {
        return this.entryInterface.getDescriptor().getPassword().equals(string);
    }

    public void clear() throws KeyManagerException {
        ArrayList arrayList = new ArrayList(this.entryInterface.getAliases());
        for (String string : arrayList) {
            this.entryInterface.delete(string);
        }
        this.save();
    }

    public void close() throws KeyManagerException {
        this.entryInterface.close();
    }

    public void delete() throws KeyManagerException {
        this.entryInterface.delete();
    }

    public Collection getAliases() {
        TreeSet treeSet = new TreeSet(ComparatorFactory.newCollatedStringComparator());
        treeSet.addAll(this.entryInterface.getAliases());
        return treeSet;
    }

    public CertificateItem getCertificate(String string) throws KeyManagerException {
        Entry entry = this.entryInterface.getItem(string);
        if (entry instanceof CertificateItem) {
            return (CertificateItem)entry;
        }
        throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_CERTIFICATE_FOR_LABEL, new String[]{string});
    }

    private static Collection getEntries(EntryInterfaceFactory$EntryInterface entryInterfaceFactory$EntryInterface, FilterFactory$Filter filterFactory$Filter, Class clazz) throws KeyManagerException {
        Entry entry;
        Object object2;
        ArrayList arrayList = new ArrayList();
        Collection collection = entryInterfaceFactory$EntryInterface.getAliases();
        ArrayList<Entry> arrayList2 = new ArrayList<Entry>();
        for (Object object2 : collection) {
            entry = entryInterfaceFactory$EntryInterface.getItem((String)object2);
            arrayList2.add(entry);
        }
        Collection collection2 = filterFactory$Filter.filter(arrayList2);
        object2 = collection2.iterator();
        while (object2.hasNext()) {
            entry = (Entry)object2.next();
            arrayList.add(clazz.cast(entry));
        }
        Collections.sort(arrayList, new CertSortComparator(entryInterfaceFactory$EntryInterface));
        return arrayList;
    }

    public DatabaseDescriptorFactory$DatabaseDescriptor getDescriptor() {
        return (DatabaseDescriptorFactory$DatabaseDescriptor)this.castClass.cast(this.entryInterface.getDescriptor());
    }

    public Entry getEntry(PublicKey publicKey) throws KeyManagerException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getCertificates());
        arrayList.addAll(this.getCertificateRequests());
        for (PublicKeyItem publicKeyItem : arrayList) {
            try {
                PublicKey publicKey2 = publicKeyItem.getPublicKey();
                if (!publicKey2.equals(publicKey)) continue;
                return (Entry)((Object)publicKeyItem);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        return null;
    }

    public Entry getCertificateKeyEntry(PublicKey publicKey) throws KeyManagerException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getCertificates());
        arrayList.addAll(this.getCertificateRequests());
        for (PublicKeyItem publicKeyItem : arrayList) {
            try {
                PublicKey publicKey2 = publicKeyItem.getPublicKey();
                if (!publicKey2.equals(publicKey) || !(publicKeyItem instanceof PrivateKeyItem)) continue;
                return (Entry)((Object)publicKeyItem);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
        }
        return null;
    }

    public Collection getCertificates() throws KeyManagerException {
        return KeyStoreItemFactory$KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getTypeFilter(CertificateItem.class), CertificateItem.class);
    }

    protected Collection getCertificateRequests() throws KeyManagerException {
        return KeyStoreItemFactory$KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getTypeFilter(CertificateRequestKeyItem.class), CertificateRequestKeyItem.class);
    }

    protected Collection getPersonalCerts() throws KeyManagerException {
        return KeyStoreItemFactory$KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getTypeFilter(CertificateKeyItem.class), CertificateKeyItem.class);
    }

    protected Collection getSecretKeys() throws KeyManagerException {
        return KeyStoreItemFactory$KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getTypeFilter(SecretKeyItem.class), SecretKeyItem.class);
    }

    public KeyStoreInfo getInfo() throws KeyManagerException {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getCertificates());
        arrayList.addAll(this.getCertificateRequests());
        arrayList.addAll(this.getSecretKeys());
        return new KeyStoreInfo(this.getDescriptor(), this.getKeyCreator(), arrayList, this.entryInterface.getSupportedTypes());
    }

    public String getPassword() {
        return this.getDescriptor().getPassword();
    }

    public Collection getSignerCerts() throws KeyManagerException {
        return KeyStoreItemFactory$KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getListWhichFilter(Constants$ListFilter.CA), CertificateItem.class);
    }

    public void verifyEntries(Collection collection, boolean bl, boolean bl2, KeyStoreItem$ValidationMode keyStoreItem$ValidationMode) throws KeyManagerException {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        for (Entry entry : collection) {
            if (!(entry instanceof PrivateKeyItem)) {
                CertificateItem certificateItem = (CertificateItem)entry;
                Entry entry2 = this.getCertificateKeyEntry(certificateItem.getPublicKey());
                if (entry2 != null) {
                    this.receiveCertificate(new ArrayList<CertificateItem>(Arrays.asList(certificateItem)));
                    continue;
                }
                arrayList.add(entry);
                continue;
            }
            arrayList.add(entry);
        }
        if (!arrayList.isEmpty()) {
            this.addAll(arrayList, bl, bl2, keyStoreItem$ValidationMode);
        }
    }

    public String receiveCertificate(Collection collection) throws KeyManagerException {
        Entry entry2;
        block7: {
            List list = EntryFactory.reorderCertChain(collection);
            ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
            for (Entry entry2 : list) {
                arrayList.add(entry2.getCert());
            }
            CertificateItem certificateItem = (CertificateItem)list.remove(0);
            entry2 = this.getCertificateKeyEntry(certificateItem.getPublicKey());
            if (entry2 == null) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_REQUEST_FOR_CERTIFICATE);
            }
            PrivateKey privateKey = ((PrivateKeyItem)((Object)entry2)).getPrivateKey();
            Certificate[] certificateArray = arrayList.toArray(new Certificate[0]);
            CertificateKeyItem certificateKeyItem = EntryFactory.newKeyItem(entry2.getLabel(), privateKey, certificateArray);
            try {
                ArrayList<CertificateItem> arrayList2 = new ArrayList<CertificateItem>();
                for (CertificateItem certificateItem2 : list) {
                    Entry entry3 = this.getCertificateKeyEntry(certificateItem2.getPublicKey());
                    if (entry3 != null) continue;
                    arrayList2.add(certificateItem2);
                }
                this.addAll(arrayList2, true, false, KeyStoreItem$ValidationMode.ADD);
                this.addValidItem(certificateKeyItem);
                this.refresh();
                if ((this.getDescriptor().getType() == Constants$DatabaseType.CMS || this.getDescriptor().getType() == Constants$DatabaseType.JKS || this.getDescriptor().getType() == Constants$DatabaseType.JCEKS) && entry2 instanceof CertificateRequestItem) {
                    this.delete(entry2);
                }
                if (entry2 instanceof PrivateKeyItem && !((PrivateKeyItem)((Object)entry2)).getPrivateKey().equals(certificateKeyItem.getPrivateKey())) {
                    this.delete(entry2);
                }
            }
            catch (KeyManagerException keyManagerException) {
                if (keyManagerException.getReason() == KeyManagerException$ExceptionReason.NO_REQUEST_FOR_LABEL) break block7;
                throw keyManagerException;
            }
        }
        return entry2.getLabel();
    }

    public void validate() throws KeyManagerException {
    }

    public boolean equals(Object object) {
        if (object instanceof String) {
            return this.getDescriptor().getFileName().equals(new File((String)object).getAbsolutePath());
        }
        return super.equals(object);
    }

    public Collection getEntries(Class clazz) throws KeyManagerException {
        return KeyStoreItemFactory$KeyStoreItemImpl.getEntries(this.entryInterface, FilterFactory.getTypeFilter(clazz), clazz);
    }

    public Entry getEntry(String string, Class clazz, KeyManagerException$ExceptionReason keyManagerException$ExceptionReason) throws KeyManagerException {
        Entry entry = this.entryInterface.getItem(string);
        if (clazz.isInstance(entry)) {
            return (Entry)clazz.cast(entry);
        }
        throw new KeyManagerException(keyManagerException$ExceptionReason, new String[]{string});
    }

    public boolean supportsEntry(Class clazz) {
        return this.entryInterface.getEntryBag(clazz) != null;
    }

    public void add(Entry entry) throws KeyManagerException {
        this.validateEntry(entry, KeyStoreItem$ValidationMode.ADD);
        this.addValidItem(entry);
    }

    public void delete(String string) throws KeyManagerException {
        super.delete(string);
        this.save();
    }

    public void delete(Entry entry) throws KeyManagerException {
        super.delete(entry);
        this.save();
    }

    protected void reload() throws CancelledException, KeyManagerException {
        this.entryInterface.refresh();
    }

    public void save() throws KeyManagerException {
        this.entryInterface.save();
    }

    public KeyCreatorFactory$KeyCreator getKeyCreator() {
        return this.keyCreator;
    }

    static {
        entryValidators.put(KeyStoreItem$ValidationMode.ADD, new ArrayList());
        entryValidators.put(KeyStoreItem$ValidationMode.IMPORT, new ArrayList());
        ((List)entryValidators.get((Object)KeyStoreItem$ValidationMode.ADD)).add(EntryValidatorFactory.newDuplicateLabelValidator());
        ((List)entryValidators.get((Object)KeyStoreItem$ValidationMode.IMPORT)).add(EntryValidatorFactory.newDuplicateKeyValidator());
        ((List)entryValidators.get((Object)KeyStoreItem$ValidationMode.IMPORT)).add(EntryValidatorFactory.newDuplicateLabelValidator());
    }
}

