/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.CertificateWriter$OutputMode;
import com.ibm.misc.BASE64Encoder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class CertificateWriter {
    public static final String BEGIN_CERT_TAG = "-----BEGIN CERTIFICATE-----";
    public static final String END_CERT_TAG = "-----END CERTIFICATE-----";
    private byte[] certData;
    private CertificateWriter$OutputMode mode;

    public CertificateWriter(X509Certificate x509Certificate, CertificateWriter$OutputMode certificateWriter$OutputMode) throws KeyManagerException {
        try {
            this.certData = x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.CERTIFICATE_ENCODING_ERROR, (Throwable)certificateEncodingException);
        }
        this.mode = certificateWriter$OutputMode;
    }

    public void write(File file) throws KeyManagerException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (SecurityException securityException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_WRITE_PERMISSION, securityException, new String[]{file.getAbsolutePath()});
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_FILE_CREATION_ERROR, fileNotFoundException, new String[]{file.getAbsolutePath()});
        }
        try {
            switch (this.mode) {
                case BinaryDER: {
                    this.writeBinary(fileOutputStream);
                    break;
                }
                case Base64EncodedAscii: {
                    this.writeASCII(fileOutputStream);
                }
            }
        }
        catch (KeyManagerException keyManagerException) {
            if (file.exists()) {
                file.delete();
            }
            keyManagerException.addDetail(file.getAbsolutePath());
            throw keyManagerException;
        }
    }

    public void append(File file) throws KeyManagerException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file, true);
        }
        catch (SecurityException securityException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_WRITE_PERMISSION, securityException, new String[]{file.getAbsolutePath()});
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_FILE_CREATION_ERROR, fileNotFoundException, new String[]{file.getAbsolutePath()});
        }
        try {
            switch (this.mode) {
                case BinaryDER: {
                    this.writeBinary(fileOutputStream);
                    break;
                }
                case Base64EncodedAscii: {
                    this.writeASCII(fileOutputStream);
                }
            }
        }
        catch (KeyManagerException keyManagerException) {
            if (file.exists()) {
                file.delete();
            }
            keyManagerException.addDetail(file.getAbsolutePath());
            throw keyManagerException;
        }
    }

    private void writeBinary(FileOutputStream fileOutputStream) throws KeyManagerException {
        try {
            fileOutputStream.write(this.certData);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_STREAM_WRITE_ERROR, (Throwable)iOException);
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_STREAM_CLOSE_ERROR, (Throwable)iOException);
        }
    }

    private void writeASCII(FileOutputStream fileOutputStream) throws KeyManagerException {
        PrintStream printStream = new PrintStream(fileOutputStream);
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        printStream.println(BEGIN_CERT_TAG);
        try {
            bASE64Encoder.encodeBuffer(this.certData, (OutputStream)printStream);
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_STREAM_WRITE_ERROR, (Throwable)iOException);
        }
        printStream.println(END_CERT_TAG);
        printStream.close();
    }
}

