/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.io;

import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$1;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$CertificateParser;
import com.ibm.gsk.ikeyman.io.CertificateParserFactory$UnsuitableParserException;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Collection;

class CertificateParserFactory$BinaryParser
implements CertificateParserFactory$CertificateParser {
    private CertificateParserFactory$BinaryParser() {
    }

    public Collection getCertificates(byte[] byArray, String string) throws KeyManagerException {
        try {
            CertificateFactory certificateFactory = null;
            certificateFactory = KeymanUtil.isIBMJCE() ? CertificateFactory.getInstance(KeymanUtil.getX509FormatIBM(), string) : CertificateFactory.getInstance(KeymanUtil.getX509FormatOracle());
            return certificateFactory.generateCertificates(new BufferedInputStream(new ByteArrayInputStream(byArray)));
        }
        catch (CertificateException certificateException) {
            Debug.throwing(certificateException);
            throw new CertificateParserFactory$UnsuitableParserException(null);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.NO_SUCH_PROVIDER, noSuchProviderException, new String[]{KeymanUtil.getJCEProviderName()});
        }
    }

    public Collection getCertificates(Object object, String string) throws KeyManagerException {
        return this.getCertificates((byte[])object, string);
    }

    CertificateParserFactory$BinaryParser(CertificateParserFactory$1 certificateParserFactory$1) {
        this();
    }
}

