/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$ListFilter;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.Constants$SignatureAlgorithms;
import com.ibm.gsk.ikeyman.command.LabelMap;
import com.ibm.gsk.ikeyman.error.InternalKeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.io.CertificateWriter$OutputMode;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory;
import com.ibm.gsk.ikeyman.keystore.entry.DisplayItemFactory$DNItem;
import com.ibm.gsk.ikeyman.keystore.entry.X509Version;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DescriptorType;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.PKIXExtensions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;

public class CommandParameters {
    private final Map parameters;
    private final DatabaseDescriptorFactory$DatabaseDescriptor sourceDescriptor;
    private final DatabaseDescriptorFactory$DatabaseDescriptor targetDescriptor;

    CommandParameters(Map map, DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor, DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor2) {
        this.parameters = map;
        this.sourceDescriptor = databaseDescriptorFactory$DatabaseDescriptor;
        this.targetDescriptor = databaseDescriptorFactory$DatabaseDescriptor2;
    }

    private Object getValue(Constants$Parameter constants$Parameter) throws KeyManagerException {
        if (this.parameters.containsKey(constants$Parameter)) {
            return this.parameters.get(constants$Parameter);
        }
        throw new InternalKeyManagerException(KeyManagerException$ExceptionReason.MISSING_PARAMETER, new String[]{constants$Parameter.toString()});
    }

    private void setValue(Constants$Parameter constants$Parameter, Object object) {
        if (this.parameters.containsKey(constants$Parameter)) {
            this.parameters.remove(constants$Parameter);
        }
        this.parameters.put(constants$Parameter, object);
    }

    private static boolean getBoolean(Object object) {
        return (Boolean)object;
    }

    private static int getInt(Object object) {
        return (Integer)object;
    }

    private static String getString(Object object) {
        return (String)object;
    }

    private static List getList(Object object) {
        String string = ((String)object).trim();
        String[] stringArray = string.split("[\\s,]+");
        return Arrays.asList(stringArray);
    }

    private static List getCommaList(Object object) {
        String string = ((String)object).trim();
        String[] stringArray = string.split(",");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : stringArray) {
            arrayList.add(string2.trim());
        }
        return arrayList;
    }

    public boolean isParameterPresent(Constants$Parameter constants$Parameter) {
        return this.parameters.containsKey(constants$Parameter);
    }

    public LabelMap getLabelMap() throws KeyManagerException {
        return (LabelMap)this.getValue(Constants$Parameter.LabelMap);
    }

    public DatabaseDescriptorFactory$DatabaseDescriptor getSourceDescriptor(CallbackHandler callbackHandler) throws KeyManagerException {
        if (this.sourceDescriptor != null) {
            return this.sourceDescriptor;
        }
        return DatabaseDescriptorFactory.getDatabaseDescriptor(this, callbackHandler, DatabaseDescriptorFactory$DescriptorType.Source);
    }

    public DatabaseDescriptorFactory$DatabaseDescriptor getTargetDescriptor(CallbackHandler callbackHandler) throws KeyManagerException {
        if (this.targetDescriptor != null) {
            return this.targetDescriptor;
        }
        return DatabaseDescriptorFactory.getDatabaseDescriptor(this, callbackHandler, DatabaseDescriptorFactory$DescriptorType.Target);
    }

    public String getCryptoPassword() throws KeyManagerException {
        if (this.isParameterPresent(Constants$Parameter.SecondPassword)) {
            return CommandParameters.getString(this.getValue(Constants$Parameter.SecondPassword));
        }
        return CommandParameters.getString(this.getValue(Constants$Parameter.Password));
    }

    public String getCrypto() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.Crypto));
    }

    public String getTokenLabel() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.TokenLabel));
    }

    public String getSecondaryDb() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.SecondaryDb));
    }

    public String getSecondaryDbPassword() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.SecondaryDbPassword));
    }

    public Constants$DatabaseType getType() throws KeyManagerException {
        return (Constants$DatabaseType)this.getValue(Constants$Parameter.Type);
    }

    public void setType(Constants$DatabaseType constants$DatabaseType) {
        this.setValue(Constants$Parameter.Type, constants$DatabaseType);
    }

    public String getDatabaseName() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.DatabaseName));
    }

    public String getPassword() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.Password));
    }

    public boolean isCa() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants$Parameter.CA));
    }

    public boolean isDefaultCert() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants$Parameter.DefaultCert));
    }

    public DisplayItemFactory$DNItem getDn() throws KeyManagerException {
        return (DisplayItemFactory$DNItem)this.getValue(Constants$Parameter.DN);
    }

    public boolean isEncryption() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants$Parameter.Encryption));
    }

    public int getExpire() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants$Parameter.Expire));
    }

    public int getExpiry() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants$Parameter.Expiry));
    }

    public String getFile() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.File));
    }

    public CertificateWriter$OutputMode getFormat() throws KeyManagerException {
        return (CertificateWriter$OutputMode)this.getValue(Constants$Parameter.Format);
    }

    public String getLabel() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.Label));
    }

    public List getLabels() throws KeyManagerException {
        return CommandParameters.getCommaList(this.getValue(Constants$Parameter.Label));
    }

    public Constants$ListFilter getListWhich() throws KeyManagerException {
        return (Constants$ListFilter)((Object)this.getValue(Constants$Parameter.ListFilter));
    }

    public String getNewLabel() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.NewLabel));
    }

    public String getNewPassword() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.NewPassword));
    }

    public DisplayItemFactory.SanItem getSan() throws KeyManagerException {
        List list = null;
        List list2 = null;
        List list3 = null;
        if (this.isParameterPresent(Constants$Parameter.SanEmailAddress)) {
            list = this.getSanEmailAddress();
        }
        if (this.isParameterPresent(Constants$Parameter.SanDnsName)) {
            list2 = this.getSanDnsNames();
        }
        if (this.isParameterPresent(Constants$Parameter.SanIpAddress)) {
            list3 = this.getSanIpAddresses();
        }
        return DisplayItemFactory.getSanItem(list, list2, list3);
    }

    public List getSanDnsNames() throws KeyManagerException {
        return CommandParameters.getList(this.getValue(Constants$Parameter.SanDnsName));
    }

    public List getSanEmailAddress() throws KeyManagerException {
        return CommandParameters.getList(this.getValue(Constants$Parameter.SanEmailAddress));
    }

    public List getSanIpAddresses() throws KeyManagerException {
        return CommandParameters.getList(this.getValue(Constants$Parameter.SanIpAddress));
    }

    public Integer getSerNum() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants$Parameter.SerNum));
    }

    public boolean isShowOid() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants$Parameter.ShowOID));
    }

    public int getSize() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants$Parameter.Size));
    }

    public String getTarget() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.Target));
    }

    public String getTargetPassword() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.TargetPassword));
    }

    public Constants$DatabaseType getTargetType() throws KeyManagerException {
        return (Constants$DatabaseType)this.getValue(Constants$Parameter.TargetType);
    }

    public boolean isTrust() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants$Parameter.Trust));
    }

    public X509Version getX509Ver() throws KeyManagerException {
        return (X509Version)this.getValue(Constants$Parameter.X509Version);
    }

    public Constants$DatabaseType getNewFormat() throws KeyManagerException {
        return (Constants$DatabaseType)this.getValue(Constants$Parameter.NewFormat);
    }

    public Constants$DatabaseType getOldFormat() throws KeyManagerException {
        return (Constants$DatabaseType)this.getValue(Constants$Parameter.OldFormat);
    }

    public int getRelativeSlotNumber() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants$Parameter.RelativeSlotNumber));
    }

    public Constants$DatabaseType getSecondaryDbType() throws KeyManagerException {
        return (Constants$DatabaseType)this.getValue(Constants$Parameter.SecondaryDbType);
    }

    public String getProviderClassName() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.ProviderClass));
    }

    public boolean isStash() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants$Parameter.StashPassword));
    }

    public boolean isV1Stash() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants$Parameter.StashV1Password));
    }

    public boolean isPfx() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants$Parameter.Pfx));
    }

    public String getKeyAlgorithm() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.KeyAlgorithm));
    }

    public int getKeySize() throws KeyManagerException {
        return CommandParameters.getInt(this.getValue(Constants$Parameter.KeySize));
    }

    public String getKeyAlias() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.KeyAlias));
    }

    public String getLabelRange() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.LabelRange));
    }

    public Constants$SignatureAlgorithms getSigAlg() throws KeyManagerException {
        return (Constants$SignatureAlgorithms)((Object)this.getValue(Constants$Parameter.SigAlg));
    }

    public boolean isPopulate() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants$Parameter.Populate));
    }

    public boolean isIBMCloudTrust() throws KeyManagerException {
        return CommandParameters.getBoolean(this.getValue(Constants$Parameter.IBMCloudTrust));
    }

    public String getAddTrust() throws KeyManagerException {
        return CommandParameters.getString(this.getValue(Constants$Parameter.AddTrust));
    }

    public Vector getExtendedKeyUsage() throws KeyManagerException {
        Vector<ObjectIdentifier> vector = new Vector<ObjectIdentifier>();
        try {
            String[] stringArray;
            for (String string : stringArray = CommandParameters.getString(this.getValue(Constants$Parameter.EKU)).split(",")) {
                if (string.equalsIgnoreCase("anyExtendedKeyUsage") || string.equalsIgnoreCase("any")) {
                    vector.add(new ObjectIdentifier("2.5.29.37.0"));
                    continue;
                }
                if (string.equalsIgnoreCase("serverAuth")) {
                    vector.add(PKIXExtensions.ServerAuth_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("clientAuth")) {
                    vector.add(PKIXExtensions.ClientAuth_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("codeSigning")) {
                    vector.add(PKIXExtensions.CodeSigning_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("emailProtection")) {
                    vector.add(PKIXExtensions.EmailProtection_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("ipsecEndSystem")) {
                    vector.add(PKIXExtensions.IPSecEndSystem_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("ipsecTunnel")) {
                    vector.add(PKIXExtensions.IPSecTunnel_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("ipsecUser")) {
                    vector.add(PKIXExtensions.IPSecUser_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("timeStamping")) {
                    vector.add(PKIXExtensions.TimeStamping_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("OCSPSigning")) {
                    vector.add(new ObjectIdentifier("1.3.6.1.5.5.7.3.9"));
                    continue;
                }
                if (string.equalsIgnoreCase("iKEIntermediate")) {
                    vector.add(new ObjectIdentifier("1.3.6.1.5.5.8.2.2"));
                    continue;
                }
                if (string.equalsIgnoreCase("microsoftSGC")) {
                    vector.add(PKIXExtensions.MicrosoftSGC_Id);
                    continue;
                }
                if (string.equalsIgnoreCase("netscapeSGC")) {
                    vector.add(PKIXExtensions.NetscapeSGC_Id);
                    continue;
                }
                throw new KeyManagerException(KeyManagerException$ExceptionReason.UNSUPPORTED_ENCODING);
            }
        }
        catch (InternalKeyManagerException internalKeyManagerException) {
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.UNSUPPORTED_ENCODING);
        }
        return vector;
    }

    public KeyUsageExtension getKeyUsage() throws KeyManagerException {
        KeyUsageExtension keyUsageExtension = null;
        String string = "";
        try {
            String[] stringArray = CommandParameters.getString(this.getValue(Constants$Parameter.KU)).split(",");
            keyUsageExtension = new KeyUsageExtension();
            for (String string2 : stringArray) {
                if (string2.equalsIgnoreCase("digitalsignature")) {
                    string2 = "digital_signature";
                } else if (string2.equalsIgnoreCase("nonrepudiation")) {
                    string2 = "non_repudiation";
                } else if (string2.equalsIgnoreCase("keyencipherment")) {
                    string2 = "key_encipherment";
                } else if (string2.equalsIgnoreCase("dataencipherment")) {
                    string2 = "data_encipherment";
                } else if (string2.equalsIgnoreCase("keyagreement")) {
                    string2 = "key_agreement";
                } else if (string2.equalsIgnoreCase("keycertsign")) {
                    string2 = "key_certsign";
                } else if (string2.equalsIgnoreCase("crlsign")) {
                    string2 = "crl_sign";
                } else if (string2.equalsIgnoreCase("encipheronly")) {
                    string2 = "encipher_only";
                } else if (string2.equalsIgnoreCase("decipheronly")) {
                    string2 = "decipher_only";
                }
                string = string2;
                keyUsageExtension.set(string2, (Object)true);
            }
        }
        catch (InternalKeyManagerException internalKeyManagerException) {
        }
        catch (IOException iOException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.UNSUPPORTED_ENCODING, new String[]{Constants$Parameter.KU.toString(), string});
        }
        return keyUsageExtension;
    }
}

