/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.Constants$DatabaseType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validatable;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validation;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory$DatabaseDescriptor;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStorePasswordStash;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.sequence.bytes.ByteSequenceXorFactory;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.FileName;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.io.IOException;
import java.text.MessageFormat;

class CommandFactory$StashDbPasswordCommand
extends Command {
    public CommandFactory$StashDbPasswordCommand(ParameterMap parameterMap) {
        super(parameterMap, ValidatorFactory.newValidator(new ValidatorFactory$Validation[]{ValidatorFactory.required(Constants$Parameter.DatabaseName, ValidatorFactory.always()), ValidatorFactory.optional(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Password, Constants$Parameter.Stashed}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Type, ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.StashV1Password, ValidatorFactory.always())}), null);
        Debug.entering();
        Debug.exiting();
    }

    public ControlObjectFactory$ControlObject run(CommandParameters commandParameters, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{commandParameters, keyManagerEventListener, displayer});
        DatabaseDescriptorFactory$DatabaseDescriptor databaseDescriptorFactory$DatabaseDescriptor = commandParameters.getSourceDescriptor(CommandFactory.access$200());
        KeyStoreItem keyStoreItem = this.getValidKeystoreItem(databaseDescriptorFactory$DatabaseDescriptor);
        if (keyStoreItem instanceof KeyStorePasswordStash) {
            if (commandParameters.isParameterPresent(Constants$Parameter.StashV1Password) || KeymanSettings$Setting.DefaultPasswordV1StashingState.getBoolean().booleanValue()) {
                ((KeyStorePasswordStash)((Object)keyStoreItem)).stashPassword(true);
            } else {
                ((KeyStorePasswordStash)((Object)keyStoreItem)).stashPassword(false);
            }
            this.fireKeyManagerEventDatabaseChanged(keyManagerEventListener, keyStoreItem);
        } else if (databaseDescriptorFactory$DatabaseDescriptor.getType().equals(Constants$DatabaseType.PKCS12) || databaseDescriptorFactory$DatabaseDescriptor.getType().equals(Constants$DatabaseType.PKCS12S2)) {
            try {
                if (commandParameters.isParameterPresent(Constants$Parameter.StashV1Password) || KeymanSettings$Setting.DefaultPasswordV1StashingState.getBoolean().booleanValue()) {
                    ByteSequenceXorFactory.stashKeyDbPwd(commandParameters.getPassword(), CommandFactory.getStashFileName(commandParameters.getDatabaseName()), true, CommandFactory$StashDbPasswordCommand.isPasswordStashed());
                }
                ByteSequenceXorFactory.stashKeyDbPwd(commandParameters.getPassword(), CommandFactory.getStashFileName(commandParameters.getDatabaseName()), false, CommandFactory$StashDbPasswordCommand.isPasswordStashed());
            }
            catch (IOException iOException) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR);
            }
        } else {
            KeyManagerException keyManagerException = new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_TYPE_FOR_ACTION, new String[]{Constants$CommandType.StashDBPassword.toString(), keyStoreItem.getDescriptor().getType().toString()});
            Debug.throwing(keyManagerException);
            throw keyManagerException;
        }
        ControlObjectFactory$ControlObject controlObjectFactory$ControlObject = ControlObjectFactory.newMessage(MessageFormat.format(Messages.getString("Message.StashFileCreated"), new FileName(commandParameters.getDatabaseName()).changeExtension(".sth")));
        CommandFactory.access$400(commandParameters.getDatabaseName());
        Debug.exiting(controlObjectFactory$ControlObject);
        return controlObjectFactory$ControlObject;
    }
}

