/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.FilterFactory;
import com.ibm.gsk.ikeyman.command.FilterFactory$Filter;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validatable;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validation;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.io.SecretKeyWriter;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.entry.SecretKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.util.Debug;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class CommandFactory$ExportSecretKeyCommand
extends Command {
    public CommandFactory$ExportSecretKeyCommand(ParameterMap parameterMap) {
        super(parameterMap, ValidatorFactory.newValidator(new ValidatorFactory$Validation[]{ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.DatabaseName, Constants$Parameter.TokenLabel, Constants$Parameter.RelativeSlotNumber}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Crypto, ValidatorFactory.not(ValidatorFactory.itemPresent(Constants$Parameter.DatabaseName))), ValidatorFactory.required(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Label, Constants$Parameter.LabelRange}), ValidatorFactory.always()), ValidatorFactory.required(Constants$Parameter.KeyAlias, ValidatorFactory.always()), ValidatorFactory.required(Constants$Parameter.File, ValidatorFactory.always()), ValidatorFactory.optional(ValidatorFactory.choice(new ValidatorFactory$Validatable[]{Constants$Parameter.Password, Constants$Parameter.Stashed}), ValidatorFactory.always()), ValidatorFactory.optional(Constants$Parameter.Type, ValidatorFactory.itemPresent(Constants$Parameter.DatabaseName))}), null);
    }

    protected ControlObjectFactory$ControlObject run(CommandParameters commandParameters, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{commandParameters, keyManagerEventListener, displayer});
        CommandFactory.access$000(commandParameters.getFile());
        KeyStoreItem keyStoreItem = this.getValidKeystoreItem(commandParameters.getSourceDescriptor(CommandFactory.access$200()));
        if (!keyStoreItem.supportsEntry(SecretKeyItem.class)) {
            KeyManagerException keyManagerException = new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_TYPE_FOR_ACTION, new String[]{Constants$CommandType.ExportSecretKey.toString(), keyStoreItem.getDescriptor().getType().toString()});
            Debug.throwing(keyManagerException);
            throw keyManagerException;
        }
        CertificateItem certificateItem = (CertificateItem)keyStoreItem.getEntry(commandParameters.getKeyAlias(), CertificateItem.class, KeyManagerException$ExceptionReason.NO_CERTIFICATE_FOR_LABEL);
        Collection collection = this.getKeys(keyStoreItem, commandParameters);
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(commandParameters.getFile()));
            SecretKeyWriter secretKeyWriter = new SecretKeyWriter(outputStream);
            for (Entry entry : collection) {
                SecretKeyItem secretKeyItem = (SecretKeyItem)entry;
                byte[] byArray = secretKeyItem.encryptKey(certificateItem.getPublicKey(), keyStoreItem.getKeyCreator().getProvider());
                secretKeyWriter.write(secretKeyItem.getLabel(), secretKeyItem.getAlgorithm(), byArray);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.OUTPUT_FILE_CREATION_ERROR, fileNotFoundException, new String[]{commandParameters.getFile()});
        }
        catch (IOException iOException) {
            if (iOException.getMessage() != null) {
                throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR_MSG, iOException, new String[]{iOException.getMessage()});
            }
            throw new KeyManagerException(KeyManagerException$ExceptionReason.IO_ERROR, (Throwable)iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    Debug.log(iOException.toString(), new Object[0]);
                }
            }
            CommandFactory.access$100(commandParameters.getFile());
        }
        Debug.exiting(null);
        return null;
    }

    private Collection getKeys(KeyStoreItem keyStoreItem, CommandParameters commandParameters) throws KeyManagerException {
        if (commandParameters.isParameterPresent(Constants$Parameter.LabelRange)) {
            Collection collection = keyStoreItem.getEntries(SecretKeyItem.class);
            FilterFactory$Filter filterFactory$Filter = FilterFactory.getAliasRangeFilter(commandParameters);
            return filterFactory$Filter.filter(collection);
        }
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        List list = commandParameters.getLabels();
        for (String string : list) {
            arrayList.add(keyStoreItem.getEntry(string, SecretKeyItem.class, KeyManagerException$ExceptionReason.NO_KEY_FOR_LABEL));
        }
        return arrayList;
    }
}

