/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command;

import com.ibm.gsk.ikeyman.command.Command;
import com.ibm.gsk.ikeyman.command.CommandFactory;
import com.ibm.gsk.ikeyman.command.CommandParameters;
import com.ibm.gsk.ikeyman.command.Constants$CommandType;
import com.ibm.gsk.ikeyman.command.Constants$Parameter;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory;
import com.ibm.gsk.ikeyman.command.ControlObjectFactory$ControlObject;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.ValidatorFactory$Validator;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.error.KeyManagerException$ExceptionReason;
import com.ibm.gsk.ikeyman.event.KeyManagerEventListener;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateItem;
import com.ibm.gsk.ikeyman.keystore.entry.CertificateKeyItem;
import com.ibm.gsk.ikeyman.keystore.ext.Displayer;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreDefaultCert;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreItem;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.Debug;
import com.ibm.gsk.ikeyman.util.KeymanSettings$Setting;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;

abstract class CommandFactory$DefaultableCommand
extends Command {
    Collection newCerts = null;

    protected CommandFactory$DefaultableCommand(ParameterMap parameterMap, ValidatorFactory$Validator validatorFactory$Validator, Map map) {
        super(parameterMap, validatorFactory$Validator, map);
        Debug.entering();
        Debug.exiting();
    }

    protected ControlObjectFactory$ControlObject run(CommandParameters commandParameters, KeyManagerEventListener keyManagerEventListener, Displayer displayer) throws KeyManagerException, CancelledException {
        Debug.entering(new Object[]{commandParameters, keyManagerEventListener, displayer});
        KeyStoreItem keyStoreItem = this.getValidKeystoreItem(commandParameters.getSourceDescriptor(CommandFactory.access$200()));
        if (commandParameters.isParameterPresent(Constants$Parameter.DefaultCert) && !(keyStoreItem instanceof KeyStoreDefaultCert)) {
            throw new KeyManagerException(KeyManagerException$ExceptionReason.INVALID_DATABASE_TYPE_FOR_PARAMETER, new String[]{Constants$Parameter.DefaultCert.toString(), keyStoreItem.getDescriptor().getType().toString()});
        }
        String string = this.addKey(keyStoreItem, commandParameters);
        ControlObjectFactory$ControlObject controlObjectFactory$ControlObject = null;
        ParameterMap parameterMap = keyStoreItem.getDescriptor().getDatabaseParameters(false);
        parameterMap.put(Constants$Parameter.Label, string);
        parameterMap.put(Constants$CommandType.SetDefaultCert);
        Command command = CommandFactory.getCommand(parameterMap);
        if (commandParameters.isParameterPresent(Constants$Parameter.DefaultCert) && commandParameters.isDefaultCert()) {
            command.invoke(this.loader, keyManagerEventListener, displayer);
        } else if (KeymanSettings$Setting.DefaultCertDefault.getBoolean() != null && keyStoreItem instanceof KeyStoreDefaultCert) {
            if (KeymanSettings$Setting.DefaultCertDefault.getBoolean().booleanValue()) {
                command.invoke(this.loader, keyManagerEventListener, displayer);
            }
        } else if (controlObjectsEnabled && keyStoreItem instanceof KeyStoreDefaultCert) {
            if (keyStoreItem.getEntries(CertificateKeyItem.class).size() > 1) {
                controlObjectFactory$ControlObject = ControlObjectFactory.newChoiceCommand(Messages.getString("Question.SetDefaultKey"), command, null);
            } else if (keyStoreItem.getEntries(CertificateKeyItem.class).size() == 1) {
                controlObjectFactory$ControlObject = ControlObjectFactory.newCommandObject(command);
            }
        }
        if (this.newCerts != null) {
            String string2 = CommandFactory.access$600(commandParameters, keyStoreItem, this.newCerts.toArray(new CertificateItem[0]));
            try {
                displayer.showMessage(MessageFormat.format(Messages.getString(string2), string));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.fireKeyManagerEventDatabaseChanged(keyManagerEventListener, keyStoreItem);
        Debug.exiting(controlObjectFactory$ControlObject);
        return controlObjectFactory$ControlObject;
    }

    protected abstract String addKey(KeyStoreItem var1, CommandParameters var2) throws KeyManagerException;
}

