/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.MessageDigest;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private static final long serialVersionUID = 6577238317307289933L;
    private byte[] key;
    private String algorithm;
    private static final String[] z;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SecretKeySpec(byte[] byArray, String string) {
        if (byArray == null) throw new IllegalArgumentException(z[12]);
        if (string == null) {
            throw new IllegalArgumentException(z[12]);
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException(z[11]);
        }
        this.key = (byte[])byArray.clone();
        this.algorithm = string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SecretKeySpec(byte[] byArray, int n, int n2, String string) {
        if (byArray == null) throw new IllegalArgumentException(z[10]);
        if (string == null) {
            throw new IllegalArgumentException(z[10]);
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException(z[7]);
        }
        if (byArray.length - n < n2) {
            throw new IllegalArgumentException(z[9]);
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(z[8]);
        }
        this.key = new byte[n2];
        System.arraycopy(byArray, n, this.key, 0, n2);
        this.algorithm = string;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return z[4];
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.key.length; ++i) {
            n += this.key[i] * i;
        }
        if (this.algorithm.equalsIgnoreCase(z[5])) {
            return n ^= z[6].hashCode();
        }
        return n ^= this.algorithm.toLowerCase().hashCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        String string = ((SecretKey)object).getAlgorithm();
        if (!(string.equalsIgnoreCase(this.algorithm) || string.equalsIgnoreCase(z[2]) && this.algorithm.equalsIgnoreCase(z[1]) || string.equalsIgnoreCase(z[3]) && this.algorithm.equalsIgnoreCase(z[0]))) {
            return false;
        }
        byte[] byArray = ((SecretKey)object).getEncoded();
        return MessageDigest.isEqual(this.key, byArray);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[13];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "\u0011af}F0";
        int n2 = -1;
        block20: while (true) {
            char[] cArray;
            block25: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block24: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block24;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block25;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c2 = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 85;
                                break;
                            }
                            case 1: {
                                n8 = 36;
                                break;
                            }
                            case 2: {
                                n8 = 53;
                                break;
                            }
                            case 3: {
                                n8 = 24;
                                break;
                            }
                            default: {
                                n8 = 34;
                            }
                        }
                        cArray4[n7] = (char)(c2 ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "\u0001V\\hN0`pK";
                    n2 = 0;
                    continue block20;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "\u0011af}F0";
                    n2 = 1;
                    continue block20;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "\u0001V\\hN0`pK";
                    n2 = 2;
                    continue block20;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "\u0007eb";
                    n2 = 3;
                    continue block20;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "\u0001V\\hN0`pK";
                    n2 = 4;
                    continue block20;
                }
                case 4: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 6;
                    string2 = "1AF}F0";
                    n2 = 5;
                    continue block20;
                }
                case 5: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 7;
                    string2 = "\u0010IEl[uOPa";
                    n2 = 6;
                    continue block20;
                }
                case 6: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 8;
                    string2 = "9A[8K&\u0004[}E4P\\nG";
                    n2 = 7;
                    continue block20;
                }
                case 7: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 9;
                    string2 = "\u001cJCyN<@\u0015wD3WPl\r9A[\u007fV=\u0004VwO7M[yV<K[";
                    n2 = 8;
                    continue block20;
                }
                case 8: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 10;
                    string2 = "\u0018MFkK;C\u0015yP2QX}L!";
                    n2 = 9;
                    continue block20;
                }
                case 9: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 11;
                    string2 = "\u0010IEl[uOPa";
                    n2 = 10;
                    continue block20;
                }
                case 10: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 12;
                    string2 = "\u0018MFkK;C\u0015yP2QX}L!";
                    n2 = 11;
                    continue block20;
                }
                case 11: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        z = stringArray3;
    }
}

