/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.util;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkAttrs;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.beans.PkCertGen;
import com.ibm.security.certclient.util.PkCertUtils;
import com.ibm.security.tools.CertAndKeyGen;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.AuthorityKeyIdentifierExtension;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CertificateExtensions;
import com.ibm.security.x509.CertificateSerialNumber;
import com.ibm.security.x509.CertificateVersion;
import com.ibm.security.x509.CertificateX509Key;
import com.ibm.security.x509.KeyIdentifier;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.SubjectKeyIdentifierExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import com.ibm.security.x509.X509CertInfo;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.GregorianCalendar;

public class PkCASetUp
implements PkConstants {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "PkCASetUp";
    public static final int CERT = 0;
    public static final int SERVER = 1;
    public static final int CRL = 2;
    public static final int CA = 3;
    public static final int CA_ALL = 4;
    private PrivateKey privateKey;
    private X509Key publicKey;
    private X500Name subjectName;
    private String sigAlg;
    private X509Certificate certificate;
    private String[] keyUsageType = new String[1];
    private long validity;
    private String providerName;

    public PkCASetUp(String string, String string2, String string3, int n, long l, String string4) throws GeneralSecurityException, IOException, PkException {
        X500Name x500Name = new X500Name(string);
        CertAndKeyGen certAndKeyGen = new CertAndKeyGen(string2, string3);
        certAndKeyGen.generate(n);
        Key key = certAndKeyGen.newGetPublicKey();
        PrivateKey privateKey = certAndKeyGen.getPrivateKey();
        KeyFactory keyFactory = null;
        X509Key x509Key = null;
        PrivateKey privateKey2 = null;
        if (string2.equalsIgnoreCase("rsa") || string2.equalsIgnoreCase("dsa")) {
            keyFactory = string2.equalsIgnoreCase("rsa") ? KeyFactory.getInstance("RSA", PkEeFactory.getProvider()) : KeyFactory.getInstance("DSA", PkEeFactory.getProvider());
            x509Key = (X509Key)keyFactory.translateKey(key);
            privateKey2 = (PrivateKey)keyFactory.translateKey(privateKey);
        } else {
            x509Key = (X509Key)key;
            privateKey2 = privateKey;
        }
        this.privateKey = privateKey2;
        this.publicKey = x509Key;
        this.subjectName = x500Name;
        this.sigAlg = string3;
        this.keyUsageType[0] = string4;
        this.validity = l * 1000L;
        this.setSelfSignedCert(new BigInteger("0"), x500Name, this.keyUsageType);
    }

    public PkCASetUp(String string, String string2, String string3, int n, long l, String[] stringArray, String string4) throws GeneralSecurityException, IOException, PkException {
        X500Name x500Name = new X500Name(string);
        this.providerName = string4;
        if (string4.equalsIgnoreCase("IBMJCE4758")) {
            this.keyPairGenerate(string2, n, string4);
            this.keyPairGenerate(string2, n, string4);
        } else {
            this.keyPairGenerate(string2, n, string4);
        }
        this.subjectName = x500Name;
        this.sigAlg = string3;
        this.keyUsageType = stringArray;
        this.validity = l * 1000L;
        this.setSelfSignedCert(new BigInteger("0"), x500Name, this.keyUsageType);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    private X509Key getPublicKey() {
        return this.publicKey;
    }

    private X500Name getSubjectName() {
        return this.subjectName;
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public String getSigAlg() {
        return this.sigAlg;
    }

    private byte[] getKID(boolean bl) throws NoSuchAlgorithmException {
        return PkCASetUp.computeKID((PublicKey)this.publicKey, bl);
    }

    private static int getOff(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        if (byArray.length < 2) {
            return byArray.length;
        }
        if ((byArray[1] & 0x80) == 0) {
            return 2;
        }
        return (byArray[1] & 0x7F) + 2;
    }

    public static byte[] computeKID(PublicKey publicKey, boolean bl) throws NoSuchAlgorithmException {
        byte[] byArray = publicKey.getEncoded();
        if (byArray == null) {
            return null;
        }
        int n = PkCASetUp.getOff(byArray) + 1;
        if (n >= byArray.length) {
            return null;
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
        messageDigest.update(byArray, n, byArray.length - n);
        if (bl) {
            byte[] byArray2 = messageDigest.digest();
            byte[] byArray3 = new byte[8];
            for (int i = 0; i < 8; ++i) {
                byArray3[i] = byArray2[i + byArray2.length - 8];
            }
            byArray3[0] = (byte)(byArray3[0] & 0xF | 0x40);
            return byArray3;
        }
        return messageDigest.digest();
    }

    private static AuthorityKeyIdentifierExtension computeAuthorityKID(PublicKey publicKey) throws NoSuchAlgorithmException, IOException {
        SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = null;
        byte[] byArray = PkCASetUp.computeKID(publicKey, false);
        subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(byArray);
        return new AuthorityKeyIdentifierExtension(new KeyIdentifier(byArray), null, null);
    }

    private static X509CertInfo makeCertInfo(X509Certificate x509Certificate) throws CertificateException, IOException {
        byte[] byArray = x509Certificate.getEncoded();
        try {
            return new X509CertInfo(byArray);
        }
        catch (CertificateParsingException certificateParsingException) {
            if (debug != null) {
                debug.exception(1L, className, "makeCertInfo", (Throwable)certificateParsingException);
            }
            DerInputStream derInputStream = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream.getSequence(3);
            return new X509CertInfo(derValueArray[0]);
        }
    }

    private void setSelfSignedCert(BigInteger bigInteger, X500Name x500Name, String[] stringArray) throws GeneralSecurityException, IOException, PkException {
        if (this.publicKey == null) {
            throw new PkException(PkNLSConstants.CASETUP_PUBLICKEY_NULL);
        }
        PkCertGen pkCertGen = new PkCertGen(PkEeFactory.getProvider());
        PkAttrs pkAttrs = new PkAttrs();
        pkAttrs.add("cert.oper.privateKey", 2, this.privateKey);
        int n = 3;
        pkAttrs.add("x509.info.version", n, CERT_VERSION_3);
        pkAttrs.add("x509.info.serialNumber", n, bigInteger);
        pkAttrs.add("x509.info.algorithmID", n, AlgorithmId.get((String)this.sigAlg));
        pkAttrs.add("x509.info.issuer", n, x500Name);
        pkAttrs.add("x509.info.validity.notBefore", n, new Date());
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = gregorianCalendar.getTime();
        long l = date.getTime();
        date.setTime(l += this.validity);
        if (debug != null) {
            debug.text(0L, className, "setSelfSignedCert", "notAfter {0}", (Object)date);
        }
        pkAttrs.add("x509.info.validity.notAfter", n, date);
        pkAttrs.add("x509.info.subject", n, this.subjectName);
        pkAttrs.add("x509.info.key", n, this.publicKey);
        if (this.publicKey == null) {
            throw new PkException(PkNLSConstants.CASETUP_PUBLICKEY_NULL);
        }
        KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
        for (int i = 0; i < stringArray.length; ++i) {
            keyUsageExtension.set(stringArray[i], (Object)Boolean.TRUE);
        }
        pkAttrs.add("x509.info.extensions.KeyUsage", 3, keyUsageExtension);
        BasicConstraintsExtension basicConstraintsExtension = new BasicConstraintsExtension(true, 1);
        pkAttrs.add("x509.info.extensions.BasicConstraints", 3, basicConstraintsExtension);
        SubjectKeyIdentifierExtension subjectKeyIdentifierExtension = null;
        byte[] byArray = PkCASetUp.computeKID((PublicKey)this.publicKey, false);
        subjectKeyIdentifierExtension = new SubjectKeyIdentifierExtension(byArray);
        AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension = new AuthorityKeyIdentifierExtension(new KeyIdentifier(byArray), null, null);
        pkAttrs.add("x509.info.extensions.SubjectKeyIdentifier", 3, subjectKeyIdentifierExtension);
        pkAttrs.add("x509.info.extensions.AuthorityKeyIdentifier", 3, authorityKeyIdentifierExtension);
        PkCertReqEvent pkCertReqEvent = new PkCertReqEvent("", null, pkAttrs);
        PkCertRepEvent pkCertRepEvent = null;
        try {
            pkCertRepEvent = (PkCertRepEvent)pkCertReqEvent.executeOn(pkCertGen);
        }
        catch (PkException pkException) {
            pkException.printStackTrace();
        }
        this.certificate = (X509Certificate)pkCertRepEvent.getCert();
    }

    public X509Certificate recertify(X509Certificate x509Certificate, int n, PrivateKey privateKey, Date date, Date date2, String string) throws GeneralSecurityException {
        boolean bl = true;
        try {
            CertificateX509Key certificateX509Key;
            X509CertInfo x509CertInfo = PkCASetUp.makeCertInfo(x509Certificate);
            bl = false;
            X509CertInfo x509CertInfo2 = PkCASetUp.makeCertInfo(this.certificate);
            boolean bl2 = false;
            CertificateExtensions certificateExtensions = new CertificateExtensions();
            Date date3 = new Date();
            x509CertInfo.set("version", (Object)new CertificateVersion(2));
            x509CertInfo.set("serialNumber", (Object)new CertificateSerialNumber(0));
            x509CertInfo.set("algorithmID", x509CertInfo2.get("algorithmID"));
            x509CertInfo.set("issuer", x509CertInfo2.get("issuer"));
            KeyUsageExtension keyUsageExtension = new KeyUsageExtension();
            switch (n) {
                case 1: {
                    keyUsageExtension.set("key_encipherment", (Object)Boolean.TRUE);
                }
                case 0: {
                    keyUsageExtension.set("digital_signature", (Object)Boolean.TRUE);
                    break;
                }
                case 4: {
                    keyUsageExtension.set("crl_sign", (Object)Boolean.TRUE);
                }
                case 3: {
                    keyUsageExtension.set("key_certsign", (Object)Boolean.TRUE);
                    bl2 = true;
                    break;
                }
                case 2: {
                    keyUsageExtension.set("crl_sign", (Object)Boolean.TRUE);
                    bl2 = true;
                    break;
                }
                default: {
                    throw new CertificateEncodingException(PkNLSConstants.CASETUP_BAD_KEY_USAGE);
                }
            }
            certificateExtensions.set("x509.info.extensions.KeyUsage", (Object)keyUsageExtension);
            certificateExtensions.set("x509.info.extensions.BasicConstraints", (Object)new BasicConstraintsExtension(true, 1));
            Object var15_16 = null;
            byte[] byArray = null;
            try {
                certificateX509Key = (CertificateX509Key)x509CertInfo.get("key");
                byArray = PkCASetUp.computeKID(certificateX509Key.get("value"), false);
            }
            catch (GeneralSecurityException generalSecurityException) {
                // empty catch block
            }
            if (byArray != null && bl2) {
                certificateExtensions.set("x509.info.extensions.SubjectKeyIdentifier", (Object)new SubjectKeyIdentifierExtension(byArray));
                certificateExtensions.set("x509.info.extensions.AuthorityKeyIdentifier", (Object)new AuthorityKeyIdentifierExtension(new KeyIdentifier(byArray), null, null));
            }
            if (!bl2) {
                try {
                    certificateX509Key = (CertificateX509Key)x509CertInfo.get("key");
                    byArray = PkCASetUp.computeKID(certificateX509Key.get("value"), false);
                    if (byArray != null) {
                        certificateExtensions.set("x509.info.extensions.SubjectKeyIdentifier", (Object)new SubjectKeyIdentifierExtension(byArray));
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                    // empty catch block
                }
            }
            x509CertInfo.set("extensions", (Object)certificateExtensions);
            X509CertImpl x509CertImpl = new X509CertImpl(x509CertInfo);
            if (date != null) {
                x509CertImpl.set("x509.info.validity.notBefore", (Object)date);
            }
            if (date2 != null) {
                x509CertImpl.set("x509.info.validity.notAfter", (Object)date2);
            }
            x509CertImpl.sign(privateKey, this.sigAlg, string);
            return x509CertImpl;
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(PkNLSConstants.CASETUP_RECERTIFICATION_FAILED + iOException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            if (bl) {
                System.err.println(x509Certificate.toString());
            } else {
                System.err.println(this.certificate.toString());
            }
            throw generalSecurityException;
        }
    }

    public void keyPairGenerate(String string, int n, String string2) throws GeneralSecurityException {
        try {
            Key[] keyArray = PkCertUtils.generateKeyPair(string, n, string2);
            this.publicKey = (X509Key)keyArray[0];
            this.privateKey = (PrivateKey)keyArray[1];
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

