/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.beans;

import com.ibm.security.certclient.base.PkEventFormatter;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkNLSConstants;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkRepEvent;
import com.ibm.security.certclient.base.PkReqEvent;
import com.ibm.security.certclient.util.PkPool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import javax.net.SocketFactory;

public class PkTcpClient
extends PkPipe {
    private final String host;
    private final int port;
    private final PkEventFormatter eventFormatter;
    private final SocketFactory socketFactory;
    private int numConns;
    private PkPool conns;
    private int numberOfConnectionsActuallyPushed;

    public PkTcpClient(String string, int n, PkEventFormatter pkEventFormatter, int n2) throws PkException {
        this.host = string;
        this.port = n;
        this.eventFormatter = pkEventFormatter;
        this.numConns = n2;
        this.numberOfConnectionsActuallyPushed = 0;
        if (this.numConns <= 0) {
            PkException pkException = new PkException(PkNLSConstants.NUMBER_OF_CONNS_INVALID);
            throw pkException;
        }
        this.socketFactory = SocketFactory.getDefault();
        this.conns = new PkPool();
        this.connect();
    }

    public PkTcpClient(String string, int n, PkEventFormatter pkEventFormatter, int n2, SocketFactory socketFactory) throws PkException {
        this.host = string;
        this.port = n;
        this.eventFormatter = pkEventFormatter;
        this.numConns = n2;
        this.numberOfConnectionsActuallyPushed = 0;
        if (this.numConns <= 0) {
            PkException pkException = new PkException(PkNLSConstants.NUMBER_OF_CONNS_INVALID);
            throw pkException;
        }
        this.socketFactory = socketFactory;
        this.conns = new PkPool();
        this.connect();
    }

    public void finalize() throws PkException {
        this.close();
    }

    public synchronized void close() throws PkException {
        while (this.numberOfConnectionsActuallyPushed > 0) {
            TcpConn tcpConn = (TcpConn)this.conns.pop();
            try {
                tcpConn.out.close();
                tcpConn.in.close();
                tcpConn.socket.close();
            }
            catch (IOException iOException) {
                throw new PkException(PkNLSConstants.TCPCLIENT_FAILED_CONNECTION_TO_HOST + this.host + ":" + this.port, iOException);
            }
            finally {
                --this.numberOfConnectionsActuallyPushed;
            }
        }
    }

    @Override
    public synchronized PkRepEvent doReq(PkReqEvent pkReqEvent) throws PkException {
        TcpConn tcpConn = (TcpConn)this.conns.pop();
        --this.numberOfConnectionsActuallyPushed;
        try {
            try {
                pkReqEvent.write(this.eventFormatter, tcpConn.out);
                tcpConn.out.flush();
            }
            catch (IOException iOException) {
                this.connect();
                try {
                    pkReqEvent.write(this.eventFormatter, tcpConn.out);
                    tcpConn.out.flush();
                }
                catch (IOException iOException2) {
                    throw new PkException(PkNLSConstants.TCPCLIENT_ERROR_SENDING_REQUEST, iOException2);
                }
            }
            try {
                PkRepEvent pkRepEvent;
                PkRepEvent pkRepEvent2 = pkRepEvent = (PkRepEvent)this.eventFormatter.readEvent(this, tcpConn.in, pkReqEvent);
                return pkRepEvent2;
            }
            catch (IOException iOException) {
                this.connect();
                throw new PkException(PkNLSConstants.TCPCLIENT_ERROR_RECEIVING_REPLY, iOException);
            }
        }
        finally {
            this.conns.push(tcpConn);
            ++this.numberOfConnectionsActuallyPushed;
        }
    }

    private synchronized void connect() throws PkException {
        long l = new Date().getTime() + 60000L;
        boolean bl = true;
        if (this.numConns <= 0) {
            PkException pkException = new PkException(PkNLSConstants.NUMBER_OF_CONNS_INVALID);
            throw pkException;
        }
        for (int i = 0; i < this.numConns; ++i) {
            while (bl) {
                try {
                    TcpConn tcpConn = new TcpConn();
                    tcpConn.socket = this.socketFactory.createSocket(this.host, this.port);
                    tcpConn.in = new BufferedInputStream(tcpConn.socket.getInputStream());
                    tcpConn.out = new BufferedOutputStream(tcpConn.socket.getOutputStream());
                    this.conns.push(tcpConn);
                    ++this.numberOfConnectionsActuallyPushed;
                    bl = false;
                }
                catch (IOException iOException) {
                    if (new Date().getTime() < l) {
                        try {
                            this.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    throw new PkException(PkNLSConstants.TCPCLIENT_FAILED_CONNECTION_TO_HOST + this.host + ":" + this.port, iOException);
                }
            }
        }
    }

    private final class TcpConn {
        private Socket socket;
        private InputStream in;
        private OutputStream out;

        private TcpConn() {
        }
    }
}

