/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.certclient.beans;

import com.ibm.misc.Debug;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.base.PkCertRepEvent;
import com.ibm.security.certclient.base.PkCertReqEvent;
import com.ibm.security.certclient.base.PkConstants;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.certclient.base.PkPipe;
import com.ibm.security.certclient.base.PkXcerReqEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PkCertPath
extends PkPipe
implements PkConstants {
    private static Debug debug = Debug.getInstance((String)"keycertmanage");
    private static final Object className = "com.ibm.security.certclient.PkCertPath";
    private KeyStore kStore;
    private PKIXParameters pkixParms;

    public PkCertPath(String string, String string2, char[] cArray) throws PkException {
        block8: {
            this.kStore = null;
            this.pkixParms = null;
            try {
                this.kStore = KeyStore.getInstance(string, PkEeFactory.getProvider());
                this.kStore.load(new FileInputStream(string2), cArray);
                this.setPKIXParms();
            }
            catch (KeyStoreException keyStoreException) {
                if (debug != null) {
                    debug.text(0L, className, "PkCertPath", "KeyStoreException. keyStoreType {0}", (Object)string);
                    debug.exception(0L, className, "PkCertPath", (Throwable)keyStoreException);
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                if (debug != null) {
                    debug.text(0L, className, "PkCertPath", "GeneralSecurityException. file {0}", (Object)string2);
                    debug.exception(0L, className, "PkCertPath", (Throwable)generalSecurityException);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (debug != null) {
                    debug.text(0L, className, "PkCertPath", "FileNotFoundException for file {0}", (Object)string2);
                    debug.exception(0L, className, "PkCertPath", (Throwable)fileNotFoundException);
                }
            }
            catch (IOException iOException) {
                if (debug == null) break block8;
                debug.text(0L, className, "PkCertPath", "IOException from file {0}", (Object)string2);
                debug.exception(0L, className, "PkCertPath", (Throwable)iOException);
            }
        }
    }

    @Override
    public PkCertRepEvent doCertReq(PkCertReqEvent pkCertReqEvent) throws PkException {
        PkCertRepEvent pkCertRepEvent = this.propagate(pkCertReqEvent);
        if (this.pkixParms != null && !(pkCertReqEvent instanceof PkXcerReqEvent)) {
            this.validateCert(pkCertRepEvent);
        }
        return pkCertRepEvent;
    }

    private boolean validateCert(PkCertRepEvent pkCertRepEvent) throws PkException {
        boolean bl = false;
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509", "IBMCertPath");
            Certificate[] certificateArray = new Certificate[]{pkCertRepEvent.getCert()};
            List<Certificate> list = Arrays.asList(certificateArray);
            CertPath certPath = certificateFactory.generateCertPath(list);
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            certPathValidator.validate(certPath, this.pkixParms);
            bl = true;
            if (debug != null) {
                debug.text(0L, className, "validateCert", "certpath validated");
            }
        }
        catch (CertPathValidatorException certPathValidatorException) {
            if (debug != null) {
                debug.text(0L, className, "validateCert", "WARNING:certpath could not be validated.The issuer of this certificate is not trusted");
                debug.exception(0L, className, "validateCert", (Throwable)certPathValidatorException);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PkException(generalSecurityException);
        }
        return bl;
    }

    private void setPKIXParms() throws PkException {
        Object object;
        Enumeration<String> enumeration = null;
        try {
            enumeration = this.kStore.aliases();
        }
        catch (Exception exception) {
            throw new PkException(exception);
        }
        try {
            object = CertPathValidator.getInstance("PKIX");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PkException(noSuchAlgorithmException);
        }
        object = new HashSet();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            try {
                if (!this.kStore.isCertificateEntry(string)) continue;
                TrustAnchor trustAnchor = new TrustAnchor((X509Certificate)this.kStore.getCertificate(string), null);
                object.add(trustAnchor);
            }
            catch (Exception exception) {
                throw new PkException(exception);
            }
        }
        this.pkixParms = null;
        if (!object.isEmpty()) {
            try {
                this.pkixParms = new PKIXParameters((Set<TrustAnchor>)object);
                this.pkixParms.setRevocationEnabled(false);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PkException(generalSecurityException);
            }
        }
    }
}

