/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TraceFormat;
import com.ibm.jvm.format.TracePoint;
import com.ibm.jvm.format.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Vector;

public class TraceRecord50
implements Comparable {
    public static final int INTERNAL_WRAP_SPLIT_TP = -1;
    public static final int EXTERNAL_WRAP_SPLIT_TP = -2;
    private BigInteger timeStamp;
    private BigInteger wrapTime;
    private BigInteger writePlatform = BigInteger.ZERO;
    private BigInteger writeSystem = BigInteger.ZERO;
    private long threadID = 0L;
    private long threadSyn1 = 0L;
    private long threadSyn2 = 0L;
    private int firstEntry;
    private int nextEntry;
    private String threadName;
    private BigInteger upperTimeWord = BigInteger.ZERO;
    private String threadIDString = null;
    private String fromFileName = null;
    private long offsetInFile = -1L;
    private int bufferLength = -1;
    private int traceRecordType = -1;
    private Vector tps = new Vector();
    private int dataStart;
    private int dataEnd;
    private int dataLength;
    private byte[] overspillData = null;
    private BigInteger overspillUpperWord = null;
    private boolean primed = false;
    private byte[] traceRecordBytes;
    private TraceFile traceFile;
    private int offset;
    private int tplength;
    private long absolutePositionInFile;
    private byte[] dataAtEndOfBuffer;
    private boolean isMiddleOfTracePoint = false;
    private long lostRecordCount = 0L;
    private BigInteger earliestTimeStamp = null;

    public int processTraceBufferHeader(TraceFile traceFile, long start, int bufferLength) throws IOException {
        this.fromFileName = traceFile.toString();
        this.offsetInFile = start;
        this.bufferLength = bufferLength;
        this.traceFile = traceFile;
        traceFile.seek(start);
        this.timeStamp = traceFile.readBigInteger(8);
        this.wrapTime = traceFile.readBigInteger(8);
        this.writePlatform = traceFile.readBigInteger(8);
        this.writeSystem = traceFile.readBigInteger(8);
        this.threadID = traceFile.readL();
        this.threadSyn1 = traceFile.readL();
        this.threadSyn2 = traceFile.readL();
        this.firstEntry = traceFile.readI();
        this.nextEntry = traceFile.readI();
        this.threadName = traceFile.readString(this.firstEntry - 64);
        this.upperTimeWord = this.timeStamp.shiftRight(32);
        this.threadIDString = Util.formatAsHexString(this.threadID);
        this.dataStart = this.firstEntry;
        this.dataEnd = this.nextEntry;
        if (this.dataEnd < 0) {
            this.isMiddleOfTracePoint = true;
            this.dataLength = bufferLength - this.dataStart;
            Util.Debug.println("Found a middle section - dataLength == " + this.dataLength);
        } else {
            this.dataLength = this.dataEnd - this.dataStart;
        }
        if (this.nextEntry >= 0 && (this.nextEntry < this.dataStart || this.nextEntry > bufferLength)) {
            this.dataLength = 0;
            ++TraceFormat.invalidBuffers;
        }
        Util.Debug.println("Buffer is at offset " + Long.toHexString(start) + " in " + traceFile);
        Util.Debug.println("  First TracePoint in buffer is at offset " + this.firstEntry);
        Util.Debug.println("  Last TracePoint in buffer is at offset  " + this.nextEntry);
        Util.Debug.println("  timeStamp:    " + this.timeStamp);
        Util.Debug.println("  wrapTime:     " + this.wrapTime);
        Util.Debug.println("  writePlatform " + this.writePlatform);
        Util.Debug.println("  writeSystem   " + this.writeSystem);
        if (this.writePlatform.compareTo(TraceFormat.lastWritePlatform) > 0) {
            Util.Debug.println("updating lastWritePlatform" + this.writePlatform);
            Util.Debug.println("updating lastWriteSystem  " + this.writeSystem);
            TraceFormat.lastWritePlatform = this.writePlatform;
            TraceFormat.lastWriteSystem = this.writeSystem;
        }
        if (this.wrapTime.compareTo(TraceFormat.first) < 0) {
            TraceFormat.first = this.wrapTime;
        }
        if (this.timeStamp.compareTo(TraceFormat.last) > 0) {
            TraceFormat.last = this.timeStamp;
        }
        if (this.writeSystem.compareTo(traceFile.lastWriteSystem) > 0) {
            traceFile.lastWriteSystem = this.writeSystem;
            traceFile.wrapOffset = start;
        }
        return 1;
    }

    public TracePoint getNextTracePoint() {
        TracePoint tp = null;
        if (!this.primed) {
            try {
                this.primeRecord(this.traceFile);
                this.primed = true;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (this.tps.isEmpty()) {
            Util.Debug.println("Reached end of buffer ");
            tp = null;
        } else {
            tp = (TracePoint)this.tps.elementAt(0);
            this.tps.removeElementAt(0);
        }
        return tp;
    }

    public boolean addOverspillData(byte[] overspillFromPreviousBuffer, BigInteger upperWord) {
        this.overspillData = overspillFromPreviousBuffer;
        return true;
    }

    public boolean isMiddleOfTracePoint() {
        return this.isMiddleOfTracePoint;
    }

    public byte[] getExtraData() {
        if (this.isMiddleOfTracePoint) {
            if (!this.primed) {
                try {
                    this.primeRecord(this.traceFile);
                    this.primed = true;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return null;
                }
            }
            if (this.traceRecordBytes != null) {
                Util.Debug.println("returning " + this.traceRecordBytes.length + " bytes of middle");
            } else {
                Util.Debug.println("returning some null stuff for the middle");
            }
            return this.traceRecordBytes;
        }
        return this.dataAtEndOfBuffer;
    }

    private byte[] readRecord(TraceFile traceFile) throws IOException {
        int dataLeftAtEndOfBufLength;
        this.absolutePositionInFile = this.offsetInFile + (long)this.dataStart;
        traceFile.seek(this.absolutePositionInFile);
        long startOfExtraData = 0L;
        byte[] recordBytes = new byte[this.dataLength + 1];
        int dataread = traceFile.read(recordBytes);
        if (dataread != this.dataLength + 1) {
            System.err.println("*** Incorrect data length read, expecting " + (this.dataLength + 1) + " found " + dataread + " skipping this TraceBuffer");
            throw new IOException("Can't read record from tracefile");
        }
        if (this.dataEnd < 0) {
            Util.Debug.println("this is the middle - dataLength == " + this.dataLength);
            Util.Debug.println("dataStart " + this.dataStart + " dataEnd " + this.dataEnd + " bufferLength " + this.bufferLength);
            this.dataEnd = this.dataStart;
        }
        if ((dataLeftAtEndOfBufLength = this.bufferLength - this.dataEnd) > 0) {
            this.dataAtEndOfBuffer = new byte[dataLeftAtEndOfBufLength];
            startOfExtraData = (long)this.dataEnd + this.offsetInFile;
            traceFile.seek(startOfExtraData);
            dataread = traceFile.read(this.dataAtEndOfBuffer);
            if (dataread != dataLeftAtEndOfBufLength) {
                TraceFormat.outStream.println("*** Can't read the last " + dataLeftAtEndOfBufLength + "bytes from a trace record. Record begins at file offset " + this.offsetInFile + " data to be read should start at " + this.dataEnd);
                TraceFormat.outStream.println("  * will continue processing the remainder of the buffer");
            } else {
                Util.Debug.println("Read some excess data from end of buffer at offset " + ((long)this.dataEnd + this.offsetInFile) + " in " + traceFile);
            }
        }
        return recordBytes;
    }

    public boolean primeRecord(TraceFile traceFile) throws IOException {
        this.traceRecordBytes = this.readRecord(traceFile);
        this.offset = this.traceRecordBytes.length - 1;
        if (this.offset < 0) {
            return true;
        }
        long endOfCurrentTP = this.absolutePositionInFile + (long)this.offset;
        long startOfCurrentTP = -3L;
        TracePoint sp = null;
        byte[] tpdata = new byte[this.bufferLength];
        boolean recordHasWrapped = false;
        boolean longTPLen = false;
        if (this.traceRecordBytes[0] == 0 && this.traceRecordBytes[1] == 0 && this.traceRecordBytes[2] == 1 && this.traceRecordBytes[3] == 0 && this.traceRecordBytes.length >= 8) {
            this.lostRecordCount = Util.constructUnsignedInt(this.traceRecordBytes, 4);
            TraceFormat.lostRecordCount += this.lostRecordCount;
            this.overspillData = null;
        }
        do {
            if (!longTPLen) {
                this.tplength = Util.constructUnsignedByte(this.traceRecordBytes, this.offset);
            }
            longTPLen = false;
            boolean currentTPIsFragmented = false;
            startOfCurrentTP = endOfCurrentTP - (long)this.tplength;
            if (sp != null && sp.isLongTracePoint()) {
                int lengthOfLongTracePoint = sp.longTracePointLength();
                Util.Debug.println("Processing long tracepoint - length = " + lengthOfLongTracePoint);
                this.tplength = lengthOfLongTracePoint;
                longTPLen = true;
            }
            sp = null;
            if (this.tplength > this.offset) {
                byte[] newBufferToWorkOn;
                byte[] restOfBuffer;
                currentTPIsFragmented = true;
                if (recordHasWrapped) break;
                int numberOfMissingBytes = this.tplength - this.offset;
                if (this.traceRecordType == 0) {
                    startOfCurrentTP = -1L;
                    if (this.dataAtEndOfBuffer != null) {
                        restOfBuffer = this.dataAtEndOfBuffer;
                        newBufferToWorkOn = new byte[restOfBuffer.length + this.offset + 1];
                        System.arraycopy(restOfBuffer, 0, newBufferToWorkOn, 0, restOfBuffer.length);
                        System.arraycopy(this.traceRecordBytes, 0, newBufferToWorkOn, restOfBuffer.length, this.offset + 1);
                        Util.Debug.println(" coalesced the buffers successfully! ");
                        recordHasWrapped = true;
                        this.traceRecordBytes = newBufferToWorkOn;
                        this.offset = newBufferToWorkOn.length - 1;
                        continue;
                    }
                    Util.Debug.println(" TraceRecord50 wrapped an internal buffer which doesn't seem to have any extra data at the end");
                    break;
                }
                startOfCurrentTP = -2L;
                if (this.overspillData != null) {
                    restOfBuffer = this.overspillData;
                    newBufferToWorkOn = new byte[restOfBuffer.length + this.offset + 1];
                    System.arraycopy(restOfBuffer, 0, newBufferToWorkOn, 0, restOfBuffer.length);
                    System.arraycopy(this.traceRecordBytes, 0, newBufferToWorkOn, restOfBuffer.length, this.offset + 1);
                    Util.Debug.println(" coalesced the buffers successfully! ");
                    recordHasWrapped = true;
                    this.traceRecordBytes = newBufferToWorkOn;
                    this.offset = newBufferToWorkOn.length - 1;
                    continue;
                }
                if (this.lostRecordCount > 0L) {
                    sp = new TracePoint(this.traceRecordBytes, 8, this.upperTimeWord, this.threadID, traceFile.toString(), this.absolutePositionInFile, this.absolutePositionInFile + 8L, false);
                }
                Util.Debug.println(" TraceRecord50 walked back off the beginning of this buffer, but found no overspill data");
                break;
            }
            this.offset -= this.tplength;
            if (sp == null) {
                if (tpdata.length < this.tplength) {
                    tpdata = new byte[this.tplength + 1];
                }
                System.arraycopy(this.traceRecordBytes, this.offset, tpdata, 0, this.tplength);
                sp = new TracePoint(tpdata, this.tplength, this.upperTimeWord, this.threadID, traceFile.toString(), startOfCurrentTP, endOfCurrentTP, currentTPIsFragmented);
            }
            if (sp.isTimerUpperWord()) {
                this.upperTimeWord = BigInteger.valueOf(sp.getNewTimerUpperWord());
            } else if (sp.isLostRecord()) {
                if (this.earliestTimeStamp != null) {
                    sp.setRawTimeStamp(this.earliestTimeStamp);
                } else {
                    sp.setRawTimeStamp(this.timeStamp);
                }
                if (this.tps.size() > 0) {
                    this.tps.insertElementAt(sp, this.tps.size() - 1);
                } else {
                    this.tps.add(sp);
                }
            }
            if (sp.isNormalTracepoint()) {
                this.tps.add(sp);
                this.earliestTimeStamp = sp.getRawTimeStamp();
            }
            endOfCurrentTP -= (long)this.tplength;
        } while (this.tplength > 0 && this.offset >= 0);
        if (this.offset != 0) {
            Util.Debug.println("TraceRecord ended with some extra data");
        }
        Util.Debug.print("About to sort");
        Collections.sort(this.tps);
        Util.Debug.println(" ... sorted");
        if (!this.isMiddleOfTracePoint) {
            this.traceRecordBytes = null;
        }
        return true;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getThreadIDAsLong() {
        return this.threadID;
    }

    public String getFileName() {
        return this.fromFileName;
    }

    public long getOffsetInFile() {
        return this.offsetInFile;
    }

    public BigInteger getTimeStamp() {
        return this.timeStamp;
    }

    public BigInteger getLastTimerWrap() {
        return this.wrapTime;
    }

    public void setTimeStamp(BigInteger newTimeStamp) {
        this.timeStamp = newTimeStamp;
    }

    public int compareTo(Object other) {
        if (this.writeSystem == BigInteger.ZERO || ((TraceRecord50)other).writeSystem == BigInteger.ZERO) {
            Util.Debug.println("TraceRecord50.compareTo() found trace record with a zero system write time");
            return 0;
        }
        int result = this.writeSystem.compareTo(((TraceRecord50)other).writeSystem);
        if (result == 0) {
            if (this.offsetInFile <= this.traceFile.wrapOffset && ((TraceRecord50)other).offsetInFile > this.traceFile.wrapOffset) {
                return 1;
            }
            if (this.offsetInFile > this.traceFile.wrapOffset && ((TraceRecord50)other).offsetInFile <= this.traceFile.wrapOffset) {
                return -1;
            }
        }
        return result;
    }

    public int getTraceType() {
        return this.traceRecordType;
    }

    public void setTraceType(int traceType) {
        this.traceRecordType = traceType;
    }

    public BigInteger getLastUpperWord() {
        return this.upperTimeWord;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TraceRecord50:");
        sb.append(this.timeStamp);
        sb.append(":offset in file ");
        sb.append(this.absolutePositionInFile);
        sb.append(":len ");
        sb.append(this.bufferLength);
        return sb.toString();
    }
}

