/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.methodprofiling.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.AxisPair;
import com.ibm.java.diagnostics.common.datamodel.data.axes.XDataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.YDataAxis;
import com.ibm.java.diagnostics.common.datamodel.factory.DataFactory;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisUtil;
import com.ibm.java.diagnostics.common.datamodel.impl.data.DataPointImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import java.util.logging.Logger;

public class PercentTprofDataPostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final String CLASS_NAME = PercentTprofDataPostProcessor.class.getName();
    private static final Logger TRACE = LogFactory.getTrace(PercentTprofDataPostProcessor.class);
    private static final DataFactory factory = DataFactory.getFactory();
    private static AxisPair numberAxisPair = null;

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        Data data;
        Object object;
        Object object2;
        TRACE.entering(CLASS_NAME, "postprocess");
        if (numberAxisPair == null) {
            object2 = AxisUtil.prepareXAxis(outputProperties);
            object = AxisUtil.prepareNumberAxis(outputProperties);
            numberAxisPair = factory.createAxisPair((XDataAxis)object2, (YDataAxis)object);
        }
        if ((object2 = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.PROFILING)) != null && (object = dataBuilder.getData(JVMLabels.TPROF)) != null && (data = object.getTopLevelData("NumberOfSamples")) != null) {
            this.calculatePercentages(data);
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }

    private int calculateNumberOfSamples(Data data) {
        Data[] dataArray;
        int n = 0;
        for (Data data2 : dataArray = data.getChildren()) {
            Data[] dataArray2;
            for (Data data3 : dataArray2 = data2.getChildren()) {
                if (!data3.getLabel().startsWith("NumberOfSamples")) continue;
                n = (int)((double)n + ((TwoDimensionalDataImpl)data3).getTotalY());
            }
        }
        return n;
    }

    private void calculatePercentages(Data data) {
        Data[] dataArray;
        int n = this.calculateNumberOfSamples(data);
        for (Data data2 : dataArray = data.getChildren()) {
            Data[] dataArray2;
            for (Data data3 : dataArray2 = data2.getChildren()) {
                if (data3.getLabel().startsWith("NumberOfSamples")) {
                    this.calculateAndStorePercentage(data3, n);
                }
                if (!data3.getLabel().startsWith("TID:")) continue;
                Data[] dataArray3 = data3.getChildren();
                int n2 = this.calculateNumberOfSamples(data2);
                for (Data data4 : dataArray3) {
                    if (data4.getLabel().startsWith("NumberOfSamples")) {
                        this.calculateAndStorePercentage(data4, n2);
                    }
                    if (!data4.getLabel().startsWith("MODULE_NAME:")) continue;
                    Data[] dataArray4 = data4.getChildren();
                    int n3 = this.calculateNumberOfSamples(data3);
                    for (Data data5 : dataArray4) {
                        if (data5.getLabel().startsWith("NumberOfSamples")) {
                            this.calculateAndStorePercentage(data5, n3);
                        }
                        if (!data5.getLabel().startsWith("SYMBOL_NAME: ")) continue;
                        Data[] dataArray5 = data5.getChildren();
                        int n4 = this.calculateNumberOfSamples(data4);
                        for (Data data6 : dataArray5) {
                            if (!data6.getLabel().startsWith("NumberOfSamples")) continue;
                            this.calculateAndStorePercentage(data6, n4);
                        }
                    }
                }
            }
        }
    }

    private void calculateAndStorePercentage(Data data, int n) {
        double d = ((TwoDimensionalDataImpl)data).getTotalY();
        double d2 = d / (double)n * 100.0;
        d2 *= 100.0;
        d2 = Math.round(d2);
        d2 /= 100.0;
        DataBuilder dataBuilder = (DataBuilder)((DataBuilder)data).getParent();
        String string = data.getLabel().split("NumberOfSamples")[1];
        String string2 = "Percentage" + string;
        TwoDimensionalDataImpl twoDimensionalDataImpl = new TwoDimensionalDataImpl(string2, numberAxisPair);
        dataBuilder.addData(twoDimensionalDataImpl);
        this.createNewDataPoint(((TwoDimensionalDataImpl)data).getMeanX(), d2, twoDimensionalDataImpl);
    }

    private void createNewDataPoint(double d, double d2, DataBuilder dataBuilder) {
        DataPointImpl dataPointImpl = new DataPointImpl(0, d, d2, numberAxisPair);
        ((TwoDimensionalDataBuilder)dataBuilder).addDataPointBuilder(dataPointImpl);
    }
}

