/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.gc.parser.converters;

import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.UnitConverterDefinitionImpl;
import com.ibm.java.diagnostics.healthcenter.gc.parser.constants.GCAxes;
import com.ibm.java.diagnostics.healthcenter.gc.parser.converters.TwoDimensionalDataConverter;

public class GCNumberConverter
extends TwoDimensionalDataConverter {
    private static final UnitConverterDefinition definition = new UnitConverterDefinitionImpl(GCAxes.MILLISECONDS_SINCE_EPOCH, GCAxes.COLLECTION, GCAxes.GC_NUMBER);

    public GCNumberConverter(TwoDimensionalDataBuilder twoDimensionalDataBuilder) {
        super(twoDimensionalDataBuilder);
    }

    @Override
    public String unconvertedFormat(double d) {
        return String.valueOf(Math.round(d));
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        return this.unconvertedFormat(d);
    }

    @Override
    public UnitConverterDefinition getDefinition() {
        return definition;
    }

    @Override
    protected double interpolateValue(int n, int n2, int n3) {
        return Math.floor(super.interpolateValue(n, n2, n3));
    }

    @Override
    public boolean shouldFormatWithUnits() {
        return false;
    }
}

