/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.agent.lateattach;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "com.ibm.java.diagnostics.healthcenter.agent.lateattach.messages";
    private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle("com.ibm.java.diagnostics.healthcenter.agent.lateattach.messages");

    private Messages() {
    }

    private static String getString(String string) {
        try {
            if ("z/OS".equals(System.getProperty("os.name")) && !"IBM-1047".equals(System.getProperty("file.encoding"))) {
                return new String(RESOURCE_BUNDLE.getString(string).getBytes(), System.getProperty("file.encoding").replace("-", ""));
            }
            return RESOURCE_BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return '!' + string + '!';
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return RESOURCE_BUNDLE.getString(string);
        }
    }

    public static void issueMessage(String string, Object ... objectArray) {
        String string2 = null;
        string2 = objectArray.length == 0 ? Messages.getString(string) : MessageFormat.format(Messages.getString(string), objectArray);
        Messages.outputMessage(string2);
    }

    public static void printException(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        exception.printStackTrace(printWriter);
        printWriter.flush();
        Messages.outputMessage(stringWriter.toString());
    }

    private static void outputMessage(String string) {
        System.out.println(string);
    }
}

