/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.axes;

import com.ibm.java.diagnostics.common.datamodel.data.axes.LinearUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AbstractUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.Messages;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.UnitConverterDefinitionImpl;
import java.text.MessageFormat;

public class NormalisingIdentityConverter
extends AbstractUnitConverter
implements LinearUnitConverter {
    private static final String NORMALISING_IDENTITY_CONVERTER_WITH_OFFSET = Messages.getString("NormalisingIdentityConverter.identityconverter.with.offset");
    private UnitConverterDefinition definition;
    private double normalisationOffset = Double.MAX_VALUE;

    public NormalisingIdentityConverter(String string, String string2) {
        this(string, string2, string2);
    }

    public NormalisingIdentityConverter(String string, String string2, String string3) {
        this.definition = new UnitConverterDefinitionImpl(string2, string, string3);
        this.normalisationOffset = 0.0;
    }

    @Override
    public void setOffset(double d) {
        this.normalisationOffset = d;
    }

    @Override
    public double convert(double d, int n) {
        return this.convert(d);
    }

    @Override
    public double convert(double d) {
        return d - this.normalisationOffset;
    }

    @Override
    public double reverseConvert(double d) {
        return d + this.normalisationOffset;
    }

    @Override
    public String unconvertedFormat(double d) {
        return NumberFormatter.prettyString(d);
    }

    @Override
    public String unconvertedFormat(double d, int n) {
        return NumberFormatter.prettyString(d, n);
    }

    @Override
    public UnitConverterDefinition getDefinition() {
        return this.definition;
    }

    public String toString() {
        return MessageFormat.format(NORMALISING_IDENTITY_CONVERTER_WITH_OFFSET, this.normalisationOffset);
    }
}

