/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.common.datamodel.impl.axes;

import com.ibm.java.diagnostics.common.datamodel.data.DataPoint;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalData;
import com.ibm.java.diagnostics.common.datamodel.data.axes.Axis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.DataAxis;
import com.ibm.java.diagnostics.common.datamodel.data.axes.LinearUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.data.axes.NonLinearUnitConverter;
import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverter;
import com.ibm.java.diagnostics.common.datamodel.data.axes.UnitConverterDefinition;
import com.ibm.java.diagnostics.common.datamodel.exceptions.JavaDiagnosticsException;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.AxisImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.IdentityConverter;
import com.ibm.java.diagnostics.common.datamodel.impl.axes.NumberFormatter;
import com.ibm.java.diagnostics.common.datamodel.impl.data.TwoDimensionalDataImpl;
import com.ibm.java.diagnostics.common.datamodel.impl.util.Messages;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.common.util.weak.WeakHashSet;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DataAxisImpl
implements DataAxis,
Comparable<Object> {
    private static final String CLOSE_PARENTHESIS = ")";
    private static final String OPEN_PARENTHESIS = " (";
    private String[] possibleUnits;
    private final Map<String, UnitConverter> converters = new HashMap<String, UnitConverter>();
    private UnitConverterDefinition definition;
    private UnitConverter converter;
    private static final String[] UNIT_TEMPLATE_ARRAY = new String[0];
    protected AxisImpl axis;
    protected OutputProperties properties;
    protected double rawOffset = Double.MAX_VALUE;
    private final Set<TwoDimensionalDataImpl> axisListeners = new WeakHashSet<TwoDimensionalDataImpl>();
    private DataPoint minimum;
    private DataPoint maximum;
    private final String baseUnit;
    private boolean boundsObsolete;
    private static final Logger TRACE = LogFactory.getTrace(DataAxisImpl.class);

    public DataAxisImpl(Axis axis, OutputProperties outputProperties, String string) {
        this.axis = (AxisImpl)axis;
        this.properties = outputProperties;
        this.baseUnit = string;
        this.registerWithProperties();
        IdentityConverter identityConverter = new IdentityConverter(axis.getLabel(), string);
        this.setConverter(identityConverter);
        this.converters.put(this.definition.getUnitName(), identityConverter);
        this.axis.addAxisUnitListener(this);
        this.setUnits(axis.getUnits());
    }

    protected abstract void registerWithProperties();

    @Override
    public String getLabel() {
        String string = null;
        if (this.definition != null && this.definition.getLabel() != null) {
            string = this.definition.getLabel();
        }
        if (string == null) {
            string = this.axis.getLabel();
        }
        return string;
    }

    @Override
    public String getUnits() {
        return this.definition.getUnitName();
    }

    @Override
    public String getBaseUnitName() {
        return this.baseUnit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUnitConverter(UnitConverter unitConverter) throws JavaDiagnosticsException {
        if (unitConverter != null) {
            UnitConverterDefinition unitConverterDefinition = unitConverter.getDefinition();
            if (this.baseUnit.equals(unitConverterDefinition.getBaseUnitName())) {
                unitConverter.setOffset(this.rawOffset);
                Object object = this.converters;
                synchronized (object) {
                    this.converters.put(unitConverterDefinition.getUnitName(), unitConverter);
                }
                this.possibleUnits = null;
                if (this.axis != null && unitConverter != null && (object = this.getConverterDefinition(this.axis.getUnits())) != null && object.equals(unitConverter.getDefinition())) {
                    this.setConverter(unitConverter);
                }
            } else {
                throw new JavaDiagnosticsException(MessageFormat.format(Messages.getString("DataAxisImpl.units.warning"), this.baseUnit, unitConverter.getDefinition().getBaseUnitName()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnitConverter getUnitConverter(String string) {
        Map<String, UnitConverter> map = this.converters;
        synchronized (map) {
            return this.converters.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String[] getPossibleUnits() {
        String[] stringArray;
        if (this.possibleUnits == null) {
            stringArray = this.converters;
            // MONITORENTER : this.converters
            this.possibleUnits = this.converters.keySet().toArray(UNIT_TEMPLATE_ARRAY);
            // MONITOREXIT : stringArray
        }
        if (this.possibleUnits == null) return null;
        stringArray = new String[this.possibleUnits.length];
        System.arraycopy(this.possibleUnits, 0, stringArray, 0, this.possibleUnits.length);
        return stringArray;
    }

    @Override
    public UnitConverterDefinition getConverterDefinition(String string) {
        UnitConverterDefinition unitConverterDefinition = null;
        UnitConverter unitConverter = this.getUnitConverter(string);
        if (unitConverter != null) {
            unitConverterDefinition = unitConverter.getDefinition();
        }
        return unitConverterDefinition;
    }

    public void setUnits(String string) {
        UnitConverter unitConverter;
        TRACE.finer("setUnits - " + string + " listeners: " + this.axisListeners.size());
        if (string != null && (unitConverter = this.getUnitConverter(string)) != null) {
            boolean bl = unitConverter instanceof NonLinearUnitConverter;
            boolean bl2 = this.converter instanceof NonLinearUnitConverter;
            boolean bl3 = this.boundsObsolete = bl2 || bl;
            if (this.boundsObsolete) {
                this.cropTuples();
            }
            this.setConverter(unitConverter);
            if (TRACE.isLoggable(Level.FINER)) {
                TRACE.finer("Successfully changed units to " + string);
            }
        }
    }

    public void correctObsoleteBounds() {
        if (this.boundsObsolete) {
            this.properties.disableNotifications();
            if (this.minimum != null) {
                this.setMinimumBound(this.minimum);
            }
            if (this.maximum != null) {
                this.setMaximumBound(this.maximum);
            }
            this.properties.enableNotifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cropTuples() {
        DataPointBuilder dataPointBuilder = null;
        DataPointBuilder dataPointBuilder2 = null;
        double d = Double.MAX_VALUE;
        double d2 = -1.7976931348623157E308;
        if (this.minimum != null && !(this.minimum instanceof DataPointBuilder) || this.maximum != null && !(this.maximum instanceof DataPointBuilder)) {
            Set<TwoDimensionalDataImpl> set = this.axisListeners;
            synchronized (set) {
                for (TwoDimensionalData twoDimensionalData : this.axisListeners) {
                    DataPointBuilder dataPointBuilder3;
                    twoDimensionalData.getDataPoints();
                    DataPointBuilder dataPointBuilder4 = this.getMinimum(twoDimensionalData);
                    if (dataPointBuilder4 != null && this.getValue(dataPointBuilder4) < d) {
                        dataPointBuilder = dataPointBuilder4;
                        d = this.getValue(dataPointBuilder4);
                    }
                    if ((dataPointBuilder3 = this.getMaximum(twoDimensionalData)) == null || !(this.getValue(dataPointBuilder3) > d2)) continue;
                    dataPointBuilder2 = dataPointBuilder3;
                    d2 = this.getValue(dataPointBuilder3);
                }
            }
            if (this.minimum != null) {
                this.setMinimumBound(this.minimum);
                this.minimum = dataPointBuilder;
            }
            if (this.maximum != null) {
                this.maximum = dataPointBuilder2;
            }
        }
    }

    protected abstract DataPointBuilder getMinimum(TwoDimensionalData var1);

    protected abstract DataPointBuilder getMaximum(TwoDimensionalData var1);

    protected abstract double getValue(DataPointBuilder var1);

    private final void setConverter(UnitConverter unitConverter) {
        this.converter = unitConverter;
        this.definition = this.converter.getDefinition();
        this.converter.setOffset(this.rawOffset);
    }

    public final double convert(double d) {
        if (this.converter != null) {
            return this.converter.convert(d, 0);
        }
        return d;
    }

    public final double convert(double d, String string) {
        if (this.converter != null) {
            UnitConverter unitConverter = this.getUnitConverter(string);
            if (unitConverter != null) {
                return unitConverter.convert(d, 0);
            }
            return Double.NaN;
        }
        return d;
    }

    @Override
    public final double convert(double d, int n) {
        if (this.converter != null) {
            return this.converter.convert(d, n);
        }
        return d;
    }

    public final double convert(double d, int n, String string) {
        if (this.converter != null) {
            UnitConverter unitConverter = this.getUnitConverter(string);
            if (unitConverter != null) {
                return unitConverter.convert(d, n);
            }
            return Double.NaN;
        }
        return d;
    }

    public final String format(double d, int n) {
        if (this.converter != null) {
            return this.converter.format(d, n);
        }
        return NumberFormatter.prettyString(d);
    }

    public final String format(double d, int n, int n2) {
        if (this.converter != null) {
            return this.converter.format(d, n, n2);
        }
        return NumberFormatter.prettyString(d, n2);
    }

    @Override
    public String formatUnconverted(double d) {
        if (this.converter != null) {
            return this.converter.unconvertedFormat(d);
        }
        return NumberFormatter.prettyString(d);
    }

    @Override
    public String formatUnconverted(double d, int n) {
        if (this.converter != null) {
            return this.converter.unconvertedFormat(d, n);
        }
        return NumberFormatter.prettyString(d, n);
    }

    @Override
    public final double parse(String string) {
        if (this.converter != null) {
            return this.converter.parseUnconverted(string);
        }
        return Double.parseDouble(string);
    }

    public String toString() {
        if (this.definition != null) {
            String string = this.definition.getLabel();
            if (string == null) {
                string = this.axis.getLabel();
            }
            if (this.axis.getType() != 1) {
                return string + OPEN_PARENTHESIS + this.definition.getUnitName() + CLOSE_PARENTHESIS;
            }
            return string;
        }
        return this.axis.toString();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public int compareTo(Object object) {
        if (this == object) {
            return 0;
        }
        if (object instanceof DataAxisImpl) {
            return this.getLabel().compareTo(((DataAxisImpl)object).getLabel());
        }
        return 1;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCropping() {
        this.minimum = this.getMinimumBound();
        this.maximum = this.getMaximumBound();
        Set<TwoDimensionalDataImpl> set = this.axisListeners;
        synchronized (set) {
            Iterator<TwoDimensionalDataImpl> iterator = this.axisListeners.iterator();
            if (TRACE.isLoggable(Level.FINE)) {
                TRACE.finer("setNorm:" + this.axisListeners.size());
            }
            while (iterator.hasNext()) {
                TwoDimensionalDataImpl twoDimensionalDataImpl = iterator.next();
                twoDimensionalDataImpl.resetCropping();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOffset(double d) {
        if (TRACE.isLoggable(Level.FINER)) {
            TRACE.finer(this.getLabel() + " updating normalisation offset to " + d + ".");
        }
        this.rawOffset = d;
        Map<String, UnitConverter> map = this.converters;
        synchronized (map) {
            Iterator<UnitConverter> iterator = this.converters.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().setOffset(d);
            }
        }
    }

    public double getNormalisationOffset() {
        return this.rawOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TwoDimensionalDataImpl twoDimensionalDataImpl) {
        Set<TwoDimensionalDataImpl> set = this.axisListeners;
        synchronized (set) {
            if (TRACE.isLoggable(Level.FINER) && this.axisListeners.size() > 0 && this.axisListeners.size() % 1000 == 0) {
                TRACE.finer("Potential memory leak: add # " + this.axisListeners.size() + " " + twoDimensionalDataImpl.toString());
            }
            this.axisListeners.add(twoDimensionalDataImpl);
        }
    }

    @Override
    public boolean shouldFormatWithUnits() {
        if (this.converter != null) {
            return this.converter.shouldFormatWithUnits();
        }
        return true;
    }

    @Override
    public void updateNormalisation(double d) {
        if (d < this.rawOffset) {
            this.setOffset(d);
        }
    }

    @Override
    public Axis getAxis() {
        return this.axis;
    }

    @Override
    public abstract DataPoint getMaximumBound();

    @Override
    public abstract DataPoint getMinimumBound();

    @Override
    public abstract void setMaximumBound(DataPoint var1);

    @Override
    public abstract void setMinimumBound(DataPoint var1);

    public void updateBounds() {
        DataPoint dataPoint = this.getMinimumBound();
        DataPoint dataPoint2 = this.getMaximumBound();
        if (dataPoint2 != this.maximum || dataPoint != this.minimum) {
            this.minimum = dataPoint;
            this.maximum = dataPoint2;
            this.resetCropping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableNonlinearUnitConverters() {
        Map<String, UnitConverter> map = this.converters;
        synchronized (map) {
            Iterator<UnitConverter> iterator = this.converters.values().iterator();
            while (iterator.hasNext()) {
                UnitConverter unitConverter = iterator.next();
                if (!(unitConverter instanceof NonLinearUnitConverter)) continue;
                iterator.remove();
                this.possibleUnits = null;
            }
        }
    }

    @Override
    public boolean isLinearConversions() {
        return this.converter instanceof LinearUnitConverter;
    }

    @Override
    public UnitConverter getConverter() {
        return this.converter;
    }
}

