/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.trace.format.api;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Vector;

public class ByteStream {
    ByteBuffer buffer;
    ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    Vector rawData = new Vector();
    boolean blocking = false;
    private int guardBytes;

    public ByteStream(byte[] data) {
        this.add(data);
    }

    public ByteStream(byte[] data, int offset) {
        this.add(data, offset);
    }

    public ByteStream(byte[] data, int offset, int length) {
        this.add(data, offset, length);
    }

    public ByteStream() {
    }

    private synchronized void commit(int bytes) throws BufferUnderflowException {
        int requiredBytes = bytes + this.guardBytes;
        boolean recurse = true;
        if (this.buffer != null && this.buffer.remaining() >= requiredBytes) {
            return;
        }
        if (this.rawData.isEmpty()) {
            if (!this.blocking) {
                throw new BufferUnderflowException();
            }
            try {
                this.rawData.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.rawData.isEmpty()) {
                throw new BufferUnderflowException();
            }
        }
        Slice slice = (Slice)this.rawData.get(0);
        if (this.buffer != null && this.buffer.remaining() >= bytes && slice.length >= this.guardBytes) {
            return;
        }
        if (this.buffer == null || this.buffer.remaining() == 0) {
            this.rawData.remove(0);
            this.buffer = ByteBuffer.wrap(slice.data, slice.offset, slice.length);
        } else {
            byte[] mergeData;
            int remaining = this.buffer.remaining();
            if (slice.length > requiredBytes) {
                mergeData = new byte[bytes];
                int shortfall = bytes - remaining;
                this.buffer.get(mergeData, 0, remaining);
                System.arraycopy(slice.data, slice.offset, mergeData, remaining, shortfall);
                slice.offset += shortfall;
                slice.length -= shortfall;
                recurse = false;
            } else {
                mergeData = new byte[remaining + slice.length];
                this.buffer.get(mergeData, 0, remaining);
                System.arraycopy(slice.data, slice.offset, mergeData, remaining, slice.length);
                this.rawData.remove(0);
            }
            this.buffer = ByteBuffer.wrap(mergeData);
        }
        this.buffer.order(this.byteOrder);
        if (recurse && this.buffer.remaining() < requiredBytes) {
            this.commit(bytes);
        }
    }

    public void reverseBytes(byte[] data) {
        for (int i = 0; i < data.length / 2; ++i) {
            byte temp = data[i];
            data[i] = data[data.length - 1 - i];
            data[data.length - 1 - i] = temp;
        }
    }

    public void add(byte[] data) {
        this.add(data, 0);
    }

    public void add(byte[] data, int offset) {
        if (data == null) {
            return;
        }
        this.add(data, offset, data.length - offset);
    }

    public synchronized void add(byte[] data, int offset, int length) {
        if (data == null || length == 0) {
            return;
        }
        if (data.length < offset + length) {
            throw new IndexOutOfBoundsException();
        }
        if (length < 0) {
            throw new IllegalArgumentException("can't add data with a negative size");
        }
        this.rawData.add(new Slice(data, offset, length));
        if (this.blocking) {
            this.rawData.notify();
        }
    }

    public byte get() {
        this.commit(1);
        return this.buffer.get();
    }

    public byte get(int index) {
        this.commit(index + 1);
        return this.buffer.get(index);
    }

    public char getUTF8Char() {
        this.commit(1);
        return this.buffer.getChar();
    }

    public char getUTF8Char(int index) {
        this.commit(index + 1);
        return this.buffer.getChar(index);
    }

    public double getDouble() {
        this.commit(8);
        return this.buffer.getDouble();
    }

    public double getDouble(int index) {
        this.commit(index + 8);
        return this.buffer.getDouble(index);
    }

    public float getFloat() {
        this.commit(8);
        return this.buffer.getFloat();
    }

    public float getFloat(int index) {
        this.commit(index + 8);
        return this.buffer.getFloat(index);
    }

    public int getInt() {
        this.commit(4);
        return this.buffer.getInt();
    }

    public int getInt(int index) {
        this.commit(index + 4);
        return this.buffer.getInt(index);
    }

    public long getUnsignedInt() {
        this.commit(4);
        byte[] data = new byte[4];
        this.buffer.get(data);
        return this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (long)data[3] << 24 & 0xFF000000L | (long)data[2] << 16 & 0xFF0000L | (long)data[1] << 8 & 0xFF00L | (long)data[0] & 0xFFL : (long)data[0] << 24 & 0xFF000000L | (long)data[1] << 16 & 0xFF0000L | (long)data[2] << 8 & 0xFF00L | (long)data[3] & 0xFFL;
    }

    public long getUnsignedInt(int index) {
        this.commit(index + 4);
        byte[] data = new byte[index + 4];
        this.peek(data);
        return this.byteOrder == ByteOrder.LITTLE_ENDIAN ? (long)data[index + 3] << 24 & 0xFF000000L | (long)data[index + 2] << 16 & 0xFF0000L | (long)data[index + 1] << 8 & 0xFF00L | (long)data[index + 0] & 0xFFL : (long)data[index + 0] << 24 & 0xFF000000L | (long)data[index + 1] << 16 & 0xFF0000L | (long)data[index + 2] << 8 & 0xFF00L | (long)data[index + 3] & 0xFFL;
    }

    public long getLong() {
        this.commit(8);
        return this.buffer.getLong();
    }

    public long getLong(int index) {
        this.commit(index + 8);
        return this.buffer.getLong(index);
    }

    public short getShort() {
        this.commit(2);
        return this.buffer.getShort();
    }

    public short getShort(int index) {
        this.commit(index + 2);
        return this.buffer.getShort(index);
    }

    public String getASCIIString(int length) {
        this.commit(length);
        byte[] stringBytes = new byte[length];
        this.buffer.get(stringBytes);
        int cursor = 0;
        for (cursor = 0; cursor < stringBytes.length && stringBytes[cursor] != 0; ++cursor) {
        }
        try {
            return new String(stringBytes, 0, cursor, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            return new String(stringBytes, 0, cursor);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getASCIIString() {
        block10: {
            if (this.buffer == null) {
                try {
                    this.commit(20);
                }
                catch (BufferUnderflowException e) {
                    if (this.buffer != null) break block10;
                    throw e;
                }
            }
        }
        int length = 0;
        while (true) {
            int s = this.buffer.position();
            byte b = 1;
            byte[] bufferArray = this.buffer.array();
            while (length < this.buffer.remaining() && b != 0) {
                b = bufferArray[s + length];
                ++length;
            }
            if (b == 0) {
                String value;
                try {
                    value = new String(bufferArray, s, length - 1, "US-ASCII");
                }
                catch (UnsupportedEncodingException e) {
                    value = new String(bufferArray, s, length - 1);
                }
                this.buffer.position(s + length);
                return value;
            }
            try {
                this.commit(this.buffer.remaining() + 20);
                continue;
            }
            catch (BufferUnderflowException e) {
                if (length == this.buffer.remaining()) throw e;
                continue;
            }
            break;
        }
    }

    public String getUTF8String() throws UnsupportedEncodingException {
        this.commit(1);
        short length = this.getShort();
        byte[] data = new byte[length];
        this.commit(length);
        this.get(data);
        String s = new String(data, "UTF-8");
        if (data.length % 2 == 0) {
            int i;
            boolean swap = false;
            boolean utf16 = false;
            for (i = 0; i < data.length - 1; ++i) {
                if (data[i] != 0) continue;
                utf16 = true;
                if (i % 2 == 0) continue;
                swap = true;
            }
            if (utf16) {
                if (swap) {
                    for (i = 0; i < data.length - 1; i += 2) {
                        byte b = data[i + 1];
                        data[i + 1] = data[i];
                        data[i] = b;
                    }
                }
                s = new String(data, "UTF-16");
            }
        }
        return s;
    }

    public BigInteger getBigInteger(int bytes) {
        this.commit(bytes);
        byte[] data = new byte[bytes];
        this.buffer.get(data);
        if (this.byteOrder != ByteOrder.BIG_ENDIAN) {
            this.reverseBytes(data);
        }
        return new BigInteger(1, data);
    }

    public void get(byte[] dst) {
        this.commit(dst.length);
        this.buffer.get(dst);
    }

    public void get(byte[] dst, int offset, int length) {
        this.commit(length);
        this.buffer.get(dst, offset, length);
    }

    public ByteOrder order() {
        return this.byteOrder;
    }

    public synchronized void order(ByteOrder order) {
        this.byteOrder = order == null ? ByteOrder.BIG_ENDIAN : order;
        if (this.buffer != null) {
            this.buffer.order(this.byteOrder);
        }
    }

    public synchronized void setGuardBytes(int bytes) {
        this.guardBytes = bytes;
    }

    public int getGuardBytes() {
        return this.guardBytes;
    }

    public synchronized void truncate(int bytes) {
        if (bytes < 0) {
            throw new IllegalArgumentException();
        }
        for (int i = this.rawData.size() - 1; i >= 0 && bytes > 0; --i) {
            int reduce = bytes;
            Slice s = (Slice)this.rawData.get(i);
            bytes -= s.length;
            if (reduce < s.length) {
                s.length -= reduce;
                continue;
            }
            this.rawData.remove(i);
        }
        if (bytes > 0 && this.buffer != null) {
            int remove = bytes;
            if ((bytes -= this.buffer.remaining()) < 0) {
                this.buffer.limit(this.buffer.limit() - remove);
            } else {
                this.buffer = null;
            }
        }
        if (bytes > 0) {
            throw new BufferUnderflowException();
        }
    }

    public synchronized int truncate(byte[] bytes) {
        int remaining = bytes.length;
        for (int i = this.rawData.size() - 1; i >= 0 && remaining > 0; --i) {
            int reduce = remaining;
            Slice s = (Slice)this.rawData.get(i);
            remaining -= s.length;
            if (reduce < s.length) {
                s.length -= reduce;
                System.arraycopy(s.data, s.offset + s.length, bytes, 0, reduce);
                continue;
            }
            this.rawData.remove(i);
            System.arraycopy(s.data, s.offset, bytes, remaining, s.length);
        }
        if (remaining > 0 && this.buffer != null) {
            int remove = remaining;
            if ((remaining -= this.buffer.remaining()) < 0) {
                this.buffer.limit(this.buffer.limit() - remove);
                System.arraycopy(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position() + this.buffer.remaining(), bytes, 0, remove);
            } else {
                System.arraycopy(this.buffer.array(), this.buffer.arrayOffset() + this.buffer.position(), bytes, remaining, this.buffer.remaining());
                this.buffer = null;
            }
        }
        if (remaining < 0) {
            this.guardBytes -= bytes.length;
            return bytes.length;
        }
        this.guardBytes -= bytes.length - remaining;
        return bytes.length - remaining;
    }

    public int remaining() {
        int remaining = 0;
        if (this.buffer != null) {
            remaining += this.buffer.remaining();
        }
        for (int i = 0; i < this.rawData.size(); ++i) {
            Slice s = (Slice)this.rawData.get(i);
            remaining += s.length;
        }
        return remaining -= this.guardBytes;
    }

    public byte peek() throws BufferUnderflowException {
        byte[] dest = new byte[1];
        if (this.peek(dest) != 1) {
            throw new BufferUnderflowException();
        }
        return dest[0];
    }

    public int peek(byte[] dest) {
        boolean currentBlocking = this.blocking;
        this.blocking = false;
        int bytes = dest.length;
        int offset = 0;
        try {
            this.commit(dest.length);
        }
        catch (BufferUnderflowException e) {
            bytes = this.buffer.remaining();
        }
        byte[] data = this.buffer.array();
        offset = this.buffer.arrayOffset() + this.buffer.position();
        System.arraycopy(data, offset, dest, 0, bytes);
        this.blocking = currentBlocking;
        return bytes;
    }

    public void skip(int bytes) {
        this.commit(bytes);
        this.buffer.position(this.buffer.position() + bytes);
    }

    public synchronized void put(byte[] data, int index) {
        if (index >= 0) {
            throw new IndexOutOfBoundsException("Value must be negative: " + index);
        }
        if (index < -this.guardBytes) {
            throw new IndexOutOfBoundsException("Insufficient guard bytes to insert at index: " + index);
        }
        int distance = -index;
        int guardAhead = this.guardBytes - distance;
        Slice slice = null;
        for (int i = this.rawData.size() - 1; i >= 0; --i) {
            slice = (Slice)this.rawData.get(i);
            if (distance <= slice.length) break;
            distance -= slice.length;
            slice = null;
        }
        if (slice == null) {
            if (this.buffer == null || distance > this.buffer.remaining()) {
                throw new IndexOutOfBoundsException("Index references past the begining of the data");
            }
            int guardStart = this.buffer.arrayOffset() + this.buffer.limit() - distance - guardAhead;
            int guardLength = distance + guardAhead;
            byte[] newdata = new byte[guardLength];
            System.arraycopy(this.buffer.array(), guardStart, newdata, 0, guardLength);
            slice = new Slice(newdata, 0, newdata.length);
            this.rawData.add(0, slice);
            this.buffer.limit(this.buffer.limit() - guardLength);
        }
        byte[] newdata = new byte[slice.length + data.length];
        if (slice.length > distance) {
            System.arraycopy(slice.data, slice.offset, newdata, 0, slice.length - distance);
        }
        System.arraycopy(data, 0, newdata, slice.length - distance, data.length);
        System.arraycopy(slice.data, slice.offset + slice.length - distance, newdata, slice.length - distance + data.length, distance);
        this.guardBytes += data.length;
        slice.data = newdata;
        slice.offset = 0;
        slice.length = newdata.length;
    }

    public synchronized byte put(byte b, int index) {
        byte[] data;
        if (index >= 0) {
            throw new IndexOutOfBoundsException("Value must be negative: " + index);
        }
        if (index < -this.guardBytes) {
            throw new IndexOutOfBoundsException("Insufficient guard bytes to insert at index: " + index);
        }
        int distance = -index;
        Slice slice = null;
        int offset = 0;
        for (int i = this.rawData.size() - 1; i >= 0; --i) {
            slice = (Slice)this.rawData.get(i);
            if (distance <= slice.length) break;
            distance -= slice.length;
            slice = null;
        }
        if (slice != null) {
            data = slice.data;
            offset = slice.offset + slice.length - distance;
        } else if (this.buffer != null && distance <= this.buffer.remaining()) {
            data = this.buffer.array();
            offset = this.buffer.arrayOffset() + this.buffer.position() + this.buffer.remaining() - distance;
        } else {
            throw new IndexOutOfBoundsException("Index references past the begining of the data");
        }
        byte original = data[offset];
        data[offset] = b;
        return original;
    }

    class Slice {
        byte[] data;
        int offset;
        int length;

        Slice(byte[] data, int offset, int length) {
            this.data = data;
            this.offset = offset;
            this.length = length;
        }
    }
}

