/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.InvalidSpannedRecordException;
import com.ibm.jvm.format.Merge;
import com.ibm.jvm.format.Message;
import com.ibm.jvm.format.MessageFile;
import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.TracePoint;
import com.ibm.jvm.format.TraceRecord;
import com.ibm.jvm.format.TraceRecord50;
import com.ibm.jvm.format.TraceThread;
import com.ibm.jvm.format.Util;
import com.ibm.jvm.trace.TraceFileHeader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;

public final class TraceFormat {
    protected static final int traceFormatMajorVersion = 1;
    protected static final int traceFormatMinorVersion = 0;
    private TraceArgs traceArgs = null;
    private Vector traceFiles = new Vector();
    private TraceFile traceFile = null;
    private BufferedWriter out;
    private static int generations;
    protected static long lostRecordCount;
    protected static MessageFile messageFile;
    protected static Vector threads;
    protected static int invalidBuffers;
    protected static float verMod;
    protected static BigInteger overallStartSystem;
    protected static BigInteger overallStartPlatform;
    protected static BigInteger first;
    protected static BigInteger last;
    protected static BigInteger lastWritePlatform;
    protected static BigInteger lastWriteSystem;
    protected static BigInteger timeConversion;
    protected static String headings;
    protected static PrintStream outStream;
    protected static PrintStream errStream;
    protected static int expectedRecords;
    private boolean traceFileIsTruncatedOrCorrupt = false;
    private boolean primed = false;
    protected static final String usageMessage = "Usage:\njava com.ibm.jvm.format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [-datdir datfiledirectory] [-uservmid vmid] [-thread:id] [-indent] \n\t[-overridetimezone noOfHours] [-help]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdatdir = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. java com.ibm.jvm.format.TraceFormat 142trcfile /\n\t           -datdir /142sdk/jre/lib\n\tthread = only trace information for the specified thread will \n\t      be formatted. Any number of thread IDs can be specified, \n\t      separated by commas.\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. java com.ibm.jvm.format.TraceFormat trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n\thelp \t= display this message and stop.";
    protected static final String header = "                Trace Formatted Data ";
    private static final int FAIL = -1;
    private static final int OK = 0;
    private static String userVMIdentifier;
    public static final boolean SUPPRESS_VERSION_WARNINGS = false;
    long globalNumberOfBuffers;
    TraceThread[] tempThreadArray;
    TraceThread[] tracedThreads;
    int numberOfThreads;
    BigInteger[] timeStamps;
    private int tracedThreadWithNewestTracePoint = -1;

    public static void main(String[] args) {
        TraceFormat tf = new TraceFormat();
        tf.readAndFormat(args, true);
    }

    public TraceFormat() {
        this.initStatics();
        outStream = System.out;
        errStream = new PrintStream(new PipedOutputStream());
    }

    public TraceFormat(PrintStream outStream, String[] args) {
        this.initStatics();
        TraceFormat.outStream = outStream;
        errStream = new PrintStream(new PipedOutputStream());
        this.readAndFormat(args, true);
        try {
            this.out.close();
        }
        catch (IOException ioe) {
            TraceFormat.outStream.println("Error closing formatted trace file.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void initStatics() {
        threads = new Vector();
        invalidBuffers = 0;
        overallStartSystem = BigInteger.ZERO;
        overallStartPlatform = BigInteger.ZERO;
        first = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        last = BigInteger.ZERO;
        lastWritePlatform = BigInteger.ZERO;
        lastWriteSystem = BigInteger.ZERO;
        timeConversion = BigInteger.ZERO;
        headings = new String("  ThreadID         TP id  Type         TraceEntry ");
        expectedRecords = 0;
        Util.initStatics();
        TraceArgs.initStatics();
        TraceRecord.initStatics();
        MessageFile.initStatics();
    }

    public void readAndFormat(String[] args, boolean processFully) {
        try {
            this.traceArgs = new TraceArgs(args);
        }
        catch (TraceArgs.UsageException usage) {
            outStream.println(usage.getMessage());
            outStream.println("TraceFormat Usage:\njava com.ibm.jvm.format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [-datdir datfiledirectory] [-uservmid vmid] [-thread:id] [-indent] \n\t[-overridetimezone noOfHours] [-help]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdatdir = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. java com.ibm.jvm.format.TraceFormat 142trcfile /\n\t           -datdir /142sdk/jre/lib\n\tthread = only trace information for the specified thread will \n\t      be formatted. Any number of thread IDs can be specified, \n\t      separated by commas.\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. java com.ibm.jvm.format.TraceFormat trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n\thelp \t= display this message and stop.");
            return;
        }
        if (TraceArgs.isHelpOnly) {
            outStream.println("TraceFormat Usage:\njava com.ibm.jvm.format.TraceFormat input_filespec [output_filespec] \n\t[-summary] [-datdir datfiledirectory] [-uservmid vmid] [-thread:id] [-indent] \n\t[-overridetimezone noOfHours] [-help]\n\nwhere:\n\tinput_filespec = trace file generated by the jvm to be processed\n\toutput_filespec = name of the formatted file - default is\n\t      input_filespec.fmt\n\tsummary = print summary information to screen without generating\n\t      formatted file\n\n\tdatdir = used when the formatter is used to format a pre 5.0 vm's\n\t      tracefile. The datfilelocation tells the formatter where to\n\t      find the .dat files of the older vm's dat files. Default is\n\t      current directory, and the .dat files can be safely copied\n\t      into the current directory (as long as they don't overwrite\n\t      the current vm's .dat files).\n\tuservmid = users can specify a string to be inserted into each\n\t      tracepoint's formatted output, to help track and compare\n\t      tracefiles from multiple jvm runs.\n\t      e.g. java com.ibm.jvm.format.TraceFormat 142trcfile /\n\t           -datdir /142sdk/jre/lib\n\tthread = only trace information for the specified thread will \n\t      be formatted. Any number of thread IDs can be specified, \n\t      separated by commas.\n\toverridetimezone = specify an integer number of hours to be\n\t      added to the formatted tracepoints (can be negative).\n\t      This option allows the user to override the default time\n\t      zone used in the formatter (GMT)\n\t      e.g. java com.ibm.jvm.format.TraceFormat trcfile /\n\t           -overridetimezone -4\n\tindent = specify indentation at Entry/Exit trace points.\n\t      Default is not to indent.\n\thelp \t= display this message and stop.");
            return;
        }
        if (TraceArgs.verbose) {
            errStream = System.err;
        }
        userVMIdentifier = TraceArgs.userVMIdentifier;
        try {
            if (this.getTraceFiles() != 0) {
                return;
            }
            if ((double)verMod >= 0.0) {
                this.out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(TraceArgs.outputFile)));
                Util.Debug.println("TraceFormat.verMod = " + verMod);
                if (!TraceArgs.is50orNewer && (double)verMod < 5.0 || TraceArgs.override) {
                    this.readAndFormatOldStyle();
                } else if (processFully) {
                    this.readAndFormatNewStyle();
                } else {
                    this.prime();
                }
            }
        }
        catch (Exception other) {
            other.printStackTrace(outStream);
        }
    }

    private void readAndFormatOldStyle() throws IOException {
        for (TraceFile this.traceFile : this.traceFiles) {
            this.instantiateMessageFileOldStyle();
            this.traceFile.traceFileHeader.processTraceBufferHeaders();
        }
        for (TraceThread traceThread : threads) {
            Collections.sort(traceThread);
        }
        if (TraceArgs.summary) {
            this.doSummary(new BufferedWriter(new OutputStreamWriter(outStream)));
            return;
        }
        if (this.doSummary(this.out) != 0) {
            return;
        }
        outStream.println("*** starting formatting of entries");
        this.out.write(header, 0, header.length());
        this.out.newLine();
        this.out.newLine();
        if (Integer.valueOf(Util.getProperty("POINTER_SIZE")) == 4) {
            headings = "ThreadID TP id  Type         TraceEntry ";
        }
        this.out.write(Util.getTimerDescription() + headings, 0, headings.length() + Util.getTimerDescription().length());
        this.out.newLine();
        try {
            String s;
            Merge merge = new Merge(threads);
            String eol = System.getProperty("line.separator");
            while ((s = merge.getNextEntry()) != null) {
                this.out.write(s + eol);
            }
        }
        catch (InvalidSpannedRecordException isre) {
            outStream.println("\n" + isre.getMessage());
            return;
        }
        this.out.flush();
        outStream.println("*** formatted ");
        outStream.println("Formatted output written to file: " + TraceArgs.outputFile);
    }

    private void instantiateMessageFileOldStyle() {
        try {
            outStream.println("Processing pre 50 trace file with 50 formatter. Searching for the .dat files supplied with the traced vm.");
            outStream.println("****Will look in current directory and directory specified by ibm.dg.trc.format environment variable. ***");
            String directory = System.getProperty("ibm.dg.trc.format");
            this.instantiateMessageFiles(directory);
        }
        catch (Exception ioe) {
            outStream.println("Can't open dat files - you need to copy the dat files from the traced vm to the current directory");
            outStream.println(" or use the -datdir flag to tell the formatter which directory it can find them in");
            Util.Debug.println(ioe);
            return;
        }
    }

    private MessageFile tryMessageFileInstantiation(String fileName) {
        if (fileName != null) {
            try {
                return new MessageFile(fileName);
            }
            catch (IOException ioe) {
                outStream.println("*** Unable to open " + fileName + ": " + ioe);
            }
        }
        return null;
    }

    private String findDatFile(String[] dirsToSearch, String firstFileName) {
        String datfile = null;
        if (dirsToSearch == null || firstFileName == null) {
            return null;
        }
        String currentFile = firstFileName;
        while (currentFile != null) {
            for (int i = 0; i < dirsToSearch.length; ++i) {
                String qualFileName = this.constructFullyQualifiedName(dirsToSearch[i], currentFile);
                File file = new File(qualFileName);
                errStream.println("*** Looking for " + currentFile + " in " + dirsToSearch[i] + ".");
                if (!file.exists()) continue;
                outStream.println("*** Found " + file);
                return qualFileName;
            }
            currentFile = this.traceFile.getNextFormatFileName(currentFile);
        }
        return datfile;
    }

    private void instantiateMessageFiles(String lowestPriorityDefault) {
        String filePath;
        String omrFormatFilePath;
        String legacyJVMFormatFileName = this.traceFile.formatFileName();
        outStream.println("*** Locating formatting template files");
        String[] dirsToSearch = TraceArgs.datFileDirectory == null ? new String[]{".", lowestPriorityDefault} : new String[]{TraceArgs.datFileDirectory, ".", lowestPriorityDefault};
        String jvmFormatFilePath = this.findDatFile(dirsToSearch, legacyJVMFormatFileName);
        if (jvmFormatFilePath == null) {
            jvmFormatFilePath = this.findDatFile(dirsToSearch, "J9TraceFormat.dat");
        }
        if (jvmFormatFilePath != null) {
            messageFile = this.tryMessageFileInstantiation(jvmFormatFilePath);
        }
        if (messageFile == null) {
            outStream.println("*** Could not find a J9TraceFormat.dat file. JVM trace points may be formatted incorrectly.");
        }
        if ((omrFormatFilePath = this.findDatFile(dirsToSearch, "OMRTraceFormat.dat")) != null) {
            this.tryMessageFileInstantiation(omrFormatFilePath);
        }
        if ((filePath = this.findDatFile(dirsToSearch, "TraceFormat.dat")) != null) {
            outStream.println("*** Loading further formatting templates from " + filePath);
            MessageFile messageFileBase = this.tryMessageFileInstantiation(filePath);
            if (messageFile == null) {
                messageFile = messageFileBase;
            }
        }
        if (messageFile == null) {
            outStream.println("Could not find a dat file. No trace point parameters will be formatted.");
        }
    }

    private void instantiateMessageFilesNewStyle() {
        String default_dir = System.getProperty("java.home");
        default_dir = default_dir.concat(File.separator).concat("lib");
        this.instantiateMessageFiles(default_dir);
    }

    private final String constructFullyQualifiedName(String directory, String baseName) {
        return directory + File.separator + baseName;
    }

    private void prime() throws IOException {
        this.globalNumberOfBuffers = 0L;
        this.tempThreadArray = null;
        this.tracedThreads = null;
        this.numberOfThreads = 0;
        this.timeStamps = null;
        long numberOfBuffers = 0L;
        int bufferSize = 0;
        Hashtable<Long, TraceThread> listOfThreadBuffers = new Hashtable<Long, TraceThread>();
        outStream.println("*** Starting data extraction from binary trace file(s) ");
        for (TraceFile this.traceFile : this.traceFiles) {
            this.instantiateMessageFilesNewStyle();
            long dataStart = this.traceFile.traceFileHeader.getTraceDataStart();
            bufferSize = this.traceFile.traceFileHeader.getBufferSize();
            long fileLength = this.traceFile.length();
            int typeOfTrace = this.traceFile.traceFileHeader.traceSection.getTraceType();
            numberOfBuffers = (fileLength - dataStart) / (long)bufferSize;
            this.globalNumberOfBuffers += numberOfBuffers;
            if ((fileLength - dataStart) / (long)bufferSize >= Integer.MAX_VALUE) {
                outStream.println("Trace file " + this.traceFile + " contains more than INT_MAX (" + Integer.MAX_VALUE + ") trace buffers, will only process INT_MAX buffers");
            }
            if ((fileLength - dataStart) % (long)bufferSize != 0L) {
                outStream.println("*** TraceFile is truncated, or corrupted, will ignore some incomplete data at the end, but process everything that is avaiable");
                this.traceFileIsTruncatedOrCorrupt = true;
            }
            if (numberOfBuffers == 0L) {
                outStream.println("\n\n*** " + this.traceFile + " CONTAINS NO TRACE DATA - skipping file.\n\n");
                continue;
            }
            Util.Debug.println("TP data starts at " + dataStart + ", buffer size is " + bufferSize + ": file contains " + numberOfBuffers + " buffers.");
            outStream.println("*** Extracting " + numberOfBuffers + " buffers from " + this.traceFile);
            int j = 0;
            while ((long)j < numberOfBuffers) {
                TraceThread buffersForThread;
                Util.Debug.println("Processing buffer " + j + " at " + (dataStart + (long)(j * bufferSize)));
                TraceRecord50 traceRecord = new TraceRecord50();
                traceRecord.setTraceType(typeOfTrace);
                Util.Debug.println(" buffer is " + (typeOfTrace == 0 ? "internal" : "external"));
                traceRecord.processTraceBufferHeader(this.traceFile, dataStart + (long)j * (long)bufferSize, bufferSize);
                Long threadID = traceRecord.getThreadIDAsLong();
                if (listOfThreadBuffers.containsKey(threadID)) {
                    buffersForThread = (TraceThread)listOfThreadBuffers.get(threadID);
                    buffersForThread.add(traceRecord);
                } else {
                    buffersForThread = new TraceThread(threadID, traceRecord.getThreadName());
                    buffersForThread.addElement(traceRecord);
                    threads.addElement(buffersForThread);
                    listOfThreadBuffers.put(threadID, buffersForThread);
                }
                ++j;
            }
        }
        if (lastWritePlatform.equals(BigInteger.ZERO)) {
            lastWritePlatform = overallStartPlatform;
            lastWriteSystem = overallStartSystem;
            first = overallStartPlatform;
            last = overallStartPlatform;
        }
        outStream.println("*** Sorting buffers");
        for (TraceThread traceThread : threads) {
            Collections.sort(traceThread);
        }
        if (TraceArgs.summary) {
            this.doSummary(new BufferedWriter(new OutputStreamWriter(outStream)));
            return;
        }
        if (this.doSummary(this.out) != 0) {
            outStream.println("*** Problem printing summary to file - may be incomplete ... continuing");
        }
        outStream.println("*** Starting formatting of entries into text file " + TraceArgs.outputFile);
        this.out.write(header, 0, header.length());
        this.out.newLine();
        this.out.newLine();
        int ptrWidth = Integer.valueOf(Util.getProperty("POINTER_SIZE"));
        StringBuffer blanks = new StringBuffer("");
        for (int i = 0; userVMIdentifier != null && i <= userVMIdentifier.length(); ++i) {
            blanks.append(" ");
        }
        headings = ptrWidth == 4 ? blanks + "  ThreadID       TP id     Type        TraceEntry " : blanks + "  ThreadID               TP id     Type        TraceEntry ";
        this.out.write(Util.getTimerDescription() + headings, 0, headings.length() + Util.getTimerDescription().length());
        this.out.newLine();
        this.tempThreadArray = new TraceThread[0];
        this.tracedThreads = threads.toArray(this.tempThreadArray);
        this.numberOfThreads = this.tracedThreads.length;
        System.out.println("*** Number of traced threads = " + this.numberOfThreads);
        this.timeStamps = new BigInteger[this.numberOfThreads];
        this.populateTimeStamps(this.tracedThreads, this.timeStamps, this.numberOfThreads);
        this.primed = true;
    }

    private void readAndFormatNewStyle() throws IOException {
        TracePoint tp;
        if (!this.primed) {
            this.prime();
        }
        double onetenthofbuffers = (double)this.globalNumberOfBuffers / 10.0;
        int nextTenth = 0;
        int numberOfBuffersProcessed = 0;
        long lastThreadID = 0L;
        int tracePointsFormatted = 0;
        while ((tp = this.findNextTracePoint(this.tracedThreads, this.timeStamps, this.numberOfThreads)) != null) {
            if (!tp.isNormalTracepoint()) {
                this.out.write(tp.toString());
                this.out.newLine();
                continue;
            }
            numberOfBuffersProcessed = TraceThread.getBuffersProcessed();
            StringBuffer tempTPString = new StringBuffer();
            if ((double)numberOfBuffersProcessed >= (double)nextTenth * onetenthofbuffers) {
                outStream.print(nextTenth * 10 + "% ");
                ++nextTenth;
            }
            TraceThread tthread = this.getCurrentTraceThread(this.tracedThreads);
            Message msg = MessageFile.getMessageFromID(tp.getComponentName(), tp.getTPID());
            ++tracePointsFormatted;
            long threadID = tp.getThreadID();
            if (Util.findThreadID(threadID)) {
                String formattedTime = tp.getFormattedTime();
                tempTPString.append(formattedTime);
                if (threadID != lastThreadID) {
                    tp.setIsChangeOfThread(true);
                }
                lastThreadID = threadID;
                tempTPString.append(tp.toString());
                tempTPString.append(" ");
                if (msg == null) {
                    Util.Debug.println("No message for tracepoint [" + tp.getComponentName() + "." + tp.getTPID() + "]");
                } else {
                    tempTPString.append(tp.getType());
                    int type = tp.getTypeAsInt();
                    if (TraceArgs.indent) {
                        if (type == 2 || type == 3) {
                            tthread.indent();
                        }
                        for (int x = 0; x < tthread.getIndent(); ++x) {
                            tempTPString.append(" ");
                        }
                        if (type == 4 || type == 5) {
                            tthread.outdent();
                        }
                    }
                    String formattedData = tp.getFormattedParameters();
                    tempTPString.append(formattedData);
                    if (TraceArgs.debug) {
                        tempTPString.append(" " + tp.from());
                    }
                }
                this.out.write(tempTPString.toString());
                this.out.newLine();
            }
            this.populateTimeStamps(this.tracedThreads, this.timeStamps, this.numberOfThreads);
        }
        if (nextTenth < 11) {
            outStream.print("... 100%");
        }
        outStream.print("\n");
        outStream.println("*** Number of formatted tracepoints = " + tracePointsFormatted);
        if ((long)numberOfBuffersProcessed < this.globalNumberOfBuffers) {
            outStream.println("\n" + numberOfBuffersProcessed + "/" + this.globalNumberOfBuffers + " buffers processed successfully\n");
        }
        if (this.traceFileIsTruncatedOrCorrupt) {
            this.out.write(" NOTE - PROBLEMS WERE ENCOUNTERED PROCESSING THE TRACE FILE(S), MOST LIKELY DUE TO TRACE FILE CORRUPTION OR TRUNCATION");
            this.out.newLine();
            this.out.write(" THE CONTENT OF THIS FORMATTED FILE COULD THEREFORE BE TRUNCATED OR CORRUPTED ALSO - REFER TO FORMATTER OUTPUT FOR FURTHER DETAILS");
            this.out.newLine();
        }
        this.out.flush();
        if (lostRecordCount > 0L) {
            outStream.println("*** " + lostRecordCount + " buffers were discarded during trace data generation");
        }
        outStream.println("*** Formatting complete");
        outStream.println("*** Formatted output written to file: " + TraceArgs.outputFile);
    }

    protected int doSummary(BufferedWriter out) throws IOException {
        out.write("                Trace Summary");
        out.newLine();
        out.newLine();
        TraceFile tf = (TraceFile)this.traceFiles.firstElement();
        tf.traceFileHeader.summarize(out);
        out.write("Active Threads :");
        out.newLine();
        for (TraceThread traceThread : threads) {
            out.write("        " + Util.formatAsHexString(traceThread.threadID));
            out.write("  ");
            out.write(traceThread.threadName);
            out.newLine();
        }
        out.newLine();
        if ((double)verMod >= 1.1) {
            BigInteger spanPlatform = lastWritePlatform.subtract(overallStartPlatform);
            BigInteger spanSystem = lastWriteSystem.subtract(overallStartSystem);
            Util.Debug.println("lastWritePlatform:    " + lastWritePlatform);
            Util.Debug.println("lastWriteSystem:      " + lastWriteSystem);
            Util.Debug.println("overallStartPlatform: " + overallStartPlatform);
            Util.Debug.println("overallStartSystem:   " + overallStartSystem);
            Util.Debug.println("spanPlatform:         " + spanPlatform);
            Util.Debug.println("spanSystem:           " + spanSystem);
            timeConversion = overallStartSystem.compareTo(BigInteger.ZERO) != 0 && spanSystem.compareTo(BigInteger.ZERO) != 0 ? spanPlatform.divide(spanSystem) : BigInteger.ONE;
            Util.Debug.println("timeConversion:         " + timeConversion);
            out.write("JVM started      : " + Util.getFormattedTime(overallStartPlatform));
            out.newLine();
            out.newLine();
            out.write("Last buffer write: " + Util.getFormattedTime(lastWritePlatform));
            out.newLine();
            out.newLine();
        }
        String fstring = "First tracepoint:  " + Util.getFormattedTime(first);
        String lstring = "Last tracepoint :  " + Util.getFormattedTime(last);
        out.write(fstring, 0, fstring.length());
        out.newLine();
        out.newLine();
        out.write(lstring, 0, lstring.length());
        out.newLine();
        out.newLine();
        out.newLine();
        out.flush();
        return 0;
    }

    static final void setStartSystem(BigInteger startSystem) {
        if (overallStartSystem.equals(BigInteger.ZERO)) {
            overallStartSystem = startSystem;
        }
        if (overallStartSystem.compareTo(startSystem) == -1) {
            overallStartSystem = startSystem;
        }
    }

    static final void setStartPlatform(BigInteger startPlatform) {
        if (overallStartPlatform.equals(BigInteger.ZERO)) {
            overallStartPlatform = startPlatform;
        }
        if (overallStartPlatform.compareTo(startPlatform) == -1) {
            overallStartPlatform = startPlatform;
        }
    }

    final int getTraceFiles() {
        int RADIX = 36;
        int hash = TraceArgs.traceFile.indexOf("#");
        if (hash == -1) {
            try {
                this.traceFiles.addElement(new TraceFile(TraceArgs.traceFile, "r"));
            }
            catch (FileNotFoundException e) {
                outStream.println("Trace file " + TraceArgs.traceFile + " not found");
                return -1;
            }
            catch (Exception e) {
                e.printStackTrace(errStream);
                return -1;
            }
        } else {
            int i = 0;
            char index = '\u0000';
            for (i = 0; i < RADIX; ++i) {
                index = Integer.toString(i, RADIX).toUpperCase().charAt(0);
                try {
                    this.traceFiles.addElement(new TraceFile(TraceArgs.traceFile.replace('#', index), "r"));
                    continue;
                }
                catch (Exception e) {
                    Util.Debug.println("TraceFormat: generations found " + i);
                    break;
                }
            }
            if (i == 0) {
                outStream.println("Trace file is missing");
                return -1;
            }
            if (i != generations) {
                Util.Debug.println("TraceFormat: generations = " + generations);
                outStream.println("Trace file " + TraceArgs.traceFile.replace('#', index) + " is missing");
            }
            outStream.println("Processing " + (i != generations ? Integer.toString(i) : "all") + " of the " + generations + " generations specified at runtime");
        }
        return 0;
    }

    static final void setGenerations(int gen) {
        generations = gen;
    }

    public static String getUserVMIdentifier() {
        return userVMIdentifier;
    }

    private boolean populateTimeStamps(TraceThread[] tracedThreads, BigInteger[] timeStamps, int numberOfThreads) {
        for (int i = 0; i < numberOfThreads; ++i) {
            timeStamps[i] = tracedThreads[i].getTimeOfNextTracePoint();
        }
        return true;
    }

    private TraceThread getCurrentTraceThread(TraceThread[] tracedThreads) {
        if (this.tracedThreadWithNewestTracePoint < 0) {
            return null;
        }
        return tracedThreads[this.tracedThreadWithNewestTracePoint];
    }

    public com.ibm.jvm.trace.TraceThread[] getTraceThreads() {
        return this.tracedThreads;
    }

    public com.ibm.jvm.trace.TracePoint getNextTracePoint() {
        TracePoint tp = this.findNextTracePoint(this.tracedThreads, this.timeStamps, this.numberOfThreads);
        this.populateTimeStamps(this.tracedThreads, this.timeStamps, this.numberOfThreads);
        return tp;
    }

    private TracePoint findNextTracePoint(TraceThread[] tracedThreads, BigInteger[] timeStamps, int numberOfThreads) {
        this.tracedThreadWithNewestTracePoint = 0;
        if (timeStamps.length == 0 || tracedThreads == null || numberOfThreads == 0) {
            this.tracedThreadWithNewestTracePoint = -1;
            return null;
        }
        BigInteger tempBI = timeStamps[0];
        for (int i = 1; i < numberOfThreads; ++i) {
            if (tempBI == null) {
                tempBI = timeStamps[i];
                this.tracedThreadWithNewestTracePoint = i;
                continue;
            }
            if (timeStamps[i] == null || tempBI.compareTo(timeStamps[i]) <= 0) continue;
            tempBI = timeStamps[i];
            this.tracedThreadWithNewestTracePoint = i;
        }
        if (tempBI == null) {
            this.tracedThreadWithNewestTracePoint = -1;
            return null;
        }
        return tracedThreads[this.tracedThreadWithNewestTracePoint].getNextTracePoint();
    }

    public TraceFileHeader getTraceFileHeader() {
        TraceFile tf = (TraceFile)this.traceFiles.firstElement();
        if (tf == null) {
            return null;
        }
        return tf.getHeader();
    }

    static {
        lostRecordCount = 0L;
        verMod = -1.0f;
        userVMIdentifier = null;
    }
}

