/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.Debug;
import com.ibm.jvm.FormatTimestamp;
import com.ibm.jvm.Indent;
import com.ibm.jvm.InputFile;
import com.ibm.jvm.MessageFile;
import com.ibm.jvm.OutputFile;
import com.ibm.jvm.ProgramOption;
import com.ibm.jvm.Statistics;
import com.ibm.jvm.Summary;
import com.ibm.jvm.Threads;
import com.ibm.jvm.Timezone;
import com.ibm.jvm.Verbose;
import com.ibm.jvm.trace.format.api.MissingDataException;
import com.ibm.jvm.trace.format.api.TraceContext;
import com.ibm.jvm.trace.format.api.TracePointImpl;
import com.ibm.jvm.trace.format.api.TraceThread;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TraceFormat {
    Object[][] options = new Object[][]{{"timezoneoffset", -1, "An offset in hours to add to the time stamps", Boolean.FALSE, Boolean.FALSE}, {"tag", -1, "A string that's prepended to the formatted trace point string to help track and compare trace from multiple JVMs", Boolean.FALSE, Boolean.FALSE}};
    private static Map indentMap = new HashMap();

    public static void main(String[] args) throws Exception {
        TraceContext context;
        ProgramOption.addOption(InputFile.class);
        ProgramOption.addOption(OutputFile.class);
        ProgramOption.addOption(MessageFile.class);
        ProgramOption.addOption(FormatTimestamp.class);
        ProgramOption.addOption(Indent.class);
        ProgramOption.addOption(Summary.class);
        ProgramOption.addOption(Threads.class);
        ProgramOption.addOption(Timezone.class);
        ProgramOption.addOption(Verbose.class);
        ProgramOption.addOption(Debug.class);
        ProgramOption.addOption(Statistics.class);
        try {
            for (int i = 0; i < args.length; ++i) {
                ProgramOption.addArgument(args[i]);
            }
            ProgramOption.applyDefaults();
        }
        catch (IllegalArgumentException e) {
            System.err.println(e.getMessage());
            return;
        }
        List inputFiles = (List)ProgramOption.getValue("input_file");
        List messageFiles = (List)ProgramOption.getValue("datfile");
        List threads = (List)ProgramOption.getValue("threads");
        Integer timezone = (Integer)ProgramOption.getValue("timezone");
        Boolean formatTime = (Boolean)ProgramOption.getValue("format_time");
        Boolean indenting = (Boolean)ProgramOption.getValue("indent");
        Boolean summary = (Boolean)ProgramOption.getValue("summary");
        Boolean verbose = (Boolean)ProgramOption.getValue("verbose");
        Integer debugLevel = (Integer)ProgramOption.getValue("debug");
        Boolean statistics = (Boolean)ProgramOption.getValue("statistics");
        int blockSize = 4000;
        PrintStream error = null;
        PrintStream warning = null;
        PrintStream debug = null;
        if (debugLevel > 0) {
            debug = System.err;
        }
        try {
            while (true) {
                try {
                    MappedByteBuffer data = ((RandomAccessFile)inputFiles.get(0)).getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, blockSize);
                    context = TraceContext.getContext((ByteBuffer)data, (File)messageFiles.get(0), System.out, warning, error, debug);
                }
                catch (BufferUnderflowException e) {
                    blockSize *= 2;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            try {
                byte[] header;
                long length = ((RandomAccessFile)inputFiles.get(0)).length();
                if (length > 0L) {
                    header = new byte[(int)length];
                    ((RandomAccessFile)inputFiles.get(0)).seek(0L);
                    int i = ((RandomAccessFile)inputFiles.get(0)).read(header);
                    if ((long)i != length || length >= (long)blockSize) {
                        throw new Exception("received premature end of file: " + e.getMessage());
                    }
                } else {
                    throw new Exception("empty trace file");
                }
                context = TraceContext.getContext(header, header.length, (File)messageFiles.get(0), System.out, warning, error, debug);
            }
            catch (Exception f) {
                System.err.println("Unable to read trace header from file: " + f.getMessage());
                System.err.println("Please check that the input file is a binary trace file");
                return;
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Problem reading the trace file header: " + e.getMessage());
            System.err.println("Please check that that the input file is a binary trace file");
            return;
        }
        if (verbose.booleanValue() || debugLevel > 0) {
            context.setErrorStream(System.err);
            context.setWarningStream(System.err);
        }
        context.setDebugLevel(debugLevel);
        for (Long id : threads) {
            context.addThreadToFilter(id);
        }
        context.setTimeZoneOffset(timezone);
        for (int i = 1; i < messageFiles.size(); ++i) {
            File file = (File)messageFiles.get(i);
            try {
                context.addMessageData(file);
                continue;
            }
            catch (IOException e) {
                System.err.println("Unable to process trace format data file: " + file.getAbsolutePath() + " (" + e.getMessage() + ")");
                return;
            }
        }
        PrintWriter output = (PrintWriter)ProgramOption.getValue("output_file");
        long recordsInData = 0L;
        long lostCountByException = 0L;
        long start = System.currentTimeMillis();
        long end = 0L;
        long startBlock = start;
        long recordsProcessed = 0L;
        long totalBytes = 0L;
        for (int i = 0; i < inputFiles.size(); ++i) {
            long offset = context.getHeaderSize();
            long recordSize = context.getRecordSize();
            RandomAccessFile traceFile = (RandomAccessFile)inputFiles.get(i);
            long length = traceFile.length();
            if ((length - (long)context.getHeaderSize()) % recordSize != 0L) {
                context.warning(context, "The body of the trace file is not a multiple of the record size, file either truncated or corrupt");
            }
            while (offset < length) {
                try {
                    TraceThread thread = context.addData(traceFile, offset);
                    indentMap.put(thread, "");
                }
                catch (IllegalArgumentException e) {
                    context.error(context, "Bad block of trace data in input file at offset " + offset + ": " + e.getMessage());
                }
                offset += recordSize;
                totalBytes += recordSize;
                ++recordsInData;
            }
        }
        output.println(context.summary());
        if (summary.booleanValue() && !statistics.booleanValue()) {
            output.close();
            return;
        }
        if (!summary.booleanValue()) {
            String columnHeader;
            output.println("                Trace Formatted Data " + System.getProperty("line.separator"));
            if (timezone == 0) {
                columnHeader = "Time (UTC)          ";
            } else {
                columnHeader = timezone > 0 ? "Time (UTC +" : "Time (UTC -";
                columnHeader = columnHeader + Math.abs(timezone / 60) + ":" + Math.abs(timezone % 60) + ")    ";
            }
            columnHeader = context.getPointerSize() == 4 ? columnHeader + "Thread ID " : columnHeader + "Thread ID         ";
            columnHeader = columnHeader + " Tracepoint ID       Type        Tracepoint Data";
            output.println(columnHeader);
        }
        Iterator itr = context.getTracepoints();
        String totalMbytes = (float)totalBytes / 1048576.0f + "Mb";
        context.message(context, "Processing " + totalMbytes + " of binary trace data");
        TraceThread thread = null;
        String indent = "";
        while (itr.hasNext()) {
            TracePointImpl tracepoint;
            try {
                tracepoint = (TracePointImpl)itr.next();
            }
            catch (MissingDataException e) {
                lostCountByException += e.getMissingBytes() / (long)context.getRecordSize();
                continue;
            }
            if (!summary.booleanValue()) {
                TraceThread current = tracepoint.getThread();
                String component = tracepoint.getComponentName();
                int tpID = tracepoint.getID();
                String container = tracepoint.getContainerComponent();
                String parameters = "";
                try {
                    parameters = tracepoint.getFormattedParameters();
                    if (parameters == null || parameters.length() == 0) {
                        context.error(context, "null parameter data for trace point " + component + "." + tpID);
                    }
                }
                catch (BufferUnderflowException e) {
                    context.error(context, "Underflow accessing parameter data for trace point " + component + "." + tpID);
                }
                StringBuilder formatted = new StringBuilder();
                if (formatTime.booleanValue()) {
                    formatted.append(tracepoint.getFormattedTime());
                } else {
                    formatted.append(tracepoint.getRawTime());
                }
                formatted.append(" ").append(current != thread ? "*" : " ");
                formatted.append(context.formatPointer(current.getThreadID()));
                formatted.append(" ");
                String fullTracepointID = String.format(container != null ? "%s(%s).%d" : "%1$s.%3$d", component, container, tpID);
                formatted.append(String.format("%-19s ", fullTracepointID));
                formatted.append(tracepoint.getType());
                if (indenting.booleanValue()) {
                    indent = indentMap.get(current).toString();
                    if (tracepoint.getTypeAsInt() == 4 || tracepoint.getTypeAsInt() == 5) {
                        try {
                            indent = indent.substring(2);
                            indentMap.put(current, indent);
                        }
                        catch (IndexOutOfBoundsException e) {
                            indent = "";
                            indentMap.put(current, "");
                        }
                    }
                    formatted.append(indent);
                }
                formatted.append(parameters.length() > 0 ? (parameters.charAt(0) == '*' ? " " : "") + parameters : "");
                if (indenting.booleanValue() && (tracepoint.getTypeAsInt() == 2 || tracepoint.getTypeAsInt() == 3)) {
                    indent = indent + "  ";
                    indentMap.put(current, indent);
                }
                if (debugLevel > 0) {
                    formatted.append(" [" + tracepoint.getDebugInfo() + "]");
                }
                thread = current;
                output.println(formatted.toString());
            }
            if (context.getTotalRecords() == recordsProcessed) continue;
            recordsProcessed = context.getTotalRecords();
            float processedMbytes = (float)(context.getTotalRecords() * (long)context.getRecordSize()) / 1048576.0f;
            if (processedMbytes % 10.0f != 0.0f) continue;
            int percent = (int)(processedMbytes * 100.0f / (float)(totalBytes / 0x100000L));
            if (verbose.booleanValue()) {
                end = System.currentTimeMillis();
                float MbpsBlock = 10.0f / (float)((double)(end - startBlock) / 1000.0);
                float Mbps = processedMbytes / (float)((double)(end - start) / 1000.0);
                startBlock = System.currentTimeMillis();
                context.message(context, "Processed " + processedMbytes + "Mb (" + percent + "%), burst speed: " + MbpsBlock + "Mb/s, average: " + Mbps + "Mb/s");
                continue;
            }
            context.message(context, "Processed " + processedMbytes + "Mb (" + percent + "%)");
        }
        if (lostCountByException > 0L) {
            context.warning(context, lostCountByException + " records were discarded during trace generation");
        }
        output.close();
        context.message(context, "Completed processing of " + context.getTotalTracePoints() + " tracepoints with " + context.getWarningCount() + " warnings and " + context.getErrorCount() + " errors");
        if (verbose.booleanValue()) {
            end = System.currentTimeMillis();
            float Mbps = (float)(recordsInData * (long)context.getRecordSize()) / ((float)(end - start) / 1000.0f * 1048576.0f);
            context.message(context, "Total processing time " + (end - start) + "ms (" + Mbps + "Mb/s)");
        }
        if (statistics.booleanValue()) {
            context.message(context, context.statistics());
        }
    }
}

