/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm;

import com.ibm.jvm.ProgramOption;
import java.util.TimeZone;

class Timezone
extends ProgramOption {
    Integer timezone;

    Timezone() {
    }

    @Override
    String getDescription() {
        return "Specifies the offset from UTC/GMT to apply when formatting timestamps, as +|-HH:MM";
    }

    @Override
    String getName() {
        return "timezone";
    }

    @Override
    String getUsage() {
        return "-timezone=+|-HH:MM";
    }

    @Override
    Object getValue() {
        return this.timezone;
    }

    @Override
    void setValue(String value) throws IllegalArgumentException {
        try {
            if (value.length() != 6) {
                throw new NumberFormatException();
            }
            int hours = Integer.parseInt(value.substring(1, 3));
            int minutes = Integer.parseInt(value.substring(4, 6));
            if (hours > 12 || minutes > 60) {
                throw new NumberFormatException();
            }
            this.timezone = hours * 60 + minutes;
            if (value.substring(0, 1).equals("-")) {
                this.timezone = -this.timezone.intValue();
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The specified timezone offset \"" + value + "\" is not valid. Format is +|-HH:MM");
        }
    }

    @Override
    void setAutomatic() {
        this.timezone = (TimeZone.getDefault().getRawOffset() + TimeZone.getDefault().getDSTSavings()) / 60000;
    }

    @Override
    void setDefault() {
        this.timezone = 0;
    }
}

