/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.net.IDN;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;

public final class SNIHostName
extends SNIServerName {
    private final String d;
    private static final String[] z;

    public SNIHostName(String string) {
        string = IDN.toASCII(Objects.requireNonNull(string, z[2]), 2);
        super(0, string.getBytes(StandardCharsets.US_ASCII));
        this.d = string;
        this.a();
    }

    public SNIHostName(byte[] byArray) {
        super(0, byArray);
        try {
            CharsetDecoder charsetDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            this.d = IDN.toASCII(charsetDecoder.decode(ByteBuffer.wrap(byArray)).toString());
        }
        catch (RuntimeException | CharacterCodingException exception) {
            throw new IllegalArgumentException(z[1], exception);
        }
        this.a();
    }

    public String getAsciiName() {
        return this.d;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SNIHostName) {
            return this.d.equalsIgnoreCase(((SNIHostName)object).d);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = 31 * n + this.d.toUpperCase(Locale.ENGLISH).hashCode();
        return n;
    }

    @Override
    public String toString() {
        return z[5] + this.d;
    }

    public static SNIMatcher createSNIMatcher(String string) {
        if (string == null) {
            throw new NullPointerException(z[0]);
        }
        return new SNIHostNameMatcher(string);
    }

    private void a() {
        if (this.d.isEmpty()) {
            throw new IllegalArgumentException(z[4]);
        }
        if (this.d.endsWith(".")) {
            throw new IllegalArgumentException(z[3]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n = 0;
        String string2 = "l\u0002z\u000f@]\rjCSJJzWBJ\u000fl\\[W\u0004?LSV\u0004p[\u0012Z\u000f?AGT\u0006";
        int n2 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n3;
                int n4;
                char[] cArray2;
                int n5;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n5 = 0;
                    int n6 = cArray3.length;
                    cArray2 = cArray3;
                    n4 = n6;
                    if (n6 <= 1) break block17;
                    cArray = cArray2;
                    n3 = n4;
                    if (n4 <= n5) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n7 = n5;
                    while (true) {
                        int n8;
                        char c = cArray4[n7];
                        switch (n5 % 5) {
                            case 0: {
                                n8 = 56;
                                break;
                            }
                            case 1: {
                                n8 = 106;
                                break;
                            }
                            case 2: {
                                n8 = 31;
                                break;
                            }
                            case 3: {
                                n8 = 47;
                                break;
                            }
                            default: {
                                n8 = 50;
                            }
                        }
                        cArray4[n7] = (char)(c ^ n8);
                        ++n5;
                        cArray2 = cArray5;
                        n4 = n4;
                        if (n4 != 0) break;
                        cArray5 = cArray2;
                        n3 = n4;
                        n7 = n4;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n3 = n4;
                } while (n4 > n5);
            }
            string = new String(cArray);
            switch (n2) {
                default: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 1;
                    string2 = "l\u0002z\u000fWV\tpKW\\JlJ@N\u000fm\u000f\\Y\u0007z\u000fDY\u0006jJ\u0012Q\u0019?F\\N\u000bsFV";
                    n2 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 2;
                    string2 = "k\u000fmYWJJqN_]JiN^M\u000f?@T\u0018\u0002p\\Fg\u0004~BW\u0018\t~A\\W\u001e?MW\u0018\u0004jC^";
                    n2 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 3;
                    string2 = "k\u000fmYWJJqN_]JiN^M\u000f?@T\u0018\u0002p\\Fg\u0004~BW\u0018\t~A\\W\u001e?GSN\u000f?[Z]Jk]SQ\u0006vAU\u0018\u000ep[";
                    n2 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 4;
                    string2 = "k\u000fmYWJJqN_]JiN^M\u000f?@T\u0018\u0002p\\Fg\u0004~BW\u0018\t~A\\W\u001e?MW\u0018\u000fr_FA";
                    n2 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n = 5;
                    string2 = "L\u0013oJ\u000fP\u0005l[mV\u000brJ\u0012\u0010Z6\u0003\u0012N\u000bsZW\u0005";
                    n2 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n] = string.intern();
        z = stringArray3;
    }

    private static final class SNIHostNameMatcher
    extends SNIMatcher {
        private final Pattern b;
        private static final String[] z;

        SNIHostNameMatcher(String string) {
            super(0);
            this.b = Pattern.compile(string, 2);
        }

        @Override
        public boolean matches(SNIServerName sNIServerName) {
            SNIHostName sNIHostName;
            block12: {
                block13: {
                    if (sNIServerName == null) {
                        throw new NullPointerException(z[1]);
                    }
                    if (sNIServerName instanceof SNIHostName) break block12;
                    if (sNIServerName.getType() == 0) break block13;
                    throw new IllegalArgumentException(z[0]);
                }
                try {
                    sNIHostName = new SNIHostName(sNIServerName.getEncoded());
                }
                catch (IllegalArgumentException | NullPointerException runtimeException) {
                    return false;
                }
            }
            sNIHostName = (SNIHostName)sNIServerName;
            String string = sNIHostName.getAsciiName();
            if (this.b.matcher(string).matches()) {
                return true;
            }
            return this.b.matcher(IDN.toUnicode(string)).matches();
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String string;
            String[] stringArray = new String[2];
            String[] stringArray2 = stringArray;
            String[] stringArray3 = stringArray;
            int n = 0;
            String string2 = "w\u0001t@'F\u001bg\u0005&\u0003\u0007p\r1\u0003\u001dh\u00101\u0003\u0000b@:L\u001d1\b;P\u001dN\u000e5N\f";
            int n2 = -1;
            block9: while (true) {
                char[] cArray;
                block14: {
                    int n3;
                    int n4;
                    char[] cArray2;
                    int n5;
                    block13: {
                        char[] cArray3 = string2.toCharArray();
                        n5 = 0;
                        int n6 = cArray3.length;
                        cArray2 = cArray3;
                        n4 = n6;
                        if (n6 <= 1) break block13;
                        cArray = cArray2;
                        n3 = n4;
                        if (n4 <= n5) break block14;
                    }
                    do {
                        char[] cArray4 = cArray2;
                        char[] cArray5 = cArray2;
                        int n7 = n5;
                        while (true) {
                            int n8;
                            char c = cArray4[n7];
                            switch (n5 % 5) {
                                case 0: {
                                    n8 = 35;
                                    break;
                                }
                                case 1: {
                                    n8 = 105;
                                    break;
                                }
                                case 2: {
                                    n8 = 17;
                                    break;
                                }
                                case 3: {
                                    n8 = 96;
                                    break;
                                }
                                default: {
                                    n8 = 84;
                                }
                            }
                            cArray4[n7] = (char)(c ^ n8);
                            ++n5;
                            cArray2 = cArray5;
                            n4 = n4;
                            if (n4 != 0) break;
                            cArray5 = cArray2;
                            n3 = n4;
                            n7 = n4;
                            cArray4 = cArray2;
                        }
                        cArray = cArray2;
                        n3 = n4;
                    } while (n4 > n5);
                }
                string = new String(cArray);
                switch (n2) {
                    default: {
                        stringArray2[n] = string.intern();
                        stringArray2 = stringArray3;
                        stringArray3 = stringArray3;
                        n = 1;
                        string2 = "w\u0001t@\u0007m B\u0005&U\fc.5N\f1\u0001&D\u001c|\u0005:WIr\u0001:M\u0006e@6FI\u007f\u00158O";
                        n2 = 0;
                        continue block9;
                    }
                    case 0: 
                }
                break;
            }
            stringArray2[n] = string.intern();
            z = stringArray3;
        }
    }
}

