/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins.impl;

import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.ClassListener;
import com.ibm.java.diagnostics.utils.plugins.Container;
import com.ibm.java.diagnostics.utils.plugins.Entry;
import com.ibm.java.diagnostics.utils.plugins.PluginManager;
import com.ibm.java.diagnostics.utils.plugins.impl.ClassScanner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import jdk.internal.org.objectweb.asm.ClassReader;

public class PluginManagerImpl
implements PluginManager {
    protected static final Logger logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
    protected final Container cache = new Container(null);
    protected final ArrayList<File> pluginSearchPath = new ArrayList();
    private static PluginManagerImpl instance = null;
    private final Set<ClassListener> listeners = new HashSet<ClassListener>();
    private URL[] classpath = null;

    public static PluginManager getPluginManager() {
        if (instance == null) {
            instance = new PluginManagerImpl();
        }
        return instance;
    }

    private PluginManagerImpl() {
        this.refreshSearchPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshSearchPath() {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            String[] parts;
            this.pluginSearchPath.clear();
            String property = System.getProperty("com.ibm.java.diagnostics.plugins");
            if (null == property) {
                property = System.getenv("com.ibm.java.diagnostics.plugins");
            }
            if (null == property || property.length() == 0) {
                logger.fine("No system property called com.ibm.java.diagnostics.plugins was found");
                return;
            }
            logger.fine("Plugins search path = " + property);
            for (String part : parts = property.split(File.pathSeparator)) {
                String path = PluginManagerImpl.stripQuotesFromPath(part);
                this.pluginSearchPath.add(new File(path));
            }
        }
    }

    private static String stripQuotesFromPath(String path) {
        if (path.length() > 0 && path.charAt(0) == '\"') {
            path = path.substring(1);
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) == '\"') {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scanForClassFiles() throws CommandException {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            this.classpath = null;
            for (File file : this.pluginSearchPath) {
                logger.fine("Scanning path " + file + " in search of plugins");
                if (!file.exists()) {
                    logger.fine(String.format("Skipping search path: %s does not exist", file.getAbsolutePath()));
                    continue;
                }
                if (file.isDirectory()) {
                    this.scanDirectory(file);
                    continue;
                }
                this.scanFile(file);
            }
        }
    }

    public <T extends Entry> T getEntry(File file) {
        return this.cache.getEntry(file);
    }

    private void scanDirectory(File dir) {
        File[] files;
        logger.fine("Scanning directory " + dir.getAbsolutePath());
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.scanDirectory(file);
                continue;
            }
            this.scanFile(file);
        }
    }

    private static String getExtension(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(46);
        if (-1 == pos || name.length() == pos + 1) {
            return "";
        }
        return name.substring(pos);
    }

    private void scanFile(File file) {
        Entry entry = null;
        logger.fine("Scanning file " + file.getAbsolutePath());
        String ext = PluginManagerImpl.getExtension(file);
        if (ext.equals(".jar") && !file.getName().equalsIgnoreCase("dtfj.jar")) {
            entry = this.examineJarFile(file);
        }
        if (ext.equals(".class") && (entry = this.examineClassFile(file)) != null) {
            for (ClassListener listener : this.listeners) {
                listener.scanComplete(entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry examineClassFile(File file) {
        if (file.length() > Integer.MAX_VALUE) {
            logger.fine("Skipping file " + file.getAbsolutePath() + " as the file size is > Integer.MAX_VALUE");
            return null;
        }
        Object entry = this.getEntry(file);
        if (entry == null || ((Entry)entry).getData() == null || ((Entry)entry).hasChanged(file)) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                ClassInfo info = this.scanClassFile(is, file.toURI().toURL());
                if (entry == null) {
                    entry = new Entry(info.getClassname(), file);
                    this.cache.addEntry((Entry)entry);
                }
                ((Entry)entry).setData(info);
                ((Entry)entry).setSize(file.length());
                ((Entry)entry).setLastModified(file.lastModified());
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage());
            }
            finally {
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException e) {
                    logger.log(Level.FINE, "Error closing file " + file.getAbsolutePath(), e);
                }
            }
        }
        return entry;
    }

    private ClassInfo scanClassFile(InputStream file, URL url) throws IOException {
        ClassScanner scanner = new ClassScanner(url, this.listeners);
        ClassReader cr = new ClassReader(file);
        cr.accept(scanner, 0);
        return scanner.getClassInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entry examineJarFile(File file) {
        logger.fine("Found jar file " + file.getAbsolutePath());
        Container root = (Container)this.getEntry(file);
        if (root == null) {
            root = new Container(file);
            this.cache.addEntry(root);
        }
        if (root.getData() == null || root.hasChanged(file)) {
            JarInputStream jin = null;
            try {
                JarEntry jarentry;
                jin = new JarInputStream(new FileInputStream(file));
                while ((jarentry = jin.getNextJarEntry()) != null) {
                    String entryName = jarentry.getName();
                    if (jarentry.isDirectory() || !entryName.endsWith(".class")) continue;
                    long entrySize = jarentry.getSize();
                    if (entrySize > Integer.MAX_VALUE) {
                        logger.fine("Skipping jar entry " + entryName + " as the uncompressed size is > Integer.MAX_VALUE");
                        continue;
                    }
                    Entry entry = new Entry(entryName);
                    ClassInfo info = this.scanClassFile(jin, entry.toURL());
                    entry.setData(info);
                    entry.setSize(entrySize);
                    entry.setLastModified(jarentry.getTime());
                    root.addEntry(entry);
                }
            }
            catch (IOException e) {
                logger.log(Level.FINE, "Error reading from file " + file.getAbsolutePath(), e);
            }
            finally {
                if (null != jin) {
                    try {
                        jin.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.FINE, "Error closing file " + file.getAbsolutePath(), e);
                    }
                }
            }
            root.setData(new Object());
        }
        for (Entry entry : root.getEntries()) {
            for (ClassListener listener : this.listeners) {
                listener.scanComplete(entry);
            }
        }
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Container getCache() {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            return this.cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(ClassListener listener) {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            if (this.listeners.contains(listener)) {
                this.listeners.remove(listener);
            }
            return this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(ClassListener listener) {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            return this.listeners.remove(listener);
        }
    }

    @Override
    public Set<ClassListener> getListeners() {
        return this.listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL[] getClasspath() {
        ArrayList<File> arrayList = this.pluginSearchPath;
        synchronized (arrayList) {
            if (this.classpath == null) {
                HashSet<URL> urls = new HashSet<URL>();
                for (Entry entry : this.cache.getEntries()) {
                    try {
                        File file = entry.getFile();
                        if (file != null && !(entry instanceof Container)) {
                            ClassInfo info = (ClassInfo)entry.getData();
                            String name = info.getClassname();
                            int pos = -1;
                            do {
                                file = file.getParentFile();
                                pos = name.indexOf(46, pos + 1);
                            } while (file != null && pos != -1);
                        }
                        if (file == null) continue;
                        urls.add(file.toURI().toURL());
                    }
                    catch (Exception e) {
                        logger.log(Level.FINE, "Error setting classpath for plugin " + entry.getName(), e);
                    }
                }
                this.classpath = new URL[urls.size()];
                urls.toArray(this.classpath);
            }
            return this.classpath;
        }
    }
}

