/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins.impl;

import com.ibm.java.diagnostics.utils.plugins.Annotation;
import com.ibm.java.diagnostics.utils.plugins.ClassInfo;
import com.ibm.java.diagnostics.utils.plugins.ClassListener;
import java.net.URL;
import java.util.Set;
import jdk.internal.org.objectweb.asm.AnnotationVisitor;
import jdk.internal.org.objectweb.asm.Attribute;
import jdk.internal.org.objectweb.asm.ClassVisitor;
import jdk.internal.org.objectweb.asm.FieldVisitor;
import jdk.internal.org.objectweb.asm.MethodVisitor;

public class ClassScanner
extends ClassVisitor {
    private ClassInfo info;
    private Annotation currentAnnotation = null;
    private final URL url;
    private final Set<ClassListener> listeners;

    public ClassScanner(URL url, Set<ClassListener> listeners) {
        super(262144, null);
        this.url = url;
        this.listeners = listeners;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String classname, boolean visible) {
        this.currentAnnotation = this.info.addAnnotation(classname);
        for (ClassListener listener : this.listeners) {
            listener.visitAnnotation(classname, visible);
        }
        return new ClassScannerAnnotation(262144);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        String dotName = name.replace('/', '.');
        String dotSuperName = superName.replace('/', '.');
        this.info = new ClassInfo(dotName, this.url);
        for (String iface : interfaces) {
            this.info.addInterface(iface);
        }
        for (ClassListener listener : this.listeners) {
            listener.visit(version, access, dotName, signature, dotSuperName, interfaces);
        }
    }

    @Override
    public void visitAttribute(Attribute attr) {
    }

    @Override
    public void visitEnd() {
    }

    @Override
    public FieldVisitor visitField(int arg0, String arg1, String arg2, String arg3, Object arg4) {
        return null;
    }

    @Override
    public void visitInnerClass(String arg0, String arg1, String arg2, int arg3) {
    }

    @Override
    public MethodVisitor visitMethod(int arg0, String arg1, String arg2, String arg3, String[] arg4) {
        return null;
    }

    @Override
    public void visitOuterClass(String arg0, String arg1, String arg2) {
    }

    @Override
    public void visitSource(String arg0, String arg1) {
    }

    public ClassInfo getClassInfo() {
        return this.info;
    }

    class ClassScannerAnnotation
    extends AnnotationVisitor {
        public ClassScannerAnnotation(int arg0) {
            super(arg0);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return null;
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return null;
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
        }

        @Override
        public void visit(String name, Object value) {
            ClassScanner.this.currentAnnotation.addEntry(name, value);
            for (ClassListener listener : ClassScanner.this.listeners) {
                listener.visitAnnotationValue(name, value);
            }
        }
    }
}

