/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils.plugins;

import com.ibm.java.diagnostics.utils.plugins.ClassListener;
import com.ibm.java.diagnostics.utils.plugins.DTFJClassListener;
import com.ibm.java.diagnostics.utils.plugins.DTFJPluginConfig;
import com.ibm.java.diagnostics.utils.plugins.PluginConfig;
import com.ibm.java.diagnostics.utils.plugins.PluginListenerFactory;
import com.ibm.java.diagnostics.utils.plugins.PluginManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DTFJPluginManager {
    private static final String LISTENER_ID = "dtfj.class.listener";
    private Logger logger = Logger.getLogger("com.ibm.java.diagnostics.plugins");
    public static final String ANNOTATION_CLASSNAME = "Lcom/ibm/java/diagnostics/utils/plugins/DTFJPlugin;";
    private final PluginManager manager;

    public DTFJPluginManager(PluginManager manager) {
        this.manager = manager;
        manager.addListener(new DTFJClassListener(LISTENER_ID));
        String className = System.getProperty("com.ibm.java.diagnostics.plugins.listener");
        if (className != null) {
            try {
                Class<?> clazz = Class.forName(className);
                if (!PluginListenerFactory.class.isAssignableFrom(clazz)) {
                    throw new IllegalArgumentException("The class " + className + " specified by the system property " + "com.ibm.java.diagnostics.plugins.listener" + " does not implement " + PluginListenerFactory.class.getName());
                }
                PluginListenerFactory factory = (PluginListenerFactory)clazz.newInstance();
                Set<ClassListener> listeners = factory.getListeners();
                if (listeners != null) {
                    for (ClassListener listener : listeners) {
                        manager.addListener(listener);
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(Level.FINE, "Error occurred loading listener factory, setting is ignored.", e);
            }
        }
    }

    public List<DTFJPluginConfig> getPlugins(String apiLevel, boolean hasImage, boolean hasRuntime) {
        ArrayList<DTFJPluginConfig> availablePlugins = new ArrayList<DTFJPluginConfig>();
        for (ClassListener listener : this.manager.getListeners()) {
            this.setAvailablePlugins(availablePlugins, listener.getPluginList(), apiLevel, hasImage, hasRuntime);
        }
        return availablePlugins;
    }

    private void setAvailablePlugins(List<DTFJPluginConfig> availablePlugins, Set<PluginConfig> plugins, String apiLevel, boolean hasImage, boolean hasRuntime) {
        if (plugins == null) {
            return;
        }
        for (PluginConfig plugin : plugins) {
            DTFJPluginConfig config;
            Pattern pattern;
            Matcher matcher;
            if (!(plugin instanceof DTFJPluginConfig) || !(matcher = (pattern = Pattern.compile((config = (DTFJPluginConfig)plugin).getVersion())).matcher(apiLevel)).matches() || config.isRuntime() && !hasRuntime || config.isImage() && !hasImage) continue;
            availablePlugins.add(config);
        }
    }
}

