/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.utils;

import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.java.diagnostics.utils.Context;
import com.ibm.java.diagnostics.utils.DTFJImageBean;
import com.ibm.java.diagnostics.utils.IDTFJContext;
import com.ibm.java.diagnostics.utils.commands.CommandException;
import com.ibm.java.diagnostics.utils.commands.ICommand;
import com.ibm.java.diagnostics.utils.plugins.DTFJPluginManager;
import com.ibm.java.diagnostics.utils.plugins.LocalPriorityClassloader;
import com.ibm.java.diagnostics.utils.plugins.PluginConfig;
import com.ibm.java.diagnostics.utils.plugins.PluginLoader;
import com.ibm.java.diagnostics.utils.plugins.PluginManager;
import com.ibm.java.diagnostics.utils.plugins.PluginManagerLocator;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;

public class DTFJContext
extends Context
implements IDTFJContext,
PluginLoader {
    private final JavaRuntime rt;
    private final ImageAddressSpace space;
    private final ImageProcess proc;
    private final int major;
    private final int minor;
    private final Properties props = new Properties();
    private DTFJImageBean bean = null;
    private final String apiLevel;
    private final boolean hasImage;
    private ArrayList<PluginConfig> loadedPlugins = new ArrayList();
    private ArrayList<PluginConfig> failedPlugins = new ArrayList();

    public DTFJContext(int major, int minor, Image image, ImageAddressSpace space, ImageProcess proc, JavaRuntime rt) {
        this.rt = rt;
        this.proc = proc;
        this.space = space;
        this.major = major;
        this.minor = minor;
        this.bean = new DTFJImageBean(image);
        this.hasImage = image != null;
        this.apiLevel = String.format("%d.%d", major, minor);
    }

    @Override
    public Properties getProperties() {
        return this.props;
    }

    @Override
    public int getMajorVersion() {
        return this.major;
    }

    @Override
    public int getMinorVersion() {
        return this.minor;
    }

    @Override
    public ImageAddressSpace getAddressSpace() {
        return this.space;
    }

    @Override
    public JavaRuntime getRuntime() {
        return this.rt;
    }

    @Override
    public ImageProcess getProcess() {
        return this.proc;
    }

    @Override
    public void refresh() {
        ArrayList<String> names = new ArrayList<String>();
        this.commands.clear();
        this.loadedPlugins.clear();
        this.failedPlugins.clear();
        this.addGlobalCommandsToContext();
        PluginManager pluginManager = PluginManagerLocator.getManager();
        DTFJPluginManager manager = new DTFJPluginManager(pluginManager);
        try {
            pluginManager.refreshSearchPath();
            pluginManager.scanForClassFiles();
        }
        catch (CommandException e) {
            logger.log(Level.FINE, "Problem loading DTFJ View plugins: " + e.getMessage());
            logger.log(Level.FINEST, "Problem loading DTFJ View plugins: ", e);
        }
        ClassLoader thisloader = this.getClass().getClassLoader();
        if (thisloader == null) {
            thisloader = ClassLoader.getSystemClassLoader();
        }
        LocalPriorityClassloader loader = new LocalPriorityClassloader(pluginManager.getClasspath(), thisloader);
        for (PluginConfig pluginConfig : manager.getPlugins(this.apiLevel, this.hasImage, this.rt != null)) {
            try {
                ICommand cmd = pluginConfig.newInstance(loader);
                this.loadedPlugins.add(pluginConfig);
                for (String cmdname : cmd.getCommandNames()) {
                    if (names.contains(cmdname)) {
                        logger.fine("Name space clash detected for " + pluginConfig.getClassName() + ". The command name " + cmdname + " is already in use");
                        continue;
                    }
                    names.add(cmdname);
                }
                this.commands.add(cmd);
            }
            catch (CommandException e) {
                this.failedPlugins.add(pluginConfig);
                logger.log(Level.FINE, "Failed to create a new plugin instance for " + pluginConfig.getClassName());
                logger.log(Level.FINEST, "Failed to create a new plugin instance: ", e);
            }
        }
    }

    @Override
    public DTFJImageBean getImage() {
        return this.bean;
    }

    @Override
    public boolean hasPropertyBeenSet(String name) {
        if (this.getProperties().containsKey(name)) {
            Object value = this.getProperties().get(name);
            if (value == null) {
                return false;
            }
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    @Override
    public ArrayList<PluginConfig> getPlugins() {
        return this.loadedPlugins;
    }

    @Override
    public ArrayList<PluginConfig> getPluginFailures() {
        return this.failedPlugins;
    }

    @Override
    public void loadPlugins() throws CommandException {
        this.refresh();
    }

    @Override
    public PluginLoader getPluginClassloader() {
        return this;
    }
}

