/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.java.JavaLocation;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.java.JavaStackFrame;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDJavaLocation;
import com.ibm.dtfj.phd.PHDJavaRuntime;
import java.util.Collections;
import java.util.Iterator;

public class PHDJavaStackFrame
implements JavaStackFrame {
    private JavaLocation loc;
    private CorruptData loc_cd;
    private ImagePointer base;
    private CorruptData base_cd;

    PHDJavaStackFrame(ImageAddressSpace space, PHDJavaRuntime runtime, JavaStackFrame frame) {
        try {
            this.loc = new PHDJavaLocation(space, runtime, frame.getLocation());
        }
        catch (CorruptDataException e) {
            this.loc_cd = new PHDCorruptData(space, e);
        }
        try {
            this.base = frame.getBasePointer();
        }
        catch (CorruptDataException e) {
            this.base_cd = new PHDCorruptData(space, e);
        }
    }

    @Override
    public ImagePointer getBasePointer() throws CorruptDataException {
        if (this.base_cd != null) {
            throw new CorruptDataException(this.base_cd);
        }
        return this.base;
    }

    @Override
    public Iterator<JavaReference> getHeapRoots() {
        return Collections.emptySet().iterator();
    }

    @Override
    public JavaLocation getLocation() throws CorruptDataException {
        if (this.loc_cd != null) {
            throw new CorruptDataException(this.loc_cd);
        }
        return this.loc;
    }
}

