/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaReference;
import com.ibm.dtfj.phd.PHDCorruptData;
import com.ibm.dtfj.phd.PHDCorruptImageSection;
import com.ibm.dtfj.phd.PHDCorruptJavaClass;
import com.ibm.dtfj.phd.PHDImageSection;
import com.ibm.dtfj.phd.PHDJavaClass;
import com.ibm.dtfj.phd.PHDJavaHeap;
import com.ibm.dtfj.phd.PHDJavaReference;
import com.ibm.dtfj.phd.util.LongEnumeration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PHDJavaObject
implements JavaObject {
    private final long address;
    private final PHDJavaHeap heap;
    private JavaClass cls;
    private Object refs;
    private int hashCode;
    private long instanceSize;
    static final int HASHED = 1;
    static final int HASHED_AND_MOVED = 2;
    static final int NO_HASHCODE = 4;
    private int flags;
    static final int SIMPLE_OBJECT = -1;
    static final int UNRESOLVED_TYPE = -2;
    static final int UNKNOWN_TYPE = -3;
    private int length = -2;
    public static final long UNSPECIFIED_INSTANCE_SIZE = -1L;

    public PHDJavaObject(Builder builder) {
        this.heap = builder.heap;
        this.address = builder.address;
        this.cls = builder.cls;
        this.flags = builder.flags;
        this.hashCode = builder.hashCode;
        this.refs = builder.refs;
        this.length = builder.length;
        this.instanceSize = builder.instanceSize;
    }

    @Override
    public void arraycopy(int srcStart, Object dst, int dstStart, int length) throws CorruptDataException, MemoryAccessException {
        String type;
        if (dst == null) {
            throw new NullPointerException("destination null");
        }
        this.fillInDetails(true);
        if (!this.isArray()) {
            throw new IllegalArgumentException(this + " is not an array");
        }
        JavaClass jc = this.getJavaClass();
        try {
            type = jc.getName();
        }
        catch (CorruptDataException e) {
            type = "[L";
        }
        if (srcStart < 0 || length < 0 || dstStart < 0 || srcStart + length < 0 || dstStart + length < 0) {
            throw new IndexOutOfBoundsException(srcStart + "," + dstStart + "," + length);
        }
        if (srcStart + length > this.getArraySize()) {
            throw new IndexOutOfBoundsException(srcStart + "+" + length + ">" + this.getArraySize() + jc);
        }
        if (dst instanceof JavaObject[]) {
            Object[] arefs;
            int count;
            if (!type.startsWith("[[") && !type.startsWith("[L")) {
                throw new IllegalArgumentException("Expected " + type + " not " + dst);
            }
            JavaObject[] dst1 = (JavaObject[])dst;
            if (this.refs instanceof LongEnumeration) {
                LongEnumeration le = (LongEnumeration)this.refs;
                count = le.numberOfElements();
                for (int idx = 0; idx < srcStart && idx < count; ++idx) {
                    le.nextLong();
                }
            } else if (this.refs instanceof int[]) {
                arefs = (int[])this.refs;
                count = arefs.length;
            } else if (this.refs instanceof long[]) {
                arefs = (long[])this.refs;
                count = arefs.length;
            } else {
                throw new CorruptDataException(new PHDCorruptData("Unknown array contents", this.getID()));
            }
            for (int idx = srcStart; idx < srcStart + length; ++idx) {
                PHDJavaObject target;
                if (idx < count) {
                    Object[] arefs2;
                    long ref;
                    if (this.refs instanceof LongEnumeration) {
                        LongEnumeration le = (LongEnumeration)this.refs;
                        ref = le.nextLong();
                    } else if (this.refs instanceof int[]) {
                        arefs2 = (int[])this.refs;
                        ref = this.heap.getJavaRuntime().expandAddress(arefs2[idx]);
                    } else {
                        arefs2 = (long[])this.refs;
                        ref = arefs2[idx];
                    }
                    target = new Builder(this.heap, ref, null, 4, -1).build();
                } else {
                    target = null;
                }
                int dstIndex = dstStart + (idx - srcStart);
                if (dstIndex >= dst1.length) {
                    throw new IndexOutOfBoundsException("Array " + jc + " 0x" + Long.toHexString(this.address) + "[" + this.getArraySize() + "]," + srcStart + "," + dst1 + "[" + dst1.length + "]," + dstStart + "," + length + " at " + idx);
                }
                dst1[dstIndex] = target;
            }
        } else if (dst instanceof byte[]) {
            if (!type.startsWith("[B")) {
                throw new IllegalArgumentException("Expected " + type + " not " + dst);
            }
            byte[] dst1 = (byte[])dst;
            if (dstStart + length > dst1.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (dst instanceof short[]) {
            if (!type.startsWith("[S")) {
                throw new IllegalArgumentException("Expected " + type + " not " + dst);
            }
            short[] dst1 = (short[])dst;
            if (dstStart + length > dst1.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (dst instanceof int[]) {
            if (!type.startsWith("[I")) {
                throw new IllegalArgumentException("Expected " + type + " not " + dst);
            }
            int[] dst1 = (int[])dst;
            if (dstStart + length > dst1.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (dst instanceof long[]) {
            if (!type.startsWith("[J")) {
                throw new IllegalArgumentException("Expected " + type + " not " + dst);
            }
            long[] dst1 = (long[])dst;
            if (dstStart + length > dst1.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (dst instanceof boolean[]) {
            if (!type.startsWith("[Z")) {
                throw new IllegalArgumentException("Expected " + type + " not " + dst);
            }
            boolean[] dst1 = (boolean[])dst;
            if (dstStart + length > dst1.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (dst instanceof char[]) {
            if (!type.startsWith("[C")) {
                throw new IllegalArgumentException("Expected " + type + " not " + dst);
            }
            char[] dst1 = (char[])dst;
            if (dstStart + length > dst1.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (dst instanceof float[]) {
            if (!type.startsWith("[F")) {
                throw new IllegalArgumentException("Expected " + type + " not " + dst);
            }
            float[] dst1 = (float[])dst;
            if (dstStart + length > dst1.length) {
                throw new IndexOutOfBoundsException();
            }
        } else if (dst instanceof double[]) {
            if (!type.startsWith("[D")) {
                throw new IllegalArgumentException("Expected " + type + " not " + dst);
            }
            double[] dst1 = (double[])dst;
            if (dstStart + length > dst1.length) {
                throw new IndexOutOfBoundsException();
            }
        } else {
            throw new IllegalArgumentException("Expected " + type + " not " + dst);
        }
    }

    @Override
    public int getArraySize() throws CorruptDataException {
        if (!this.isArray()) {
            throw new IllegalArgumentException(this + " is not an array");
        }
        if (this.length == -3) {
            throw new CorruptDataException(new PHDCorruptData("Unknown length", this.getID()));
        }
        return this.length;
    }

    @Override
    public long getHashcode() throws DataUnavailable, CorruptDataException {
        this.getJavaClass();
        if ((this.flags & 4) != 0) {
            throw new DataUnavailable("no hashcode available");
        }
        return this.hashCode;
    }

    @Override
    public JavaHeap getHeap() throws CorruptDataException, DataUnavailable {
        return this.heap;
    }

    @Override
    public ImagePointer getID() {
        return this.heap.getImageAddressSpace().getPointer(this.address);
    }

    @Override
    public JavaClass getJavaClass() throws CorruptDataException {
        this.fillInDetails(false);
        if (this.cls == null) {
            PHDCorruptJavaClass cd = new PHDCorruptJavaClass("Unable to get type for object", this.getID(), null);
            throw new CorruptDataException(cd);
        }
        return this.cls;
    }

    @Override
    public long getPersistentHashcode() throws DataUnavailable, CorruptDataException {
        this.getJavaClass();
        if ((this.flags & 4) != 0) {
            throw new DataUnavailable("no hashcode available");
        }
        if ((this.flags & 3) == 0) {
            throw new DataUnavailable("hashcode not persistent");
        }
        return this.hashCode;
    }

    @Override
    public Iterator<JavaReference> getReferences() {
        this.fillInDetails(true);
        final PHDJavaObject source = this;
        return new Iterator<JavaReference>(){
            int count = -1;
            Iterator<JavaClass> loaderCls;
            {
                this.loaderCls = ((PHDJavaObject)PHDJavaObject.this).heap.runtime.getLoaderClasses(source);
            }

            @Override
            public boolean hasNext() {
                if (this.count < 0) {
                    return true;
                }
                if (this.loaderCls.hasNext()) {
                    return true;
                }
                if (PHDJavaObject.this.refs instanceof LongEnumeration) {
                    LongEnumeration le = (LongEnumeration)PHDJavaObject.this.refs;
                    return this.count < le.numberOfElements();
                }
                if (PHDJavaObject.this.refs instanceof long[]) {
                    long[] arefs = (long[])PHDJavaObject.this.refs;
                    return this.count < arefs.length;
                }
                if (PHDJavaObject.this.refs instanceof int[]) {
                    int[] arefs = (int[])PHDJavaObject.this.refs;
                    return this.count < arefs.length;
                }
                return false;
            }

            @Override
            public JavaReference next() {
                long ref;
                JavaClass cls1;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("" + this.count++);
                }
                int refType = 0;
                if (this.count == -1) {
                    cls1 = PHDJavaObject.this.cls;
                    ref = 0L;
                    ++this.count;
                    refType = 1;
                } else if (this.loaderCls.hasNext()) {
                    refType = 11;
                    cls1 = this.loaderCls.next();
                    ref = 0L;
                } else {
                    if (PHDJavaObject.this.refs instanceof LongEnumeration) {
                        LongEnumeration le = (LongEnumeration)PHDJavaObject.this.refs;
                        ref = le.nextLong();
                        ++this.count;
                    } else if (PHDJavaObject.this.refs instanceof int[]) {
                        int[] arefs = (int[])PHDJavaObject.this.refs;
                        ref = PHDJavaObject.this.heap.getJavaRuntime().expandAddress(arefs[this.count++]);
                    } else {
                        long[] arefs = (long[])PHDJavaObject.this.refs;
                        ref = arefs[this.count++];
                    }
                    refType = PHDJavaObject.this.length >= 0 ? 3 : 2;
                    cls1 = PHDJavaObject.this.heap.getJavaRuntime().findClass(ref);
                }
                if (cls1 != null) {
                    return new PHDJavaReference(cls1, source, 1, refType, 0, "?");
                }
                return new PHDJavaReference(new Builder(PHDJavaObject.this.heap, ref, null, 4, -1).build(), source, 1, refType, 0, "?");
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<ImageSection> getSections() {
        PHDImageSection s;
        ArrayList<PHDImageSection> c = new ArrayList<PHDImageSection>();
        try {
            s = new PHDImageSection("Object section", this.getID(), this.getSize());
        }
        catch (CorruptDataException e) {
            s = new PHDCorruptImageSection("Corrupt object section", this.getID());
        }
        c.add(s);
        return c.iterator();
    }

    @Override
    public long getSize() throws CorruptDataException {
        if (this.instanceSize != -1L) {
            return this.instanceSize;
        }
        JavaClass cls = this.getJavaClass();
        if (this.isArray()) {
            return ((PHDJavaClass)cls).getArraySize(this.length);
        }
        return ((PHDJavaClass)cls).getInstanceSize();
    }

    @Override
    public boolean isArray() throws CorruptDataException {
        if (this.length >= 0) {
            return true;
        }
        if (this.length == -1) {
            return false;
        }
        return this.getJavaClass().isArray();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PHDJavaObject)) {
            return false;
        }
        PHDJavaObject p = (PHDJavaObject)o;
        return this.heap.equals(p.heap) && this.address == p.address;
    }

    @Override
    public int hashCode() {
        return (int)this.address ^ (int)(this.address >>> 32);
    }

    private void fillInDetails(boolean withRefs) {
        if (this.length == -2 || withRefs && this.refs == null) {
            JavaObject jo = this.heap.getObjectAtAddress(this.getID(), withRefs);
            if (this.equals(jo)) {
                PHDJavaObject po = (PHDJavaObject)jo;
                if (po.cls != null) {
                    this.cls = po.cls;
                    this.hashCode = po.hashCode;
                    this.flags = po.flags;
                }
                this.length = po.length;
                this.refs = po.refs;
            } else {
                this.length = -3;
            }
        }
    }

    public String toString() {
        try {
            String className = this.getJavaClass().getName();
            return "Instance of " + className + " @ 0x" + Long.toHexString(this.address);
        }
        catch (CorruptDataException e) {
            return super.toString();
        }
    }

    public static class Builder {
        private final PHDJavaHeap heap;
        private final long address;
        private final JavaClass cls;
        private final int flags;
        private final int hashCode;
        private Object refs = null;
        private int length = -2;
        private long instanceSize = -1L;

        public Builder(PHDJavaHeap heap, long address, JavaClass cls, int flags, int hashCode) {
            this.heap = heap;
            this.address = address;
            this.cls = cls;
            this.flags = flags;
            this.hashCode = hashCode;
        }

        public Builder refs(LongEnumeration refs, int skipped) {
            this.refs = this.heap.runtime.convertRefs(refs, skipped);
            return this;
        }

        public Builder refsAsArray(long[] refs, int skipped) {
            this.refs = this.heap.runtime.convertRefs(refs, skipped);
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder instanceSize(long instanceSize) {
            this.instanceSize = instanceSize;
            return this;
        }

        public PHDJavaObject build() {
            return new PHDJavaObject(this);
        }
    }
}

