/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.phd;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageAddressSpace;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageProcess;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.phd.PHDImage;
import com.ibm.dtfj.phd.PHDImagePointer;
import com.ibm.dtfj.phd.PHDImageProcess;
import com.ibm.dtfj.phd.PHDImageSection;
import com.ibm.dtfj.runtime.ManagedRuntime;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.stream.ImageInputStream;

class PHDImageAddressSpace
implements ImageAddressSpace {
    private final List<ImageProcess> processList;
    private final ImageAddressSpace metaImageAddressSpace;

    PHDImageAddressSpace(File file, PHDImage parentImage, ImageAddressSpace metaImageAddressSpace) throws IOException {
        this.metaImageAddressSpace = metaImageAddressSpace;
        this.processList = new ArrayList<ImageProcess>();
        ImageProcess metaProc = metaImageAddressSpace != null ? metaImageAddressSpace.getCurrentProcess() : null;
        this.processList.add(new PHDImageProcess(file, parentImage, (ImageAddressSpace)this, metaProc));
    }

    PHDImageAddressSpace(ImageInputStream stream, PHDImage parentImage, ImageAddressSpace metaImageAddressSpace) throws IOException {
        this.metaImageAddressSpace = metaImageAddressSpace;
        this.processList = new ArrayList<ImageProcess>();
        ImageProcess metaProc = metaImageAddressSpace != null ? metaImageAddressSpace.getCurrentProcess() : null;
        this.processList.add(new PHDImageProcess(stream, parentImage, (ImageAddressSpace)this, metaProc));
    }

    @Override
    public ImageProcess getCurrentProcess() {
        return this.processList.get(0);
    }

    @Override
    public Iterator<ImageSection> getImageSections() {
        ArrayList list = new ArrayList();
        Iterator<ImageProcess> ip = this.getProcesses();
        while (ip.hasNext()) {
            ImageProcess p = ip.next();
            if (p instanceof CorruptData) continue;
            Iterator jr = p.getRuntimes();
            while (jr.hasNext()) {
                ManagedRuntime mr = (ManagedRuntime)jr.next();
                if (mr instanceof CorruptData || !(mr instanceof JavaRuntime)) continue;
                Iterator jh = ((JavaRuntime)mr).getHeaps();
                while (jh.hasNext()) {
                    JavaHeap hp = (JavaHeap)jh.next();
                    if (hp instanceof CorruptData) continue;
                    Iterator is = hp.getSections();
                    while (is.hasNext()) {
                        list.add(is.next());
                    }
                }
            }
        }
        if (this.metaImageAddressSpace != null) {
            Iterator it = this.metaImageAddressSpace.getImageSections();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof ImageSection)) continue;
                ImageSection section = (ImageSection)next;
                PHDImageSection newSection = new PHDImageSection(section.getName(), this.getPointer(section.getBaseAddress().getAddress()), section.getSize());
                list.add(newSection);
            }
        }
        return list.iterator();
    }

    @Override
    public ImagePointer getPointer(long arg0) {
        return new PHDImagePointer(this, arg0);
    }

    @Override
    public Iterator<ImageProcess> getProcesses() {
        return this.processList.iterator();
    }

    @Override
    public String getID() throws DataUnavailable, CorruptDataException {
        return "0";
    }

    @Override
    public Properties getProperties() {
        return new Properties();
    }
}

