/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.parser.j9.section.thread;

import com.ibm.dtfj.javacore.parser.framework.tag.LineRule;
import com.ibm.dtfj.javacore.parser.framework.tag.TagParser;
import com.ibm.dtfj.javacore.parser.j9.section.common.CommonPatternMatchers;
import com.ibm.dtfj.javacore.parser.j9.section.common.PointerSizeLineRule;
import com.ibm.dtfj.javacore.parser.j9.section.thread.NativeStackTraceLineRule;
import com.ibm.dtfj.javacore.parser.j9.section.thread.StackTraceLineRule;
import com.ibm.dtfj.javacore.parser.j9.section.thread.ThreadInfoLineRule;
import com.ibm.dtfj.javacore.parser.j9.section.thread.ThreadPatternMatchers;

public class ThreadTagParser
extends TagParser {
    public ThreadTagParser() {
        super("THREADS");
    }

    @Override
    protected void initTagAttributeRules() {
        this.initThreadInfoTag();
        this.initThreadInfo1Tag();
        this.initThreadInfo2Tag();
        this.initCPUTimeTag();
        this.initThreadBlockTag();
        this.initStackTraceTag();
        this.initNativeStackTraceTag();
        this.initOSInfoTag();
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
            }
        };
        this.addTag("1XMCURTHDINFO", lineRule);
        this.addTag("1XMTHDINFO", null);
    }

    private void initCPUTimeTag() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(ThreadPatternMatchers.cpu_time_total);
                this.addToken("cpu_time_total", ThreadPatternMatchers.cpu_time);
                if (this.consumeUntilFirstMatch(ThreadPatternMatchers.cpu_time_user)) {
                    this.addToken("cpu_time_user", ThreadPatternMatchers.cpu_time);
                }
                if (this.consumeUntilFirstMatch(ThreadPatternMatchers.cpu_time_system)) {
                    this.addToken("cpu_time_system", ThreadPatternMatchers.cpu_time);
                }
            }
        };
        this.addTag("3XMCPUTIME", lineRule);
    }

    private void initThreadInfoTag() {
        ThreadInfoLineRule lineRule = new ThreadInfoLineRule();
        this.addTag("3XMTHREADINFO", lineRule);
    }

    private void initOSInfoTag() {
        PointerSizeLineRule lineRule = new PointerSizeLineRule();
        this.addTag("2XMFULLTHDDUMP", lineRule);
    }

    private void initThreadInfo1Tag() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addPrefixedHexToken("native_thread_id");
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addPrefixedHexToken("native_thread_priority");
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addToken("native_thread_policy", CommonPatternMatchers.lettervalue);
                if (this.findFirst(ThreadPatternMatchers.scope) && this.consumeUntilFirstMatch(CommonPatternMatchers.colon)) {
                    this.addPrefixedHexToken("scope");
                }
                if (this.findFirst(ThreadPatternMatchers.vmstate) && this.consumeUntilFirstMatch(CommonPatternMatchers.colon)) {
                    this.addToken("vm_thread_state", CommonPatternMatchers.lettervalue);
                }
                if (this.findFirst(ThreadPatternMatchers.vmflags) && this.consumeUntilFirstMatch(CommonPatternMatchers.colon)) {
                    this.addPrefixedHexToken("vm_thread_flags");
                }
            }
        };
        this.addTag("3XMTHREADINFO1", lineRule);
    }

    private void initThreadInfo2Tag() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addPrefixedHexToken("native_stack_from");
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addPrefixedHexToken("native_stack_to");
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.addPrefixedHexToken("native_stack_size");
            }
        };
        this.addTag("3XMTHREADINFO2", lineRule);
    }

    private void initStackTraceTag() {
        this.addTag("3XMTHREADINFO3", null);
        StackTraceLineRule lineRule = new StackTraceLineRule();
        this.addTag("4XESTACKTRACE", lineRule);
    }

    private void initNativeStackTraceTag() {
        NativeStackTraceLineRule lineRule = new NativeStackTraceLineRule();
        this.addTag("4XENATIVESTACK", lineRule);
    }

    private void initThreadBlockTag() {
        LineRule lineRule = new LineRule(){

            @Override
            public void processLine(String source, int startingOffset) {
                this.consumeUntilFirstMatch(CommonPatternMatchers.colon);
                this.consumeUntilFirstMatch(CommonPatternMatchers.whitespace);
                this.addAllCharactersAsTokenAndConsumeFirstMatch("blocker_object_full_java_name", CommonPatternMatchers.at_symbol);
                this.addPrefixedHexToken("blocker_object_address");
            }
        };
        this.addTag("3XMTHREADBLOCK", lineRule);
    }
}

