/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.MemoryAccessException;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.java.JavaClass;
import com.ibm.dtfj.java.JavaClassLoader;
import com.ibm.dtfj.java.JavaField;
import com.ibm.dtfj.java.JavaHeap;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaRuntime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public abstract class JavaAbstractClass
implements JavaClass {
    protected ImagePointer _classPointer;
    protected JavaRuntime _javaVM;
    private int _modifiers;
    private Vector _interfaceNames = new Vector();
    private long _classLoaderID;
    private ImagePointer _objectID;
    private int _flagOffset;
    private int _hashcodeSlot;
    private static final String PROTECTION_DOMAIN_FIELD_NAME = "protectionDomain";
    private static final int SYNTHETIC = 4096;
    private static final int ANNOTATION = 8192;
    private static final int ENUM = 16384;
    private static DomainSearchOrder pdSearchOrder = DomainSearchOrder.UNDEFINED;

    protected JavaAbstractClass(JavaRuntime vm, ImagePointer id, int modifiers, long loaderID, ImagePointer objectID, int flagOffset, int hashcodeSlot) {
        if (null == id) {
            throw new IllegalArgumentException("Java class pointer must be non-null");
        }
        if (null == vm) {
            throw new IllegalArgumentException("Java VM for a class must not be null");
        }
        this._javaVM = vm;
        this._classPointer = id;
        this._modifiers = modifiers;
        this._classLoaderID = loaderID;
        this._objectID = objectID;
        this._flagOffset = flagOffset;
        this._hashcodeSlot = hashcodeSlot;
    }

    @Override
    public JavaClassLoader getClassLoader() throws CorruptDataException {
        return this._javaVM.getClassLoaderForID(this._classLoaderID);
    }

    @Override
    public JavaObject getObject() throws CorruptDataException {
        ImagePointer pointer = this._objectID == null ? this._classPointer : this._objectID;
        try {
            return this._javaVM.getObjectAtAddress(pointer);
        }
        catch (IllegalArgumentException e) {
            throw new CorruptDataException(new CorruptData(e.getMessage(), pointer));
        }
    }

    @Override
    public int getModifiers() throws CorruptDataException {
        int rawModifiers = this._modifiers;
        rawModifiers = this.isArray() ? (rawModifiers &= 0x417) : (rawModifiers &= 0x761F);
        return rawModifiers;
    }

    @Override
    public ImagePointer getID() {
        return this._classPointer;
    }

    @Override
    public Iterator getInterfaces() {
        return this._interfaceNames.iterator();
    }

    public void addInterfaceName(String interfaceName) {
        this._interfaceNames.add(interfaceName);
    }

    public abstract int getInstanceSize(JavaObject var1);

    @Override
    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaAbstractClass) {
            JavaAbstractClass clazz = (JavaAbstractClass)obj;
            isEqual = this.getClass().equals(clazz.getClass()) && this._javaVM.equals(clazz._javaVM) && this._classPointer.equals(clazz._classPointer);
        }
        return isEqual;
    }

    public int getHashcodeSlotSize() {
        return this._hashcodeSlot;
    }

    @Override
    public int hashCode() {
        return this._javaVM.hashCode() ^ this._classPointer.hashCode();
    }

    public int readFlagsFromInstance(JavaObject instance) throws MemoryAccessException, CorruptDataException {
        try {
            com.ibm.dtfj.java.j9.JavaHeap heap;
            JavaHeap ersatzHeap = instance.getHeap();
            if (ersatzHeap != null && !(ersatzHeap instanceof com.ibm.dtfj.image.CorruptData) && (heap = (com.ibm.dtfj.java.j9.JavaHeap)ersatzHeap).isSWH()) {
                return (int)(instance.getID().getPointerAt(this._flagOffset).getAddress() & 0xFFL);
            }
        }
        catch (CorruptDataException corruptDataException) {
        }
        catch (DataUnavailable dataUnavailable) {
            // empty catch block
        }
        return instance.getID().getIntAt(this._flagOffset);
    }

    protected void addClassLoaderReference(Collection coll) {
        JavaReference jRef = null;
        try {
            JavaObject classLoaderObject;
            JavaClassLoader classLoader = this.getClassLoader();
            if (null != classLoader && null != (classLoaderObject = classLoader.getObject())) {
                jRef = new JavaReference(this._javaVM, (Object)this, classLoaderObject, "Classloader", 4, 0, 1);
                coll.add(jRef);
            }
        }
        catch (CorruptDataException e) {
            coll.add(e.getCorruptData());
        }
    }

    protected void addSuperclassReference(Collection coll) {
        JavaReference jRef = null;
        try {
            JavaClass superClass = this.getSuperclass();
            if (null != superClass) {
                jRef = new JavaReference(this._javaVM, (Object)this, superClass, "Superclass", 10, 0, 1);
                coll.add(jRef);
            }
        }
        catch (CorruptDataException e) {
            coll.add(e.getCorruptData());
        }
    }

    protected void addClassObjectReference(Collection coll) {
        JavaReference jRef = null;
        try {
            JavaObject classObject = this.getObject();
            if (null != classObject) {
                jRef = new JavaReference(this._javaVM, (Object)this, classObject, "Class object", 12, 0, 1);
                coll.add(jRef);
            }
        }
        catch (CorruptDataException e) {
            coll.add(e.getCorruptData());
        }
    }

    private JavaField getProtectionDomainField(JavaClass clazz) throws CorruptDataException {
        Iterator fieldsIt = clazz.getDeclaredFields();
        while (fieldsIt.hasNext()) {
            JavaField field;
            Object potential = fieldsIt.next();
            if (!(potential instanceof JavaField) || !(field = (JavaField)potential).getName().equals(PROTECTION_DOMAIN_FIELD_NAME)) continue;
            return field;
        }
        return null;
    }

    @Override
    public JavaObject getProtectionDomain() throws DataUnavailable, CorruptDataException {
        Object potential;
        JavaField _protectionDomainField = null;
        switch (pdSearchOrder) {
            case UNDEFINED: {
                _protectionDomainField = this.getProtectionDomainField(this);
                if (_protectionDomainField == null) {
                    _protectionDomainField = this.getProtectionDomainField(this.getObject().getJavaClass());
                    if (_protectionDomainField == null) break;
                    pdSearchOrder = DomainSearchOrder.JAVA_LANG_FIRST;
                    break;
                }
                pdSearchOrder = DomainSearchOrder.J9CLASS_FIRST;
                break;
            }
            case J9CLASS_FIRST: {
                _protectionDomainField = this.getProtectionDomainField(this);
                if (_protectionDomainField != null || (_protectionDomainField = this.getProtectionDomainField(this.getObject().getJavaClass())) == null) break;
                pdSearchOrder = DomainSearchOrder.JAVA_LANG_FIRST;
                break;
            }
            case JAVA_LANG_FIRST: {
                _protectionDomainField = this.getProtectionDomainField(this.getObject().getJavaClass());
                if (_protectionDomainField != null || (_protectionDomainField = this.getProtectionDomainField(this)) == null) break;
                pdSearchOrder = DomainSearchOrder.J9CLASS_FIRST;
            }
        }
        if (_protectionDomainField == null) {
            throw new DataUnavailable("The protection domain is not available");
        }
        try {
            potential = _protectionDomainField.get(this.getObject());
        }
        catch (MemoryAccessException e) {
            if (e.getPointer() == null) {
                CorruptData cd = new CorruptData("Invalid memory access : " + e.getMessage(), this._classPointer);
                throw new CorruptDataException(cd);
            }
            CorruptData cd = new CorruptData("Invalid memory access : " + e.getPointer().toString(), this._classPointer);
            throw new CorruptDataException(cd);
        }
        if (potential == null) {
            return null;
        }
        if (potential instanceof JavaObject) {
            return (JavaObject)potential;
        }
        CorruptData cd = new CorruptData("Unable to get protection domain", this._classPointer);
        throw new CorruptDataException(cd);
    }

    private static enum DomainSearchOrder {
        UNDEFINED,
        J9CLASS_FIRST,
        JAVA_LANG_FIRST;

    }
}

