/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.image.javacore;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImageModule;
import com.ibm.dtfj.image.ImageSymbol;
import com.ibm.dtfj.image.javacore.JCCorruptData;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;

public class JCImageModule
implements ImageModule {
    private Vector fSections;
    private Vector fSymbols;
    private Properties fProperties;
    private final String fName;

    public JCImageModule(String name) {
        this.fName = name;
        this.fSections = new Vector();
        this.fSymbols = new Vector();
        this.fProperties = new Properties();
    }

    @Override
    public String getName() throws CorruptDataException {
        if (this.fName == null) {
            throw new CorruptDataException(new JCCorruptData("No name found for library", null));
        }
        return this.fName;
    }

    public String getInternalName() {
        return this.fName;
    }

    @Override
    public Properties getProperties() throws CorruptDataException {
        if (this.fProperties.size() == 0) {
            throw new CorruptDataException(new JCCorruptData("No properties available for " + this.fName, null));
        }
        return this.fProperties;
    }

    public void addProperty(String key, String value) {
        this.fProperties.put(key, value);
    }

    @Override
    public Iterator getSections() {
        return this.fSections.iterator();
    }

    @Override
    public Iterator getSymbols() {
        return this.fSymbols.iterator();
    }

    public void addSymbol(ImageSymbol symbol) {
        if (!this.fSymbols.contains(symbol)) {
            this.fSymbols.add(symbol);
        }
    }

    @Override
    public long getLoadAddress() throws DataUnavailable {
        throw new DataUnavailable("no load address in a javacore");
    }
}

