/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class Symbol {
    String symbolName;
    long symbolStart;
    long symbolEnd;
    int symbolType;
    int symbolBinding;
    protected static HashMap knownSymbolsByName;
    protected static TreeMap symbolTree;
    static final int STB_UNKNOWN = -1;
    static final int STB_LOCAL = 0;
    static final int STB_GLOBAL = 1;
    static final int STB_WEAK = 2;
    static final int STT_NOTYPE = 0;
    static final int STT_OBJECT = 1;
    static final int STT_FUNC = 2;
    static final int STT_SECTION = 3;
    static final int STT_FILE = 4;
    static final int STT_COMMON = 5;
    static final int STT_TLS = 6;
    static final int STT_LOOS = 10;
    static final int STT_HIOS = 12;
    static final int STT_LOPROC = 13;
    static final int STT_HIPROC = 15;

    public Symbol(String name, long address, int extent, int type, int bind) {
        Object o;
        if (null == knownSymbolsByName) {
            knownSymbolsByName = new HashMap();
        }
        if ((o = knownSymbolsByName.get(name)) == null) {
            this.symbolName = name;
            this.symbolStart = address;
            this.symbolType = type;
            this.symbolBinding = bind;
            this.symbolEnd = extent != -1 ? address + (long)extent : -1L;
            knownSymbolsByName.put(name, this);
            if (null == symbolTree) {
                SymbolComparator c = new SymbolComparator();
                symbolTree = new TreeMap(c);
            }
            symbolTree.put(address, this);
        }
    }

    public static Symbol getSymbol(String name) {
        Symbol retSym = null;
        retSym = (Symbol)knownSymbolsByName.get(name);
        return retSym;
    }

    public static String getSymbolForAddress(long address) {
        String retString = null;
        SortedMap head = symbolTree.headMap(address);
        if (head != null && !head.isEmpty()) {
            Symbol s = (Symbol)symbolTree.get(head.lastKey());
            if (s.symbolEnd != -1L && address <= s.symbolEnd && address > s.symbolStart) {
                long diff = address - s.symbolStart;
                retString = s.symbolName + "+0x" + Long.toHexString(diff);
            }
        }
        return retString;
    }

    public long getSymbolEnd() {
        return this.symbolEnd;
    }

    public String getSymbolName() {
        return this.symbolName;
    }

    public long getSymbolStart() {
        return this.symbolStart;
    }

    public static Iterator getSymbolsIterator() {
        return symbolTree.keySet().iterator();
    }

    public static Symbol getSymbolUsingValue(Long l) {
        Symbol s = (Symbol)symbolTree.get(l);
        return s;
    }

    static final class SymbolComparator
    implements Comparator {
        SymbolComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            long addr0 = 0L;
            long addr1 = 0L;
            if (arg0 instanceof Symbol) {
                Symbol S0 = (Symbol)arg0;
                Symbol S1 = (Symbol)arg1;
                addr0 = S0.symbolStart;
                addr1 = S1.symbolStart;
            } else {
                addr0 = (Long)arg0;
                addr1 = (Long)arg1;
            }
            if (addr0 >= 0L && addr1 >= 0L) {
                if (addr0 == addr1) {
                    return 0;
                }
                if (addr0 < addr1) {
                    return -1;
                }
                return 1;
            }
            if (addr0 < 0L && addr1 < 0L) {
                if (addr0 == addr1) {
                    return 0;
                }
                if (addr0 < addr1) {
                    return 1;
                }
                return -1;
            }
            if (addr0 < 0L && addr1 >= 0L) {
                return 1;
            }
            return -1;
        }
    }
}

