/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.corereaders;

import com.ibm.dtfj.corereaders.DumpReader;
import com.ibm.dtfj.corereaders.NewAixDump;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class Aix64Dump
extends NewAixDump {
    private static final long THRDENTRY64_V1_SIZE = 424L;
    private static final long THRDENTRY64_V2_SIZE = 512L;
    private static final long THRDCTX64_V1 = 1000L;
    private static final long THRDCTX64_V2 = 1088L;
    private static final int GPR_COUNT = 32;
    private boolean hasVersionBeenDetermined = false;
    private long sizeofThreadCtx64 = 1000L;
    private long sizeofThreadEntry64 = 424L;

    protected Aix64Dump(DumpReader reader) throws IOException {
        super(reader);
        this.readCore();
    }

    @Override
    protected int readLoaderInfoFlags() throws IOException {
        return this.coreReadInt();
    }

    @Override
    protected long userInfoOffset() {
        return 1216L;
    }

    @Override
    protected int pointerSize() {
        return 64;
    }

    @Override
    protected Map readRegisters(long threadOffset) throws IOException {
        if (!this.hasVersionBeenDetermined) {
            this.calculateThreadStructureSizes(threadOffset);
        }
        this.coreSeek(threadOffset + this.sizeofThreadEntry64);
        TreeMap<String, Number> registers = new TreeMap<String, Number>();
        for (int i = 0; i < 32; ++i) {
            registers.put("gpr" + i, this.coreReadLong());
        }
        registers.put("msr", this.coreReadLong());
        registers.put("iar", this.coreReadLong());
        registers.put("lr", this.coreReadLong());
        registers.put("ctr", this.coreReadLong());
        registers.put("cr", this.coreReadInt());
        registers.put("xer", this.coreReadInt());
        registers.put("fpscr", this.coreReadInt());
        return registers;
    }

    public void calculateThreadStructureSizes(long threadOffset) {
        long address;
        try {
            this.coreSeek(threadOffset + 424L + 8L);
            address = this.coreReadLong();
        }
        catch (IOException e) {
            return;
        }
        if (null == this.memoryRangeFor(address)) {
            this.sizeofThreadEntry64 = 512L;
            this.sizeofThreadCtx64 = 1088L;
        } else {
            this.sizeofThreadEntry64 = 424L;
            this.sizeofThreadCtx64 = 1000L;
        }
        this.hasVersionBeenDetermined = true;
    }

    @Override
    protected long threadSize(long threadOffset) {
        if (!this.hasVersionBeenDetermined) {
            this.calculateThreadStructureSizes(threadOffset);
        }
        return this.sizeofThreadCtx64;
    }

    @Override
    protected long getStackPointerFrom(Map registers) {
        return (Long)registers.get("gpr1");
    }

    @Override
    protected long getInstructionPointerFrom(Map registers) {
        return (Long)registers.get("iar");
    }

    @Override
    protected long getLinkRegisterFrom(Map registers) {
        return (Long)registers.get("lr");
    }

    @Override
    protected int sizeofTopOfStack() {
        return 304;
    }
}

