/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

import com.ibm.dataaccess.CommonData;
import com.ibm.dataaccess.DecimalData;
import java.math.BigInteger;
import java.util.Arrays;

public final class PackedDecimal {
    private static final ThreadLocal<PackedDecimalOperand> op1_threadLocal = new ThreadLocal<PackedDecimalOperand>(){

        @Override
        protected PackedDecimalOperand initialValue() {
            return new PackedDecimalOperand();
        }
    };
    private static final ThreadLocal<PackedDecimalOperand> op2_threadLocal = new ThreadLocal<PackedDecimalOperand>(){

        @Override
        protected PackedDecimalOperand initialValue() {
            return new PackedDecimalOperand();
        }
    };
    private static final ThreadLocal<PackedDecimalOperand> sum_threadLocal = new ThreadLocal<PackedDecimalOperand>(){

        @Override
        protected PackedDecimalOperand initialValue() {
            return new PackedDecimalOperand();
        }
    };
    private static final int MULTIPLY = 1;
    private static final int DIVIDE = 2;
    private static final int REMAINDER = 3;

    private PackedDecimal() {
    }

    public static int checkPackedDecimal(byte[] byteArray, int offset, int precision, boolean ignoreHighNibbleForEvenPrecision, boolean canOverwriteHighNibbleForEvenPrecision) {
        if (offset + (precision / 2 + 1) > byteArray.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. checkPackedDecimal is trying to access byteArray[" + offset + "] to byteArray[" + (offset + precision / 2) + "] but valid indices are from 0 to " + (byteArray.length - 1) + ".");
        }
        return PackedDecimal.checkPackedDecimal_(byteArray, offset, precision, ignoreHighNibbleForEvenPrecision, canOverwriteHighNibbleForEvenPrecision);
    }

    private static int checkPackedDecimal_(byte[] byteArray, int offset, int precision, boolean ignoreHighNibbleForEvenPrecision, boolean canOverwriteHighNibbleForEvenPrecision) {
        int i;
        if (precision < 1) {
            throw new IllegalArgumentException("Illegal Precision.");
        }
        boolean evenPrecision = precision % 2 == 0;
        int signOffset = offset + CommonData.getPackedByteCount(precision) - 1;
        int returnCode = 0;
        if (canOverwriteHighNibbleForEvenPrecision && evenPrecision) {
            byteArray[offset] = (byte)(byteArray[offset] & 0xF);
        }
        if (evenPrecision && ignoreHighNibbleForEvenPrecision) {
            if ((byteArray[offset] & 0xF) > 9) {
                returnCode = 2;
            }
            ++offset;
        }
        for (i = offset; i < signOffset && byteArray[i] == 0; ++i) {
        }
        while (i < signOffset) {
            if ((byteArray[i] & 0xF) > 9 || (byteArray[i] & 0xF0 & 0xFF) > 144) {
                returnCode = 2;
                break;
            }
            ++i;
        }
        if (i == signOffset && (byteArray[signOffset] & 0xF0 & 0xFF) > 144) {
            returnCode = 2;
        }
        if ((byteArray[signOffset] & 0xF) < 10) {
            ++returnCode;
        }
        return returnCode;
    }

    public static int checkPackedDecimal(byte[] byteArray, int offset, int precision, boolean ignoreHighNibbleForEvenPrecision) {
        return PackedDecimal.checkPackedDecimal(byteArray, offset, precision, ignoreHighNibbleForEvenPrecision, false);
    }

    public static int checkPackedDecimal(byte[] byteArray, int offset, int precision) {
        return PackedDecimal.checkPackedDecimal(byteArray, offset, precision, false, false);
    }

    private static void copyRemainingDigits(PackedDecimalOperand op1, PackedDecimalOperand op2, boolean checkOverflow) throws ArithmeticException {
        int bytes;
        PackedDecimalOperand sum = sum_threadLocal.get();
        if (op1.currentOffset >= op1.offset) {
            bytes = op1.currentOffset - op1.offset + 1;
            int sumBytes = sum.currentOffset - sum.offset + 1;
            if (bytes >= sumBytes) {
                if (checkOverflow && bytes > sumBytes) {
                    throw new ArithmeticException("Decimal overflow during addition/subtraction.");
                }
                bytes = sum.currentOffset - sum.offset + 1;
                sum.currentOffset = sum.currentOffset - bytes + 1;
                op1.currentOffset += -bytes + 1;
                System.arraycopy(op1.byteArray, op1.currentOffset, sum.byteArray, sum.currentOffset, bytes);
                if (sum.precision % 2 == 0) {
                    byte highNibble = (byte)(sum.byteArray[sum.currentOffset] & 0xF0);
                    if (checkOverflow && bytes == sumBytes && highNibble != 0) {
                        throw new ArithmeticException("Decimal overflow during addition/subtraction.");
                    }
                    int n = sum.currentOffset;
                    sum.byteArray[n] = (byte)(sum.byteArray[n] & 0xF);
                }
            } else {
                sum.currentOffset = sum.currentOffset - bytes + 1;
                System.arraycopy(op1.byteArray, op1.offset, sum.byteArray, sum.currentOffset, bytes);
            }
            --sum.currentOffset;
        }
        if (sum.currentOffset >= sum.offset) {
            bytes = sum.currentOffset - sum.offset + 1;
            Arrays.fill(sum.byteArray, sum.offset, sum.offset + bytes, (byte)0);
        }
    }

    public static void addPackedDecimal(byte[] result, int resultOffset, int resultPrecision, byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision, boolean checkOverflow) throws ArithmeticException {
        if (resultOffset + (resultPrecision / 2 + 1) > result.length || resultOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. addPackedDecimal is trying to access result[" + resultOffset + "] to result[" + (resultOffset + resultPrecision / 2) + "] but valid indices are from 0 to " + (result.length - 1) + ".");
        }
        if (op1Offset < 0 || op1Offset + (op1Precision / 2 + 1) > op1Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. addPackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. addPackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        PackedDecimal.addPackedDecimal_(result, resultOffset, resultPrecision, op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision, checkOverflow);
    }

    private static void addPackedDecimal_(byte[] result, int resultOffset, int resultPrecision, byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision, boolean checkOverflow) throws ArithmeticException {
        sum_threadLocal.get().setSumOperand(result, resultOffset, resultPrecision);
        op1_threadLocal.get().setOperand(op1Decimal, op1Offset, op1Precision);
        op2_threadLocal.get().setOperand(op2Decimal, op2Offset, op2Precision);
        PackedDecimal.computeValue(checkOverflow);
    }

    public static void subtractPackedDecimal(byte[] result, int resultOffset, int resultPrecision, byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision, boolean checkOverflow) throws ArithmeticException {
        if (resultOffset + (resultPrecision / 2 + 1) > result.length || resultOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. subtractPackedDecimal is trying to access result[" + resultOffset + "] to result[" + (resultOffset + resultPrecision / 2) + "] but valid indices are from 0 to " + (result.length - 1) + ".");
        }
        if (op1Offset < 0 || op1Offset + (op1Precision / 2 + 1) > op1Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. subtractPackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. subtractPackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        PackedDecimal.subtractPackedDecimal_(result, resultOffset, resultPrecision, op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision, checkOverflow);
    }

    private static void subtractPackedDecimal_(byte[] result, int resultOffset, int resultPrecision, byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision, boolean checkOverflow) throws ArithmeticException {
        PackedDecimalOperand sum = sum_threadLocal.get();
        PackedDecimalOperand op1 = op1_threadLocal.get();
        PackedDecimalOperand op2 = op2_threadLocal.get();
        sum.setSumOperand(result, resultOffset, resultPrecision);
        op1.setOperand(op1Decimal, op1Offset, op1Precision);
        op2.setOperand(op2Decimal, op2Offset, op2Precision);
        op2.sign = (op2.sign & 0xF) == 12 ? op2.sign & 0xF0 | 0xD : op2.sign & 0xF0 | 0xC;
        PackedDecimal.computeValue(checkOverflow);
    }

    public static void setPackedZero(byte[] byteArray, int offset, int len) {
        int byteLen = CommonData.getPackedByteCount(len);
        Arrays.fill(byteArray, offset, offset + byteLen - 1, (byte)0);
        byteArray[offset + byteLen - 1] = 12;
    }

    private static void computeSum(PackedDecimalOperand op1, PackedDecimalOperand op2, boolean checkOverflow) throws ArithmeticException {
        PackedDecimalOperand sum = sum_threadLocal.get();
        sum.indexValue = op1.signDigit + op2.signDigit << 1 & 0x3FF;
        sum.byteValue = CommonData.getPackedSumValues(sum.indexValue);
        boolean carry = sum.byteValue < op1.signDigit;
        sum.byteArray[sum.signOffset] = (byte)(sum.byteValue | op1.sign & 0xF);
        while (op2.currentOffset >= op2.offset && sum.currentOffset >= sum.offset) {
            if (checkOverflow && sum.currentOffset < sum.offset) {
                throw new ArithmeticException("Decimal overflow in addPackedDecimal.");
            }
            op1.byteValue = op1.byteArray[op1.currentOffset] & 0xFF;
            op2.byteValue = op2.byteArray[op2.currentOffset] & 0xFF;
            op1.indexValue = op1.byteValue + (op1.byteValue & 0xF0);
            op2.indexValue = op2.byteValue + (op2.byteValue & 0xF0);
            sum.indexValue = op1.indexValue + op2.indexValue;
            sum.byteValue = carry ? (int)CommonData.getPackedSumPlusOneValues(sum.indexValue) : CommonData.getPackedSumValues(sum.indexValue);
            carry = (sum.byteValue & 0xFF) < (op1.byteValue & 0xFF) + (op2.byteValue & 0xFF);
            sum.byteArray[sum.currentOffset] = (byte)sum.byteValue;
            --op2.currentOffset;
            --op1.currentOffset;
            --sum.currentOffset;
        }
        while (carry && op1.currentOffset >= op1.offset && sum.currentOffset >= sum.offset) {
            if (checkOverflow && sum.currentOffset < sum.offset) {
                throw new ArithmeticException("Decimal overflow in addPackedDecimal");
            }
            sum.byteValue = CommonData.getPackedAddOneValues(op1.byteArray[op1.currentOffset]) & 0xFF;
            carry = sum.byteValue == 0;
            sum.byteArray[sum.currentOffset] = (byte)sum.byteValue;
            --op1.currentOffset;
            --sum.currentOffset;
        }
        if (sum.currentOffset < sum.offset) {
            if (carry && checkOverflow || checkOverflow && op1.currentOffset >= op1.offset) {
                throw new ArithmeticException("Decimal overflow in addPackedDecimal");
            }
            if (sum.precision % 2 == 0) {
                if ((byte)(sum.byteArray[sum.offset] & 0xF0) > 0 && checkOverflow) {
                    throw new ArithmeticException("Decimal overflow in addPackedDecimal");
                }
                int n = sum.offset;
                sum.byteArray[n] = (byte)(sum.byteArray[n] & 0xF);
            }
            return;
        }
        if (carry) {
            sum.byteArray[sum.currentOffset] = 1;
            --sum.currentOffset;
        }
        PackedDecimal.copyRemainingDigits(op1, op2, checkOverflow);
    }

    private static void computeDifference(PackedDecimalOperand op1, PackedDecimalOperand op2, boolean checkOverflow) throws ArithmeticException {
        PackedDecimalOperand sum = sum_threadLocal.get();
        boolean borrow = op1.signDigit < op2.signDigit;
        sum.byteValue = Math.abs((op1.signDigit >> 4) - (op2.signDigit >> 4) + 10) % 10;
        sum.byteArray[sum.signOffset] = (byte)(sum.byteValue << 4 | op1.sign & 0xF);
        op2.currentOffset = op2.signOffset - 1;
        op1.currentOffset = op1.signOffset - 1;
        while (op2.currentOffset >= op2.offset && sum.currentOffset >= sum.offset) {
            if (checkOverflow && sum.currentOffset < sum.offset) {
                throw new ArithmeticException("Decimal overflow in subtractPackedDecimal");
            }
            op1.byteValue = op1.byteArray[op1.currentOffset] & 0xFF;
            op2.byteValue = op2.byteArray[op2.currentOffset] & 0xFF;
            op1.indexValue = op1.byteValue + (op1.byteValue & 0xF0);
            op2.indexValue = op2.byteValue + (op2.byteValue & 0xF0);
            sum.indexValue = op1.indexValue - op2.indexValue & 0x3FF;
            sum.byteValue = borrow ? (int)CommonData.getPackedDifferenceMinusOneValues(sum.indexValue) : (int)CommonData.getPackedDifferenceValues(sum.indexValue);
            boolean bl = borrow = (sum.byteValue & 0xFF) > (op1.byteValue & 0xFF) - (op2.byteValue & 0xFF);
            if (sum.currentOffset >= sum.offset) {
                sum.byteArray[sum.currentOffset] = (byte)sum.byteValue;
            }
            --op2.currentOffset;
            --op1.currentOffset;
            --sum.currentOffset;
        }
        while (borrow && op1.currentOffset >= op1.offset && sum.currentOffset >= sum.offset) {
            if (checkOverflow && sum.currentOffset < sum.offset) {
                throw new ArithmeticException("Decimal overflow in subtractPackedDecimal");
            }
            sum.byteValue = CommonData.getPackedBorrowOneValues(op1.byteArray[op1.currentOffset]) & 0xFF;
            boolean bl = borrow = sum.byteValue == 153;
            if (sum.currentOffset >= sum.offset) {
                sum.byteArray[sum.currentOffset] = (byte)sum.byteValue;
            }
            --op1.currentOffset;
            --sum.currentOffset;
        }
        PackedDecimal.copyRemainingDigits(op1, op2, checkOverflow);
    }

    private static void computeValue(boolean checkOverflow) throws ArithmeticException {
        PackedDecimalOperand sum = sum_threadLocal.get();
        PackedDecimalOperand op1 = op1_threadLocal.get();
        PackedDecimalOperand op2 = op2_threadLocal.get();
        if ((op1.sign & 0xF) == (op2.sign & 0xF)) {
            if (op1.bytes < op2.bytes) {
                PackedDecimal.computeSum(op2, op1, checkOverflow);
            } else {
                PackedDecimal.computeSum(op1, op2, checkOverflow);
            }
        } else if (op1.bytes < op2.bytes) {
            PackedDecimal.computeDifference(op2, op1, checkOverflow);
        } else if (op1.bytes > op2.bytes) {
            PackedDecimal.computeDifference(op1, op2, checkOverflow);
        } else {
            block13: {
                while (op1.offset < op1.signOffset) {
                    op1.byteValue = op1.byteArray[op1.offset];
                    op2.byteValue = op2.byteArray[op2.offset];
                    if (op1.byteValue == op2.byteValue) {
                        ++op1.offset;
                        ++op2.offset;
                        continue;
                    }
                    break block13;
                }
                op1.byteValue = op1.byteArray[op1.offset] & 0xF0;
                op2.byteValue = op2.byteArray[op2.offset] & 0xF0;
                if (op1.byteValue == op2.byteValue) {
                    PackedDecimal.setPackedZero(sum.byteArray, sum.offset, sum.precision);
                    return;
                }
            }
            if ((op1.byteValue & 0xFF) > (op2.byteValue & 0xFF)) {
                PackedDecimal.computeDifference(op1, op2, checkOverflow);
            } else {
                PackedDecimal.computeDifference(op2, op1, checkOverflow);
            }
        }
    }

    public static void multiplyPackedDecimal(byte[] result, int resultOffset, int resultPrecision, byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision, boolean checkOverflow) {
        if (resultOffset + (resultPrecision / 2 + 1) > result.length || resultOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. multiplyPackedDecimal is trying to access result[" + resultOffset + "] to result[" + (resultOffset + resultPrecision / 2) + "] but valid indices are from 0 to " + (result.length - 1) + ".");
        }
        if (op1Offset < 0 || op1Offset + (op1Precision / 2 + 1) > op1Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. multiplyPackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. multiplyPackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        PackedDecimal.multiplyPackedDecimal_(result, resultOffset, resultPrecision, op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision, checkOverflow);
    }

    private static void multiplyPackedDecimal_(byte[] result, int resultOffset, int resultPrecision, byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision, boolean checkOverflow) {
        PackedDecimal.packedDecimalBinaryOp(1, result, resultOffset, resultPrecision, op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision, checkOverflow);
    }

    public static void dividePackedDecimal(byte[] result, int resultOffset, int resultPrecision, byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision, boolean checkOverflow) {
        if (resultOffset + (resultPrecision / 2 + 1) > result.length || resultOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. dividePackedDecimal is trying to access result[" + resultOffset + "] to result[" + (resultOffset + resultPrecision / 2) + "] but valid indices are from 0 to " + (result.length - 1) + ".");
        }
        if (op1Offset < 0 || op1Offset + (op1Precision / 2 + 1) > op1Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. dividePackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. dividePackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        PackedDecimal.dividePackedDecimal_(result, resultOffset, resultPrecision, op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision, checkOverflow);
    }

    private static void dividePackedDecimal_(byte[] result, int resultOffset, int resultPrecision, byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision, boolean checkOverflow) {
        PackedDecimal.packedDecimalBinaryOp(2, result, resultOffset, resultPrecision, op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision, checkOverflow);
    }

    public static void remainderPackedDecimal(byte[] result, int resultOffset, int resultPrecision, byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision, boolean checkOverflow) {
        if (resultOffset + (resultPrecision / 2 + 1) > result.length || resultOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. remainderPackedDecimal is trying to access result[" + resultOffset + "] to result[" + (resultOffset + resultPrecision / 2) + "] but valid indices are from 0 to " + (result.length - 1) + ".");
        }
        if (op1Offset < 0 || op1Offset + (op1Precision / 2 + 1) > op1Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. remainderPackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. remainderPackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        PackedDecimal.remainderPackedDecimal_(result, resultOffset, resultPrecision, op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision, checkOverflow);
    }

    private static void remainderPackedDecimal_(byte[] result, int resultOffset, int resultPrecision, byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision, boolean checkOverflow) {
        PackedDecimal.packedDecimalBinaryOp(3, result, resultOffset, resultPrecision, op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision, checkOverflow);
    }

    private static BigInteger getBigInteger(byte[] pd, int offset, int length) {
        int end = offset + length - 1;
        StringBuilder sb = new StringBuilder();
        if ((pd[end] & 0xF) == 11 || (pd[end] & 0xF) == 13) {
            sb.append('-');
        }
        for (int i = offset; i < end; ++i) {
            sb.append((char)(48 + (pd[i] >> 4 & 0xF)));
            sb.append((char)(48 + (pd[i] & 0xF)));
        }
        sb.append((char)(48 + (pd[end] >> 4 & 0xF)));
        return new BigInteger(sb.toString());
    }

    private static void putBigInteger(byte[] pd, int offset, int length, BigInteger bigInt, boolean checkOverflow) throws ArithmeticException {
        int end = offset + length - 1;
        char[] chars = bigInt.toString().toCharArray();
        boolean neg = chars[0] == '-';
        int charStart = neg ? 1 : 0;
        int charEnd = chars.length - 1;
        pd[end--] = (byte)((neg ? 13 : 12) | chars[charEnd--] - 48 << 4);
        while (end >= offset) {
            byte b = 0;
            if (charEnd >= charStart) {
                b = (byte)(chars[charEnd--] - 48);
                if (charEnd >= charStart) {
                    b = (byte)(b | chars[charEnd--] - 48 << 4);
                }
            }
            pd[end--] = b;
        }
        if (checkOverflow && charEnd < charStart) {
            while (charEnd >= charStart) {
                if (chars[charEnd--] == '0') continue;
                throw new ArithmeticException("Packed Decimal overflow during multiplication/division, non-zero digits lost");
            }
        }
    }

    private static void zeroTopNibbleIfEven(byte[] bytes, int offset, int prec) {
        if (prec % 2 == 0) {
            int n = offset;
            bytes[n] = (byte)(bytes[n] & 0xF);
        }
    }

    private static void packedDecimalBinaryOp(int op, byte[] result, int offsetResult, int precResult, byte[] op1, int op1Offset, int precOp1, byte[] op2, int op2Offset, int precOp2, boolean checkOverflow) {
        BigInteger op2BigInt;
        BigInteger op1BigInt;
        PackedDecimal.zeroTopNibbleIfEven(op1, op1Offset, precOp1);
        PackedDecimal.zeroTopNibbleIfEven(op2, op2Offset, precOp2);
        switch (op) {
            case 1: {
                if (precOp1 + precOp2 > 18 || precResult > 18) break;
                long op1long = DecimalData.convertPackedDecimalToLong(op1, op1Offset, precOp1, checkOverflow);
                long op2long = DecimalData.convertPackedDecimalToLong(op2, op2Offset, precOp2, checkOverflow);
                long resultLong = op1long * op2long;
                DecimalData.convertLongToPackedDecimal(resultLong, result, offsetResult, precResult, checkOverflow);
                if (resultLong == 0L) {
                    PackedDecimal.forceSign(result, offsetResult, precResult, op1, op1Offset, precOp1, op2, op2Offset, precOp2);
                }
                return;
            }
            case 2: 
            case 3: {
                if (precOp1 > 18 || precOp2 > 18 || precResult > 18) break;
                long op1long = DecimalData.convertPackedDecimalToLong(op1, op1Offset, precOp1, checkOverflow);
                long op2long = DecimalData.convertPackedDecimalToLong(op2, op2Offset, precOp2, checkOverflow);
                long resultLong = op == 2 ? op1long / op2long : op1long % op2long;
                DecimalData.convertLongToPackedDecimal(resultLong, result, offsetResult, precResult, checkOverflow);
                if (resultLong == 0L) {
                    PackedDecimal.forceSign(result, offsetResult, precResult, op1, op1Offset, precOp1, op2, op2Offset, precOp2);
                }
                return;
            }
        }
        try {
            op1BigInt = PackedDecimal.getBigInteger(op1, op1Offset, PackedDecimal.precisionToByteLength(precOp1));
            op2BigInt = PackedDecimal.getBigInteger(op2, op2Offset, PackedDecimal.precisionToByteLength(precOp2));
        }
        catch (NumberFormatException e) {
            if (checkOverflow) {
                throw new IllegalArgumentException("Invalid packed data value", e);
            }
            return;
        }
        BigInteger resultBigInt = null;
        switch (op) {
            case 1: {
                resultBigInt = op1BigInt.multiply(op2BigInt);
                break;
            }
            case 2: {
                resultBigInt = op1BigInt.divide(op2BigInt);
                break;
            }
            case 3: {
                resultBigInt = op1BigInt.remainder(op2BigInt);
            }
        }
        PackedDecimal.putBigInteger(result, offsetResult, PackedDecimal.precisionToByteLength(precResult), resultBigInt, checkOverflow);
        if (BigInteger.ZERO.equals(resultBigInt)) {
            PackedDecimal.forceSign(result, offsetResult, precResult, op1, op1Offset, precOp1, op2, op2Offset, precOp2);
        }
    }

    private static void forceSign(byte[] result, int offsetResult, int precResult, byte[] op1, int op1Offset, int precOp1, byte[] op2, int op2Offset, int precOp2) {
        int endResult;
        int endOp1 = op1Offset + PackedDecimal.precisionToByteLength(precOp1) - 1;
        int endOp2 = op2Offset + PackedDecimal.precisionToByteLength(precOp2) - 1;
        int n = endResult = offsetResult + PackedDecimal.precisionToByteLength(precResult) - 1;
        result[n] = (byte)(result[n] | 0xF);
        int n2 = endResult;
        result[n2] = (byte)(result[n2] & PackedDecimal.signMask(op1[endOp1], op2[endOp2]));
    }

    private static int precisionToByteLength(int precision) {
        return (precision + 2) / 2;
    }

    private static byte signMask(byte a, byte b) {
        return (byte)(PackedDecimal.sign(a) * PackedDecimal.sign(b) > 0 ? 252 : 253);
    }

    private static int sign(byte b) {
        return CommonData.getSign(b & 0xF) == 13 ? -1 : 1;
    }

    public static boolean lessThanPackedDecimal(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        if (op1Offset + (op1Precision / 2 + 1) > op1Decimal.length || op1Offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. lessThanPackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. lessThanPackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        return PackedDecimal.lessThanPackedDecimal_(op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision);
    }

    private static boolean lessThanPackedDecimal_(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        return PackedDecimal.greaterThanPackedDecimal_(op2Decimal, op2Offset, op2Precision, op1Decimal, op1Offset, op1Precision);
    }

    public static boolean lessThanOrEqualsPackedDecimal(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        if (op1Offset + (op1Precision / 2 + 1) > op1Decimal.length || op1Offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. lessThanOrEqualsPackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. lessThanOrEqualsPackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        return PackedDecimal.lessThanOrEqualsPackedDecimal_(op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision);
    }

    private static boolean lessThanOrEqualsPackedDecimal_(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        return !PackedDecimal.greaterThanPackedDecimal_(op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision);
    }

    public static boolean greaterThanPackedDecimal(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        if (op1Offset + (op1Precision / 2 + 1) > op1Decimal.length || op1Offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. greaterThanPackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. greaterThanPackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        return PackedDecimal.greaterThanPackedDecimal_(op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision);
    }

    private static boolean greaterThanPackedDecimal_(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        boolean isNegative;
        if (op1Precision < 1 || op2Precision < 1) {
            throw new IllegalArgumentException("Invalid Precision for an operand");
        }
        int op1End = op1Offset + PackedDecimal.precisionToByteLength(op1Precision) - 1;
        int op2End = op2Offset + PackedDecimal.precisionToByteLength(op2Precision) - 1;
        byte op1Sign = CommonData.getSign((byte)(op1Decimal[op1End] & 0xF));
        byte op2Sign = CommonData.getSign((byte)(op2Decimal[op2End] & 0xF));
        boolean bl = isNegative = op1Sign == 13;
        while (op1Offset < op1End && op1Decimal[op1Offset] == 0) {
            ++op1Offset;
        }
        while (op2Offset < op2End && op2Decimal[op2Offset] == 0) {
            ++op2Offset;
        }
        int op1Length = op1End - op1Offset;
        int op2Length = op2End - op2Offset;
        if (op1Length + op2Length == 0) {
            int op1LastDigit = op1Decimal[op1Offset] >> 4 & 0xF;
            int op2LastDigit = op2Decimal[op2Offset] >> 4 & 0xF;
            if (op1LastDigit + op2LastDigit == 0) {
                return false;
            }
            if (op1Sign < op2Sign) {
                return true;
            }
            if (op1Sign > op2Sign) {
                return false;
            }
            return op1LastDigit > op2LastDigit && !isNegative || op1LastDigit < op2LastDigit && isNegative;
        }
        if (op1Sign < op2Sign) {
            return true;
        }
        if (op1Sign > op2Sign) {
            return false;
        }
        if (op1Length > op2Length && !isNegative || op1Length < op2Length && isNegative) {
            return true;
        }
        if (op1Length < op2Length && !isNegative || op1Length > op2Length && isNegative) {
            return false;
        }
        while (op1Offset < op1End && op2Offset < op2End) {
            int op1Byte = op1Decimal[op1Offset] & 0xFF;
            int op2Byte = op2Decimal[op2Offset] & 0xFF;
            int opDiff = op1Byte - op2Byte;
            if (opDiff < 0 && !isNegative || opDiff > 0 && isNegative) {
                return false;
            }
            if (opDiff > 0 && !isNegative || opDiff < 0 && isNegative) {
                return true;
            }
            ++op1Offset;
            ++op2Offset;
        }
        int op1LastDigit = op1Decimal[op1Offset] >> 4 & 0xF;
        int op2LastDigit = op2Decimal[op2Offset] >> 4 & 0xF;
        return op1LastDigit > op2LastDigit && !isNegative || op1LastDigit < op2LastDigit && isNegative;
    }

    public static boolean greaterThanOrEqualsPackedDecimal(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        if (op1Offset + (op1Precision / 2 + 1) > op1Decimal.length || op1Offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. greaterThanOrEqualsPackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. greaterThanOrEqualsPackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        return PackedDecimal.greaterThanOrEqualsPackedDecimal_(op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision);
    }

    private static boolean greaterThanOrEqualsPackedDecimal_(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        return !PackedDecimal.lessThanPackedDecimal_(op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision);
    }

    public static boolean equalsPackedDecimal(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        if (op1Offset + (op1Precision / 2 + 1) > op1Decimal.length || op1Offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. equalsPackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. equalsPackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        return PackedDecimal.equalsPackedDecimal_(op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision);
    }

    private static boolean equalsPackedDecimal_(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        boolean op2IsEven;
        if (op1Precision < 1 || op2Precision < 1) {
            throw new IllegalArgumentException("Invalid Precision for an operand");
        }
        int op1End = op1Offset + PackedDecimal.precisionToByteLength(op1Precision) - 1;
        int op2End = op2Offset + PackedDecimal.precisionToByteLength(op2Precision) - 1;
        byte op1Sign = CommonData.getSign((byte)(op1Decimal[op1End] & 0xF));
        byte op2Sign = CommonData.getSign((byte)(op2Decimal[op2End] & 0xF));
        boolean op1IsEven = op1Precision % 2 == 0;
        boolean bl = op2IsEven = op2Precision % 2 == 0;
        if (op1Sign != op2Sign) {
            return PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(op1Decimal, op1Offset, op1End, op1IsEven, true) && PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(op2Decimal, op2Offset, op2End, op2IsEven, true);
        }
        if ((op1Decimal[op1End] & 0xF0) != (op2Decimal[op2End] & 0xF0)) {
            return false;
        }
        if (op1End > op1Offset && op2End > op2Offset) {
            --op1End;
            --op2End;
        }
        while (op1End > op1Offset && op2End > op2Offset) {
            if (op1Decimal[op1End] != op2Decimal[op2End]) {
                return false;
            }
            --op1End;
            --op2End;
        }
        if (op1End == op1Offset) {
            if (op1IsEven) {
                if ((op1Decimal[op1End] & 0xF) == (op2Decimal[op2End] & 0xF)) {
                    return PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(op2Decimal, op2Offset, op2End, op2IsEven, !op2IsEven || op2End != op2Offset);
                }
            } else if (op1Decimal[op1End] == op2Decimal[op2End]) {
                return PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(op2Decimal, op2Offset, op2End, op2IsEven, false);
            }
        } else if (op2IsEven) {
            if ((op1Decimal[op1End] & 0xF) == (op2Decimal[op2End] & 0xF)) {
                return PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(op1Decimal, op1Offset, op1End, op1IsEven, !op1IsEven || op1End != op1Offset);
            }
        } else if (op1Decimal[op1End] == op2Decimal[op2End]) {
            return PackedDecimal.checkZeroBetweenOpOffsetAndOpEnd(op1Decimal, op1Offset, op1End, op1IsEven, false);
        }
        return false;
    }

    private static boolean checkZeroBetweenOpOffsetAndOpEnd(byte[] opDecimal, int opOffset, int opEnd, boolean opIsEven, boolean checkHighNibbleAtOpEnd) {
        if (checkHighNibbleAtOpEnd && (opDecimal[opEnd] & 0xF0) != 0) {
            return false;
        }
        if (opEnd-- > opOffset) {
            while (opEnd > opOffset) {
                if (opDecimal[opEnd--] == 0) continue;
                return false;
            }
            if (opIsEven ? (opDecimal[opEnd] & 0xF) != 0 : opDecimal[opEnd] != 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean notEqualsPackedDecimal(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        if (op1Offset + (op1Precision / 2 + 1) > op1Decimal.length || op1Offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. notEqualsPackedDecimal is trying to access op1Decimal[" + op1Offset + "] to op1Decimal[" + (op1Offset + op1Precision / 2) + "] but valid indices are from 0 to " + (op1Decimal.length - 1) + ".");
        }
        if (op2Offset < 0 || op2Offset + (op2Precision / 2 + 1) > op2Decimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. notEqualsPackedDecimal is trying to access op2Decimal[" + op2Offset + "] to op2Decimal[" + (op2Offset + op2Precision / 2) + "] but valid indices are from 0 to " + (op2Decimal.length - 1) + ".");
        }
        return PackedDecimal.notEqualsPackedDecimal_(op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision);
    }

    private static boolean notEqualsPackedDecimal_(byte[] op1Decimal, int op1Offset, int op1Precision, byte[] op2Decimal, int op2Offset, int op2Precision) {
        return !PackedDecimal.equalsPackedDecimal(op1Decimal, op1Offset, op1Precision, op2Decimal, op2Offset, op2Precision);
    }

    private static void roundUpPackedDecimal(byte[] packedDecimal, int offset, int end, int precision, int roundingDigit, boolean checkOverflow) {
        packedDecimal[end] = CommonData.getPackedAddOneSignValues(packedDecimal[end]);
        if ((byte)(packedDecimal[end] & 0xF0) == 0) {
            byte[] addTenArray = new byte[]{1, packedDecimal[end]};
            PackedDecimal.addPackedDecimal(packedDecimal, offset, precision, packedDecimal, offset, precision, addTenArray, 0, 2, checkOverflow);
        }
    }

    private static void checkIfZero(byte[] packedDecimal, int offset, int end, int precision, boolean isEvenPrecision) {
        int i;
        if (CommonData.getSign(packedDecimal[end] & 0xF) != 13) {
            return;
        }
        if (isEvenPrecision && (packedDecimal[offset] & 0xF) != 0) {
            return;
        }
        for (i = offset; i < end && packedDecimal[i] == 0; ++i) {
        }
        if (i < end) {
            return;
        }
        if ((packedDecimal[end] & 0xF0) == 0) {
            packedDecimal[end] = 12;
        }
    }

    public static void shiftRightPackedDecimal(byte[] destination, int destinationOffset, int destinationPrecision, byte[] source, int sourceOffset, int sourcePrecision, int shiftAmount, boolean round, boolean checkOverflow) {
        if (destinationOffset + (destinationPrecision / 2 + 1) > destination.length || destinationOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. shiftRightPackedDecimal is trying to access destinationDecimal[" + destinationOffset + "] to destinationDecimal[" + (destinationOffset + destinationPrecision / 2) + "] but valid indices are from 0 to " + (destination.length - 1) + ".");
        }
        if (sourceOffset < 0 || sourceOffset + (sourcePrecision / 2 + 1) > source.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. shiftRightPackedDecimal is trying to access sourceDecimal[" + sourceOffset + "] to sourceDecimal[" + (sourceOffset + sourcePrecision / 2) + "] but valid indices are from 0 to " + (source.length - 1) + ".");
        }
        PackedDecimal.shiftRightPackedDecimal_(destination, destinationOffset, destinationPrecision, source, sourceOffset, sourcePrecision, shiftAmount, round, checkOverflow);
    }

    private static void shiftRightPackedDecimal_(byte[] destination, int destinationOffset, int destinationPrecision, byte[] source, int sourceOffset, int sourcePrecision, int shiftAmount, boolean round, boolean checkOverflow) {
        int newSrcEnd;
        int newSrcOffset;
        int end = sourceOffset + PackedDecimal.precisionToByteLength(sourcePrecision) - 1;
        byte sign = CommonData.getSign(source[end] & 0xF);
        int newDstOffset = destinationOffset;
        int newDstPrec = destinationPrecision;
        int dstEnd = destinationOffset + PackedDecimal.precisionToByteLength(destinationPrecision) - 1;
        int highDigit = sourcePrecision - 1;
        int lowDigit = 0;
        int precDiff = sourcePrecision - destinationPrecision;
        boolean evenPrecision = sourcePrecision % 2 == 0;
        boolean isLeastSigDigitInHighNibble = false;
        boolean isMostSigDigitInLowNibble = false;
        int roundingDigit = 0;
        boolean overRanPD = false;
        if (destinationPrecision < 1 || sourcePrecision < 1 || shiftAmount < 0) {
            throw new IllegalArgumentException("Invalid Precisions or shift amount");
        }
        if (PackedDecimal.checkPackedDecimal_(source, sourceOffset, sourcePrecision, true, false) != 0) {
            throw new IllegalArgumentException("Invalid sign or digit code in input packed decimal");
        }
        lowDigit += shiftAmount;
        if ((precDiff -= shiftAmount) > 0) {
            highDigit -= precDiff;
            if (checkOverflow) {
                int iter = 0;
                if (evenPrecision) {
                    --precDiff;
                    ++iter;
                    if ((byte)(source[sourceOffset] & 0xF) != 0) {
                        throw new ArithmeticException("Decimal overflow in shiftRightPackedDecimal.");
                    }
                }
                int bytes = precDiff / 2;
                precDiff -= bytes * 2;
                for (int i = 0; i < bytes; ++i) {
                    if (source[i + sourceOffset + iter] == 0) continue;
                    throw new ArithmeticException("Decimal overflow in shiftRightPackedDecimal.");
                }
                if (precDiff == 1 && (byte)(source[bytes + sourceOffset] & 0xF0) != 0) {
                    throw new ArithmeticException("Decimal overflow in shiftRightPackedDecimal.");
                }
            }
        }
        int newDifference = highDigit + 1 - lowDigit;
        if (checkOverflow && newDifference < 1) {
            overRanPD = true;
        }
        int highDiff = sourcePrecision - (highDigit + 1);
        if (evenPrecision && newDifference % 2 == 0) {
            if (highDiff % 2 == 0) {
                isMostSigDigitInLowNibble = true;
                isLeastSigDigitInHighNibble = true;
                newSrcOffset = sourceOffset + highDiff / 2;
                newSrcEnd = end - lowDigit / 2;
            } else {
                newSrcOffset = sourceOffset + (highDiff + 1) / 2;
                newSrcEnd = end - (lowDigit + 1) / 2;
            }
        } else if (evenPrecision && newDifference % 2 != 0) {
            if (highDiff % 2 != 0) {
                isLeastSigDigitInHighNibble = true;
                newSrcOffset = sourceOffset + (highDiff + 1) / 2;
                newSrcEnd = end - lowDigit / 2;
            } else {
                isMostSigDigitInLowNibble = true;
                newSrcOffset = sourceOffset + highDiff / 2;
                newSrcEnd = end - (lowDigit + 1) / 2;
            }
        } else if (!evenPrecision && newDifference % 2 == 0) {
            if (highDiff % 2 == 0) {
                newSrcOffset = sourceOffset + highDiff / 2;
                newSrcEnd = end - (lowDigit + 1) / 2;
            } else {
                isMostSigDigitInLowNibble = true;
                isLeastSigDigitInHighNibble = true;
                newSrcOffset = sourceOffset + highDiff / 2;
                newSrcEnd = end - lowDigit / 2;
            }
        } else if (highDiff % 2 == 0) {
            isLeastSigDigitInHighNibble = true;
            newSrcOffset = sourceOffset + highDiff / 2;
            newSrcEnd = end - lowDigit / 2;
        } else {
            isMostSigDigitInLowNibble = true;
            newSrcOffset = sourceOffset + highDiff / 2;
            newSrcEnd = end - (lowDigit + 1) / 2;
        }
        if (round && shiftAmount > 0 && newDifference > -1) {
            roundingDigit = isLeastSigDigitInHighNibble ? source[newSrcEnd] & 0xF : source[newSrcEnd + 1] >> 4 & 0xF;
        }
        while (precDiff < 0) {
            destination[newDstOffset] = 0;
            if (newDstPrec % 2 == 0 || precDiff == -1) {
                if (newDstPrec % 2 == 0) {
                    ++newDstOffset;
                }
                ++precDiff;
                --newDstPrec;
                continue;
            }
            if (precDiff / -2 < 1) continue;
            precDiff += 2;
            newDstPrec -= 2;
            ++newDstOffset;
        }
        if (isLeastSigDigitInHighNibble && !overRanPD) {
            if (!isMostSigDigitInLowNibble) {
                System.arraycopy(source, newSrcOffset, destination, newDstOffset, newSrcEnd - newSrcOffset + 1);
            } else {
                destination[newDstOffset] = (byte)(source[newSrcOffset] & 0xF);
                System.arraycopy(source, ++newSrcOffset, destination, ++newDstOffset, newSrcEnd - newSrcOffset + 1);
            }
        } else if (!overRanPD) {
            int newDstEnd = newDstOffset + PackedDecimal.precisionToByteLength(newDstPrec) - 1;
            byte shiftByte = newSrcEnd < sourceOffset ? (byte)0 : source[newSrcEnd];
            destination[newDstEnd] = (byte)(shiftByte << 4 & 0xF0);
            --newDstEnd;
            --newDstPrec;
            byte current_nibble = 0;
            while (newSrcEnd > newSrcOffset && newDstEnd > newDstOffset) {
                current_nibble = (byte)(source[newSrcEnd] >> 4 & 0xF);
                destination[newDstEnd] = current_nibble = (byte)(current_nibble | (byte)(source[--newSrcEnd] << 4 & 0xF0));
                --newDstEnd;
                newDstPrec -= 2;
            }
            if (newDstPrec > 0) {
                destination[newDstEnd] = (byte)(source[newSrcEnd] >> 4 & 0xF);
                --newSrcEnd;
                if (--newDstPrec > 0 && isMostSigDigitInLowNibble) {
                    int n = newDstEnd;
                    destination[n] = (byte)(destination[n] | (byte)(source[newSrcEnd] << 4 & 0xF0));
                }
            }
        }
        if (overRanPD && roundingDigit < 5 && sign != 12) {
            destination[dstEnd] = (byte)(destination[dstEnd] & 0xF0 | sign);
        } else {
            destination[dstEnd] = (byte)(destination[dstEnd] & 0xF0 | sign);
            if (round && roundingDigit >= 5) {
                PackedDecimal.roundUpPackedDecimal(destination, destinationOffset, dstEnd, destinationPrecision, roundingDigit, checkOverflow);
            }
            if (checkOverflow || round) {
                PackedDecimal.checkIfZero(destination, destinationOffset, dstEnd, destinationPrecision, destinationPrecision % 2 == 0);
            }
        }
    }

    public static void shiftLeftPackedDecimal(byte[] destination, int destinationOffset, int destinationPrecision, byte[] source, int sourceOffset, int sourcePrecision, int shiftAmount, boolean checkOverflow) {
        if (destinationOffset + (destinationPrecision / 2 + 1) > destination.length || destinationOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. shiftLeftPackedDecimal is trying to access destinationDecimal[" + destinationOffset + "] to destinationDecimal[" + (destinationOffset + destinationPrecision / 2) + "] but valid indices are from 0 to " + (destination.length - 1) + ".");
        }
        if (sourceOffset < 0 || sourceOffset + (sourcePrecision / 2 + 1) > source.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. shiftLeftPackedDecimal is trying to access sourceDecimal[" + sourceOffset + "] to sourceDecimal[" + (sourceOffset + sourcePrecision / 2) + "] but valid indices are from 0 to " + (source.length - 1) + ".");
        }
        PackedDecimal.shiftLeftPackedDecimal_(destination, destinationOffset, destinationPrecision, source, sourceOffset, sourcePrecision, shiftAmount, checkOverflow);
    }

    private static void shiftLeftPackedDecimal_(byte[] destination, int destinationOffset, int destinationPrecision, byte[] source, int sourceOffset, int sourcePrecision, int shiftAmount, boolean checkOverflow) {
        boolean isDestionationEvenPrecision;
        if (destinationPrecision < 1 || sourcePrecision < 1 || shiftAmount < 0) {
            throw new IllegalArgumentException("Invalid Precisions or shift amount");
        }
        if (PackedDecimal.checkPackedDecimal_(source, sourceOffset, sourcePrecision, true, false) != 0) {
            throw new IllegalArgumentException("Invalid sign or digit code in input packed decimal");
        }
        int end = sourceOffset + PackedDecimal.precisionToByteLength(sourcePrecision) - 1;
        byte sign = CommonData.getSign(source[end] & 0xF);
        boolean overRanPD = false;
        int sourceLength = PackedDecimal.precisionToByteLength(sourcePrecision);
        int destinationLength = PackedDecimal.precisionToByteLength(destinationPrecision);
        int shiftByte = shiftAmount / 2;
        int zerosBytesAtFront = 0;
        int totalZeros = 0;
        if (sourcePrecision % 2 != 0) {
            for (zerosBytesAtFront = 0; zerosBytesAtFront < sourceLength && source[zerosBytesAtFront + sourceOffset] == 0; ++zerosBytesAtFront) {
            }
            if ((byte)(source[zerosBytesAtFront + sourceOffset] & 0xF0) == 0) {
                ++totalZeros;
            }
        } else if ((byte)(source[sourceOffset] & 0xF) == 0) {
            ++totalZeros;
            for (int i = 1; i < sourceLength && source[i + sourceOffset] == 0; ++i) {
                ++zerosBytesAtFront;
            }
            if ((byte)(source[zerosBytesAtFront + sourceOffset + 1] & 0xF0) == 0) {
                ++totalZeros;
            }
        }
        if (checkOverflow && destinationPrecision + (totalZeros += zerosBytesAtFront * 2) < sourcePrecision + shiftAmount) {
            throw new ArithmeticException("Overflow - Destination precision not enough to hold the result of the shift operation");
        }
        Arrays.fill(destination, destinationOffset, destinationOffset + destinationLength, (byte)0);
        int startIndexSource = zerosBytesAtFront + sourceOffset;
        int diff = destinationLength - sourceLength;
        int startIndexDestination = destinationOffset + zerosBytesAtFront - shiftByte + diff;
        int numberLength = sourceLength - zerosBytesAtFront;
        int movedSignIndex = startIndexDestination + numberLength - 1;
        if (destinationPrecision <= shiftAmount) {
            if (checkOverflow && sign != 12) {
                overRanPD = true;
            }
        } else if (shiftAmount % 2 == 0) {
            if (startIndexDestination < destinationOffset) {
                int difference = sourcePrecision - (destinationPrecision - shiftAmount);
                int sourceIndex = sourcePrecision % 2 == 0 ? sourceOffset + (difference + 1) / 2 : sourceOffset + difference / 2;
                System.arraycopy(source, sourceIndex, destination, destinationOffset, destinationLength - shiftAmount / 2);
            } else {
                System.arraycopy(source, startIndexSource, destination, startIndexDestination, sourceLength - zerosBytesAtFront);
            }
            if (movedSignIndex >= 0) {
                destination[movedSignIndex] = (byte)(destination[movedSignIndex] & 0xF0);
            }
        } else {
            for (int i = 0; i < numberLength; ++i) {
                byte top = (byte)(source[startIndexSource + i] & 0xF0);
                byte bottom = (byte)(source[startIndexSource + i] & 0xF);
                if (startIndexDestination - 1 + i >= destinationOffset) {
                    destination[startIndexDestination - 1 + i] = (byte)(top >> 4 & 0xF | (byte)(destination[startIndexDestination - 1 + i] & 0xF0));
                }
                if (startIndexDestination + i < destinationOffset) continue;
                destination[startIndexDestination + i] = (byte)(bottom << 4);
            }
            if (movedSignIndex >= 0) {
                destination[movedSignIndex] = 0;
            }
        }
        int destinationEnd = destinationOffset + destinationLength - 1;
        boolean bl = isDestionationEvenPrecision = destinationPrecision % 2 == 0;
        if (isDestionationEvenPrecision) {
            destination[destinationOffset] = (byte)(destination[destinationOffset] & 0xF);
        }
        if (overRanPD) {
            destination[destinationEnd] = (byte)(0xC | destination[destinationEnd]);
        } else {
            destination[destinationEnd] = (byte)(sign | destination[destinationEnd]);
            if (checkOverflow) {
                PackedDecimal.checkIfZero(destination, destinationOffset, destinationEnd, destinationPrecision, isDestionationEvenPrecision);
            }
        }
    }

    public static void movePackedDecimal(byte[] destination, int destinationOffset, int destinationPrecision, byte[] source, int sourceOffset, int sourcePrecision, boolean checkOverflow) {
        PackedDecimal.shiftLeftPackedDecimal(destination, destinationOffset, destinationPrecision, source, sourceOffset, sourcePrecision, 0, checkOverflow);
    }

    private static class PackedDecimalOperand {
        private static final byte PACKED_ZERO = 0;
        byte[] byteArray;
        int offset;
        int precision;
        int bytes;
        int signOffset;
        int currentOffset;
        int signByteValue;
        int sign;
        int signDigit;
        int byteValue;
        int indexValue;

        private PackedDecimalOperand() {
        }

        public void setOperand(byte[] byteArray, int offset, int precision) {
            this.byteArray = byteArray;
            this.offset = offset;
            this.precision = precision;
            this.bytes = CommonData.getPackedByteCount(precision);
            this.signOffset = this.offset + this.bytes - 1;
            this.currentOffset = this.signOffset - 1;
            while (byteArray[this.offset] == 0 && this.offset < this.signOffset) {
                ++this.offset;
            }
            this.bytes = this.signOffset - this.offset + 1;
            this.signByteValue = this.byteArray[this.signOffset] & 0xFF;
            this.signDigit = this.signByteValue & 0xF0;
            this.sign = CommonData.getSign(this.signByteValue & 0xF);
        }

        public void setSumOperand(byte[] byteArray, int offset, int precision) {
            this.byteArray = byteArray;
            this.offset = offset;
            this.precision = precision;
            this.bytes = CommonData.getPackedByteCount(precision);
            this.signOffset = this.offset + this.bytes - 1;
            this.currentOffset = this.signOffset - 1;
        }
    }
}

