/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dataaccess;

import com.ibm.dataaccess.ByteArrayMarshaller;
import com.ibm.dataaccess.ByteArrayUnmarshaller;
import com.ibm.dataaccess.CommonData;
import com.ibm.dataaccess.PackedDecimal;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public final class DecimalData {
    public static final int EBCDIC_SIGN_EMBEDDED_TRAILING = 1;
    public static final int EBCDIC_SIGN_EMBEDDED_LEADING = 2;
    public static final int EBCDIC_SIGN_SEPARATE_TRAILING = 3;
    public static final int EBCDIC_SIGN_SEPARATE_LEADING = 4;
    public static final int UNICODE_UNSIGNED = 5;
    public static final int UNICODE_SIGN_SEPARATE_LEADING = 6;
    public static final int UNICODE_SIGN_SEPARATE_TRAILING = 7;
    private static final byte EBCDIC_SIGN_POSITIVE = 78;
    private static final byte EBCDIC_SIGN_NEGATIVE = 96;
    private static final byte EXTERNAL_HIGH_MASK = -16;
    private static final byte UNICODE_HIGH_MASK = 48;
    static final int EXTERNAL_DECIMAL_MIN = 1;
    static final int EXTERNAL_DECIMAL_MAX = 4;
    private static final int EBCDIC_MIN = 1;
    private static final int EBCDIC_MAX = 4;
    private static final int UNICODE_MIN = 5;
    private static final int UNICODE_MAX = 7;
    private static byte[] PD2EDTranslationTable;
    private static byte[] ED2UDTranslationTable;
    private static char UNICODE_SIGN_MINUS;
    private static char UNICODE_SIGN_PLUS;
    private static char UNICODE_ZERO;
    private static final boolean JIT_INTRINSICS_ENABLED = false;
    private static final int PACKED_BYTES_LENGTH = 33;
    private static final byte[] PACKED_BYTES;

    private DecimalData() {
    }

    private static final boolean JITIntrinsicsEnabled() {
        return false;
    }

    private static int numDigits(int value) {
        int n = value = value == Integer.MIN_VALUE ? Integer.MAX_VALUE : Math.abs(value);
        return value >= 10000 ? (value >= 10000000 ? (value >= 100000000 ? (value >= 1000000000 ? 10 : 9) : 8) : (value >= 100000 ? (value >= 1000000 ? 7 : 6) : 5)) : (value >= 100 ? (value >= 1000 ? 4 : 3) : (value >= 10 ? 2 : 1));
    }

    private static int numDigits(long value) {
        long l = value = value == Long.MIN_VALUE ? Long.MAX_VALUE : Math.abs(value);
        return value >= 1000000000L ? (value >= 100000000000000L ? (value >= 10000000000000000L ? (value >= 100000000000000000L ? (value >= 1000000000000000000L ? 19 : 18) : 17) : (value >= 1000000000000000L ? 16 : 15)) : (value >= 100000000000L ? (value >= 1000000000000L ? (value >= 10000000000000L ? 14 : 13) : 12) : (value >= 10000000000L ? 11 : 10))) : (value >= 10000L ? (value >= 1000000L ? (value >= 10000000L ? (value >= 100000000L ? 9 : 8) : 7) : (value >= 100000L ? 6 : 5)) : (value >= 100L ? (value >= 1000L ? 4 : 3) : (value >= 10L ? 2 : 1)));
    }

    public static void convertIntegerToPackedDecimal(int integerValue, byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        if (offset + (precision / 2 + 1) > packedDecimal.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertIntegerToPackedDecimal is trying to access packedDecimal[" + offset + "] to packedDecimal[" + (offset + precision / 2) + "],  but valid indices are from 0 to " + (packedDecimal.length - 1) + ".");
        }
        DecimalData.convertIntegerToPackedDecimal_(integerValue, packedDecimal, offset, precision, checkOverflow);
    }

    private static void convertIntegerToPackedDecimal_(int integerValue, byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        int i;
        int value;
        boolean evenPrecision;
        int bytes = CommonData.getPackedByteCount(precision);
        int last = offset + bytes - 1;
        boolean bl = evenPrecision = precision % 2 == 0;
        if (checkOverflow) {
            if (precision < 1) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal precision lesser than 1");
            }
            if (DecimalData.numDigits(integerValue) > precision) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal precision insufficient");
            }
        }
        if (integerValue < 0) {
            packedDecimal[last] = (byte)(Math.abs(integerValue) % 10 << 4 | 0xD);
            value = Math.abs(integerValue / 10);
        } else {
            value = integerValue;
            packedDecimal[last] = (byte)(value % 10 << 4 | 0xC);
            value /= 10;
        }
        for (i = last - 1; i > offset && value != 0; value /= 100, --i) {
            packedDecimal[i] = CommonData.getBinaryToPackedValues(value % 100);
        }
        if (i == offset && value != 0) {
            packedDecimal[i] = evenPrecision ? (byte)(CommonData.getBinaryToPackedValues(value % 100) & 0xF) : CommonData.getBinaryToPackedValues(value % 100);
            value /= 100;
            --i;
        }
        if (checkOverflow && value != 0) {
            throw new ArithmeticException("Decimal overflow - Packed Decimal precision insufficient");
        }
        if (i >= offset) {
            for (int j = 0; j < i - offset + 1; ++j) {
                packedDecimal[j + offset] = 0;
            }
        }
    }

    public static void convertIntegerToExternalDecimal(int integerValue, byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        if (offset < 0 || offset + CommonData.getExternalByteCounts(precision, decimalType) > externalDecimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertIntegerToExternalDecimal is trying to access externalDecimal[" + offset + "] to externalDecimal[" + (offset + CommonData.getExternalByteCounts(precision, decimalType) - 1) + "],  but valid indices are from 0 to " + (externalDecimal.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] packedDecimal = new byte[precision / 2 + 1];
            DecimalData.convertIntegerToPackedDecimal_(integerValue, packedDecimal, 0, precision, checkOverflow);
            DecimalData.convertPackedDecimalToExternalDecimal_(packedDecimal, 0, externalDecimal, offset, precision, decimalType);
        } else {
            DecimalData.convertIntegerToExternalDecimal_(integerValue, externalDecimal, offset, precision, checkOverflow, decimalType);
        }
    }

    private static void convertIntegerToExternalDecimal_(int integerValue, byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        int i;
        int zoneVal = -16;
        int externalSignOffset = offset++;
        if (decimalType == 4) {
            // empty if block
        }
        int end = offset + precision - 1;
        if (decimalType < 1 || decimalType > 4) {
            throw new IllegalArgumentException("invalid decimalType");
        }
        if (checkOverflow) {
            if (precision < 1) {
                throw new ArithmeticException("Decimal overflow - External Decimal precision lesser than 1");
            }
            if (DecimalData.numDigits(integerValue) > precision) {
                throw new ArithmeticException("Decimal overflow - External Decimal precision insufficient");
            }
        }
        externalDecimal[end] = (byte)(zoneVal | Math.abs(integerValue % 10));
        int value = Math.abs(integerValue / 10);
        for (i = end - 1; i >= offset && value != 0; value /= 10, --i) {
            externalDecimal[i] = (byte)(zoneVal | value % 10);
        }
        if (i >= offset) {
            for (int j = offset; j <= i; ++j) {
                externalDecimal[j] = (byte)(zoneVal | 0);
            }
        }
        switch (decimalType) {
            case 1: {
                externalSignOffset += precision - 1;
            }
            case 2: {
                int sign = integerValue >= 0 ? -64 : -48;
                externalDecimal[externalSignOffset] = (byte)(externalDecimal[externalSignOffset] & 0xF | sign);
                break;
            }
            case 3: {
                externalSignOffset += precision;
            }
            case 4: {
                externalDecimal[externalSignOffset] = integerValue >= 0 ? 78 : 96;
            }
        }
    }

    public static void convertIntegerToUnicodeDecimal(int integerValue, char[] unicodeDecimal, int offset, int precision, boolean checkoverflow, int unicodeType) {
        int size;
        int n = size = unicodeType == 5 ? precision : precision + 1;
        if (offset + size > unicodeDecimal.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertIntegerToUnicodeDecimal is trying to access unicodeDecimal[" + offset + "] to unicodeDecimal[" + (offset + size - 1) + "],  but valid indices are from 0 to " + (unicodeDecimal.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] packedDecimal = new byte[precision / 2 + 1];
            DecimalData.convertIntegerToPackedDecimal_(integerValue, packedDecimal, 0, precision, checkoverflow);
            DecimalData.convertPackedDecimalToUnicodeDecimal_(packedDecimal, 0, unicodeDecimal, offset, precision, unicodeType);
        } else {
            DecimalData.convertIntegerToUnicodeDecimal_(integerValue, unicodeDecimal, offset, precision, checkoverflow, unicodeType);
        }
    }

    private static void convertIntegerToUnicodeDecimal_(int integerValue, char[] unicodeDecimal, int offset, int precision, boolean checkOverflow, int unicodeType) {
        int i;
        if (checkOverflow) {
            if (precision < 1) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal precision lesser than 1");
            }
            if (precision < DecimalData.numDigits(integerValue)) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal precision insufficient");
            }
        }
        switch (unicodeType) {
            case 5: {
                break;
            }
            case 6: {
                unicodeDecimal[offset++] = integerValue < 0 ? UNICODE_SIGN_MINUS : UNICODE_SIGN_PLUS;
                break;
            }
            case 7: {
                unicodeDecimal[offset + precision] = integerValue < 0 ? UNICODE_SIGN_MINUS : UNICODE_SIGN_PLUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid decimalType");
            }
        }
        unicodeDecimal[offset + precision - 1] = (char)(0x30 | Math.abs(integerValue) % 10);
        integerValue = Math.abs(integerValue / 10);
        for (i = offset + precision - 2; i >= offset && integerValue != 0; integerValue /= 10, --i) {
            unicodeDecimal[i] = (char)(0x30 | integerValue % 10);
        }
        if (checkOverflow && integerValue != 0) {
            throw new ArithmeticException("Decimal overflow - Unicode Decimal precision insufficient");
        }
        while (i >= offset) {
            unicodeDecimal[i] = 48;
            --i;
        }
    }

    public static void convertLongToPackedDecimal(long longValue, byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        if (offset + (precision / 2 + 1) > packedDecimal.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertLongToPackedDecimal is trying to access packedDecimal[" + offset + "] to packedDecimal[" + (offset + precision / 2) + "],  but valid indices are from 0 to " + (packedDecimal.length - 1) + ".");
        }
        DecimalData.convertLongToPackedDecimal_(longValue, packedDecimal, offset, precision, checkOverflow);
    }

    private static void convertLongToPackedDecimal_(long longValue, byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        int i;
        long value;
        boolean evenPrecision;
        int bytes = CommonData.getPackedByteCount(precision);
        int last = offset + bytes - 1;
        boolean bl = evenPrecision = precision % 2 == 0;
        if (checkOverflow) {
            if (precision < 1) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal precision lesser than 1");
            }
            if (DecimalData.numDigits(longValue) > precision) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal precision insufficient");
            }
        }
        if (longValue < 0L) {
            packedDecimal[last] = (byte)(Math.abs(longValue) % 10L << 4 | 0xDL);
            value = Math.abs(longValue / 10L);
        } else {
            value = longValue;
            packedDecimal[last] = (byte)(value % 10L << 4 | 0xCL);
            value /= 10L;
        }
        for (i = last - 1; i > offset && value != 0L; value /= 100L, --i) {
            packedDecimal[i] = CommonData.getBinaryToPackedValues((int)(value % 100L));
        }
        if (i == offset && value != 0L) {
            packedDecimal[i] = evenPrecision ? (byte)(CommonData.getBinaryToPackedValues((int)(value % 100L)) & 0xF) : CommonData.getBinaryToPackedValues((int)(value % 100L));
            value /= 100L;
            --i;
        }
        if (checkOverflow && value != 0L) {
            throw new ArithmeticException("Decimal overflow - Packed Decimal precision insufficient");
        }
        if (i >= offset) {
            for (int j = 0; j < i - offset + 1; ++j) {
                packedDecimal[j + offset] = 0;
            }
        }
    }

    public static void convertLongToExternalDecimal(long longValue, byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        if (offset < 0 || offset + CommonData.getExternalByteCounts(precision, decimalType) > externalDecimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertLongToExternalDecimal is trying to access externalDecimal[" + offset + "] to externalDecimal[" + (offset + CommonData.getExternalByteCounts(precision, decimalType) - 1) + "],  but valid indices are from 0 to " + (externalDecimal.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] packedDecimal = new byte[precision / 2 + 1];
            DecimalData.convertLongToPackedDecimal_(longValue, packedDecimal, 0, precision, checkOverflow);
            DecimalData.convertPackedDecimalToExternalDecimal_(packedDecimal, 0, externalDecimal, offset, precision, decimalType);
        } else {
            DecimalData.convertLongToExternalDecimal_(longValue, externalDecimal, offset, precision, checkOverflow, decimalType);
        }
    }

    private static void convertLongToExternalDecimal_(long longValue, byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        int i;
        int zoneVal = -16;
        int externalSignOffset = offset++;
        if (decimalType == 4) {
            // empty if block
        }
        int end = offset + precision - 1;
        if (decimalType < 1 || decimalType > 4) {
            throw new IllegalArgumentException("invalid decimalType");
        }
        if (checkOverflow) {
            if (precision < 1) {
                throw new ArithmeticException("Decimal overflow - External Decimal precision lesser than 1");
            }
            if (DecimalData.numDigits(longValue) > precision) {
                throw new ArithmeticException("Decimal overflow - External Decimal precision insufficient");
            }
        }
        externalDecimal[end] = (byte)((long)zoneVal | Math.abs(longValue % 10L));
        long value = Math.abs(longValue / 10L);
        for (i = end - 1; i >= offset && value != 0L; value /= 10L, --i) {
            externalDecimal[i] = (byte)((long)zoneVal | value % 10L);
        }
        if (i >= offset) {
            for (int j = offset; j <= i; ++j) {
                externalDecimal[j] = (byte)(zoneVal | 0);
            }
        }
        switch (decimalType) {
            case 1: {
                externalSignOffset += precision - 1;
            }
            case 2: {
                int sign = longValue >= 0L ? -64 : -48;
                externalDecimal[externalSignOffset] = (byte)(externalDecimal[externalSignOffset] & 0xF | sign);
                break;
            }
            case 3: {
                externalSignOffset += precision;
            }
            case 4: {
                externalDecimal[externalSignOffset] = longValue >= 0L ? 78 : 96;
            }
        }
    }

    public static void convertLongToUnicodeDecimal(long longValue, char[] unicodeDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        int size;
        int n = size = decimalType == 5 ? precision : precision + 1;
        if (offset + size > unicodeDecimal.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertIntegerToUnicodeDecimal is trying to access unicodeDecimal[" + offset + "] to unicodeDecimal[" + (offset + size - 1) + "],  but valid indices are from 0 to " + (unicodeDecimal.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] packedDecimal = new byte[precision / 2 + 1];
            DecimalData.convertLongToPackedDecimal_(longValue, packedDecimal, 0, precision, checkOverflow);
            DecimalData.convertPackedDecimalToUnicodeDecimal_(packedDecimal, 0, unicodeDecimal, offset, precision, decimalType);
        } else {
            DecimalData.convertLongToUnicodeDecimal_(longValue, unicodeDecimal, offset, precision, checkOverflow, decimalType);
        }
    }

    private static void convertLongToUnicodeDecimal_(long longValue, char[] unicodeDecimal, int offset, int precision, boolean checkOverflow, int unicodeType) {
        int i;
        if (checkOverflow) {
            if (precision < 1) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal precision lesser than 1");
            }
            if (precision < DecimalData.numDigits(longValue)) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal precision insufficient");
            }
        }
        switch (unicodeType) {
            case 5: {
                break;
            }
            case 6: {
                unicodeDecimal[offset++] = longValue < 0L ? UNICODE_SIGN_MINUS : UNICODE_SIGN_PLUS;
                break;
            }
            case 7: {
                unicodeDecimal[offset + precision] = longValue < 0L ? UNICODE_SIGN_MINUS : UNICODE_SIGN_PLUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid decimalType");
            }
        }
        unicodeDecimal[offset + precision - 1] = (char)(0x30L | Math.abs(longValue) % 10L);
        longValue = Math.abs(longValue / 10L);
        for (i = offset + precision - 2; i >= offset && longValue != 0L; longValue /= 10L, --i) {
            unicodeDecimal[i] = (char)(0x30L | longValue % 10L);
        }
        if (checkOverflow && longValue != 0L) {
            throw new ArithmeticException("Decimal overflow - Unicode Decimal precision insufficient");
        }
        while (i >= offset) {
            unicodeDecimal[i] = 48;
            --i;
        }
    }

    public static int convertPackedDecimalToInteger(byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        if (offset + (precision / 2 + 1) > packedDecimal.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToInteger is trying to access packedDecimal[" + offset + "] to packedDecimal[" + (offset + precision / 2) + "],  but valid indices are from 0 to " + (packedDecimal.length - 1) + ".");
        }
        return DecimalData.convertPackedDecimalToInteger_(packedDecimal, offset, precision, checkOverflow);
    }

    private static int convertPackedDecimalToInteger_(byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        int bytes = CommonData.getPackedByteCount(precision);
        int end = offset + bytes - 1;
        long value = 0L;
        byte sign = CommonData.getSign((byte)(packedDecimal[end] & 0xF));
        if (precision % 2 == 0 && (packedDecimal[offset] & 0xF) == 0) {
            --precision;
            ++offset;
        }
        while (offset < end && packedDecimal[offset] == 0) {
            precision -= 2;
            ++offset;
        }
        if (checkOverflow) {
            if (precision % 2 == 1 && (packedDecimal[offset] & 0xF0) == 0) {
                --precision;
            }
            if (precision > 10) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal too large for an int");
            }
        }
        for (int pos = offset; pos <= end - 1; ++pos) {
            value = value * 100L + (long)CommonData.getPackedToBinaryValues(packedDecimal[pos]);
        }
        value = value * 10L + (long)((packedDecimal[end] & 0xF0) >> 4);
        if (sign == 13) {
            value = -1L * value;
        }
        if (checkOverflow && (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE)) {
            throw new ArithmeticException("Decimal overflow - Packed Decimal too large for a int");
        }
        return (int)value;
    }

    public static long convertPackedDecimalToLong(byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        if (offset + (precision / 2 + 1) > packedDecimal.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToLong is trying to access packedDecimal[" + offset + "] to packedDecimal[" + (offset + precision / 2) + "],  but valid indices are from 0 to " + (packedDecimal.length - 1) + ".");
        }
        return DecimalData.convertPackedDecimalToLong_(packedDecimal, offset, precision, checkOverflow);
    }

    private static long convertPackedDecimalToLong_(byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        long value = 0L;
        int bytes = CommonData.getPackedByteCount(precision);
        int end = offset + bytes - 1;
        int last = packedDecimal[end] & 0xFF;
        byte sign = CommonData.getSign((byte)(last & 0xF));
        if (precision % 2 == 0 && (packedDecimal[offset] & 0xF) == 0) {
            --precision;
            ++offset;
        }
        while (offset < end && packedDecimal[offset] == 0) {
            precision -= 2;
            ++offset;
        }
        if (checkOverflow) {
            if (precision % 2 == 1 && (packedDecimal[offset] & 0xF0) == 0) {
                --precision;
            }
            if (precision > 19) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal too large for a long");
            }
        }
        for (int pos = offset; pos <= end - 1; ++pos) {
            value = value * 100L + (long)CommonData.getPackedToBinaryValues(packedDecimal[pos]);
        }
        value = value * 10L + (long)((last & 0xF0) >> 4);
        if (sign == 13) {
            value = -value;
        }
        if (checkOverflow) {
            if (sign == 12 && value < 0L) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal too large for a long");
            }
            if (sign == 13 && value > 0L) {
                throw new ArithmeticException("Decimal overflow - Packed Decimal too large for a long");
            }
        }
        return value;
    }

    public static void convertPackedDecimalToExternalDecimal(byte[] packedDecimal, int packedOffset, byte[] externalDecimal, int externalOffset, int precision, int decimalType) {
        if (packedOffset + (precision / 2 + 1) > packedDecimal.length || packedOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToExternalDecimal is trying to access packedDecimal[" + packedOffset + "] to packedDecimal[" + (packedOffset + precision / 2) + "],  but valid indices are from 0 to " + (packedDecimal.length - 1) + ".");
        }
        if (externalOffset < 0 || externalOffset + CommonData.getExternalByteCounts(precision, decimalType) > externalDecimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToExternalDecimal is trying to access externalDecimal[" + externalOffset + "] to externalDecimal[" + (externalOffset + CommonData.getExternalByteCounts(precision, decimalType) - 1) + "],  but valid indices are from 0 to " + (externalDecimal.length - 1) + ".");
        }
        DecimalData.convertPackedDecimalToExternalDecimal_(packedDecimal, packedOffset, externalDecimal, externalOffset, precision, decimalType);
    }

    private static void convertPackedDecimalToExternalDecimal_(byte[] packedDecimal, int packedOffset, byte[] externalDecimal, int externalOffset, int precision, int decimalType) {
        if (decimalType < 1 || decimalType > 4) {
            throw new IllegalArgumentException("invalid decimalType");
        }
        if (precision <= 0) {
            throw new IllegalArgumentException("negative precision");
        }
        int externalSignOffset = externalOffset++;
        if (decimalType == 4) {
            // empty if block
        }
        int end = packedOffset + precision / 2;
        int edEnd = externalOffset + precision - 1;
        int zoneVal = -16;
        if (precision % 2 == 0) {
            externalDecimal[externalOffset++] = (byte)(zoneVal | packedDecimal[packedOffset++] & 0xF);
        }
        for (int i = packedOffset; i < end; ++i) {
            externalDecimal[externalOffset++] = (byte)(zoneVal | (packedDecimal[i] & 0xF0) >> 4 & 0xF);
            externalDecimal[externalOffset++] = (byte)(zoneVal | packedDecimal[i] & 0xF);
        }
        externalDecimal[edEnd] = (byte)(zoneVal | (packedDecimal[end] & 0xF0) >> 4 & 0xF);
        byte sign = (byte)(CommonData.getSign(packedDecimal[end] & 0xF) << 4);
        switch (decimalType) {
            case 4: {
                if (sign == -64) {
                    externalDecimal[externalSignOffset] = 78;
                    break;
                }
                externalDecimal[externalSignOffset] = 96;
                break;
            }
            case 2: {
                externalDecimal[externalSignOffset] = (byte)(externalDecimal[externalSignOffset] & 0xF | sign);
                break;
            }
            case 1: {
                externalDecimal[externalSignOffset += precision - 1] = (byte)(externalDecimal[externalSignOffset] & 0xF | sign);
                break;
            }
            case 3: {
                externalSignOffset += precision;
                if (sign == -64) {
                    externalDecimal[externalSignOffset] = 78;
                    break;
                }
                externalDecimal[externalSignOffset] = 96;
                break;
            }
        }
    }

    public static void convertPackedDecimalToUnicodeDecimal(byte[] packedDecimal, int packedOffset, char[] unicodeDecimal, int unicodeOffset, int precision, int decimalType) {
        int size;
        int n = size = decimalType == 5 ? precision : precision + 1;
        if (unicodeOffset + size > unicodeDecimal.length || unicodeOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToUnicodeDecimal is trying to access unicodeDecimal[" + unicodeOffset + "] to unicodeDecimal[" + (unicodeOffset + size - 1) + "],  but valid indices are from 0 to " + (unicodeDecimal.length - 1) + ".");
        }
        if (packedOffset < 0 || packedOffset + (precision / 2 + 1) > packedDecimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertPackedDecimalToUnicodeDecimal is trying to access packedDecimal[" + packedOffset + "] to packedDecimal[" + (packedOffset + precision / 2) + "],  but valid indices are from 0 to " + (packedDecimal.length - 1) + ".");
        }
        DecimalData.convertPackedDecimalToUnicodeDecimal_(packedDecimal, packedOffset, unicodeDecimal, unicodeOffset, precision, decimalType);
    }

    private static void convertPackedDecimalToUnicodeDecimal_(byte[] packedDecimal, int packedOffset, char[] unicodeDecimal, int unicodeOffset, int precision, int decimalType) {
        if (precision <= 0) {
            throw new IllegalArgumentException("negative precision");
        }
        int externalSignOffset = -1;
        switch (decimalType) {
            case 5: {
                break;
            }
            case 6: {
                externalSignOffset = unicodeOffset++;
                break;
            }
            case 7: {
                externalSignOffset = unicodeOffset + precision;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid decimalType");
            }
        }
        int zoneVal = 48;
        int end = packedOffset + precision / 2;
        byte sign = (byte)(packedDecimal[end] & 0xF);
        sign = CommonData.getSign(sign);
        if (precision % 2 == 0) {
            unicodeDecimal[unicodeOffset] = (char)(zoneVal | packedDecimal[packedOffset++] & 0xF);
            ++unicodeOffset;
        }
        for (int i = packedOffset; i < end; ++i) {
            unicodeDecimal[unicodeOffset] = (char)(zoneVal | (packedDecimal[i] & 0xF0) >> 4 & 0xF);
            unicodeDecimal[++unicodeOffset] = (char)(zoneVal | packedDecimal[i] & 0xF);
            ++unicodeOffset;
        }
        unicodeDecimal[unicodeOffset] = (char)(zoneVal | (packedDecimal[end] & 0xF0) >> 4 & 0xF);
        if (decimalType != 5) {
            unicodeDecimal[externalSignOffset] = sign == 12 ? 43 : 45;
        }
    }

    public static BigInteger convertPackedDecimalToBigInteger(byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        return DecimalData.convertPackedDecimalToBigDecimal(packedDecimal, offset, precision, 0, checkOverflow).toBigInteger();
    }

    public static BigDecimal convertPackedDecimalToBigDecimal(byte[] packedDecimal, int offset, int precision, int scale, boolean checkOverflow) {
        if (precision <= 9) {
            return BigDecimal.valueOf(DecimalData.convertPackedDecimalToInteger(packedDecimal, offset, precision, checkOverflow), scale);
        }
        if (precision <= 18) {
            return BigDecimal.valueOf(DecimalData.convertPackedDecimalToLong(packedDecimal, offset, precision, checkOverflow), scale);
        }
        return DecimalData.slowSignedPackedToBigDecimal(packedDecimal, offset, precision, scale, checkOverflow);
    }

    public static int convertExternalDecimalToInteger(byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        if (offset + CommonData.getExternalByteCounts(precision, decimalType) > externalDecimal.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertExternalDecimalToInteger is trying to access externalDecimal[" + offset + "] to externalDecimal[" + (offset + CommonData.getExternalByteCounts(precision, decimalType) - 1) + "],  but valid indices are from 0 to " + (externalDecimal.length - 1) + ".");
        }
        if (precision <= 0) {
            throw new IllegalArgumentException("Precision can't be negative.");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] packedDecimal = new byte[precision / 2 + 1];
            DecimalData.convertExternalDecimalToPackedDecimal_(externalDecimal, offset, packedDecimal, 0, precision, decimalType);
            return DecimalData.convertPackedDecimalToInteger_(packedDecimal, 0, precision, checkOverflow);
        }
        return DecimalData.convertExternalDecimalToInteger_(externalDecimal, offset, precision, checkOverflow, decimalType);
    }

    private static int convertExternalDecimalToInteger_(byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        int end = offset + CommonData.getExternalByteCounts(precision, decimalType) - 1;
        boolean isNegative = DecimalData.isExternalDecimalSignNegative(externalDecimal, offset, precision, decimalType);
        if (decimalType == 3) {
            --end;
        } else if (decimalType == 4) {
            ++offset;
        }
        int value = 0;
        if (isNegative) {
            if (precision < 10 || !checkOverflow) {
                for (int i = offset; i <= end; ++i) {
                    value = value * 10 - (externalDecimal[i] & 0xF);
                }
            } else {
                int tenthOffset;
                int offsetMod;
                int i;
                for (i = offsetMod = offset > (tenthOffset = end - 9) ? offset : tenthOffset; i <= end; ++i) {
                    value = value * 10 - (externalDecimal[i] & 0xF);
                }
                if (value > 0 || tenthOffset >= offset && (externalDecimal[tenthOffset] & 0xF) > 2) {
                    throw new ArithmeticException("Decimal overflow - External Decimal too small for an int");
                }
                for (i = offset; i < offsetMod; ++i) {
                    if ((externalDecimal[i] & 0xF) <= 0) continue;
                    throw new ArithmeticException("Decimal overflow - External Decimal too small for an int");
                }
            }
        } else if (precision < 10 || !checkOverflow) {
            for (int i = offset; i <= end; ++i) {
                value = value * 10 + (externalDecimal[i] & 0xF);
            }
        } else {
            int tenthOffset;
            int offsetMod;
            int i;
            for (i = offsetMod = offset > (tenthOffset = end - 9) ? offset : tenthOffset; i <= end; ++i) {
                value = value * 10 + (externalDecimal[i] & 0xF);
            }
            if (value < 0 || tenthOffset >= offset && (externalDecimal[tenthOffset] & 0xF) > 2) {
                throw new ArithmeticException("Decimal overflow - External Decimal too large for an int");
            }
            for (i = offset; i < offsetMod; ++i) {
                if ((externalDecimal[i] & 0xF) <= 0) continue;
                throw new ArithmeticException("Decimal overflow - External Decimal too large for an int");
            }
        }
        return value;
    }

    public static long convertExternalDecimalToLong(byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        if (offset + CommonData.getExternalByteCounts(precision, decimalType) > externalDecimal.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertExternalDecimalToLong is trying to access externalDecimal[" + offset + "] to externalDecimal[" + (offset + CommonData.getExternalByteCounts(precision, decimalType) - 1) + "],  but valid indices are from 0 to " + (externalDecimal.length - 1) + ".");
        }
        if (precision <= 0) {
            throw new IllegalArgumentException("Precision can't be negative.");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] packedDecimal = new byte[precision / 2 + 1];
            DecimalData.convertExternalDecimalToPackedDecimal_(externalDecimal, offset, packedDecimal, 0, precision, decimalType);
            return DecimalData.convertPackedDecimalToLong_(packedDecimal, 0, precision, checkOverflow);
        }
        return DecimalData.convertExternalDecimalToLong_(externalDecimal, offset, precision, checkOverflow, decimalType);
    }

    private static long convertExternalDecimalToLong_(byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        int end = offset + CommonData.getExternalByteCounts(precision, decimalType) - 1;
        boolean isNegative = DecimalData.isExternalDecimalSignNegative(externalDecimal, offset, precision, decimalType);
        if (decimalType == 3) {
            --end;
        } else if (decimalType == 4) {
            ++offset;
        }
        long value = 0L;
        if (isNegative) {
            if (precision < 19 || !checkOverflow) {
                for (int i = offset; i <= end; ++i) {
                    value = value * 10L - (long)(externalDecimal[i] & 0xF);
                }
            } else {
                int offsetMod;
                int i;
                for (i = offsetMod = offset > end - 18 ? offset : end - 18; i <= end; ++i) {
                    value = value * 10L - (long)(externalDecimal[i] & 0xF);
                }
                if (value > 0L) {
                    throw new ArithmeticException("Decimal overflow - External Decimal too small for a long");
                }
                for (i = offset; i < offsetMod; ++i) {
                    if ((externalDecimal[i] & 0xF) <= 0) continue;
                    throw new ArithmeticException("Decimal overflow - External Decimal too small for a long");
                }
            }
        } else if (precision < 19 || !checkOverflow) {
            for (int i = offset; i <= end; ++i) {
                value = value * 10L + (long)(externalDecimal[i] & 0xF);
            }
        } else {
            int offsetMod;
            int i;
            for (i = offsetMod = offset > end - 18 ? offset : end - 18; i <= end; ++i) {
                value = value * 10L + (long)(externalDecimal[i] & 0xF);
            }
            if (value < 0L) {
                throw new ArithmeticException("Decimal overflow - External Decimal too large for a long");
            }
            for (i = offset; i < offsetMod; ++i) {
                if ((externalDecimal[i] & 0xF) <= 0) continue;
                throw new ArithmeticException("Decimal overflow - External Decimal too large for a long");
            }
        }
        return value;
    }

    public static void convertExternalDecimalToPackedDecimal(byte[] externalDecimal, int externalOffset, byte[] packedDecimal, int packedOffset, int precision, int decimalType) {
        if (externalOffset + CommonData.getExternalByteCounts(precision, decimalType) > externalDecimal.length || externalOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertExternalDecimalToPackedDecimal is trying to access externalDecimal[" + externalOffset + "] to externalDecimal[" + (externalOffset + CommonData.getExternalByteCounts(precision, decimalType) - 1) + "],  but valid indices are from 0 to " + (externalDecimal.length - 1) + ".");
        }
        if (packedOffset < 0 || packedOffset + (precision / 2 + 1) > packedDecimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertExternalDecimalToPackedDecimal is trying to access packedDecimal[" + packedOffset + "] to packedDecimal[" + (packedOffset + precision / 2) + "],  but valid indices are from 0 to " + (packedDecimal.length - 1) + ".");
        }
        DecimalData.convertExternalDecimalToPackedDecimal_(externalDecimal, externalOffset, packedDecimal, packedOffset, precision, decimalType);
    }

    private static void convertExternalDecimalToPackedDecimal_(byte[] externalDecimal, int externalOffset, byte[] packedDecimal, int packedOffset, int precision, int decimalType) {
        boolean isNegative = DecimalData.isExternalDecimalSignNegative(externalDecimal, externalOffset, precision, decimalType);
        if (decimalType < 1 || decimalType > 4) {
            throw new IllegalArgumentException("invalid decimalType");
        }
        if (precision <= 0) {
            throw new IllegalArgumentException("negative precision");
        }
        int end = packedOffset + precision / 2;
        if (decimalType == 4) {
            ++externalOffset;
        }
        if (precision % 2 == 0) {
            packedDecimal[packedOffset++] = (byte)(externalDecimal[externalOffset++] & 0xF);
        }
        for (int i = packedOffset; i < end; ++i) {
            byte top = (byte)((externalDecimal[externalOffset++] & 0xF) << 4);
            byte bottom = (byte)(externalDecimal[externalOffset++] & 0xF);
            packedDecimal[i] = (byte)(top | bottom);
        }
        packedDecimal[end] = (byte)((externalDecimal[externalOffset] & 0xF) << 4);
        if (isNegative) {
            int n = end;
            packedDecimal[n] = (byte)(packedDecimal[n] | 0xD);
        } else {
            int n = end;
            packedDecimal[n] = (byte)(packedDecimal[n] | 0xC);
        }
    }

    public static BigInteger convertExternalDecimalToBigInteger(byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        byte[] packedDecimal = new byte[precision / 2 + 1];
        DecimalData.convertExternalDecimalToPackedDecimal(externalDecimal, offset, packedDecimal, 0, precision, decimalType);
        int cc = PackedDecimal.checkPackedDecimal(packedDecimal, 0, precision, true, true);
        if (cc != 0) {
            throw new IllegalArgumentException("The input External Decimal is not valid.");
        }
        return DecimalData.convertPackedDecimalToBigDecimal(packedDecimal, 0, precision, 0, checkOverflow).toBigInteger();
    }

    public static BigDecimal convertExternalDecimalToBigDecimal(byte[] externalDecimal, int offset, int precision, int scale, boolean checkOverflow, int decimalType) {
        if (precision <= 9) {
            return BigDecimal.valueOf(DecimalData.convertExternalDecimalToInteger(externalDecimal, offset, precision, checkOverflow, decimalType), scale);
        }
        if (precision <= 18) {
            return BigDecimal.valueOf(DecimalData.convertExternalDecimalToLong(externalDecimal, offset, precision, checkOverflow, decimalType), scale);
        }
        byte[] packedDecimal = new byte[precision / 2 + 1];
        DecimalData.convertExternalDecimalToPackedDecimal(externalDecimal, offset, packedDecimal, 0, precision, decimalType);
        int cc = PackedDecimal.checkPackedDecimal(packedDecimal, 0, precision, true, true);
        if (cc != 0) {
            throw new IllegalArgumentException("The input External Decimal is not valid.");
        }
        return DecimalData.convertPackedDecimalToBigDecimal(packedDecimal, 0, precision, scale, checkOverflow);
    }

    private static boolean isExternalDecimalSignNegative(byte[] externalDecimal, int externalOffset, int precision, int decimalType) {
        byte signByte = 0;
        switch (decimalType) {
            case 2: {
                signByte = (byte)(externalDecimal[externalOffset] & 0xFFFFFFF0);
                if (signByte != -48 && signByte != -80) break;
                return true;
            }
            case 1: {
                signByte = (byte)(externalDecimal[externalOffset + precision - 1] & 0xFFFFFFF0);
                if (signByte != -48 && signByte != -80) break;
                return true;
            }
            case 4: {
                signByte = externalDecimal[externalOffset];
                if (signByte != 96) break;
                return true;
            }
            case 3: {
                signByte = externalDecimal[externalOffset + precision];
                if (signByte != 96) break;
                return true;
            }
            default: {
                throw new IllegalArgumentException("Invalid decimal sign type.");
            }
        }
        return false;
    }

    public static int convertUnicodeDecimalToInteger(char[] unicodeDecimal, int offset, int precision, boolean checkOverflow, int unicodeType) {
        int size;
        int n = size = unicodeType == 5 ? precision : precision + 1;
        if (offset + size > unicodeDecimal.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertUnicodeDecimalToInteger is trying to access unicodeDecimal[" + offset + "] to unicodeDecimal[" + (offset + size - 1) + "],  but valid indices are from 0 to " + (unicodeDecimal.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] packedDecimal = new byte[precision / 2 + 1];
            DecimalData.convertUnicodeDecimalToPackedDecimal_(unicodeDecimal, offset, packedDecimal, 0, precision, unicodeType);
            int cc = PackedDecimal.checkPackedDecimal(packedDecimal, 0, precision, true, true);
            if (cc != 0) {
                throw new IllegalArgumentException("The input Unicode is not valid");
            }
            return DecimalData.convertPackedDecimalToInteger_(packedDecimal, 0, precision, checkOverflow);
        }
        return DecimalData.convertUnicodeDecimalToInteger_(unicodeDecimal, offset, precision, checkOverflow, unicodeType);
    }

    private static int convertUnicodeDecimalToInteger_(char[] unicodeDecimal, int offset, int precision, boolean checkOverflow, int unicodeType) {
        if (precision <= 0) {
            throw new IllegalArgumentException("invalid precision");
        }
        boolean positive = true;
        switch (unicodeType) {
            case 5: {
                break;
            }
            case 6: {
                positive = unicodeDecimal[offset++] == UNICODE_SIGN_PLUS;
                break;
            }
            case 7: {
                positive = unicodeDecimal[offset + precision] == UNICODE_SIGN_PLUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid decimalType");
            }
        }
        int end = offset + precision;
        long val = 0L;
        while (offset < end && unicodeDecimal[offset] == UNICODE_ZERO) {
            --precision;
            ++offset;
        }
        if (checkOverflow && precision > 10) {
            throw new ArithmeticException("Decimal overflow - Unicode Decimal too large for an int");
        }
        while (offset < end) {
            val *= 10L;
            val -= (long)(unicodeDecimal[offset] & 0xF);
            ++offset;
        }
        long l = val = positive ? -val : val;
        if (checkOverflow && (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE)) {
            throw new ArithmeticException("Decimal overflow - Unicode Decimal too large for a int");
        }
        return (int)val;
    }

    public static long convertUnicodeDecimalToLong(char[] unicodeDecimal, int offset, int precision, boolean checkOverflow, int unicodeType) {
        int size;
        int n = size = unicodeType == 5 ? precision : precision + 1;
        if (offset + size > unicodeDecimal.length || offset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertUnicodeDecimalToLong is trying to access unicodeDecimal[" + offset + "] to unicodeDecimal[" + (offset + size - 1) + "],  but valid indices are from 0 to " + (unicodeDecimal.length - 1) + ".");
        }
        if (DecimalData.JITIntrinsicsEnabled()) {
            byte[] packedDecimal = new byte[precision / 2 + 1];
            DecimalData.convertUnicodeDecimalToPackedDecimal_(unicodeDecimal, offset, packedDecimal, 0, precision, unicodeType);
            int cc = PackedDecimal.checkPackedDecimal(packedDecimal, 0, precision, true, true);
            if (cc != 0) {
                throw new IllegalArgumentException("The input Unicode is not valid");
            }
            return DecimalData.convertPackedDecimalToLong_(packedDecimal, 0, precision, checkOverflow);
        }
        return DecimalData.convertUnicodeDecimalToLong_(unicodeDecimal, offset, precision, checkOverflow, unicodeType);
    }

    private static long convertUnicodeDecimalToLong_(char[] unicodeDecimal, int offset, int precision, boolean checkOverflow, int unicodeType) {
        if (precision <= 0) {
            throw new IllegalArgumentException("invalid precision");
        }
        boolean positive = true;
        switch (unicodeType) {
            case 5: {
                break;
            }
            case 6: {
                positive = unicodeDecimal[offset++] == UNICODE_SIGN_PLUS;
                break;
            }
            case 7: {
                positive = unicodeDecimal[offset + precision] == UNICODE_SIGN_PLUS;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid decimalType");
            }
        }
        int end = offset + precision;
        long val = 0L;
        while (offset < end && unicodeDecimal[offset] == UNICODE_ZERO) {
            --precision;
            ++offset;
        }
        if (checkOverflow && precision > 19) {
            throw new ArithmeticException("Decimal overflow - Unicode Decimal too large for a long");
        }
        while (offset < end) {
            val *= 10L;
            val -= (long)(unicodeDecimal[offset] & 0xF);
            ++offset;
        }
        long l = val = positive ? -val : val;
        if (checkOverflow) {
            if (positive && val < 0L) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal too large for a long");
            }
            if (!positive && val > 0L) {
                throw new ArithmeticException("Decimal overflow - Unicode Decimal too small for a long");
            }
        }
        return val;
    }

    public static void convertUnicodeDecimalToPackedDecimal(char[] unicodeDecimal, int unicodeOffset, byte[] packedDecimal, int packedOffset, int precision, int decimalType) {
        int size;
        int n = size = decimalType == 5 ? precision : precision + 1;
        if (unicodeOffset + size > unicodeDecimal.length || unicodeOffset < 0) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertUnicodeDecimalToPackedDecimal is trying to access unicodeDecimal[" + unicodeOffset + "] to unicodeDecimal[" + (unicodeOffset + size - 1) + "],  but valid indices are from 0 to " + (unicodeDecimal.length - 1) + ".");
        }
        if (packedOffset < 0 || packedOffset + (precision / 2 + 1) > packedDecimal.length) {
            throw new ArrayIndexOutOfBoundsException("Array access index out of bounds. convertUnicodeDecimalToPackedDecimal is trying to access packedDecimal[" + packedOffset + "] to packedDecimal[" + (packedOffset + precision / 2) + "],  but valid indices are from 0 to " + (packedDecimal.length - 1) + ".");
        }
        DecimalData.convertUnicodeDecimalToPackedDecimal_(unicodeDecimal, unicodeOffset, packedDecimal, packedOffset, precision, decimalType);
    }

    private static void convertUnicodeDecimalToPackedDecimal_(char[] unicodeDecimal, int unicodeOffset, byte[] packedDecimal, int packedOffset, int precision, int decimalType) {
        if (precision <= 0) {
            throw new IllegalArgumentException("invalid precision");
        }
        int end = packedOffset + precision / 2;
        int signOffset = unicodeOffset++;
        if (decimalType == 6) {
            // empty if block
        }
        if (precision % 2 == 0) {
            packedDecimal[packedOffset++] = (byte)(unicodeDecimal[unicodeOffset++] & 0xF);
        }
        for (int i = packedOffset; i < end; ++i) {
            byte top = (byte)((unicodeDecimal[unicodeOffset++] & 0xF) << 4);
            byte bottom = (byte)(unicodeDecimal[unicodeOffset++] & 0xF);
            packedDecimal[i] = (byte)(top | bottom);
        }
        packedDecimal[end] = (byte)((unicodeDecimal[unicodeOffset++] & 0xF) << 4);
        switch (decimalType) {
            case 6: {
                if (unicodeDecimal[signOffset] == '-') {
                    int n = end;
                    packedDecimal[n] = (byte)(packedDecimal[n] | 0xD);
                    break;
                }
                int n = end;
                packedDecimal[n] = (byte)(packedDecimal[n] | 0xC);
                break;
            }
            case 7: {
                if (unicodeDecimal[unicodeOffset] == '-') {
                    int n = end;
                    packedDecimal[n] = (byte)(packedDecimal[n] | 0xD);
                    break;
                }
                int n = end;
                packedDecimal[n] = (byte)(packedDecimal[n] | 0xC);
                break;
            }
            case 5: {
                int n = end;
                packedDecimal[n] = (byte)(packedDecimal[n] | 0xC);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid decimalType");
            }
        }
    }

    public static BigInteger convertUnicodeDecimalToBigInteger(char[] unicodeDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        byte[] packedDecimal = new byte[precision / 2 + 1];
        DecimalData.convertUnicodeDecimalToPackedDecimal(unicodeDecimal, offset, packedDecimal, 0, precision, decimalType);
        int cc = PackedDecimal.checkPackedDecimal(packedDecimal, 0, precision, true, true);
        if (cc != 0) {
            throw new IllegalArgumentException("The input Unicode is not valid");
        }
        return DecimalData.convertPackedDecimalToBigDecimal(packedDecimal, 0, precision, 0, checkOverflow).toBigInteger();
    }

    public static BigDecimal convertUnicodeDecimalToBigDecimal(char[] unicodeDecimal, int offset, int precision, int scale, boolean checkOverflow, int decimalType) {
        byte[] packedDecimal = new byte[precision / 2 + 1];
        DecimalData.convertUnicodeDecimalToPackedDecimal(unicodeDecimal, offset, packedDecimal, 0, precision, decimalType);
        int cc = PackedDecimal.checkPackedDecimal(packedDecimal, 0, precision, true, true);
        if (cc != 0) {
            throw new IllegalArgumentException("The input Unicode is not valid");
        }
        return DecimalData.convertPackedDecimalToBigDecimal(packedDecimal, 0, precision, scale, checkOverflow);
    }

    public static void convertBigIntegerToPackedDecimal(BigInteger bigIntegerValue, byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        DecimalData.convertBigDecimalToPackedDecimal(new BigDecimal(bigIntegerValue), packedDecimal, offset, precision, checkOverflow);
    }

    public static void convertBigIntegerToExternalDecimal(BigInteger bigIntegerValue, byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        byte[] packedDecimal = new byte[precision / 2 + 1];
        DecimalData.convertBigDecimalToPackedDecimal(new BigDecimal(bigIntegerValue), packedDecimal, 0, precision, checkOverflow);
        DecimalData.convertPackedDecimalToExternalDecimal(packedDecimal, 0, externalDecimal, offset, precision, decimalType);
    }

    public static void convertBigIntegerToUnicodeDecimal(BigInteger bigIntegerValue, char[] unicodeDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        byte[] packedDecimal = new byte[precision / 2 + 1];
        DecimalData.convertBigDecimalToPackedDecimal(new BigDecimal(bigIntegerValue), packedDecimal, 0, precision, checkOverflow);
        DecimalData.convertPackedDecimalToUnicodeDecimal(packedDecimal, 0, unicodeDecimal, offset, precision, decimalType);
    }

    public static void convertBigDecimalToPackedDecimal(BigDecimal bigDecimalValue, byte[] packedDecimal, int offset, int precision, boolean checkOverflow) {
        int bdprec = bigDecimalValue.precision();
        if (bdprec <= 9) {
            DecimalData.convertIntegerToPackedDecimal((int)bigDecimalValue.unscaledValue().longValue(), packedDecimal, offset, precision, checkOverflow);
            return;
        }
        if (bdprec <= 18) {
            DecimalData.convertLongToPackedDecimal(bigDecimalValue.unscaledValue().longValue(), packedDecimal, offset, precision, checkOverflow);
            return;
        }
        DecimalData.slowBigDecimalToSignedPacked(bigDecimalValue, packedDecimal, offset, precision, checkOverflow);
    }

    public static void convertBigDecimalToExternalDecimal(BigDecimal bigDecimalValue, byte[] externalDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        int bdprec = bigDecimalValue.precision();
        if (bdprec <= 9) {
            DecimalData.convertIntegerToExternalDecimal((int)bigDecimalValue.unscaledValue().longValue(), externalDecimal, offset, precision, checkOverflow, decimalType);
            return;
        }
        if (bdprec <= 18) {
            DecimalData.convertLongToExternalDecimal(bigDecimalValue.unscaledValue().longValue(), externalDecimal, offset, precision, checkOverflow, decimalType);
            return;
        }
        byte[] packedDecimal = new byte[precision / 2 + 1];
        DecimalData.convertBigDecimalToPackedDecimal(bigDecimalValue, packedDecimal, 0, precision, checkOverflow);
        DecimalData.convertPackedDecimalToExternalDecimal(packedDecimal, 0, externalDecimal, offset, precision, decimalType);
    }

    public static void convertBigDecimalToUnicodeDecimal(BigDecimal bigDecimalValue, char[] unicodeDecimal, int offset, int precision, boolean checkOverflow, int decimalType) {
        byte[] packedDecimal = new byte[precision / 2 + 1];
        DecimalData.convertBigDecimalToPackedDecimal(bigDecimalValue, packedDecimal, 0, precision, checkOverflow);
        DecimalData.convertPackedDecimalToUnicodeDecimal(packedDecimal, 0, unicodeDecimal, offset, precision, decimalType);
    }

    private static boolean DFPFacilityAvailable() {
        return false;
    }

    private static boolean DFPUseDFP() {
        return false;
    }

    private static BigDecimal createZeroBigDecimal() {
        return new BigDecimal(0);
    }

    private static boolean DFPConvertPackedToDFP(BigDecimal bd, long pack, int scale, boolean signed) {
        return false;
    }

    private static long DFPConvertDFPToPacked(long dfpValue, boolean signed) {
        return Long.MAX_VALUE;
    }

    private static final int getflags() {
        return 3;
    }

    private static final long getlaside(BigDecimal bd) {
        return Long.MIN_VALUE;
    }

    private static BigDecimal slowSignedPackedToBigDecimal(byte[] byteArray, int offset, int precision, int scale, boolean exceptions) {
        int length = (precision + 2) / 2;
        int sn = byteArray[offset + length - 1] & 0xF;
        char[] temp = new char[length * 2];
        temp[0] = sn == 13 || sn == 11 ? 45 : 48;
        for (int i = 0; i < length - 1; ++i) {
            temp[2 * i + 1] = (char)(48 + (byteArray[i + offset] >>> 4 & 0xF));
            temp[2 * i + 2] = (char)(48 + (byteArray[i + offset] & 0xF));
        }
        temp[length * 2 - 1] = (char)(48 + (byteArray[offset + length - 1] >>> 4 & 0xF));
        return new BigDecimal(new BigInteger(new String(temp)), scale);
    }

    private static void slowBigDecimalToSignedPacked(BigDecimal bd, byte[] byteArray, int offset, int precision, boolean checkOverflow) {
        if (checkOverflow && precision < bd.precision()) {
            throw new ArithmeticException("Decimal overflow - precision of result Packed Decimal lesser than BigDecimal precision");
        }
        BigInteger value = bd.unscaledValue();
        char[] buffer = value.abs().toString().toCharArray();
        int numDigitsLeft = buffer.length - 1;
        int endPosition = numDigitsLeft % 2;
        int length = (precision + 2) / 2;
        int index = length - 2;
        byteArray[offset + length - 1] = (byte)(buffer[numDigitsLeft] - 48 << 4);
        int n = offset + length - 1;
        byteArray[n] = (byte)(byteArray[n] | (value.signum() == -1 ? 13 : 12));
        int i = numDigitsLeft - 1;
        while (i >= endPosition && offset + index >= 0) {
            byteArray[offset + index] = (byte)(buffer[i] - 48);
            int n2 = offset + index;
            byteArray[n2] = (byte)(byteArray[n2] | (byte)(buffer[i - 1] - 48 << 4));
            i -= 2;
            --index;
        }
        if (endPosition > 0 && offset + index >= 0) {
            byteArray[offset + index] = (byte)(buffer[0] - 48);
        }
    }

    private static long convertPackedToLong(byte[] byteArray, int offset, int length) {
        if (length == 8) {
            return ByteArrayUnmarshaller.readLong(byteArray, offset, true);
        }
        if (length == 4) {
            return (long)ByteArrayUnmarshaller.readInt(byteArray, offset, true) & 0xFFFFFFFFL;
        }
        long value = 0L;
        for (int i = 0; i < length; ++i) {
            value <<= 8;
            value += (long)(byteArray[offset + i] & 0xFF);
        }
        return value;
    }

    private static void convertLongToPacked(long value, byte[] byteArray, int offset, int length) {
        if (length == 8) {
            ByteArrayMarshaller.writeLong(value, byteArray, offset, true);
        } else if (length == 4) {
            ByteArrayMarshaller.writeInt((int)value, byteArray, offset, true);
        } else {
            for (int i = length - 1; i <= 0; --i) {
                byteArray[offset + i] = (byte)(value & 0xFFL);
                value >>= 8;
            }
        }
    }

    static {
        int high;
        int low;
        UNICODE_SIGN_MINUS = (char)45;
        UNICODE_SIGN_PLUS = (char)43;
        UNICODE_ZERO = (char)48;
        PD2EDTranslationTable = new byte[512];
        ED2UDTranslationTable = new byte[256];
        Arrays.fill(PD2EDTranslationTable, (byte)0);
        Arrays.fill(ED2UDTranslationTable, (byte)0);
        for (int tenDigit = 0; tenDigit < 10; ++tenDigit) {
            for (int oneDigit = 0; oneDigit < 10; ++oneDigit) {
                int pdValue = tenDigit * 16 + oneDigit;
                DecimalData.PD2EDTranslationTable[pdValue * 2] = (byte)(0xF0 | tenDigit);
                DecimalData.PD2EDTranslationTable[pdValue * 2 + 1] = (byte)(0xF0 | oneDigit);
            }
        }
        for (int digit = 0; digit < 10; ++digit) {
            int edValue = 0xF0 | digit;
            DecimalData.ED2UDTranslationTable[edValue + 1] = (byte)(0x30 | digit);
        }
        BigDecimal digit = new BigDecimal("0");
        PACKED_BYTES = new byte[200];
        int i = 100;
        int j = 0;
        while (j < 100) {
            low = i % 10;
            high = i / 10 % 10;
            DecimalData.PACKED_BYTES[j] = (byte)((high << 4) + low);
            ++j;
            --i;
        }
        i = 0;
        j = 100;
        while (j < 200) {
            low = i % 10;
            high = i / 10 % 10;
            DecimalData.PACKED_BYTES[j] = (byte)((high << 4) + low);
            ++j;
            ++i;
        }
    }
}

