/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.util;

import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.Utility;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INITIALIZE;

public class Version {
    private static final String CLASS = Version.class.getName();
    public static final String PROJECT_NAME = "IBM Java ORB";
    public static final String BUILD = "orb80-20190308.00";
    public static final String FULL = "IBM Java ORB build orb80-20190308.00";
    public static final String CFW_VERSION = "IBM CFW level " + com.ibm.ws.channel.framework.Version.versionString;
    public static final String PARTNER_VERSION = Integer.toHexString(Version.getVersionMajor()) + "." + Version.getVersionMinor();
    public static final String MAIN = "IBM Java ORB build orb80-20190308.00 version " + PARTNER_VERSION;
    private static final String sdkFullVersion = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            String string = System.getProperty("java.fullversion");
            if (string != null) {
                string = string.replaceAll("\r?\n", Utility.LINE_SEP);
            }
            return string;
        }
    });
    private static final String sdkVersion = (String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("java.version");
        }
    });
    private static final int sdkMajor;
    private static final int sdkMinor;
    private static final int sdkRev;
    private static final long sdkRel;

    private static long[] setSDKComponent(String string) {
        Pattern pattern = Pattern.compile("(\\d+)(?:\\D+(\\d+)(?:\\D+(\\d+)(?:\\D+(\\d+))?)?)?.*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            int n = Integer.parseInt(matcher.group(1));
            int n2 = matcher.group(2) == null ? 0 : Integer.parseInt(matcher.group(2));
            int n3 = matcher.group(3) == null ? 0 : Integer.parseInt(matcher.group(3));
            long l = matcher.group(4) == null ? 0L : Long.parseLong(matcher.group(4));
            long[] lArray = new long[]{n, n2, n3, l};
            return lArray;
        }
        throw new IllegalStateException("Unable to parse java.version: '" + string + "' - expected format: 'major[.minor[.revision[.release]]]'");
    }

    private static String getBuildId() {
        return "@@MY_LEVEL@@";
    }

    public static String asString() {
        return FULL;
    }

    public static String getBuildLevel() {
        return BUILD;
    }

    public static short getVersionMajor() {
        return PartnerVersionUtil.getORB_MAJOR();
    }

    public static short getVersionMinor() {
        return PartnerVersionUtil.getORB_MINOR();
    }

    public static boolean sdkVersionLowerThan(int n, int n2, int n3) {
        return sdkMajor < n || sdkMajor == n && (sdkMinor < n2 || sdkMinor == n2 && sdkRev < n3);
    }

    public static boolean sdkVersionHigherThan(int n, int n2, int n3) {
        return sdkMajor > n || sdkMajor == n && (sdkMinor > n2 || sdkMinor == n2 && sdkRev > n3);
    }

    public static void logVersions() {
        if (Trc.enabled()) {
            Trc.info(Trc.FINE, FULL, CLASS, "logVersions:191");
            Trc.info(Trc.FINE, CFW_VERSION, CLASS, "logVersions:193");
            Trc.info(Trc.FINE, sdkFullVersion, CLASS, "logVersions:195");
            Trc.info(Trc.FINE, "SDK major=", Trc.str(sdkMajor), ", minor=", Trc.str(sdkMinor), ", revision=", Trc.str(sdkRev), ", release=", Trc.str(sdkRel), CLASS, "logVersions:199");
        }
    }

    public static void checkVersions() {
        String string = "";
        short s = Version.getVersionMajor();
        short s2 = Version.getVersionMinor();
        try {
            string = "Cannot use ORB 'orb80-20190308.00' with JDK '" + sdkVersion + "'";
            if (PartnerVersionUtil.isORB14OrGreater(s, s2)) {
                if (Version.sdkVersionLowerThan(1, 4, 0)) {
                    System.err.println(string);
                    throw new IllegalStateException(string);
                }
            } else if (!Version.sdkVersionLowerThan(1, 4, 0)) {
                System.err.println(string);
                throw new IllegalStateException(string);
            }
        }
        catch (IllegalStateException illegalStateException) {
            Trc.ffdc(illegalStateException, CLASS, "checkVersions:230");
            throw new INITIALIZE(illegalStateException.toString(), 1229124869, CompletionStatus.COMPLETED_NO);
        }
    }

    public static void main(String[] stringArray) {
        System.out.println(MAIN);
    }

    static {
        long[] lArray = Version.setSDKComponent(sdkVersion);
        sdkMajor = (int)lArray[0];
        sdkMinor = (int)lArray[1];
        sdkRev = (int)lArray[2];
        sdkRel = lArray[3];
    }
}

