/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.io.ObjectSerializer;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.SunSerializableFactory;
import com.ibm.rmi.util.PartnerVersionUtil;
import java.io.IOException;
import java.sql.Timestamp;

public final class TimestampSerializer
extends ObjectSerializer {
    private static final TimestampSerializer instance = new TimestampSerializer();
    private static final ObjectStreamClass timestampOSC = ObjectStreamClass.lookup(Timestamp.class);
    private static final SunSerializableFactory SERIALIZABLE_FACTORY = SunSerializableFactory.INSTANCE;

    private TimestampSerializer() {
        this.vTag = (byte)-126;
    }

    public static final TimestampSerializer getInstance() {
        return instance;
    }

    @Override
    public Object write(EncoderOutputStream encoderOutputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Timestamp timestamp = (Timestamp)object;
        encoderOutputStream.write_longlong(timestamp.getTime());
        return null;
    }

    @Override
    public Object read(EncoderInputStream encoderInputStream, Object object, ObjectStreamClass objectStreamClass) throws IOException {
        Timestamp timestamp = null;
        long l = encoderInputStream.read_longlong();
        timestamp = new Timestamp(l);
        encoderInputStream.addToValueCache(timestamp);
        return timestamp;
    }

    public static boolean canMarshall(short s, Object object) {
        if (PartnerVersionUtil.isSQLSerializersSupported(s)) {
            Timestamp timestamp = (Timestamp)object;
            Timestamp timestamp2 = new Timestamp(timestamp.getTime());
            return timestamp.equals(timestamp2);
        }
        return false;
    }

    Object getTargetObject(Timestamp timestamp) {
        Timestamp timestamp2 = new Timestamp(timestamp.getTime());
        return timestamp2;
    }
}

