/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.io;

import com.ibm.rmi.io.IIOPOutputStream;
import com.ibm.rmi.io.ObjectStreamClass;
import com.ibm.rmi.io.ObjectStreamField;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public abstract class OutputStreamHook
extends ObjectOutputStream {
    private HookPutFields putFields = null;
    private boolean defaultWriteObject = false;

    @Override
    public void defaultWriteObject() throws IOException {
        this.defaultWriteObject = true;
        this.defaultWriteObjectDelegate();
    }

    public abstract void defaultWriteObjectDelegate() throws IOException;

    @Override
    public ObjectOutputStream.PutField putFields() throws IOException {
        ObjectStreamField[] objectStreamFieldArray;
        ObjectStreamClass objectStreamClass = this.getCurrentClassDesc();
        int n = 11;
        if (objectStreamClass != null && null != (objectStreamFieldArray = objectStreamClass.getFieldsNoCopy())) {
            n = objectStreamFieldArray.length;
        }
        if (this.putFields == null) {
            this.putFields = new HookPutFields(n);
        }
        return this.putFields;
    }

    ObjectStreamClass getCurrentClassDesc() {
        return null;
    }

    @Override
    public void writeFields() throws IOException {
        this.defaultWriteObject = true;
        this.putFields.write(this);
    }

    public boolean getDefaultWriteObjectFlag() {
        return this.defaultWriteObject;
    }

    public void resetHookFields() {
        this.putFields = null;
        this.defaultWriteObject = false;
    }

    private class HookPutFields
    extends ObjectOutputStream.PutField {
        private HashMap fields = null;

        public HookPutFields(int n) {
            this.fields = new HashMap(n, 1.0f);
        }

        @Override
        public void put(String string, boolean bl) {
            this.fields.put(string, bl);
        }

        @Override
        public void put(String string, char c) {
            this.fields.put(string, Character.valueOf(c));
        }

        @Override
        public void put(String string, byte by) {
            this.fields.put(string, by);
        }

        @Override
        public void put(String string, short s) {
            this.fields.put(string, s);
        }

        @Override
        public void put(String string, int n) {
            this.fields.put(string, n);
        }

        @Override
        public void put(String string, long l) {
            this.fields.put(string, l);
        }

        @Override
        public void put(String string, float f) {
            this.fields.put(string, Float.valueOf(f));
        }

        @Override
        public void put(String string, double d) {
            this.fields.put(string, d);
        }

        @Override
        public void put(String string, Object object) {
            this.fields.put(string, object);
        }

        @Override
        public void write(ObjectOutput objectOutput) throws IOException {
            ((IIOPOutputStream)objectOutput).putClassFields(this.fields);
        }
    }
}

