/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.iiop.WorkUnit;
import com.ibm.rmi.iiop.WorkerPool;
import com.ibm.rmi.iiop.WorkerThread;
import java.util.LinkedList;

final class WorkQueue {
    private LinkedList workToDo = new LinkedList();
    private int workerCount = 0;
    private boolean shutdownPending = false;
    private WorkerPool workerPool;

    WorkQueue() {
    }

    synchronized void setWorkerPool(WorkerPool workerPool) {
        this.workerPool = workerPool;
    }

    synchronized void addWorkToDo(WorkUnit workUnit) {
        this.workToDo.addLast(workUnit);
        if (this.workToDo.size() > this.workerCount) {
            this.workerPool.createThread();
        }
        this.notify();
    }

    synchronized WorkUnit getWorkToDo() {
        if (this.workToDo.isEmpty()) {
            return null;
        }
        return (WorkUnit)this.workToDo.removeFirst();
    }

    synchronized void shutdown() {
        this.setShutdownPending(true);
        this.workerPool.shutdown();
        this.notifyAll();
    }

    private synchronized void setShutdownPending(boolean bl) {
        this.shutdownPending = true;
    }

    synchronized boolean isShutdownPending() {
        return this.shutdownPending;
    }

    synchronized void removeThread(WorkerThread workerThread) {
        this.workerPool.removeWorkerThread(workerThread);
    }

    synchronized void incrementWorkerCount() {
        ++this.workerCount;
    }

    synchronized void decrementWorkerCount() {
        --this.workerCount;
    }
}

