/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.corba;

import com.ibm.CORBA.iiop.INSUtil;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.ObjectURL;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.rmi.corba.IIOPAddrImpl;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.iiop.EncoderOutputStream;
import com.ibm.rmi.util.Utility;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.Object;

public class IorURL
implements ObjectURL {
    private Object objref;
    private String url;
    private IOR ior;
    private ArrayList iiopList = new ArrayList(1);
    private ObjectKey objectKey;
    private byte[] iorBytes;
    private boolean resolved = false;

    @Override
    public boolean isCorbaloc() {
        return false;
    }

    @Override
    public boolean isCorbaname() {
        return false;
    }

    @Override
    public boolean isIOR() {
        return true;
    }

    @Override
    public boolean isRir() {
        return false;
    }

    public Object resolve(ORB oRB) {
        if (!this.resolved) {
            this.iorbytesToObjref(oRB);
            if (this.ior == null) {
                this.ior = oRB.objectToIOR(this.objref);
                this.extractIorFields();
            }
        }
        return this.objref;
    }

    private void iorbytesToObjref(final ORB oRB) {
        EncoderInputStream encoderInputStream = (EncoderInputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                return new EncoderInputStream((org.omg.CORBA.ORB)oRB, IorURL.this.iorBytes, IorURL.this.iorBytes.length);
            }
        });
        encoderInputStream.consumeEndian();
        this.objref = encoderInputStream.read_Object();
        this.resolved = true;
    }

    IorURL(String string) {
        this.url = string;
        if (!string.startsWith("IOR:")) {
            throw new BAD_PARAM(string + " does not start with IOR:", 1330446343, CompletionStatus.COMPLETED_NO);
        }
        if ((string.length() & 1) != 0) {
            throw new DATA_CONVERSION(string + " not an even length", 1229124482, CompletionStatus.COMPLETED_NO);
        }
        this.iorBytes = new byte[(string.length() - 4) / 2];
        int n = 0;
        for (int i = 4; i < string.length(); i += 2) {
            this.iorBytes[n] = (byte)(Utility.hexOf(string.charAt(i)) << 4 & 0xF0);
            int n2 = n++;
            this.iorBytes[n2] = (byte)(this.iorBytes[n2] | (byte)(Utility.hexOf(string.charAt(i + 1)) << 0 & 0xF));
        }
    }

    IorURL(IOR iOR, final ORB oRB) {
        this.ior = iOR;
        this.extractIorFields();
        EncoderOutputStream encoderOutputStream = (EncoderOutputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public java.lang.Object run() {
                return new EncoderOutputStream((org.omg.CORBA.ORB)oRB);
            }
        });
        encoderOutputStream.putEndian();
        iOR.write(encoderOutputStream);
        this.iorBytes = encoderOutputStream.toByteArray();
        encoderOutputStream.releaseBuffer();
        this.iorbytesToObjref(oRB);
    }

    private void extractIorFields() {
        Profile profile = this.ior.getProfile();
        IIOPAddrImpl iIOPAddrImpl = new IIOPAddrImpl(profile.getHost(), profile.getPort(), profile.getMajor(), profile.getMinor());
        this.iiopList.add(iIOPAddrImpl);
        this.objectKey = profile.getObjectKeyObject();
    }

    @Override
    public String getStringName() {
        return null;
    }

    @Override
    public ObjectKey getObjectKey() {
        return this.objectKey;
    }

    @Override
    public String getKeyString() {
        if (this.objectKey != null) {
            return INSUtil.encode2936(new String(this.objectKey.getBytes()));
        }
        return null;
    }

    @Override
    public Iterator getProtList() {
        return this.getIIOPList();
    }

    @Override
    public Iterator getIIOPList() {
        if (this.iiopList != null) {
            return this.iiopList.iterator();
        }
        return null;
    }

    @Override
    public String toString() {
        if (this.url != null) {
            return this.url;
        }
        this.url = this.ior.stringify().trim();
        return this.url;
    }
}

