/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.CodeSetComponentInfo;
import com.ibm.rmi.corba.GIOPVersionProvider;
import com.ibm.rmi.corba.ORB;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.EncoderInputStream;
import com.ibm.rmi.util.JDKBridge;
import com.ibm.rmi.util.PartnerVersionUtil;
import com.ibm.rmi.util.Validator;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.OutputStream;

public class Profile
implements com.ibm.CORBA.iiop.Profile {
    private static final String CLASS = Profile.class.getName();
    protected String host;
    protected int port;
    protected byte major = 1;
    protected byte minor = (byte)2;
    private final byte maxMinor;
    protected ObjectKey objectKey;
    private byte[] data;
    protected TaggedComponent[] components;
    private com.ibm.rmi.ORB factory;
    private String dottedDecimalHostAddress = null;
    private CodeSetComponentInfo cs = null;
    private int partnerVersion = 0;
    private short partnerExtended = 0;
    private byte streamFormatVersion = 0;
    private String codebase = null;
    private boolean interceptorsRun = false;
    private Connection connection = null;
    private boolean isSameHost = false;

    public Profile(com.ibm.rmi.ORB oRB) {
        this(oRB, null, 0, null, new TaggedComponent[0]);
    }

    public Profile(com.ibm.rmi.ORB oRB, ObjectKey objectKey) {
        this(oRB, null, 0, objectKey, new TaggedComponent[0]);
    }

    public Profile(com.ibm.rmi.ORB oRB, String string, int n, ObjectKey objectKey, boolean bl) {
        this(oRB, string, n, objectKey, bl ? new TaggedComponent[]{} : null);
        if (bl) {
            this.partnerVersion = PartnerVersionUtil.pack((short)-1, (short)-1);
            this.partnerExtended = (short)-1;
        }
    }

    public Profile(com.ibm.rmi.ORB oRB, String string, int n, ObjectKey objectKey) {
        this(oRB, string, n, objectKey, null);
    }

    public Profile(com.ibm.rmi.ORB oRB, String string, int n, ObjectKey objectKey, TaggedComponent[] taggedComponentArray) {
        this.factory = oRB;
        this.host = string;
        this.port = n;
        this.objectKey = objectKey;
        this.minor = this.maxMinor = ((GIOPVersionProvider)((Object)oRB)).getMaxGIOPMinor();
        if (taggedComponentArray == null) {
            int n2 = this.major == 1 && this.minor == 2 ? 3 : 2;
            this.components = new TaggedComponent[n2];
            this.components[0] = this.createCodeSetComponent();
            this.components[1] = this.createPartnerComponent();
            if (n2 > 2) {
                this.components[2] = this.createStreamFormatComponent();
            }
        } else {
            this.components = taggedComponentArray;
            this.setCachedComponentInfo();
        }
    }

    private TaggedComponent createCodeSetComponent() {
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        this.cs = (CodeSetComponentInfo)this.factory.getCodeSetComponentInfo();
        cDROutputStream.putEndian();
        this.cs.write(cDROutputStream);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return new TaggedComponent(1, byArray);
    }

    private TaggedComponent createPartnerComponent() {
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        cDROutputStream.putEndian();
        this.partnerExtended = ((ORB)this.factory).getPartnerExtended();
        cDROutputStream.write_ushort(this.partnerExtended);
        this.partnerVersion = ((ORB)this.factory).getPartnerVersion();
        cDROutputStream.write_ulong(this.partnerVersion);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return new TaggedComponent(1229081866, byArray);
    }

    private TaggedComponent createStreamFormatComponent() {
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        cDROutputStream.putEndian();
        this.streamFormatVersion = (byte)2;
        cDROutputStream.write_octet(this.streamFormatVersion);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return new TaggedComponent(38, byArray);
    }

    void addCodebaseComponent(String string) {
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        cDROutputStream.putEndian();
        cDROutputStream.write_string(string);
        byte[] byArray = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        this.addTaggedComponent(new TaggedComponent(25, byArray));
        this.codebase = string;
    }

    private void setCachedComponentInfo() {
        for (int i = 0; i < this.components.length; ++i) {
            this.setCachedComponentInfo(this.components[i]);
        }
    }

    private void setCachedComponentInfo(TaggedComponent taggedComponent) {
        switch (taggedComponent.tag()) {
            case 1: {
                CDRInputStream cDRInputStream = taggedComponent.getComponentData(this.factory);
                this.cs = new CodeSetComponentInfo();
                this.cs.read(cDRInputStream);
                break;
            }
            case 25: {
                CDRInputStream cDRInputStream = taggedComponent.getComponentData(this.factory);
                this.codebase = cDRInputStream.read_string();
                break;
            }
            case 38: {
                CDRInputStream cDRInputStream = taggedComponent.getComponentData(this.factory);
                this.streamFormatVersion = cDRInputStream.read_octet();
                break;
            }
            case 1229081866: {
                CDRInputStream cDRInputStream = taggedComponent.getComponentData(this.factory);
                this.partnerExtended = cDRInputStream.read_ushort();
                this.partnerVersion = cDRInputStream.read_ulong();
                if (this.partnerVersion != 0) break;
                this.partnerVersion = PartnerVersionUtil.pack(PartnerVersionUtil.getORB11(), (short)0);
            }
        }
    }

    @Override
    public byte[] getEncapsulation() throws SystemException {
        if (this.data != null) {
            return this.data;
        }
        CDROutputStream cDROutputStream = this.factory.newOutputStream();
        cDROutputStream.putEndian();
        cDROutputStream.write_octet(this.major);
        cDROutputStream.write_octet(this.minor);
        cDROutputStream.write_string(this.host);
        if (!this.getIsSameHost() && this.dottedDecimalHostAddress != null) {
            cDROutputStream.write_string(this.dottedDecimalHostAddress);
        }
        cDROutputStream.write_short((short)this.port);
        cDROutputStream.write_long(this.objectKey.length());
        cDROutputStream.write_octet_array(this.objectKey.getBytes(), 0, this.objectKey.length());
        if (this.minor > 0) {
            cDROutputStream.write_long(this.components.length);
            for (int i = 0; i < this.components.length; ++i) {
                this.components[i].write(cDROutputStream);
            }
        }
        this.data = cDROutputStream.toByteArray();
        cDROutputStream.releaseBuffer();
        return this.data;
    }

    @Override
    public Profile.TaggedComponent[] getTaggedComponents() {
        return this.components;
    }

    @Override
    public Profile.TaggedComponent[] getTaggedComponents(int n) {
        int n2 = 0;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag() != n) continue;
            ++n2;
        }
        Profile.TaggedComponent[] taggedComponentArray = new TaggedComponent[n2];
        n2 = 0;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag() != n) continue;
            taggedComponentArray[n2++] = this.components[i];
        }
        return taggedComponentArray;
    }

    @Override
    public byte[] getTaggedComponent(int n) {
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag() != n) continue;
            return this.components[i].componentData();
        }
        return null;
    }

    @Override
    public void putTaggedComponent(int n, byte[] byArray) {
        this.putTaggedComponent(n, byArray, true);
    }

    @Override
    public void putTaggedComponent(int n, byte[] byArray, boolean bl) {
        int n2;
        TaggedComponent taggedComponent = null;
        if (bl) {
            for (n2 = 0; n2 < this.components.length; ++n2) {
                if (this.components[n2].tag() != n) continue;
                taggedComponent = this.components[n2];
            }
        }
        if (taggedComponent == null) {
            n2 = this.components.length;
            TaggedComponent[] taggedComponentArray = this.components;
            this.components = new TaggedComponent[n2 + 1];
            System.arraycopy(taggedComponentArray, 0, this.components, 0, n2);
            this.components[n2] = taggedComponent = new TaggedComponent(n, byArray);
        } else {
            taggedComponent.setData(byArray);
        }
        this.setCachedComponentInfo(taggedComponent);
    }

    @Override
    public void removeTaggedComponent(int n) {
        int n2 = 0;
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].tag() == n) continue;
            ++n2;
        }
        if (n2 < this.components.length) {
            TaggedComponent[] taggedComponentArray = new TaggedComponent[n2];
            n2 = 0;
            for (int i = 0; i < this.components.length; ++i) {
                if (this.components[i].tag() == n) continue;
                taggedComponentArray[n2] = this.components[i];
                ++n2;
            }
            this.components = taggedComponentArray;
        }
    }

    public void addTaggedComponent(TaggedComponent taggedComponent) {
        TaggedComponent[] taggedComponentArray = this.components;
        this.components = new TaggedComponent[taggedComponentArray.length + 1];
        System.arraycopy(taggedComponentArray, 0, this.components, 0, taggedComponentArray.length);
        this.components[taggedComponentArray.length] = taggedComponent;
    }

    public void addTaggedComponents(TaggedComponent[] taggedComponentArray) {
        TaggedComponent[] taggedComponentArray2 = this.components;
        this.components = new TaggedComponent[taggedComponentArray2.length + taggedComponentArray.length];
        System.arraycopy(taggedComponentArray2, 0, this.components, 0, taggedComponentArray2.length);
        System.arraycopy(taggedComponentArray, 0, this.components, taggedComponentArray2.length, taggedComponentArray.length);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String string) {
        this.host = string;
        this.dottedDecimalHostAddress = null;
    }

    @Override
    public String getHostIPAddress() {
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, "HostIPAddress(Entry) = " + (this.dottedDecimalHostAddress == null ? "null" : this.dottedDecimalHostAddress), CLASS, "getHostIPAddress:511");
        }
        if (this.dottedDecimalHostAddress == null) {
            this.dottedDecimalHostAddress = this.factory.getTransport().getHostIPAddress(this.host);
        }
        if (Trc.enabled(3)) {
            Trc.info(Trc.FINEST, "HostIPAddress(Exit) = " + (this.dottedDecimalHostAddress == null ? "null" : this.dottedDecimalHostAddress), CLASS, "getHostIPAddress:522");
        }
        return this.dottedDecimalHostAddress;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int n) {
        this.port = n;
    }

    @Override
    public byte[] getObjectKey() {
        return this.objectKey.getBytes();
    }

    @Override
    public ObjectKey getObjectKeyObject() {
        return this.objectKey;
    }

    public void setObjectKey(ObjectKey objectKey) {
        this.objectKey = objectKey;
    }

    public com.ibm.rmi.ORB getFactory() {
        return this.factory;
    }

    @Override
    public byte getMajor() {
        return this.major;
    }

    @Override
    public byte getMinor() {
        return this.minor;
    }

    @Override
    public void setMinor(byte by) {
        this.minor = by < 0 ? (byte)0 : (by > this.maxMinor ? this.maxMinor : by);
        if (this.minor != by && Trc.enabled(3)) {
            Trc.info(Trc.FINER, "requested GIOP minor = " + by + " out of range,  reset to " + this.minor, CLASS, "setMinor:577");
        }
    }

    @Override
    public com.ibm.CORBA.iiop.CodeSetComponentInfo getCodeSetComponentInfo() {
        return this.cs;
    }

    @Override
    public int getPartnerVersion() {
        return this.partnerVersion;
    }

    @Override
    public short getPartnerExtended() {
        return this.partnerExtended;
    }

    public byte getStreamFormatVersion() {
        return this.streamFormatVersion;
    }

    @Override
    public String getCodebase() {
        return this.codebase;
    }

    @Override
    public boolean isEquivalent(com.ibm.CORBA.iiop.Profile profile) {
        return this.getPort() == profile.getPort() && this.getHost().equalsIgnoreCase(profile.getHost()) && this.getObjectKeyObject().equals(profile.getObjectKeyObject());
    }

    @Override
    public void read(CDRInputStream cDRInputStream) {
        byte[] byArray;
        int n = cDRInputStream.read_ulong();
        boolean bl = Validator.isValidPostiveInteger(n);
        if (!bl) {
            throw new MARSHAL("Invalid Profile data length " + n);
        }
        try {
            byArray = new byte[n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new MARSHAL("Data of length 0x" + Integer.toHexString(n) + " while reading Profile", 1229126036, CompletionStatus.COMPLETED_NO);
        }
        cDRInputStream.read_octet_array(byArray, 0, n);
        this.read(byArray);
    }

    protected void read(final byte[] byArray) {
        block11: {
            byte[] byArray2;
            this.dottedDecimalHostAddress = null;
            CDRInputStream cDRInputStream = (CDRInputStream)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new EncoderInputStream((org.omg.CORBA.ORB)Profile.this.factory, byArray, byArray.length);
                }
            });
            cDRInputStream.consumeEndian();
            this.major = cDRInputStream.read_octet();
            this.minor = cDRInputStream.read_octet();
            this.host = cDRInputStream.read_string();
            this.port = cDRInputStream.read_short() & 0xFFFF;
            int n = cDRInputStream.read_long();
            boolean bl = Validator.isValidPostiveInteger(n);
            if (!bl) {
                throw new MARSHAL("Invalid ObjectKey length " + n);
            }
            try {
                byArray2 = new byte[n];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new MARSHAL("ObjectKey of length 0x" + Integer.toHexString(n) + " while reading Profile", 1229126037, CompletionStatus.COMPLETED_NO);
            }
            cDRInputStream.read_octet_array(byArray2, 0, n);
            this.objectKey = this.factory.createObjectKey(byArray2);
            if (this.minor > 0) {
                String string;
                int n2 = cDRInputStream.read_long();
                try {
                    this.components = new TaggedComponent[n2];
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new MARSHAL("TaggedComponent sequence of length 0x" + Integer.toHexString(n2) + " while reading Profile", 1229126038, CompletionStatus.COMPLETED_NO);
                }
                for (int i = 0; i < n2; ++i) {
                    this.components[i] = new TaggedComponent();
                    this.components[i].read(cDRInputStream);
                }
                this.setCachedComponentInfo();
                if (this.codebase == null && (string = JDKBridge.getLocalCodebase()) != null) {
                    this.addCodebaseComponent(string);
                }
            } else {
                this.components = new TaggedComponent[0];
            }
            try {
                cDRInputStream.close();
            }
            catch (IOException iOException) {
                if (!Trc.enabled(3)) break block11;
                Trc.ffdc(iOException, CLASS, "read:710");
            }
        }
    }

    @Override
    public void write(CDROutputStream cDROutputStream) {
        CDROutputStream cDROutputStream2 = this.factory.newOutputStream();
        cDROutputStream2.putEndian();
        cDROutputStream2.write_octet(this.major);
        cDROutputStream2.write_octet(this.minor);
        cDROutputStream2.write_string(this.host);
        cDROutputStream2.write_short((short)this.port);
        cDROutputStream2.write_long(this.objectKey.length());
        cDROutputStream2.write_octet_array(this.objectKey.getBytes(), 0, this.objectKey.length());
        if (this.minor > 0) {
            cDROutputStream2.write_long(this.components.length);
            for (int i = 0; i < this.components.length; ++i) {
                this.components[i].write(cDROutputStream2);
            }
        }
        cDROutputStream2.writeOctetSequenceTo((OutputStream)cDROutputStream);
        cDROutputStream2.releaseBuffer();
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Trc.ffdc(cloneNotSupportedException, CLASS, "clone:748");
            throw new INTERNAL("failed to clone Profile:" + cloneNotSupportedException.getMessage(), 1229125048, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void interceptorsRun(boolean bl) {
        this.interceptorsRun = bl;
    }

    public boolean interceptorsRun() {
        return this.interceptorsRun;
    }

    public int hashCode() {
        return this.objectKey.hashCode() + this.host.hashCode() + this.port;
    }

    public boolean equals(Profile profile) {
        if (this.getHost().equalsIgnoreCase(profile.getHost()) && profile.dottedDecimalHostAddress == null) {
            this.setIsSameHost(true);
        }
        byte[] byArray = this.getEncapsulation();
        byte[] byArray2 = profile.getEncapsulation();
        boolean bl = Arrays.equals(byArray, byArray2);
        return bl;
    }

    public boolean equals(Object object) {
        if (object instanceof Profile) {
            return this.equals((Profile)object);
        }
        return false;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    boolean getIsSameHost() {
        return this.isSameHost;
    }

    void setIsSameHost(boolean bl) {
        this.isSameHost = bl;
    }

    public static class TaggedComponent
    implements Profile.TaggedComponent {
        private int tag;
        private byte[] data;

        public TaggedComponent() {
            this.tag = -1;
            this.data = null;
        }

        public TaggedComponent(int n, byte[] byArray) {
            this.tag = n;
            this.data = byArray;
        }

        public void read(CDRInputStream cDRInputStream) {
            byte[] byArray;
            this.tag = cDRInputStream.read_ulong();
            int n = cDRInputStream.read_long();
            boolean bl = Validator.isValidPostiveInteger(n);
            if (!bl) {
                throw new MARSHAL("Invalid Component data length " + n);
            }
            try {
                byArray = new byte[n];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new MARSHAL("Component data of length 0x" + Integer.toHexString(n) + " while reading Profile", 1229126035, CompletionStatus.COMPLETED_NO);
            }
            cDRInputStream.read_octet_array(byArray, 0, n);
            this.data = byArray;
        }

        @Override
        public void write(CDROutputStream cDROutputStream) {
            cDROutputStream.write_ulong(this.tag);
            cDROutputStream.write_long(this.data.length);
            cDROutputStream.write_octet_array(this.data, 0, this.data.length);
        }

        @Override
        public CDRInputStream getComponentData(com.ibm.CORBA.iiop.ORB oRB) {
            return this.getComponentData((com.ibm.rmi.ORB)oRB);
        }

        public CDRInputStream getComponentData(com.ibm.rmi.ORB oRB) {
            CDRInputStream cDRInputStream = oRB.newInputStream(this.data, this.data.length);
            cDRInputStream.consumeEndian();
            return cDRInputStream;
        }

        @Override
        public int tag() {
            return this.tag;
        }

        @Override
        public byte[] componentData() {
            return this.data;
        }

        private void setData(byte[] byArray) {
            this.data = byArray;
        }
    }
}

