/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertID;
import com.ibm.security.cert.CertPathSystemProperties;
import com.ibm.security.cert.CertStatus;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.Extension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SingleResponse {
    private CertID certId;
    private CertStatus certStatus;
    private Date thisUpdate;
    private Date nextUpdate;
    private Map<String, java.security.cert.Extension> singleExtensions;
    private Date date = null;
    private static final Debug debug = Debug.getInstance((String)"certpath");

    public SingleResponse(CertID certId, CertStatus status, Date thisUpdate, Date nextUpdate, Map<String, java.security.cert.Extension> exts) {
        if (certId == null) {
            throw new NullPointerException("CertID can not be null");
        }
        if (status == null) {
            throw new NullPointerException("CertStatus can not be null");
        }
        if (thisUpdate == null) {
            throw new NullPointerException("thisUpdate can not be null");
        }
        this.certId = certId;
        this.certStatus = status;
        this.thisUpdate = thisUpdate;
        this.nextUpdate = nextUpdate;
        this.singleExtensions = exts;
    }

    public SingleResponse(byte[] encodedData) throws IOException {
        this(encodedData, null);
    }

    SingleResponse(byte[] encodedData, Date date) throws IOException {
        DerInputStream dis = new DerInputStream(encodedData);
        DerValue[] ders = dis.getSequence(3);
        if (ders.length < 3) {
            throw new IOException("encoded data do not contain all required data fields");
        }
        this.certId = new CertID(ders[0]);
        this.certStatus = new CertStatus(ders[1]);
        this.thisUpdate = ders[2].getGeneralizedTime();
        this.date = date;
        if (ders.length > 3) {
            block4: for (int i = 3; i < ders.length; ++i) {
                int tag = ders[i].getTag() & 0x1F;
                switch (tag) {
                    case 0: {
                        this.nextUpdate = ders[i].getData().getGeneralizedTime();
                        continue block4;
                    }
                    case 1: {
                        DerInputStream temp = ders[i].getData();
                        DerValue[] values = temp.getSequence(1);
                        if (this.singleExtensions == null || this.singleExtensions.isEmpty()) {
                            this.singleExtensions = new HashMap<String, java.security.cert.Extension>(values.length);
                        }
                        for (int j = 0; j < values.length; ++j) {
                            Extension extension = new Extension(values[j]);
                            this.singleExtensions.put(extension.getId(), (java.security.cert.Extension)extension);
                        }
                        continue block4;
                    }
                    default: {
                        throw new IOException("invalid tag");
                    }
                }
            }
        }
        if (this.singleExtensions == null) {
            this.singleExtensions = Collections.emptyMap();
        }
        long now = date == null ? System.currentTimeMillis() : date.getTime();
        Date nowPlusSkew = new Date(now + (long)CertPathSystemProperties.getOCSPClockSkew());
        Date nowMinusSkew = new Date(now - (long)CertPathSystemProperties.getOCSPClockSkew());
        if (debug != null) {
            String until = "";
            if (this.nextUpdate != null) {
                until = " until " + this.nextUpdate;
            }
            System.out.println("OCSP response validity interval is from " + this.thisUpdate + until);
            System.out.println("Checking validity of OCSP response on: " + new Date(now));
        }
        if (nowPlusSkew.before(this.thisUpdate) || nowMinusSkew.after(this.nextUpdate != null ? this.nextUpdate : this.thisUpdate)) {
            if (debug != null) {
                System.out.println("Response is unreliable: its validity interval is out-of-date");
            }
            throw new IOException("Response is unreliable: its validity interval is out-of-date");
        }
    }

    public SingleResponse(DerValue der) throws IOException {
        this(der.toByteArray());
    }

    SingleResponse(DerValue der, Date date) throws IOException {
        this(der.toByteArray(), date);
    }

    public CertID getCertID() {
        return this.certId;
    }

    public CertStatus getCertStatus() {
        return this.certStatus;
    }

    public Date getThisUpdate() {
        return this.thisUpdate;
    }

    public Date getNextUpdate() {
        return this.nextUpdate;
    }

    public java.security.cert.Extension getExtension(String oidstring) {
        java.security.cert.Extension ext = this.singleExtensions.get(oidstring);
        return ext;
    }

    public Map<String, java.security.cert.Extension> getSingleExtensions() {
        return Collections.unmodifiableMap(this.singleExtensions);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SingleResponse:[\n");
        sb.append(this.certId.toString());
        sb.append(this.certStatus.toString() + "\n");
        sb.append("  thisUpdate: " + this.thisUpdate.toString() + "\n");
        if (this.nextUpdate != null) {
            sb.append("  nextUpdate: " + this.nextUpdate.toString() + "\n");
        }
        if (!this.singleExtensions.isEmpty()) {
            Iterator<String> it = this.singleExtensions.keySet().iterator();
            sb.append("  extensions:[\n");
            while (it.hasNext()) {
                String key = it.next();
                sb.append(" (" + this.singleExtensions.get(key) + ") ");
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public byte[] encode() throws IOException {
        ArrayList<DerValue> alist = new ArrayList<DerValue>();
        byte[] temp = this.certId.encode();
        alist.add(new DerValue(temp));
        alist.add(new DerValue(this.certStatus.encode()));
        DerOutputStream dos = new DerOutputStream();
        dos.putGeneralizedTime(this.thisUpdate);
        alist.add(new DerValue(dos.toByteArray()));
        if (this.nextUpdate != null) {
            dos = new DerOutputStream();
            dos.putGeneralizedTime(this.nextUpdate);
            DerValue der3 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)0), dos.toByteArray());
            alist.add(der3);
        }
        if (this.singleExtensions != null && !this.singleExtensions.isEmpty()) {
            DerValue[] ders = new DerValue[this.singleExtensions.size()];
            Iterator<String> it = this.singleExtensions.keySet().iterator();
            int count = 0;
            while (it.hasNext()) {
                String extID = it.next();
                java.security.cert.Extension ext = this.singleExtensions.get(extID);
                dos = new DerOutputStream();
                ext.encode((OutputStream)dos);
                ders[count] = new DerValue(dos.toByteArray());
                ++count;
            }
            dos = new DerOutputStream();
            dos.putSequence(ders);
            DerValue der4 = new DerValue(DerValue.createTag((byte)-128, (boolean)true, (byte)1), dos.toByteArray());
            alist.add(der4);
        }
        DerValue[] values = new DerValue[alist.size()];
        alist.toArray(values);
        dos = new DerOutputStream();
        dos.putSequence(values);
        return dos.toByteArray();
    }
}

