/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.security.cert.CertID;
import com.ibm.security.cert.OCSPException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.Extension;
import java.io.IOException;

public class SingleRequest {
    private Extension[] ext = null;
    private CertID certId = null;

    public SingleRequest(CertID id, Extension[] extx) {
        if (id == null) {
            OCSPException e = new OCSPException("missing CertID");
            e.printStackTrace();
        }
        this.certId = id;
        this.ext = extx;
    }

    public SingleRequest(DerValue der) throws IOException {
        DerInputStream dis = new DerInputStream(der.toByteArray());
        DerValue[] ders = dis.getSequence(1);
        if (ders.length == 0) {
            throw new IOException("SingleRequest does not contain a Cert ID");
        }
        this.certId = new CertID(ders[0]);
        if (ders.length == 2) {
            DerInputStream dis2 = ders[1].getData();
            DerValue[] values = dis2.getSequence(2);
            this.ext = new Extension[values.length];
            for (int i = 0; i < values.length; ++i) {
                this.ext[i] = new Extension(values[i]);
            }
        }
    }

    public CertID getCertID() {
        return this.certId;
    }

    public Extension[] getExtensions() {
        return this.ext;
    }

    public byte[] encode() throws IOException {
        DerOutputStream dos = new DerOutputStream();
        dos.write(this.certId.encode());
        if (this.ext != null) {
            DerOutputStream dos2 = null;
            DerValue[] ders = new DerValue[this.ext.length];
            for (int i = 0; i < this.ext.length; ++i) {
                dos2 = new DerOutputStream();
                this.ext[i].encode(dos2);
                ders[i] = new DerValue(dos2.toByteArray());
            }
            dos2 = new DerOutputStream();
            dos2.putSequence(ders);
            dos.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), dos2);
        }
        DerOutputStream temp = new DerOutputStream();
        temp.write((byte)48, dos);
        return temp.toByteArray();
    }
}

