/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertPathSystemProperties;
import java.net.URI;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.Extension;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PKIXRevocationCheckerImpl
extends PKIXRevocationChecker {
    private URI ocspResponder;
    private X509Certificate ocspResponderCert;
    private List<Extension> ocspExtensions = Collections.emptyList();
    private Map<X509Certificate, byte[]> ocspResponses = Collections.emptyMap();
    private Set<PKIXRevocationChecker.Option> options = Collections.emptySet();
    protected LinkedList<CertPathValidatorException> softFailExceptions = new LinkedList();
    private static final Debug debug = Debug.getInstance((String)"certpath");

    protected PKIXRevocationCheckerImpl() {
    }

    public void setOCSPResponder(URI uri) {
        this.ocspResponder = uri;
    }

    public URI getOCSPResponder() {
        return this.ocspResponder;
    }

    public void setOCSPResponderCert(X509Certificate cert) {
        this.ocspResponderCert = cert;
    }

    public X509Certificate getOCSPResponderCert() {
        return this.ocspResponderCert;
    }

    public void setOCSPExtensions(List<Extension> extensions) {
        this.ocspExtensions = extensions == null ? Collections.emptyList() : new ArrayList<Extension>(extensions);
    }

    public List<Extension> getOCSPExtensions() {
        return Collections.unmodifiableList(this.ocspExtensions);
    }

    public void setOCSPResponses(Map<X509Certificate, byte[]> responses) {
        if (responses == null) {
            this.ocspResponses = Collections.emptyMap();
        } else {
            HashMap<X509Certificate, byte[]> copy = new HashMap<X509Certificate, byte[]>(responses.size());
            for (Map.Entry<X509Certificate, byte[]> e : responses.entrySet()) {
                copy.put(e.getKey(), (byte[])e.getValue().clone());
            }
            this.ocspResponses = copy;
        }
    }

    public Map<X509Certificate, byte[]> getOCSPResponses() {
        HashMap<X509Certificate, byte[]> copy = new HashMap<X509Certificate, byte[]>(this.ocspResponses.size());
        for (Map.Entry<X509Certificate, byte[]> e : this.ocspResponses.entrySet()) {
            copy.put(e.getKey(), (byte[])e.getValue().clone());
        }
        return copy;
    }

    @Override
    public void setOptions(Set<PKIXRevocationChecker.Option> options) {
        this.options = options == null ? Collections.emptySet() : new HashSet<PKIXRevocationChecker.Option>(options);
    }

    @Override
    public Set<PKIXRevocationChecker.Option> getOptions() {
        return Collections.unmodifiableSet(this.options);
    }

    @Override
    public PKIXRevocationChecker clone() {
        PKIXRevocationCheckerImpl copy = (PKIXRevocationCheckerImpl)super.clone();
        copy.ocspExtensions = new ArrayList<Extension>(this.ocspExtensions);
        copy.ocspResponses = new HashMap<X509Certificate, byte[]>(this.ocspResponses);
        for (Map.Entry<X509Certificate, byte[]> entry : copy.ocspResponses.entrySet()) {
            byte[] encoded = entry.getValue();
            entry.setValue((byte[])encoded.clone());
        }
        copy.options = new HashSet<PKIXRevocationChecker.Option>(this.options);
        copy.softFailExceptions = new LinkedList<CertPathValidatorException>(this.softFailExceptions);
        return copy;
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking is unsupported.");
        }
        this.softFailExceptions.clear();
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    @Override
    public Set<String> getSupportedExtensions() {
        return null;
    }

    @Override
    public List<CertPathValidatorException> getSoftFailExceptions() {
        return Collections.unmodifiableList(this.softFailExceptions);
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) {
    }

    @Override
    public void check(Certificate cert) throws CertPathValidatorException {
        this.check(cert, Collections.emptySet());
    }

    protected static boolean isSoftFailException(CertPathValidatorException e, PKIXParameters pkixParams) {
        boolean softFail;
        PKIXRevocationCheckerImpl checker = PKIXRevocationCheckerImpl.getPKIXRevocationCheckerFromPKIXParameters(pkixParams);
        if (checker != null && (softFail = PKIXRevocationCheckerImpl.getSoftFail(pkixParams)) && e.getReason() == CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS) {
            checker.softFailExceptions.addFirst(e);
            return true;
        }
        return false;
    }

    static boolean getSoftFail(PKIXParameters pkixParams) {
        PKIXRevocationCheckerImpl checker = PKIXRevocationCheckerImpl.getPKIXRevocationCheckerFromPKIXParameters(pkixParams);
        if (checker != null) {
            Set<PKIXRevocationChecker.Option> optionSet = ((PKIXRevocationChecker)checker).getOptions();
            if (optionSet != null) {
                if (debug != null) {
                    System.out.println("CERTPATH:  PKIXRevocationCheckerImpl.java:  getSoftFail():  The revocation optionSet is not null.");
                }
                if (optionSet.size() != 0) {
                    for (PKIXRevocationChecker.Option option : optionSet) {
                        if (option != PKIXRevocationChecker.Option.SOFT_FAIL) continue;
                        if (debug != null) {
                            System.out.println("CERTPATH:  PKIXRevocationCheckerImpl.java:  getSoftFail():  SOFT_FAIL was specified by the caller.  Returning TRUE");
                        }
                        return true;
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH:  PKIXRevocationCheckerImpl.java:  getSoftFail():  SOFT_FAIL was NOT specified by the caller.  Returning FALSE");
                    }
                    return false;
                }
                if (debug != null) {
                    System.out.println("CERTPATH:  PKIXRevocationCheckerImpl.java:  getSoftFail():  SOFT_FAIL was NOT specified by the caller.  The OptionSet was empty.  Returning FALSE");
                }
                return false;
            }
            if (debug != null) {
                System.out.println("CERTPATH:  PKIXRevocationCheckerImpl.java:  getSoftFail():  SOFT_FAIL was NOT specified by the caller.  The OptionSet was null.  Returning FALSE");
            }
            return false;
        }
        if (debug != null) {
            System.out.println("CERTPATH:  PKIXRevocationCheckerImpl.java:  getSoftFail():  SOFT_FAIL was NOT specified by the caller.  The RevocationChecker object was null.  Returning FALSE");
        }
        return false;
    }

    static boolean getOnlyCheckEECert(PKIXParameters pkixParams) {
        boolean onlyCheckEECert = false;
        PKIXRevocationCheckerImpl checker = PKIXRevocationCheckerImpl.getPKIXRevocationCheckerFromPKIXParameters(pkixParams);
        if (checker != null) {
            Set<PKIXRevocationChecker.Option> optionSet = ((PKIXRevocationChecker)checker).getOptions();
            if (optionSet != null) {
                for (PKIXRevocationChecker.Option option : optionSet) {
                    if (option == PKIXRevocationChecker.Option.ONLY_END_ENTITY) {
                        onlyCheckEECert = true;
                        if (debug == null) continue;
                        System.out.println("CERTPATH: PKIXRevocationCheckerImpl.java:  getOnlyCheckEECert():  ONLY_END_ENTITY = true IN REVOCATION CHECKER ");
                        System.out.println("                                                                  Setting onlyCheckEECert = true               ");
                        continue;
                    }
                    if (debug == null) continue;
                    System.out.println("CERTPATH: PKIXRevocationCheckerImpl.java:  getOnlyCheckEECert():  This PKIXRevocationChecker.Option is NOT \"ONLY_END_ENTITY\" ");
                }
            } else if (debug != null) {
                System.out.println("CERTPATH:  PKIXRevocationCheckerImpl.java:  getOnlyCheckEECert():  ONLY_END_ENTITY = false SINCE THE OPTIONS IN REVOCATION CHECKER ARE NULL");
            }
        }
        if (CertPathSystemProperties.getOnlyEECert()) {
            onlyCheckEECert = true;
            if (debug != null) {
                System.out.println("CERTPATH: PKIXRevocationCheckerImpl.java:  getOnlyCheckEECert():  The system property com.ibm.security.onlyCheckRevocationOfEECert DID specify that only the end-entity cert was to be checked.");
            }
        } else if (debug != null) {
            System.out.println("CERTPATH: PKIXRevocationCheckerImpl.java:  getOnlyCheckEECert():  The system property com.ibm.security.onlyCheckRevocationOfEECert DID NOT specify that only the end-entity cert was to be checked.");
        }
        if (debug != null) {
            System.out.println("CERTPATH: PKIXRevocationCheckerImpl.java:  getOnlyCheckEECert():  Returning:  " + onlyCheckEECert);
        }
        return onlyCheckEECert;
    }

    /*
     * Enabled aggressive block sorting
     */
    static PKIXRevocationCheckerImpl getPKIXRevocationCheckerFromPKIXParameters(PKIXParameters pkixParams) {
        int size;
        List<PKIXCertPathChecker> tmpList;
        PKIXCertPathChecker checker;
        block13: {
            block12: {
                if (pkixParams == null) {
                    return null;
                }
                checker = null;
                tmpList = pkixParams.getCertPathCheckers();
                if (tmpList == null) break block12;
                if (debug != null) {
                    System.out.println("PKIXRevocationCheckerImpl.java:  The PKIXParameters contains a list of CertPathCheckers that is not null");
                }
                if ((size = tmpList.size()) != 0) {
                    if (debug != null) {
                        System.out.println("PKIXRevocationCheckerImpl.java:  The PKIXParameters contains a list of CertPathCheckers and the list size is not zero");
                    }
                    break block13;
                } else {
                    if (debug != null) {
                        System.out.println("PKIXRevocationCheckerImpl.java:  getPKIXRevocationCheckerFromPKIXParameters():  The list of CertPathCheckers from PKIXParameters was empty.  Therefore, there was no PKIXRevocationChecker object.");
                    }
                    return null;
                }
            }
            if (debug != null) {
                System.out.println("PKIXRevocationCheckerImpl.java:  getPKIXRevocationCheckerFromPKIXParameters():  The list of CertPathCheckers from PKIXParameters was NULL.  Therefore, there was no PKIXRevocationChecker object.");
            }
            return null;
        }
        int i = 0;
        while (i < size) {
            checker = tmpList.get(i);
            if (debug != null) {
                System.out.println("PKIXRevocationCheckerImpl.java:  The PKIXParameters contains a checker of class:  " + checker.getClass().getName());
            }
            if (checker instanceof PKIXRevocationCheckerImpl) {
                if (debug != null) {
                    System.out.println("PKIXRevocationCheckerImpl.java:  getPKIXRevocationCheckerFromPKIXParameters():  PKIXParameters DID contain a PKIXRevocationChecker object.");
                }
                return (PKIXRevocationCheckerImpl)checker;
            }
            ++i;
        }
        return null;
    }
}

