/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.misc.IOUtils;
import com.ibm.security.cert.BasicOCSPResponse;
import com.ibm.security.cert.CertID;
import com.ibm.security.cert.CertPathSystemProperties;
import com.ibm.security.cert.CertStatus;
import com.ibm.security.cert.OCSPCertPathStatusUnknownException;
import com.ibm.security.cert.OCSPCertRevokedException;
import com.ibm.security.cert.OCSPException;
import com.ibm.security.cert.OCSPRequest;
import com.ibm.security.cert.OCSPResponse;
import com.ibm.security.cert.PKIXExtendedParameters;
import com.ibm.security.cert.PKIXRevocationCheckerImpl;
import com.ibm.security.cert.SingleRequest;
import com.ibm.security.cert.SingleResponse;
import com.ibm.security.x509.AccessDescription;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.URIName;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.Extension;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class OCSPChecker
extends PKIXCertPathChecker {
    public static final String OCSP_ENABLE = "ocsp.enable";
    public static final String OCSP_URL = "ocsp.responderURL";
    public static final String OCSP_CERT_SUBJECT = "ocsp.responderCertSubjectName";
    public static final String OCSP_CERT_ISSUER = "ocsp.responderCertIssuerName";
    public static final String OCSP_CERT_SERIAL_NUMBER = "ocsp.responderCertSerialNumber";
    private URL responderURL;
    private String responderIssuerName;
    private String responderSubjectName;
    private BigInteger responderSerialNumber;
    private CertPath certPath;
    private int remainingCerts;
    private Set<TrustAnchor> trustAnchors;
    private List<CertStore> certStores;
    PKIXParameters pkixParams;
    private static final Debug debug = Debug.getInstance((String)"certpath");
    private byte[] ocspRequestNonce;
    private byte[] ocspResponseNonce;
    static int debugint = 0;

    public OCSPChecker(String respURL, String respSubjectName, CertPath certPath, PKIXParameters params) throws CertPathValidatorException {
        block9: {
            this.pkixParams = null;
            this.ocspRequestNonce = null;
            this.ocspResponseNonce = null;
            try {
                this.responderURL = new URL(respURL);
            }
            catch (MalformedURLException muex) {
                this.responderURL = null;
                if (debug == null) break block9;
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  The following MalformedURLException was thrown while processing the OCSP responder URL:");
                System.out.println(muex.getMessage());
            }
        }
        try {
            this.responderSubjectName = respSubjectName != null ? new X500Name(respSubjectName).getRFC2253Name() : null;
        }
        catch (IOException ex) {
            this.responderSubjectName = null;
        }
        if (debug != null) {
            if (respURL == null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  respURL IS NULL");
            } else {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  respURL = " + respURL);
            }
            if (this.responderSubjectName == null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  responderSubjectName IS NULL");
            } else {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  responderSubjectName = " + this.responderSubjectName);
            }
        }
        this.certPath = certPath;
        this.pkixParams = params;
        this.trustAnchors = params.getTrustAnchors();
        this.certStores = params.getCertStores();
    }

    public OCSPChecker(String respURL, String respIssuerName, BigInteger respSerialNum, CertPath certPath, PKIXParameters params) throws CertPathValidatorException {
        block9: {
            this.pkixParams = null;
            this.ocspRequestNonce = null;
            this.ocspResponseNonce = null;
            try {
                this.responderURL = new URL(respURL);
            }
            catch (MalformedURLException muex) {
                this.responderURL = null;
                if (debug == null) break block9;
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  The following MalformedURLException was thrown while processing the OCSP responder URL:");
                System.out.println(muex.getMessage());
            }
        }
        try {
            this.responderIssuerName = new X500Name(respIssuerName).getRFC2253Name();
        }
        catch (IOException ex) {
            throw new CertPathValidatorException(ex);
        }
        this.responderSerialNumber = respSerialNum;
        if (debug != null) {
            if (respURL == null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  respURL IS NULL");
            } else {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  respURL = " + respURL);
            }
            if (this.responderIssuerName == null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  responderIssuerName IS NULL");
            } else {
                System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  responderIssuerName = " + this.responderIssuerName);
            }
            System.out.println("CERTPATH:  OCSPChecker.java:  CONSTRUCTOR:  responderSerialNumber = " + this.responderSerialNumber);
        }
        this.certPath = certPath;
        this.pkixParams = params;
        this.trustAnchors = params.getTrustAnchors();
        this.certStores = params.getCertStores();
    }

    @Override
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException("Forward checking not supported");
        }
        this.remainingCerts = this.certPath.getCertificates().size();
    }

    @Override
    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        return Collections.EMPTY_SET;
    }

    @Override
    public void check(Certificate cert, Collection<String> unresolvedCritExts) throws CertPathValidatorException {
        TrustAnchor responderTa = null;
        List<? extends Certificate> certList = this.certPath.getCertificates();
        X509Certificate[] cts = new X509Certificate[certList.size()];
        certList.toArray(cts);
        if (debug != null) {
            System.out.println("CERTPATH:  OCSPChecker.java:  check():  The array of certificates being checked is:");
            for (int ii = 0; ii < cts.length; ++ii) {
                System.out.println(cts[ii].toString() + "\n\n");
            }
        }
        X509Certificate ocspResponderCert = null;
        PKIXRevocationCheckerImpl pkixRevocationChecker = PKIXRevocationCheckerImpl.getPKIXRevocationCheckerFromPKIXParameters(this.pkixParams);
        if (pkixRevocationChecker != null && (ocspResponderCert = pkixRevocationChecker.getOcspResponderCert()) != null && debug != null) {
            System.out.println("CERTPATH: OCSPChecker.java:  check(): ");
            System.out.println("          The following OCSP responder certificate was specified within PKIXRevocationChecker: ");
            System.out.println(ocspResponderCert.toString());
        }
        if (ocspResponderCert != null) {
            if (debug != null) {
                System.out.println("==================================================================================");
                System.out.println("CERTPATH: OCSPChecker.java:  check(): ");
                System.out.println("          The OCSP responder certificate from within PKIXRevocationChecker will be used by OCSPChecker.check() ");
                System.out.println("==================================================================================");
            }
            if ((responderTa = new TrustAnchor(ocspResponderCert, null)) == null) {
                throw new CertPathValidatorException("Cannot create a TrustAnchor object from the OCSP responder certificate supplied in PKIXRevocationChecker.");
            }
        } else if (this.responderSubjectName != null) {
            if (debug != null) {
                System.out.println("==================================================================================");
                System.out.println("CERTPATH: OCSPChecker.java:  check(): ");
                System.out.println("          The OCSP responder certificate specified by the system property for \"OCSP responder subject dn\" will be used by OCSPChecker.check() ");
                System.out.println("==================================================================================");
            }
            if ((responderTa = this.getResponderTA(this.responderSubjectName, cts)) == null) {
                throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
            }
        } else if (this.responderIssuerName != null && this.responderSerialNumber != null) {
            if (debug != null) {
                System.out.println("==================================================================================");
                System.out.println("CERTPATH: OCSPChecker.java:  check(): ");
                System.out.println("          The OCSP responder certificate specified by the system properties for \"OCSP responder issuer dn and serial number\" will be used by OCSPChecker.check() ");
                System.out.println("==================================================================================");
            }
            if ((responderTa = this.getResponderTA(this.responderSerialNumber, this.responderIssuerName, cts)) == null) {
                throw new CertPathValidatorException("Cannot find the responder's certificate (set using the OCSP security properties).");
            }
        }
        if (debug != null) {
            if (responderTa == null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  check():  The responderTa IS NULL.");
            } else {
                System.out.println("CERTPATH:  OCSPChecker.java:  check():  The responderTa is:  \n" + responderTa.toString());
            }
        }
        this.internalCheck(cts, responderTa);
    }

    private TrustAnchor getResponderTA(String sn, X509Certificate[] certs) throws CertPathValidatorException {
        for (TrustAnchor temp : this.trustAnchors) {
            String ca = temp.getCAName();
            if (ca != null) {
                if (!ca.equals(sn)) continue;
                return temp;
            }
            X509Certificate ct = temp.getTrustedCert();
            if (!(ct instanceof X509CertImpl ? ((X500Name)((X509CertImpl)ct).getSubjectDN()).getRFC2253Name().equals(sn) : ct.getSubjectX500Principal().getName("RFC2253").equals(sn))) continue;
            return new TrustAnchor(ct, null);
        }
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                if (!(certs[i] instanceof X509CertImpl ? ((X500Name)((X509CertImpl)certs[i]).getSubjectDN()).getRFC2253Name().equals(sn) : certs[i].getSubjectX500Principal().getName("RFC2253").equals(sn))) continue;
                return new TrustAnchor(certs[i], null);
            }
        }
        Iterator<Object> it = this.certStores.iterator();
        X509CertSelector selector = new X509CertSelector();
        try {
            selector.setSubject(sn);
            if (debug != null) {
                System.out.println("CERTPATH, get responder cert using selector-" + selector);
            }
            while (it.hasNext()) {
                CertStore cs = (CertStore)it.next();
                Iterator<? extends Certificate> temp = cs.getCertificates(selector).iterator();
                if (!temp.hasNext()) continue;
                return new TrustAnchor((X509Certificate)temp.next(), null);
            }
        }
        catch (IOException ex) {
            throw new CertPathValidatorException(ex);
        }
        catch (CertStoreException ex) {
            throw new CertPathValidatorException(ex);
        }
        return null;
    }

    private TrustAnchor getResponderTA(BigInteger serialNum, String issuerName, X509Certificate[] certs) throws CertPathValidatorException {
        for (TrustAnchor temp : this.trustAnchors) {
            X509Certificate ct = temp.getTrustedCert();
            if (!(ct instanceof X509CertImpl ? ((X500Name)((X509CertImpl)ct).getIssuerDN()).getRFC2253Name().equals(issuerName) && ct.getSerialNumber().equals(serialNum) : ct.getIssuerX500Principal().getName("RFC2253").equals(issuerName) && ct.getSerialNumber().equals(serialNum))) continue;
            return new TrustAnchor(ct, null);
        }
        if (certs != null) {
            for (int i = 0; i < certs.length; ++i) {
                if (!(certs[i] instanceof X509CertImpl ? ((X500Name)((X509CertImpl)certs[i]).getIssuerDN()).getRFC2253Name().equals(issuerName) && certs[i].getSerialNumber().equals(serialNum) : certs[i].getIssuerX500Principal().getName("RFC2253").equals(issuerName) && certs[i].getSerialNumber().equals(serialNum))) continue;
                return new TrustAnchor(certs[i], null);
            }
        }
        Iterator<Object> it = this.certStores.iterator();
        X509CertSelector selector = new X509CertSelector();
        selector.setSerialNumber(serialNum);
        try {
            selector.setIssuer(issuerName);
            if (debug != null) {
                System.out.println("CERTPATH: get responder cert using selector -" + selector.toString());
            }
            while (it.hasNext()) {
                CertStore cs = (CertStore)it.next();
                Iterator<? extends Certificate> temp = cs.getCertificates(selector).iterator();
                if (!temp.hasNext()) continue;
                return new TrustAnchor((X509Certificate)temp.next(), null);
            }
        }
        catch (IOException ex) {
            throw new CertPathValidatorException(ex);
        }
        catch (CertStoreException ex) {
            throw new CertPathValidatorException(ex);
        }
        return null;
    }

    private void internalCheck(X509Certificate[] certs, TrustAnchor responderTa) throws CertPathValidatorException {
        CertStatus[] st;
        int checkDepth;
        boolean onlyCheckEECert;
        block73: {
            PKIXRevocationCheckerImpl pkixRevocationChecker;
            SingleRequest[] reqs;
            CertID[] ids;
            block74: {
                boolean needRequest;
                block70: {
                    Map<X509Certificate, byte[]> ocspResponseMap;
                    block72: {
                        block71: {
                            block69: {
                                onlyCheckEECert = PKIXRevocationCheckerImpl.getOnlyCheckEECert(this.pkixParams);
                                checkDepth = onlyCheckEECert ? 1 : certs.length;
                                st = new CertStatus[checkDepth];
                                ids = new CertID[checkDepth];
                                for (int i = checkDepth - 1; i >= 0; --i) {
                                    if (i == certs.length - 1) {
                                        TrustAnchor ta = this.getTrustAnchor(certs[i], this.trustAnchors);
                                        if (ta == null) {
                                            throw new CertPathValidatorException("Unable to find the issuer cert");
                                        }
                                        X509Certificate trustedCert = ta.getTrustedCert();
                                        ids[i] = trustedCert != null ? new CertID(trustedCert, certs[i]) : new CertID(ta.getCAName(), ta.getCAPublicKey(), certs[i].getSerialNumber(), null);
                                    } else {
                                        ids[i] = new CertID(certs[i + 1], certs[i]);
                                    }
                                    if (debug == null) continue;
                                    System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  CertID[" + i + "] is:  " + ids[i].toString());
                                }
                                reqs = new SingleRequest[checkDepth];
                                for (int i = 0; i < checkDepth; ++i) {
                                    reqs[i] = new SingleRequest(ids[i], null);
                                    if (debug == null) continue;
                                    System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  SingleRequest[" + i + "] is:  " + reqs[i].toString() + "\n\n");
                                }
                                needRequest = true;
                                pkixRevocationChecker = PKIXRevocationCheckerImpl.getPKIXRevocationCheckerFromPKIXParameters(this.pkixParams);
                                if (pkixRevocationChecker != null) break block69;
                                if (debug == null) break block70;
                                System.out.println("OCSPChecker.java:  internalCheck():  No RevocationChecker object passed in by caller. ");
                                break block70;
                            }
                            ocspResponseMap = pkixRevocationChecker.getOcspResponses();
                            if (ocspResponseMap != null) break block71;
                            if (debug == null) break block70;
                            System.out.println("OCSPChecker.java:  internalCheck():  No stapled OCSPReponse map was passed in by caller. ");
                            break block70;
                        }
                        if (ocspResponseMap.size() != 0) break block72;
                        if (debug == null) break block70;
                        System.out.println("OCSPChecker.java:  internalCheck():  A stapled OCSPReponse map of size 0 was passed in by caller. ");
                        break block70;
                    }
                    for (int i = 0; i < checkDepth; ++i) {
                        CertStatus certStatusLiftedFromPKiXRevocationChecker = this.getCertStatus(certs[i], ocspResponseMap.get(certs[i]), ids, responderTa);
                        if (certStatusLiftedFromPKiXRevocationChecker != null) {
                            if (debug != null) {
                                System.out.println("CERTPATH: OCSPChecker.java:  internalCheck():  A stapled OCSPResponse was found for the ");
                                System.out.println("                             following certificate within PKIXRevocationChecker:");
                                System.out.println(certs[i].toString());
                            }
                            st[i] = certStatusLiftedFromPKiXRevocationChecker;
                            if (certStatusLiftedFromPKiXRevocationChecker.getStatus() != 1) continue;
                            needRequest = false;
                            continue;
                        }
                        if (debug != null) {
                            System.out.println("CERTPATH: OCSPChecker.java:  internalCheck():  A stapled OCSPResponse was NOT FOUND for the ");
                            System.out.println("                             following certificate within PKIXRevocationChecker:");
                            System.out.println(certs[i].toString());
                        }
                        needRequest = true;
                        break;
                    }
                }
                if (!needRequest) break block73;
                if (debug != null) {
                    System.out.println("CERTPATH: OCSPChecker.java:  internalCheck():  Still need to send OCSP request");
                }
                if (this.responderURL == null) break block74;
                HttpURLConnection con = null;
                OCSPRequest request = null;
                if (pkixRevocationChecker == null) {
                    if (debug != null) {
                        System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  The pkixRevocationChecker is NULL");
                    }
                    request = new OCSPRequest(reqs);
                } else {
                    List<Extension> extensions;
                    if (debug != null) {
                        System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  The pkixRevocationChecker is NOT NULL");
                    }
                    if ((extensions = pkixRevocationChecker.getOcspExtensions()) != null && extensions.size() != 0) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  OCSP extensions were supplied in the RevocationChecker object.");
                        }
                        request = new OCSPRequest(reqs, this.convertExtensionListToArray(extensions));
                        this.ocspRequestNonce = request.getNonce();
                        if (debug != null) {
                            if (this.ocspRequestNonce != null) {
                                System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  A NONCE extension was among the OCSP extensions supplied in the RevocationChecker object.");
                                System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  NONCE extension value being added to the OCSPRequest = ");
                                System.out.println(OCSPChecker.toHexString(this.ocspRequestNonce));
                            } else {
                                System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  No NONCE extension was among the OCSP extensions supplied in the RevocationChecker object.");
                            }
                        }
                    } else {
                        if (debug != null) {
                            System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  No OCSP extensions were supplied in the RevocationChecker object.");
                        }
                        request = new OCSPRequest(reqs);
                    }
                }
                boolean wasExceptionThrown = false;
                try {
                    con = (HttpURLConnection)this.responderURL.openConnection();
                    this.sendRequest(con, request.encode());
                }
                catch (IOException ex) {
                    wasExceptionThrown = true;
                    if (!PKIXRevocationCheckerImpl.getSoftFail(this.pkixParams)) {
                        if (debug != null) {
                            System.out.println("CERTPATH: OCSPChecker.java:  internalCheck():  Network failure while accessing OCSP responder defined by system properties.");
                            System.out.println("                                               SOFT_FAIL is false, so throw the exception.");
                        }
                        throw new CertPathValidatorException(ex);
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH: OCSPChecker.java:  internalCheck():  Network failure while accessing OCSP responder defined by system properties.");
                        System.out.println("                                               SOFT_FAIL is true, so do not throw the exception.");
                    }
                    return;
                }
                if (!wasExceptionThrown) {
                    st = this.checkResponse(con, ids, responderTa);
                }
                break block73;
            }
            for (int i = 0; i < checkDepth; ++i) {
                if (st[i] != null) continue;
                try {
                    X509CertImpl impl;
                    if (!(certs[i] instanceof X509CertImpl)) {
                        try {
                            impl = new X509CertImpl(certs[i].getEncoded());
                        }
                        catch (CertificateException ex) {
                            throw new CertPathValidatorException(ex);
                        }
                    } else {
                        impl = (X509CertImpl)certs[i];
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  Beginning OCSP processing for the following SINGLE cert:");
                        System.out.println(impl.toString());
                    }
                    Set c = null;
                    c = impl.getAuthorityInformationAccess();
                    URL url = null;
                    for (AccessDescription ad : c) {
                        GeneralName gn;
                        if (!ad.getAccessMethod().equals(AccessDescription.Ad_OCSP_Id) || (gn = ad.getAccessLocation()).getType() != 6) continue;
                        try {
                            URIName uri = (URIName)gn.getName();
                            url = new URL(uri.getName());
                        }
                        catch (MalformedURLException ex) {
                            if (debug == null) continue;
                            ex.printStackTrace();
                        }
                    }
                    if (url == null) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  No OCSP responder URL was found in the cert.");
                        }
                        throw new IOException("Can't learn the responder URL from the AIA extension of the cert");
                    }
                    if (debug != null) {
                        System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  An OCSP responder URL 'WAS FOUND' in the cert.");
                        System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  The OCSP responder URL learned from the AIA extension is:  " + url.toString());
                    }
                    HttpURLConnection con = null;
                    con = (HttpURLConnection)url.openConnection();
                    OCSPRequest request = null;
                    if (pkixRevocationChecker == null) {
                        if (debug != null) {
                            System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  The pkixRevocationChecker object is NULL");
                        }
                        request = new OCSPRequest(new SingleRequest[]{reqs[i]});
                    } else {
                        List<Extension> extensions;
                        if (debug != null) {
                            System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  The pkixRevocationChecker object is not NULL");
                        }
                        if ((extensions = pkixRevocationChecker.getOcspExtensions()) != null) {
                            if (debug != null) {
                                System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  OCSP extensions were supplied in the RevocationChecker object.");
                            }
                            request = new OCSPRequest(new SingleRequest[]{reqs[i]}, this.convertExtensionListToArray(extensions));
                            this.ocspRequestNonce = request.getNonce();
                            if (debug != null) {
                                if (this.ocspRequestNonce != null) {
                                    System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  A NONCE extension was among the OCSP extensions supplied in the RevocationChecker object.");
                                    System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  NONCE extension value added to OCSPRequest = ");
                                    System.out.println(OCSPChecker.toHexString(this.ocspRequestNonce));
                                } else {
                                    System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  No NONCE extension was among the OCSP extensions supplied in the RevocationChecker object.");
                                }
                            }
                        } else {
                            if (debug != null) {
                                System.out.println("CERTPATH:  OCSPChecker.java:  internalCheck():  No OCSP extensions were supplied in the RevocationChecker object.");
                            }
                            request = new OCSPRequest(new SingleRequest[]{reqs[i]});
                        }
                    }
                    this.sendRequest(con, request.encode());
                    CertStatus[] temp = new CertStatus[1];
                    st[i] = this.checkResponse(con, new CertID[]{ids[i]}, responderTa)[0];
                    continue;
                }
                catch (CertificateException ex) {
                    if (debug != null) {
                        System.out.println("CERTPATH: internal error 1 , " + ex.getMessage());
                    }
                    st[i] = null;
                    continue;
                }
                catch (IOException ex) {
                    if (debug != null) {
                        System.out.println("CERTPATH: internal error 2, " + ex.getMessage());
                    }
                    if (PKIXRevocationCheckerImpl.getSoftFail(this.pkixParams)) {
                        if (debug != null) {
                            System.out.println("CERTPATH: OCSPChecker.java:  internalCheck():  Network failure while accessing OCSP responder defined by AIA extension.");
                            System.out.println("                                               SOFT_FAIL is true, so build artificial successful CertStatus.");
                        }
                        st[i] = new CertStatus(0, null, null);
                        continue;
                    }
                    st[i] = null;
                    continue;
                }
                catch (CertPathValidatorException ex) {
                    if (debug != null) {
                        System.out.println("CERTPATH: internal error 3, " + ex.getMessage());
                    }
                    st[i] = null;
                }
            }
        }
        block20: for (int i = 0; i < checkDepth; ++i) {
            if (st[i] == null) {
                if (debug != null) {
                    System.out.println("CERTPATH: error getting cert status for certificate, serial number is " + certs[i].getSerialNumber() + ", subject is " + certs[i].getSubjectDN().getName());
                    System.out.println("CERTPATH: OCSPChecker.java:  internalCheck():  Throwing revocation exception for the cert below.");
                    System.out.println("                                               System property or option onlyCheckEECerts==" + onlyCheckEECert);
                    System.out.println(certs[i].toString());
                }
                CertPathValidatorException exceptionToBeThrown = new CertPathValidatorException("certificate status undetermined", new OCSPCertPathStatusUnknownException(st, certs, this.certPath), this.certPath, i, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
                PKIXRevocationCheckerImpl.isSoftFailException(exceptionToBeThrown, this.pkixParams);
                throw exceptionToBeThrown;
            }
            switch (st[i].getStatus()) {
                case 2: {
                    if (debug != null) {
                        System.out.println("CERTPATH: cert status is " + st[i].toString() + " for certificate serial number " + certs[i].getSerialNumber() + ", subject is " + certs[i].getSubjectDN().getName());
                        System.out.println("CERTPATH: OCSPChecker.java:  internalCheck():  Throwing revocation exception for the cert below.");
                        System.out.println("                                               System property onlyCheckEECerts==" + onlyCheckEECert);
                        System.out.println(certs[i].toString());
                    }
                    CertPathValidatorException exceptionToBeThrown = new CertPathValidatorException("certificate status unknown", new OCSPCertPathStatusUnknownException(st, certs, this.certPath), this.certPath, i, CertPathValidatorException.BasicReason.UNDETERMINED_REVOCATION_STATUS);
                    PKIXRevocationCheckerImpl.isSoftFailException(exceptionToBeThrown, this.pkixParams);
                    throw exceptionToBeThrown;
                }
                case 1: {
                    if (debug != null) {
                        System.out.println("CERTPATH: cert status is  " + st[i].toString() + " for certificate " + certs[i].getSerialNumber() + ", subject is " + certs[i].getSubjectDN().getName());
                        System.out.println("CERTPATH: OCSPChecker.java:  internalCheck():  Throwing revocation exception for the cert below.");
                        System.out.println("                                               System property onlyCheckEECerts==" + onlyCheckEECert);
                        System.out.println(certs[i].toString());
                    }
                    throw new CertPathValidatorException("certificate is revoked", (Throwable)new OCSPCertRevokedException(this.certPath, i), this.certPath, i);
                }
                case 0: {
                    if (debug == null) continue block20;
                    System.out.println("CERTPATH: cert status is " + st[i].toString() + " for certificate " + certs[i].getSerialNumber() + ", subject is " + certs[i].getSubjectDN().getName());
                }
            }
        }
    }

    private CertStatus[] checkResponse(HttpURLConnection con, CertID[] ids, TrustAnchor responderTa) throws CertPathValidatorException {
        byte[] response;
        block37: {
            block36: {
                if (debug != null) {
                    try {
                        if (con.getResponseCode() != 200) {
                            throw new CertPathValidatorException("Received HTTP error: " + con.getResponseCode() + " - " + con.getResponseMessage());
                        }
                    }
                    catch (IOException ex) {
                        if (debug == null) break block36;
                        ex.printStackTrace();
                    }
                }
            }
            InputStream in = null;
            try {
                in = con.getInputStream();
            }
            catch (IOException ex) {
                throw new CertPathValidatorException(ex);
            }
            int length = con.getContentLength();
            response = null;
            try {
                response = IOUtils.readFully((InputStream)in, (int)length, (boolean)false);
                in.close();
            }
            catch (IOException ex) {
                if (debug == null) break block37;
                ex.printStackTrace();
            }
        }
        OCSPResponse ocspResponse = null;
        try {
            ocspResponse = new OCSPResponse(response);
        }
        catch (IOException ex) {
            if (debug != null) {
                System.out.println("OCSPChecker.java:  checkResponse():  The following exception was thrown while");
                System.out.println("                                     creating an OCSPResponse object from    ");
                System.out.println("                                     the byte array:                         ");
                System.out.println(ex.toString());
                ex.printStackTrace();
            }
            throw new CertPathValidatorException(ex);
        }
        if (ocspResponse.getResponseStatus().getStatus() != 0) {
            throw (CertPathValidatorException)new CertPathValidatorException("Unsuccessful OCSP response").initCause(new OCSPException(OCSPException.setResponseErrorMsg(ocspResponse.getResponseStatus().getStatus())));
        }
        this.ocspResponseNonce = ocspResponse.getNonce();
        if (this.ocspRequestNonce != null) {
            if (debug != null) {
                System.out.println("CERTPATH: OCSPChecker.java:  checkResponse():  A nonce extension was included on the OCSPRequest");
                System.out.println("                                               Compare it to the one echoed   on the OCSPResponse");
            }
            if (this.ocspResponseNonce != null) {
                if (this.ocspRequestNonce.length != this.ocspResponseNonce.length) {
                    throw new CertPathValidatorException("Nonce value sent on the OCSPRequest is a different length than the Nonce value received on the OCSPResponse");
                }
                for (int i = 0; i < this.ocspRequestNonce.length; ++i) {
                    if (this.ocspRequestNonce[i] == this.ocspResponseNonce[i]) continue;
                    throw new CertPathValidatorException("Nonce value sent on the OCSPRequest does not match the Nonce value received on the OCSPResponse");
                }
            } else {
                throw new CertPathValidatorException("Nonce was not echoed on OCSPResponse");
            }
            if (debug != null) {
                System.out.println("CERTPATH: OCSPChecker.java:  checkResponse():  The nonce extension received on the OCSPResponse matches the one sent on the OCSPRequest.");
            }
        }
        BasicOCSPResponse bresp = null;
        byte[] responseData = ocspResponse.getResponseData();
        if (responseData != null) {
            try {
                if (debug != null) {
                    System.out.println("Get response type: " + ocspResponse.getResponseType());
                }
                if (this.pkixParams instanceof PKIXExtendedParameters) {
                    bresp = new BasicOCSPResponse(ocspResponse.getResponseData(), this.pkixParams.getDate(), ((PKIXExtendedParameters)this.pkixParams).getVariant());
                }
                bresp = new BasicOCSPResponse(ocspResponse.getResponseData(), this.pkixParams.getDate());
            }
            catch (IOException ex) {
                if (debug != null) {
                    ex.printStackTrace();
                }
                throw new CertPathValidatorException(ex);
            }
        } else {
            throw new CertPathValidatorException("No data was found in the OCSPResponse");
        }
        HashSet<TrustAnchor> tas = new HashSet<TrustAnchor>();
        if (responderTa == null) {
            for (int i = 0; i < ids.length; ++i) {
                TrustAnchor ta = new TrustAnchor(ids[i].getIssuerName(), ids[i].getIssuerPublicKey(), null);
                if (tas.contains(ta)) continue;
                tas.add(ta);
            }
        } else {
            tas.add(responderTa);
        }
        try {
            bresp.verify(tas);
        }
        catch (OCSPException ex) {
            if (debug != null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  checkOCSPResponse():  The following exception was thrown while trying to verify the BasicOCSPResponse:");
                System.out.println(ex.toString());
                ex.printStackTrace();
            }
            throw new CertPathValidatorException(ex);
        }
        CertStatus[] st = new CertStatus[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            SingleResponse singleResp = bresp.getSingleResponse(ids[i]);
            if (singleResp == null) {
                st[i] = null;
                continue;
            }
            Date thisUpdate = singleResp.getThisUpdate();
            Date today = new Date();
            Date nextUpdate = singleResp.getNextUpdate();
            if (nextUpdate != null && nextUpdate.before(today)) {
                st[i] = null;
            }
            if (thisUpdate.after(today)) {
                st[i] = null;
            }
            st[i] = singleResp.getCertStatus();
        }
        return st;
    }

    private void sendRequest(HttpURLConnection con, byte[] request) throws IOException {
        con.setConnectTimeout(CertPathSystemProperties.getOCSPConnectTimeout());
        con.setReadTimeout(CertPathSystemProperties.getOCSPConnectTimeout());
        con.setDoOutput(true);
        con.setDoInput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-type", "application/ocsp-request");
        con.setRequestProperty("Content-length", String.valueOf(request));
        OutputStream out = con.getOutputStream();
        out.write(request);
        out.flush();
        out.close();
    }

    private TrustAnchor getTrustedCert(X509Certificate cert, List certStores) {
        Iterator it = certStores.iterator();
        X500Principal issuer = cert.getIssuerX500Principal();
        while (it.hasNext()) {
            X509Certificate temp;
            block7: {
                Iterator<? extends Certificate> it2;
                CertStore store = (CertStore)it.next();
                X509CertSelector selector = new X509CertSelector();
                try {
                    selector.setSubject(issuer.getName("RFC2253"));
                }
                catch (IOException ex) {
                    if (debug == null) continue;
                    System.out.println(ex.getMessage());
                    continue;
                }
                Collection<? extends Certificate> certs = null;
                try {
                    certs = store.getCertificates(selector);
                }
                catch (CertStoreException ex) {
                    if (debug == null) continue;
                    System.out.println(ex.getMessage());
                    continue;
                }
                if (certs.size() <= 0 || !(it2 = certs.iterator()).hasNext()) continue;
                temp = (X509Certificate)it2.next();
                try {
                    cert.verify(temp.getPublicKey());
                }
                catch (Exception ex) {
                    if (debug == null) break block7;
                    System.out.println("CERTPATH: can not verify the signature" + ex.getMessage());
                }
            }
            return new TrustAnchor(temp, null);
        }
        return null;
    }

    private TrustAnchor getTrustAnchor(X509Certificate cert, Set trustAnchors) {
        Iterator it = trustAnchors.iterator();
        X500Principal issuer = cert.getIssuerX500Principal();
        while (it.hasNext()) {
            TrustAnchor ta = (TrustAnchor)it.next();
            X509Certificate trustedCert = ta.getTrustedCert();
            if (trustedCert != null) {
                X500Principal subject = trustedCert.getSubjectX500Principal();
                if (!subject.equals(issuer)) continue;
                return ta;
            }
            String caName = ta.getCAName();
            PublicKey key = ta.getCAPublicKey();
            if (!caName.equals(issuer.getName("RFC2253"))) continue;
            try {
                cert.verify(key);
            }
            catch (Exception ex) {
                if (debug == null) continue;
                System.out.println("CERTPATH: try to find the trust anchor of the cert chain " + ex.getMessage());
                continue;
            }
            return ta;
        }
        if (debug != null) {
            System.out.println("CERTPATH: failed to find the trust anchor");
        }
        return null;
    }

    CertStatus getCertStatus(X509Certificate x509Certificate, byte[] ocspResponseBytes, CertID[] ids, TrustAnchor responderTa) throws CertPathValidatorException {
        if (x509Certificate == null || ocspResponseBytes == null) {
            throw new CertPathValidatorException("Bad entry found witin the stapled OCSPResponses supplied by the user within the PKIXRevocationChecker object.");
        }
        BigInteger serialNumberFromCertificate = x509Certificate.getSerialNumber();
        if (serialNumberFromCertificate == null) {
            if (debug != null) {
                System.out.println("OCSPChecker.java:  getCertStatus():  Unable to read the serial number from the following \"stapled\" X509Certificate.");
                System.out.println("                                     Throwing CertPathValidatorException.             ");
                System.out.println(x509Certificate.toString());
            }
            throw new CertPathValidatorException("Unable to read the serial number from a \"stapled\" X509Certificate.");
        }
        OCSPResponse ocspResponse = null;
        try {
            ocspResponse = new OCSPResponse(ocspResponseBytes);
        }
        catch (IOException ex) {
            if (debug != null) {
                System.out.println("OCSPChecker.java:  getCertStatus():  Unable to convert the stapled OCSPResponse bytes, passed by the user within");
                System.out.println("                                     PKIXRevocationChecker, to an OCSPResponse object.");
                System.out.println("                                     Throwing CertPathValidatorException.             ");
            }
            throw new CertPathValidatorException("Unable to convert the stapled OCSPResponse bytes, passed by the user within PKIXRevocationChecker, to an OCSPResponse object.", ex);
        }
        BasicOCSPResponse bresp = null;
        byte[] responseData = ocspResponse.getResponseData();
        if (responseData != null) {
            try {
                if (debug != null) {
                    System.out.println("Get response type: " + ocspResponse.getResponseType());
                }
                if (this.pkixParams instanceof PKIXExtendedParameters) {
                    bresp = new BasicOCSPResponse(responseData, this.pkixParams.getDate(), ((PKIXExtendedParameters)this.pkixParams).getVariant());
                }
                bresp = new BasicOCSPResponse(responseData, this.pkixParams.getDate());
            }
            catch (IOException ex) {
                if (debug != null) {
                    ex.printStackTrace();
                }
                throw new CertPathValidatorException(ex);
            }
        } else {
            throw new CertPathValidatorException("No data was found within the stapled OCSPResponse passed in for the certificate with the following subject dn:  " + x509Certificate.getSubjectX500Principal().toString());
        }
        HashSet<TrustAnchor> tas = new HashSet<TrustAnchor>();
        for (int i = 0; i < ids.length; ++i) {
            TrustAnchor ta = new TrustAnchor(ids[i].getIssuerName(), ids[i].getIssuerPublicKey(), null);
            if (tas.contains(ta)) continue;
            tas.add(ta);
        }
        if (responderTa != null && !tas.contains(responderTa)) {
            tas.add(responderTa);
        }
        try {
            bresp.verify(tas);
        }
        catch (OCSPException ex) {
            if (debug != null) {
                System.out.println("CERTPATH:  OCSPChecker.java:  getCertStatus():  The following exception was thrown while trying to verify the BasicOCSPResponse portion of the stapled OCSPResponse passed in for the certificate with the following subject dn:  " + x509Certificate.getSubjectX500Principal().toString());
                System.out.println(ex.toString());
                ex.printStackTrace();
            }
            throw new CertPathValidatorException(ex);
        }
        if (ocspResponse.getResponseStatus().getStatus() != 0) {
            throw (CertPathValidatorException)new CertPathValidatorException("OCSP response carrying unsuccessful status was passed as a stapled OCSPResponse by the user within PKIXRevocationChecker").initCause(new OCSPException(OCSPException.setResponseErrorMsg(ocspResponse.getResponseStatus().getStatus())));
        }
        Map<CertID, SingleResponse> mapCertIDToSingleResponse = null;
        try {
            mapCertIDToSingleResponse = ocspResponse.getCertIDToSingleResponseMap(ocspResponseBytes, this.pkixParams.getDate());
        }
        catch (IOException ex) {
            throw new CertPathValidatorException("An exception was thrown while getting the \"CertID\" to \"SingleResponse\" map from the stapled OCSPResponse bytes.");
        }
        Set<Map.Entry<CertID, SingleResponse>> ocspCertIDToSingleResponseSet = mapCertIDToSingleResponse.entrySet();
        for (Map.Entry<CertID, SingleResponse> entry : ocspCertIDToSingleResponseSet) {
            CertID certID = entry.getKey();
            SingleResponse singleResponse = entry.getValue();
            BigInteger serialNumberFromCertID = certID.getTargetCertSerialNumber();
            if (!serialNumberFromCertID.equals(serialNumberFromCertificate)) continue;
            return singleResponse.getCertStatus();
        }
        return null;
    }

    private com.ibm.security.x509.Extension[] convertExtensionListToArray(List<Extension> inputExtensionList) {
        com.ibm.security.x509.Extension[] outputExtensionArray = new com.ibm.security.x509.Extension[inputExtensionList.size()];
        int i = 0;
        Object oid = null;
        boolean isCritical = false;
        Object extensionValue = null;
        for (Extension inputExtension : inputExtensionList) {
            outputExtensionArray[i] = (com.ibm.security.x509.Extension)inputExtension;
            if (debug != null) {
                System.out.println("==========================================================================");
                System.out.println("OCSPChecker.java:  ConvertExtensionListToArray():  DUMPING THE CONTENTS OF THE NONCE EXTENSION PASSED IN:");
                System.out.println("OCSPChecker.java:  ConvertExtensionListToArray():  THE OID IS:  " + outputExtensionArray[i].getExtensionId().toString());
                System.out.println("OCSPChecker.java:  ConvertExtensionListToArray():  THE ISCRITICAL IS:  " + outputExtensionArray[i].isCritical());
                System.out.println("OCSPChecker.java:  ConvertExtensionListToArray():  THE EXTENSION VALUE IS:  " + OCSPChecker.toHexString(outputExtensionArray[i].getExtensionValue()));
                System.out.println("==========================================================================");
            }
            ++i;
        }
        return outputExtensionArray;
    }

    public static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int len = block.length;
        int high = 0;
        int low = 0;
        for (int i = 0; i < len; ++i) {
            if (i % 16 == 0) {
                buf.append('\n');
            }
            high = (block[i] & 0xF0) >> 4;
            low = block[i] & 0xF;
            buf.append(hexChars[high]);
            buf.append(hexChars[low]);
            buf.append(' ');
        }
        return buf.toString();
    }
}

