/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cert;

import com.ibm.misc.Debug;
import com.ibm.security.cert.CertPathSystemProperties;
import com.ibm.security.cert.UntrustedChecker;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.BasicConstraintsExtension;
import com.ibm.security.x509.CRLDistributionPointsExtension;
import com.ibm.security.x509.CertificatePoliciesExtension;
import com.ibm.security.x509.DistributionPoint;
import com.ibm.security.x509.ExtKeyUsageExtension;
import com.ibm.security.x509.Extension;
import com.ibm.security.x509.GeneralName;
import com.ibm.security.x509.GeneralNames;
import com.ibm.security.x509.GeneralNamesException;
import com.ibm.security.x509.InhibitAnyPolicyExtension;
import com.ibm.security.x509.KeyUsageExtension;
import com.ibm.security.x509.OIDMap;
import com.ibm.security.x509.PolicyConstraintsExtension;
import com.ibm.security.x509.X500Name;
import com.ibm.security.x509.X509CRLImpl;
import com.ibm.security.x509.X509CertImpl;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.auth.x500.X500Principal;

class CertPathUtil {
    static final int SUCCESS = 0;
    static final int NO_TRUST_BASE = 1;
    static final int NAME_CHAINING_ERROR = 4;
    static final int FAIL = Integer.MAX_VALUE;
    static final String LDAP_URI_START = "ldap://";
    static final String HTTP_URI_START = "http://";
    static final String FTP_URI_START = "ftp://";
    static final String URI_NAME = "URIName: ";
    private static Debug debug = Debug.getInstance((String)"certpath");

    CertPathUtil() {
    }

    static Object[] getExtension(String ident, X509CRL crl) throws CertPathValidatorException {
        boolean crit = false;
        String oid = OIDMap.getOID((String)ident).toString();
        byte[] extBytes = crl.getExtensionValue(oid);
        if (extBytes != null) {
            crit = crl.getCriticalExtensionOIDs().contains(oid);
            try {
                extBytes = new DerValue(extBytes).getOctetString();
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        Object[] retVal = new Object[]{new Boolean(crit), extBytes};
        return retVal;
    }

    static Object[] getExtension(String ident, X509Certificate cert) throws CertPathValidatorException {
        boolean crit = false;
        String oid = null;
        ObjectIdentifier oi = OIDMap.getOID((String)ident);
        if (oi == null) {
            throw new CertPathValidatorException("An internal error has occurred. The extension definition could not be found:" + ident + ".");
        }
        oid = OIDMap.getOID((String)ident).toString();
        byte[] extBA = cert.getExtensionValue(oid);
        if (extBA != null) {
            Set<String> critOIDS = cert.getCriticalExtensionOIDs();
            crit = critOIDS.contains(oid);
            try {
                DerValue derValue = new DerValue(extBA);
                extBA = derValue.getOctetString();
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        Object[] result = new Object[]{new Boolean(crit), extBA};
        return result;
    }

    static void removeExtensions(Collection removeFrom, String[] removeThis) {
        for (int i = 0; i < removeThis.length; ++i) {
            removeFrom.remove(removeThis[i]);
        }
    }

    static Object[] getBasicConstraints(X509Certificate cert) throws CertPathValidatorException {
        Object[] result = new Object[3];
        BasicConstraintsExtension ext = null;
        Object[] extObj = CertPathUtil.getExtension("x509.info.extensions.BasicConstraints", cert);
        if (extObj[1] != null) {
            try {
                ext = new BasicConstraintsExtension((Boolean)extObj[0], extObj[1]);
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        result[0] = ext;
        if (ext == null) {
            result[1] = Boolean.FALSE;
            result[2] = new Integer(Integer.MAX_VALUE);
        } else {
            try {
                result[1] = ext.get("is_ca");
                result[2] = ext.get("path_len");
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        return result;
    }

    static int verifyIssuer(X509Certificate cert, PublicKey issuerKey, X500Principal issuerName, String sigProvider) throws CertPathValidatorException {
        int result = Integer.MAX_VALUE;
        if (issuerKey == null || issuerName == null) {
            throw new CertPathValidatorException("No trust base");
        }
        if (cert.getIssuerX500Principal().equals(issuerName)) {
            try {
                CertPathUtil.verifySignature(cert, issuerKey, sigProvider);
                result = 0;
            }
            catch (CertificateNotYetValidException e) {
                throw new CertPathValidatorException(e.getMessage());
            }
        } else {
            throw new CertPathValidatorException("Certificate chaining error");
        }
        return result;
    }

    static TrustAnchor findIssuer(X509Certificate cert, Collection trustBaseSet, String sigProvider) throws CertPathValidatorException {
        TrustAnchor ta = null;
        Iterator it = trustBaseSet.iterator();
        TrustAnchor temp = null;
        X509Certificate trustedCert = null;
        int result = Integer.MAX_VALUE;
        String msg = null;
        if (!(cert instanceof X509CertImpl)) {
            try {
                cert = new X509CertImpl(cert.getEncoded());
            }
            catch (CertificateException ex) {
                throw new CertPathValidatorException(ex.getMessage());
            }
        }
        UntrustedChecker untrustedChecker = new UntrustedChecker();
        while (it.hasNext()) {
            block15: {
                temp = (TrustAnchor)it.next();
                X509Certificate anchorCert = temp.getTrustedCert();
                try {
                    if (anchorCert == null) break block15;
                    untrustedChecker.check(anchorCert, Collections.emptySet());
                }
                catch (Exception e) {
                    msg = e.getMessage();
                    continue;
                }
            }
            trustedCert = temp.getTrustedCert();
            if (trustedCert != null) {
                if (!(trustedCert instanceof X509CertImpl)) {
                    try {
                        trustedCert = new X509CertImpl(trustedCert.getEncoded());
                    }
                    catch (CertificateException ex) {
                        throw new CertPathValidatorException(ex.getMessage());
                    }
                }
                try {
                    result = CertPathUtil.verifyIssuer(cert, trustedCert.getPublicKey(), trustedCert.getSubjectX500Principal(), sigProvider);
                }
                catch (CertPathValidatorException e) {
                    msg = e.getMessage();
                }
                if (result != 0) continue;
                ta = temp;
                break;
            }
            try {
                X500Principal issuerName = temp.getCA();
                result = CertPathUtil.verifyIssuer(cert, temp.getCAPublicKey(), issuerName, sigProvider);
            }
            catch (CertPathValidatorException cvEx) {
                msg = cvEx.getMessage();
            }
            if (result != 0) continue;
            ta = temp;
            break;
        }
        if (ta != null) {
            return ta;
        }
        throw new CertPathValidatorException(msg);
    }

    static boolean findIssuerForCRSCheck(X509Certificate cert, Collection trustBaseSet, String sigProvider) {
        Iterator it = trustBaseSet.iterator();
        X509Certificate trustedCert = null;
        int result = Integer.MAX_VALUE;
        while (it.hasNext()) {
            trustedCert = (X509Certificate)it.next();
            if (trustedCert == null) continue;
            try {
                result = CertPathUtil.verifyIssuer(cert, trustedCert.getPublicKey(), trustedCert.getSubjectX500Principal(), sigProvider);
            }
            catch (CertPathValidatorException e) {
                continue;
            }
            if (result != 0) continue;
            return true;
        }
        return false;
    }

    static void verifySignature(X509Certificate cert, PublicKey issuerKey, String sigProvider) throws CertificateNotYetValidException {
        try {
            if (sigProvider == null) {
                cert.verify(issuerKey);
            } else {
                cert.verify(issuerKey, sigProvider);
            }
        }
        catch (SignatureException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
        catch (CertificateException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
    }

    static boolean[] getKeyUsage(X509Certificate cert) throws CertPathValidatorException {
        KeyUsageExtension ext = null;
        boolean[] keyUsageToReturn = null;
        Object[] extObj = CertPathUtil.getExtension("x509.info.extensions.KeyUsage", cert);
        if (extObj[1] != null) {
            try {
                ext = new KeyUsageExtension((Boolean)extObj[0], extObj[1]);
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        if (ext != null) {
            try {
                keyUsageToReturn = new boolean[9];
                keyUsageToReturn[0] = ext.get("digital_signature");
                keyUsageToReturn[1] = ext.get("non_repudiation");
                keyUsageToReturn[2] = ext.get("key_encipherment");
                keyUsageToReturn[4] = ext.get("key_agreement");
                keyUsageToReturn[5] = ext.get("key_certsign");
                keyUsageToReturn[6] = ext.get("crl_sign");
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        return keyUsageToReturn;
    }

    static Collection getExtendedKeyUsage(X509Certificate cert) throws CertPathValidatorException {
        ExtKeyUsageExtension ext = null;
        Vector<String> extKUToReturn = null;
        Object[] extObj = CertPathUtil.getExtension("x509.info.extensions.ExtKeyUsage", cert);
        if (extObj[1] != null) {
            try {
                ext = new ExtKeyUsageExtension((Boolean)extObj[0], extObj[1]);
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        if (ext != null && ext.isCritical()) {
            try {
                Vector extKUFromCert = ext.get("extkeyusage");
                extKUToReturn = new Vector<String>();
                for (ObjectIdentifier oid : extKUFromCert) {
                    extKUToReturn.add(oid.toString());
                }
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        return extKUToReturn;
    }

    static Extension getPolicyInformation(X509Certificate cert, Collection policyInfoCollection, boolean policyQualifierRejected) throws CertPathValidatorException {
        CertificatePoliciesExtension ext = null;
        Object[] extObj = CertPathUtil.getExtension("x509.info.extensions.CertificatePolicies", cert);
        if (extObj[1] != null) {
            try {
                ext = new CertificatePoliciesExtension((Boolean)extObj[0], extObj[1]);
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        return ext;
    }

    static int[] getPolicyConstraints(X509Certificate cert) throws CertPathValidatorException {
        int[] result = new int[2];
        PolicyConstraintsExtension ext = null;
        result[0] = Integer.MAX_VALUE;
        result[1] = Integer.MAX_VALUE;
        Object[] extObj = CertPathUtil.getExtension("x509.info.extensions.PolicyConstraints", cert);
        if (extObj[1] == null) {
            return null;
        }
        try {
            ext = new PolicyConstraintsExtension((Boolean)extObj[0], extObj[1]);
        }
        catch (IOException e) {
            throw new CertPathValidatorException("An internal error has occurred.", e);
        }
        if (ext != null) {
            try {
                result[0] = ext.get("require");
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
            try {
                result[1] = ext.get("inhibit");
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        return result;
    }

    static int getInhibitAnyPolicy(X509Certificate cert) throws CertPathValidatorException {
        int result = Integer.MAX_VALUE;
        InhibitAnyPolicyExtension ext = null;
        Object[] extObj = CertPathUtil.getExtension("x509.info.extensions.InhibitAnyPolicy", cert);
        if (extObj[1] != null) {
            try {
                ext = new InhibitAnyPolicyExtension((Boolean)extObj[0], extObj[1]);
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        if (ext != null) {
            try {
                result = ext.get("value").intValue();
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        return result;
    }

    static DistributionPoint[] getCRLDistributionPoints(X509Certificate cert) throws CertPathValidatorException {
        CRLDistributionPointsExtension ext = null;
        DistributionPoint[] result = null;
        Object[] extObj = CertPathUtil.getExtension("x509.info.extensions.CRLDistributionPoints", cert);
        if (extObj[1] != null) {
            try {
                ext = new CRLDistributionPointsExtension((Boolean)extObj[0], extObj[1]);
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        if (ext != null) {
            try {
                result = ext.get("distribution_pts");
            }
            catch (IOException e) {
                throw new CertPathValidatorException("An internal error has occurred.", e);
            }
        }
        return result;
    }

    static X509Certificate findIssuerOfCRL(X509CRL crl, Collection willBeTrustedCollection, Collection trustedCerts, Collection certStores, String sigProvider) throws CertificateNotYetValidException {
        int result = Integer.MAX_VALUE;
        X509Certificate issuer = null;
        issuer = CertPathUtil.findIssuerOfCRL(crl, willBeTrustedCollection, sigProvider);
        if (issuer == null) {
            issuer = CertPathUtil.findIssuerOfCRL(crl, trustedCerts, sigProvider);
        }
        if (issuer == null) {
            Iterator iterCertStores = certStores.iterator();
            while (iterCertStores.hasNext() && issuer == null) {
                CertStore certStore = (CertStore)iterCertStores.next();
                try {
                    X509CertSelector cs = new X509CertSelector();
                    X500Principal crlIssuer = crl.getIssuerX500Principal();
                    cs.setSubject(crlIssuer);
                    Collection<? extends Certificate> x509Certs = certStore.getCertificates(cs);
                    issuer = CertPathUtil.findIssuerOfCRL(crl, x509Certs, sigProvider);
                }
                catch (CertStoreException certStoreException) {}
            }
        }
        return issuer;
    }

    static X509Certificate findIssuerOfCRL(X509CRL crl, Collection trustedCerts, String sigProvider) throws CertificateNotYetValidException {
        int result = Integer.MAX_VALUE;
        X509Certificate trustedCert = null;
        TrustAnchor anchor = null;
        if (trustedCerts == null) {
            result = 1;
        } else if (trustedCerts != null) {
            if (trustedCerts.isEmpty()) {
                result = 1;
            } else {
                for (Object o : trustedCerts) {
                    if (o instanceof X509Certificate) {
                        trustedCert = (X509Certificate)o;
                        if (!(trustedCert instanceof X509CertImpl)) {
                            try {
                                trustedCert = new X509CertImpl(trustedCert.getEncoded());
                            }
                            catch (CertificateException ex) {
                                throw new CertificateNotYetValidException(ex.getMessage());
                            }
                        }
                        result = CertPathUtil.verifyCRLIssuer(crl, trustedCert.getPublicKey(), trustedCert.getSubjectX500Principal(), sigProvider);
                    } else if (o instanceof TrustAnchor) {
                        anchor = (TrustAnchor)o;
                        trustedCert = anchor.getTrustedCert();
                        if (trustedCert != null) {
                            if (!(trustedCert instanceof X509CertImpl)) {
                                try {
                                    trustedCert = new X509CertImpl(trustedCert.getEncoded());
                                }
                                catch (CertificateException ex) {
                                    throw new CertificateNotYetValidException(ex.getMessage());
                                }
                            }
                            result = CertPathUtil.verifyCRLIssuer(crl, trustedCert.getPublicKey(), trustedCert.getSubjectX500Principal(), sigProvider);
                        } else {
                            X500Principal name = anchor.getCA();
                            result = CertPathUtil.verifyCRLIssuer(crl, anchor.getCAPublicKey(), name, sigProvider);
                        }
                    }
                    if (result != 0) continue;
                    break;
                }
            }
        }
        if (result == 0) {
            return trustedCert;
        }
        return null;
    }

    static int verifyCRLIssuer(X509CRL crl, PublicKey issuerKey, X500Principal issuerName, String sigProvider) throws CertificateNotYetValidException {
        int result = 0;
        if (issuerKey == null || issuerName == null) {
            result = 1;
        } else if (crl.getIssuerX500Principal().equals(issuerName)) {
            CertPathUtil.verifySignature(crl, issuerKey, sigProvider);
        } else {
            result = 4;
        }
        return result;
    }

    static void verifySignature(X509CRL crl, PublicKey issuerKey, String sigProvider) throws CertificateNotYetValidException {
        try {
            crl.verify(issuerKey, sigProvider);
        }
        catch (SignatureException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
        catch (NoSuchProviderException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
        catch (CRLException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
    }

    static Principal findDNCRLIssuer(GeneralNames issGNs) {
        boolean goOn = true;
        GeneralName gn = null;
        if (issGNs != null) {
            int i = 0;
            while (goOn) {
                try {
                    gn = issGNs.getGeneralName(i);
                }
                catch (GeneralNamesException e) {
                    goOn = false;
                }
                if (gn != null) {
                    if (gn.getType() == 4) {
                        goOn = false;
                    } else {
                        gn = null;
                    }
                }
                ++i;
            }
        }
        X500Name dn = null;
        if (gn != null) {
            DerOutputStream dos = new DerOutputStream();
            try {
                gn.encode(dos);
                DerInputStream dis = new DerInputStream(dos.toByteArray());
                DerValue encName = dis.getDerValue();
                byte[] encNameBytes = encName.getData().getDerValue().toByteArray();
                dn = new X500Name(encNameBytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return dn;
    }

    static GeneralName getSupportedNameObjectFromGeneralNames(GeneralNames gns) {
        GeneralName gn = null;
        if (gns != null) {
            try {
                String temp;
                gn = gns.getGeneralName(6);
                if (gn != null && !CertPathUtil.isSupportedURI(temp = CertPathUtil.stripJunk(gn.toString()))) {
                    gn = null;
                }
                if (gn == null) {
                    gn = gns.getGeneralName(4);
                }
            }
            catch (GeneralNamesException e) {
                gn = null;
            }
        }
        return gn;
    }

    static boolean isEqualReasons(boolean[] reasonsA, boolean[] reasonsB) {
        boolean e = false;
        if (reasonsA == reasonsB) {
            e = true;
        } else if (reasonsA.length == reasonsB.length) {
            int i = 0;
            for (i = 0; i < reasonsA.length && reasonsA[i] == reasonsB[i]; ++i) {
            }
            e = i >= reasonsA.length;
        }
        return e;
    }

    static void unionReasons(boolean[] baseReasons, boolean[] reasonsToMerge) {
        int size = Math.min(baseReasons.length, reasonsToMerge.length);
        for (int i = 0; i < size; ++i) {
            if (!reasonsToMerge[i]) continue;
            baseReasons[i] = true;
        }
    }

    static boolean minimalUserReasonsSatisfied(boolean[] userReasons, boolean[] allReasons) {
        int size = Math.min(userReasons.length, allReasons.length);
        boolean match = false;
        for (int i = 0; i < size && !match; ++i) {
            if (!userReasons[i] || !allReasons[i]) continue;
            match = true;
        }
        return match;
    }

    static boolean allUserReasonsSatisfied(boolean[] userReasons, boolean[] allReasons) {
        int size = Math.min(userReasons.length, allReasons.length);
        boolean match = true;
        for (int i = 0; i < size && match; ++i) {
            if (userReasons[i] && allReasons[i] || !userReasons[i]) continue;
            match = false;
        }
        return match;
    }

    static boolean interimContainMoreReasons(boolean[] interimReasonMask, boolean[] reasonMask) {
        int size = Math.min(interimReasonMask.length, reasonMask.length);
        boolean flag = false;
        for (int i = 0; i < size; ++i) {
            if (interimReasonMask[i] && reasonMask[i]) continue;
            if (interimReasonMask[i] && !reasonMask[i]) {
                flag = true;
                break;
            }
            if (interimReasonMask[i]) continue;
        }
        return flag;
    }

    static void intersectReasons(boolean[] interimReasonMask, boolean[] dpReasons) {
        int i;
        int size = Math.min(interimReasonMask.length, dpReasons.length);
        for (i = 0; i < size; ++i) {
            if (interimReasonMask[i] && dpReasons[i]) continue;
            interimReasonMask[i] = false;
        }
        for (i = size; i < interimReasonMask.length; ++i) {
            interimReasonMask[i] = false;
        }
    }

    static DirContext getDirContext(String uri) {
        String JNDI_LDAP_CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
        if (debug != null) {
            System.out.println("CERTPATH: connect to " + uri);
        }
        Properties env = new Properties();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", uri);
        String crlConnectTimeout = System.getenv(JNDI_LDAP_CONNECT_TIMEOUT);
        if (crlConnectTimeout == null) {
            crlConnectTimeout = String.valueOf(CertPathSystemProperties.getCRLSConnectTimeout());
        }
        env.put(JNDI_LDAP_CONNECT_TIMEOUT, crlConnectTimeout);
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
        }
        catch (NamingException e) {
            if (debug != null) {
                System.err.println("CERTPATH: getDirContext failed: " + e.getMessage());
            }
            ctx = null;
        }
        return ctx;
    }

    static X509CRLImpl[] retrieveCRLs(DirContext ctx, String name, String[] attribute) {
        X509CRLImpl[] crl;
        block7: {
            crl = new X509CRLImpl[attribute.length];
            try {
                Attributes as = ctx.getAttributes(name, attribute);
                if (as != null && as.size() != 0) {
                    NamingEnumeration<? extends Attribute> nenum = as.getAll();
                    while (nenum.hasMoreElements()) {
                        Attribute attr = nenum.next();
                        String type = attr.getID();
                        int i = 0;
                        for (i = 0; i < attribute.length; ++i) {
                            if (!type.equalsIgnoreCase(attribute[i])) continue;
                            Object temp = attr.get();
                            crl[i / 2] = new X509CRLImpl((byte[])temp);
                            if (debug == null) continue;
                            System.out.println("CERTPATH: retrieveCRLs, crl with type: " + attribute[i]);
                        }
                    }
                }
            }
            catch (NamingException e) {
                if (debug != null) {
                    System.err.println("CERTPATH: NewGetAttr failed: " + e.getMessage());
                }
            }
            catch (CRLException e) {
                if (debug == null) break block7;
                System.err.println("CERTPATH: NewGetAttr failed: " + e.getMessage());
            }
        }
        return crl;
    }

    static boolean isSupportedURI(String uriString) {
        if (CertPathUtil.isLDAPURI(uriString)) {
            return true;
        }
        if (CertPathUtil.isHTTPURI(uriString)) {
            return true;
        }
        return CertPathUtil.isFTPURI(uriString);
    }

    static boolean isLDAPURI(String uriString) {
        return uriString.regionMatches(true, 0, LDAP_URI_START, 0, LDAP_URI_START.length());
    }

    static boolean isHTTPURI(String uriString) {
        return uriString.regionMatches(true, 0, HTTP_URI_START, 0, HTTP_URI_START.length());
    }

    static boolean isFTPURI(String uriString) {
        return uriString.regionMatches(true, 0, FTP_URI_START, 0, HTTP_URI_START.length());
    }

    static String stripJunk(String in) {
        String temp = in;
        if (in.startsWith(URI_NAME)) {
            temp = temp.substring(URI_NAME.length());
        }
        return temp;
    }

    static boolean isCACert(X509Certificate cert) throws CertPathValidatorException {
        Object[] bcResult = CertPathUtil.getBasicConstraints(cert);
        return !bcResult[1].equals(Boolean.FALSE);
    }

    static boolean isTrustedCert(X509Certificate cert, Set trustAnchors) {
        Iterator it = trustAnchors.iterator();
        TrustAnchor ta = null;
        X509Certificate tempcert = null;
        while (it.hasNext()) {
            ta = (TrustAnchor)it.next();
            tempcert = ta.getTrustedCert();
            if (tempcert == null || !cert.equals(tempcert)) continue;
            return true;
        }
        return false;
    }
}

