/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.pkcs11.PKCS11Session;
import java.lang.management.ManagementFactory;
import java.math.BigInteger;
import java.security.ProviderException;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class Session {
    private static final long MAX_IDLE_TIME = 180000L;
    private SessionManager manager;
    protected PKCS11Session session;
    private Object sessionID;
    private static Hashtable sessionsWithAHardwareCallOutstanding = new Hashtable();
    private static final Object lock = new Object();
    private boolean isObjSess;
    private boolean hasObjs;
    private long lastAccess;
    private final AtomicInteger createdObjects;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static Debug debugSession = Debug.getInstance((String)"session");
    private static Debug debugDeriveKey = Debug.getInstance((String)"kdf");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Session";

    Session(SessionManager manager, PKCS11Session sess, boolean isObjSess) {
        this.manager = manager;
        this.session = sess;
        if (this.session != null) {
            this.sessionID = this.session.getID();
        }
        this.isObjSess = isObjSess;
        this.lastAccess = System.currentTimeMillis();
        this.createdObjects = new AtomicInteger();
    }

    boolean hasObjects() {
        return this.createdObjects.intValue() > 0;
    }

    void addObject() {
        int n = this.createdObjects.incrementAndGet();
    }

    void removeObject() {
        int n = this.createdObjects.decrementAndGet();
        if (n == 0) {
            this.manager.demoteObjSession(this);
        } else if (n < 0) {
            throw new ProviderException("Internal error: objects created " + n);
        }
    }

    int[] getMechanismList() {
        this.logEntry("getMechanismList");
        int[] myInts = null;
        try {
            myInts = this.session.getSlot().getMechanismList();
        }
        catch (PKCS11Exception ex) {
            this.logExit("getMechanismList");
            throw ex;
        }
        this.logExit("getMechanismList");
        return myInts;
    }

    void setObjSession(boolean isObjSession) {
        this.isObjSess = isObjSession;
    }

    boolean isAlive(long currentTime) {
        return currentTime - this.lastAccess < 180000L;
    }

    void setAccessTime(long time) {
        this.lastAccess = time;
    }

    long getAccessTime() {
        return this.lastAccess;
    }

    public void login(boolean isSo, Object PIN) throws PKCS11Exception {
        this.logEntry("login.");
        try {
            this.session.login(isSo, PIN);
        }
        catch (PKCS11Exception ex) {
            this.logExit("login");
            throw ex;
        }
        this.logExit("login");
    }

    public void logout() throws PKCS11Exception {
        this.logEntry("logout.");
        try {
            this.session.logout();
        }
        catch (PKCS11Exception ex) {
            this.logExit("logout");
            throw ex;
        }
        this.logExit("logout");
    }

    public PKCS11Object createObject(int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        this.logEntry("createObject.");
        PKCS11Object obj = null;
        try {
            obj = this.session.createObject(attrTypes, attrValues);
        }
        catch (PKCS11Exception ex) {
            this.logExit("createObject");
            throw ex;
        }
        this.logExit("createObject");
        return obj;
    }

    public void destroyObject(PKCS11Object obj) throws PKCS11Exception {
        this.logEntry("destroyObject.");
        try {
            this.session.destroyObject(obj);
        }
        catch (PKCS11Exception ex) {
            this.logExit("destroyObject");
            throw ex;
        }
        this.logExit("destroyObject");
    }

    public boolean getBoolAttributeValue(PKCS11Object obj, int attribute) {
        try {
            boolean value;
            this.logEntry("getBoolAttributeValue.");
            try {
                value = this.session.getBoolAttributeValue(obj, attribute);
            }
            catch (PKCS11Exception ex) {
                this.logExit("getBoolAttributeValue");
                throw ex;
            }
            this.logExit("getBoolAttributeValue");
            return value;
        }
        catch (PKCS11Exception ex) {
            return false;
        }
    }

    public Object getAttrValue(PKCS11Object obj, int attr) {
        Object rtn;
        try {
            this.logEntry("getAttributeValue.");
            try {
                rtn = this.session.getAttributeValue(obj, attr);
            }
            catch (PKCS11Exception ex) {
                this.logExit("getAttributeValue");
                throw ex;
            }
            this.logExit("getAttributeValue");
        }
        catch (PKCS11Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getAttrValue", "return null, attr=" + attr);
            }
            rtn = null;
        }
        return rtn;
    }

    public Object[] getAttrValues(PKCS11Object obj, int[] attrs) {
        Object[] rtn;
        try {
            this.logEntry("getAttributeValues.");
            try {
                rtn = this.session.getAttributeValues(obj, attrs, attrs.length);
            }
            catch (PKCS11Exception ex) {
                this.logExit("getAttributeValues");
                throw ex;
            }
            this.logExit("getAttributeValues");
        }
        catch (PKCS11Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getAttrValues", "exception = " + ex.getMessage());
            }
            rtn = new Object[attrs.length];
            for (int i = 0; i < attrs.length; ++i) {
                rtn[i] = this.getAttrValue(obj, attrs[i]);
            }
        }
        return rtn;
    }

    public void seedRandom(byte[] data, int offset, int len) throws PKCS11Exception {
        this.logEntry("seedRandom.");
        try {
            this.session.seedRandom(data, offset, len);
        }
        catch (PKCS11Exception ex) {
            this.logExit("seedRandom");
            throw ex;
        }
        this.logExit("seedRandom");
    }

    public void generateRandom(byte[] outdata, int outoffset, int len) throws PKCS11Exception {
        this.logEntry("generateRandom.");
        try {
            this.session.generateRandom(outdata, outoffset, len);
        }
        catch (PKCS11Exception ex) {
            this.logExit("generateRandom");
            throw ex;
        }
        this.logExit("generateRandom");
    }

    public PKCS11Object[] generateKeyPair(int mech, Object param, int[] pubTypes, Object[] pubValues, int[] privTypes, Object[] privValues) throws PKCS11Exception {
        this.logEntry("generateKeyPair.");
        PKCS11Object[] kp = null;
        try {
            kp = this.session.generateKeyPair(mech, param, pubTypes, pubValues, privTypes, privValues);
        }
        catch (PKCS11Exception ex) {
            this.logExit("generateKeyPair");
            throw ex;
        }
        this.logExit("generateKeyPair");
        return kp;
    }

    public PKCS11Object generateKey(int mech, Object param, int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        this.logEntry("generateKey.");
        PKCS11Object key = null;
        try {
            key = this.session.generateKey(mech, param, attrTypes, attrValues);
        }
        catch (PKCS11Exception ex) {
            this.logExit("generateKey");
            throw ex;
        }
        this.logExit("generateKey");
        return key;
    }

    public SessionManager getSessionManager() {
        return this.manager;
    }

    public BigInteger getBigIntegerAttributeValue(PKCS11Object obj, int type) throws PKCS11Exception {
        if (PKCS11Object.valueClass((int)type) != BigInteger.class) {
            throw new PKCS11Exception(18);
        }
        this.logEntry("getAttributeValue (for BigInteger).");
        BigInteger value = null;
        try {
            value = (BigInteger)this.session.getAttributeValue(obj, type);
        }
        catch (PKCS11Exception ex) {
            this.logExit("getAttributeValue (for BigInteger)");
            throw ex;
        }
        this.logExit("getAttributeValue (for BigInteger)");
        return value;
    }

    public int sign(byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("sign.");
        try {
            value = this.session.sign(indata, inoffset, inlen, outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("sign");
            throw ex;
        }
        this.logExit("sign");
        return value;
    }

    public void signInit(int mech, Object param, PKCS11Object key) throws PKCS11Exception {
        this.logEntry("signInit.");
        try {
            this.session.signInit(mech, param, key);
        }
        catch (PKCS11Exception ex) {
            this.logExit("signInit");
            throw ex;
        }
        this.logExit("signInit");
    }

    public void signUpdate(byte[] indata, int inoffset, int inlen) throws PKCS11Exception {
        this.logEntry("signUpdate.");
        try {
            this.session.signUpdate(indata, inoffset, inlen);
        }
        catch (PKCS11Exception ex) {
            this.logExit("signUpdate");
            throw ex;
        }
        this.logExit("signUpdate");
    }

    public int signFinal(byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("signFinal.");
        try {
            value = this.session.signFinal(outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("signFinal");
            throw ex;
        }
        this.logExit("signFinal");
        return value;
    }

    public PKCS11Object copy(PKCS11Object origObj, int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        this.logEntry("copy.");
        PKCS11Object obj = null;
        try {
            obj = this.session.copy(origObj, attrTypes, attrValues);
        }
        catch (PKCS11Exception ex) {
            this.logExit("copy");
            throw ex;
        }
        this.logExit("copy");
        return obj;
    }

    public void findObjectsInit(int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        this.logEntry("findObjectsInit.");
        try {
            this.session.findObjectsInit(attrTypes, attrValues);
        }
        catch (PKCS11Exception ex) {
            this.logExit("findObjectsInit");
            throw ex;
        }
        this.logExit("findObjectsInit");
    }

    public void findObjectsFinal() throws PKCS11Exception {
        this.logEntry("findObjectsFinal.");
        try {
            this.session.findObjectsFinal();
        }
        catch (PKCS11Exception ex) {
            this.logExit("findObjectsFinal");
            throw ex;
        }
        this.logExit("findObjectsFinal");
    }

    public PKCS11Object findObject() throws PKCS11Exception {
        this.logEntry("findObject.");
        PKCS11Object obj = null;
        try {
            obj = this.session.findObject();
        }
        catch (PKCS11Exception ex) {
            this.logExit("findObject");
            throw ex;
        }
        this.logExit("findObject");
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws PKCS11Exception {
        Integer n = SessionManager.objectUsedForOpenCloseSynchronization;
        synchronized (n) {
            if (debugSession != null) {
                System.out.println("Session.java:  close():  Returning session to hardware.  Session ID = " + this.session.getID());
            }
            this.logEntry("close.");
            try {
                this.session.close();
                this.session = null;
            }
            catch (PKCS11Exception ex) {
                this.logExit("close");
                throw ex;
            }
            this.logExit("close");
        }
    }

    public boolean verifyFinal(byte[] sig, int sigoffset, int siglen) throws PKCS11Exception {
        boolean value;
        this.logEntry("verifyFinal.");
        try {
            value = this.session.verifyFinal(sig, sigoffset, siglen);
        }
        catch (PKCS11Exception ex) {
            this.logExit("verifyFinal");
            throw ex;
        }
        this.logExit("verifyFinal");
        return value;
    }

    public void verifyUpdate(byte[] indata, int inoffset, int inlen) throws PKCS11Exception {
        this.logEntry("verifyUpdate.");
        try {
            this.session.verifyUpdate(indata, inoffset, inlen);
        }
        catch (PKCS11Exception ex) {
            this.logExit("verifyUpdate");
            throw ex;
        }
        this.logExit("verifyUpdate");
    }

    public boolean verify(byte[] data, int dataoffset, int datalen, byte[] sig, int sigoffset, int siglen) throws PKCS11Exception {
        boolean value;
        this.logEntry("verify.");
        try {
            value = this.session.verify(data, dataoffset, datalen, sig, sigoffset, siglen);
        }
        catch (PKCS11Exception ex) {
            this.logExit("verify");
            throw ex;
        }
        this.logExit("verify");
        return value;
    }

    public void verifyInit(int mech, Object param, PKCS11Object key) throws PKCS11Exception {
        this.logEntry("verifyInit.");
        try {
            this.session.verifyInit(mech, param, key);
        }
        catch (PKCS11Exception ex) {
            this.logExit("verifyInit");
            throw ex;
        }
        this.logExit("verifyInit");
    }

    public void digestInit(int mech, Object param) throws PKCS11Exception {
        this.logEntry("digestInit.");
        try {
            this.session.digestInit(mech, param);
        }
        catch (PKCS11Exception ex) {
            this.logExit("digestInit");
            throw ex;
        }
        this.logExit("digestInit");
    }

    public void digestUpdate(byte[] indata, int inoffset, int inlen) throws PKCS11Exception {
        this.logEntry("digestUpdate.");
        try {
            this.session.digestUpdate(indata, inoffset, inlen);
        }
        catch (PKCS11Exception ex) {
            this.logExit("digestUpdate");
            throw ex;
        }
        this.logExit("digestUpdate");
    }

    public int digestFinal(byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("digestFinal.");
        try {
            value = this.session.digestFinal(outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("digestFinal");
            throw ex;
        }
        this.logExit("digestFinal");
        return value;
    }

    public PKCS11Object deriveKey(int mech, Object param, PKCS11Object baseKey, int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        this.logEntry("deriveKey.");
        if (debugDeriveKey != null) {
            System.out.println("Session.java:  deriveKey():  The mechanism to be used is:  " + Integer.toHexString(mech));
        }
        PKCS11Object obj = null;
        try {
            obj = this.session.deriveKey(mech, param, baseKey, attrTypes, attrValues);
        }
        catch (PKCS11Exception ex) {
            this.logExit("deriveKey");
            throw ex;
        }
        this.logExit("deriveKey");
        return obj;
    }

    public void decryptInit(int mech, Object param, PKCS11Object key) throws PKCS11Exception {
        this.logEntry("decryptInit.");
        try {
            this.session.decryptInit(mech, param, key);
        }
        catch (PKCS11Exception ex) {
            this.logExit("decryptInit");
            throw ex;
        }
        this.logExit("decryptInit");
    }

    public int decryptUpdate(byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("decryptUpdate.");
        try {
            value = this.session.decryptUpdate(indata, inoffset, inlen, outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("decryptUpdate");
            throw ex;
        }
        this.logExit("decryptUpdate");
        return value;
    }

    public int decryptFinal(byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("decryptFinal.");
        try {
            value = this.session.decryptFinal(outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("decryptFinal");
            throw ex;
        }
        this.logExit("decryptFinal");
        return value;
    }

    public int decrypt(byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("decrypt.");
        try {
            value = this.session.decrypt(indata, inoffset, inlen, outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("decrypt");
            throw ex;
        }
        this.logExit("decrypt");
        return value;
    }

    public int decryptDoFinalGCM(int mech, Object param, PKCS11Object key, byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("decryptDoFinalGCM.");
        try {
            value = this.session.decryptDoFinalGCM(mech, param, key, indata, inoffset, inlen, outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("decryptDoFinalGCM");
            throw ex;
        }
        this.logExit("decryptDoFinalGCM");
        return value;
    }

    public void encryptInit(int mech, Object param, PKCS11Object key) throws PKCS11Exception {
        this.logEntry("encryptInit.");
        try {
            this.session.encryptInit(mech, param, key);
        }
        catch (PKCS11Exception ex) {
            this.logExit("encryptInit");
            throw ex;
        }
        this.logExit("encryptInit");
    }

    public int encryptUpdate(byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("encryptUpdate.");
        try {
            value = this.session.encryptUpdate(indata, inoffset, inlen, outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("encryptUpdate");
            throw ex;
        }
        this.logExit("encryptUpdate");
        return value;
    }

    public int encryptFinal(byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("encryptFinal.");
        try {
            value = this.session.encryptFinal(outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("encryptFinal");
            throw ex;
        }
        this.logExit("encryptFinal");
        return value;
    }

    public int encrypt(byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("encrypt.");
        try {
            value = this.session.encrypt(indata, inoffset, inlen, outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("encrypt");
            throw ex;
        }
        this.logExit("encrypt");
        return value;
    }

    public int encryptDoFinalGCM(int mech, Object param, PKCS11Object key, byte[] indata, int inoffset, int inlen, byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("encryptDoFinalGCM.");
        try {
            value = this.session.encryptDoFinalGCM(mech, param, key, indata, inoffset, inlen, outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("encryptDoFinalGCM");
            throw ex;
        }
        this.logExit("encryptDoFinalGCM");
        return value;
    }

    public PKCS11Object unwrapKey(int mech, Object param, PKCS11Object unwrappingKey, byte[] inkeydata, int inkeyoffset, int inkeylen, int[] attrTypes, Object[] attrValues) throws PKCS11Exception {
        this.logEntry("unwrapKey.");
        PKCS11Object obj = null;
        try {
            obj = this.session.unwrapKey(mech, param, unwrappingKey, inkeydata, inkeyoffset, inkeylen, attrTypes, attrValues);
        }
        catch (PKCS11Exception ex) {
            this.logExit("unwrapKey");
            throw ex;
        }
        this.logExit("unwrapKey");
        return obj;
    }

    public int wrapKey(int mech, Object param, PKCS11Object wrappingKey, PKCS11Object key, byte[] outdata, int outoffset) throws PKCS11Exception {
        int value;
        this.logEntry("wrapKey.");
        try {
            value = this.session.wrapKey(mech, param, wrappingKey, key, outdata, outoffset);
        }
        catch (PKCS11Exception ex) {
            this.logExit("wrapKey");
            throw ex;
        }
        this.logExit("wrapKey");
        return value;
    }

    public Object getID() {
        return this.sessionID;
    }

    private static void printSessionOperation() {
        boolean hasSessions = false;
        System.out.println("Session.java:  printSessionOperation(): BEGIN DUMP OF SESSION LIST");
        if (sessionsWithAHardwareCallOutstanding.size() > 0) {
            Set entries = sessionsWithAHardwareCallOutstanding.keySet();
            Iterator it = entries.iterator();
            if (it.hasNext()) {
                hasSessions = true;
            }
            while (it.hasNext()) {
                System.out.print(it.next() + "  ");
            }
        }
        if (hasSessions) {
            System.out.println("\nSession.java:  printSessionOperation(): END DUMP OF SESSION LIST");
        } else {
            System.out.println("Session.java:  printSessionOperation(): END DUMP OF SESSION LIST");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logEntry(String action) {
        if (debugSession != null) {
            Object object = lock;
            synchronized (object) {
                System.out.println("\n================================VVVVVVVVVVVV===========================================");
                System.out.println("\n\nSession.java:  logEntry():  CALLING THE FOLLOWING CRYPTO MECHANISM: " + action);
                if (this.sessionID != null) {
                    if (sessionsWithAHardwareCallOutstanding.containsKey(this.sessionID)) {
                        this.log("Session.java:  logEntry():  session " + this.sessionID + " already has a hardware ecall outstanding.  ERROR.");
                        Session.printSessionOperation();
                    } else {
                        Date date = Calendar.getInstance().getTime();
                        sessionsWithAHardwareCallOutstanding.put(this.sessionID, date);
                        this.log("Session.java:  logEntry():  Adding session " + this.sessionID + " to the table.");
                        Session.printSessionOperation();
                    }
                } else {
                    this.log("Session.java:  logEntry():  sessionID == NULL.  DO NOTHING.  ERROR ?");
                }
                System.out.println("\nSession.java:  logEntry():  THE CALL STACK IS:");
                Exception ex = new Exception();
                ex.printStackTrace();
                System.out.println("==================================AAAAAAAAAAAAA==============================================\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logExit(String action) {
        if (debugSession != null) {
            Object object = lock;
            synchronized (object) {
                System.out.println("\n================================VVVVVVVVVVVV============================================");
                System.out.println("\n\nSession.java:  logExit():  RETURNING FROM THE FOLLOWING CRYPTO MECHANISM: " + action);
                if (this.sessionID != null) {
                    if (sessionsWithAHardwareCallOutstanding.containsKey(this.sessionID)) {
                        sessionsWithAHardwareCallOutstanding.remove(this.sessionID);
                        this.log("Session.java:  logExit():  Removing session " + this.sessionID + " from the table.");
                        Session.printSessionOperation();
                    } else {
                        this.log("Session.java:  logExit():  Trying to remove session " + this.sessionID + " which is not in the table.  ERROR.");
                        Session.printSessionOperation();
                    }
                } else {
                    this.log("Session.java:  logExit():  sessionID == NULL.  DO NOTHING.  ERROR ? ");
                }
                System.out.println("\nSession.java:  logExit():  THE CALL STACK IS:");
                Exception ex = new Exception();
                ex.printStackTrace();
                System.out.println("==================================AAAAAAAAAAAAA========================================\n");
            }
        }
    }

    private void log(String action) {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        String processID = processName.split("@")[0];
        int pID = Integer.valueOf(processID);
        long threadID = Thread.currentThread().getId();
        if (this.sessionID == null) {
            System.out.println("Session.java:  log():  process " + pID + "(0x" + Integer.toHexString(pID).toUpperCase() + "), thread " + threadID + "(0x" + Long.toHexString(threadID).toUpperCase() + "), session null: " + action);
        } else if (this.sessionID instanceof Number) {
            Integer sessionID = ((Number)this.sessionID).intValue();
            System.out.println("Session.java:  log():  process " + pID + "(0x" + Integer.toHexString(pID).toUpperCase() + "), thread " + threadID + "(0x" + Long.toHexString(threadID).toUpperCase() + "), session " + sessionID + "(0x" + Integer.toHexString(sessionID).toUpperCase() + "): " + action);
        } else {
            System.out.println("Session.java:  log():  process " + pID + "(0x" + Integer.toHexString(pID).toUpperCase() + "), thread " + threadID + "(0x" + Long.toHexString(threadID).toUpperCase() + "), session " + this.sessionID + ": " + action);
        }
    }

    protected void finalize() throws Throwable {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "finalize");
        }
        if (IBMPKCS11Impl.doMemoryManagement()) {
            if (!this.hasObjects()) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "finalize", "Free this Session object since it has no objects associated with it.");
                }
                if (this.session != null) {
                    this.session.close();
                    this.session = null;
                }
            } else if (debug != null) {
                debug.text(16384L, (Object)className, "finalize", "Do NOT free this Session object since it has objects associated with it.");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "finalize");
        }
    }
}

