/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11ECKeyFactory;
import com.ibm.crypto.pkcs11impl.provider.PKCS11PublicKey;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import com.ibm.security.ec.ECParameters;
import com.ibm.security.ec.ECPublicKeyImpl;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.util.Date;

public final class PKCS11ECPublicKey
extends X509Key
implements PKCS11PublicKey,
ECPublicKey {
    private ECPoint w;
    private byte[] encodedW;
    private ECParameterSpec params;
    private byte[] encoded;
    private PKCS11Object object;
    private SessionManager sessionManager;
    private Config config;
    private Session session;
    static final long serialVersionUID = 915217859012835L;
    private Boolean isToken = null;
    private Boolean isPrivate = null;
    private String label = null;
    private Boolean isModifiable = null;
    private Integer keyType = PKCS11Object.EC;
    private byte[] ID = null;
    private Date startDate = null;
    private Date endDate = null;
    private Boolean isDerive = null;
    private Boolean isLocal = null;
    private byte[] subject = null;
    private Boolean isEncrypt = null;
    private Boolean isVerify = null;
    private Boolean isVerifyRecover = null;
    private Boolean isWrap = null;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.PKCS11ECPublicKey";

    PKCS11ECPublicKey(Session session, PKCS11Object object, byte[] ID, byte[] subject, String label) throws InvalidKeyException {
        this.sessionManager = session.getSessionManager();
        this.object = object;
        if (ID != null) {
            this.ID = new byte[ID.length];
            System.arraycopy(ID, 0, this.ID, 0, ID.length);
        } else {
            this.ID = (byte[])this.getValue(session, this.object, 258);
        }
        if (subject != null) {
            this.subject = new byte[subject.length];
            System.arraycopy(subject, 0, this.subject, 0, subject.length);
        } else {
            this.subject = (byte[])this.getValue(session, this.object, 257);
        }
        this.label = label != null ? new String(label) : (String)this.getValue(session, this.object, 3);
        this.isToken = (Boolean)this.getValue(session, this.object, 1);
        this.isVerify = (Boolean)this.getValue(session, this.object, 266);
        this.isEncrypt = (Boolean)this.getValue(session, this.object, 260);
        this.isWrap = (Boolean)this.getValue(session, this.object, 262);
        this.isPrivate = (Boolean)this.getValue(session, this.object, 2);
        this.isModifiable = (Boolean)this.getValue(session, this.object, 368);
        this.startDate = (Date)this.getValue(session, this.object, 272);
        this.endDate = (Date)this.getValue(session, this.object, 273);
        this.isDerive = (Boolean)this.getValue(session, this.object, 268);
        this.isLocal = (Boolean)this.getValue(session, this.object, 355);
        this.isVerifyRecover = (Boolean)this.getValue(session, this.object, 267);
        byte[] temp = null;
        temp = (byte[])this.getValue(session, this.object, 384);
        if (temp != null) {
            try {
                this.params = PKCS11ECKeyFactory.decodeParameters(temp);
                temp = (byte[])this.getValue(session, this.object, 385);
                this.algid = new AlgorithmId(AlgorithmId.EC_oid, ECParameters.getAlgorithmParameters((ECParameterSpec)this.params));
                if (temp != null) {
                    DerValue der = new DerValue(temp);
                    int length = der.length();
                    byte[] wdata = new byte[length];
                    System.arraycopy(temp, temp.length - length, wdata, 0, wdata.length);
                    EllipticCurve curve = this.params.getCurve();
                    this.w = PKCS11ECKeyFactory.decodePoint(wdata, curve);
                    this.key = wdata;
                    this.encodedW = temp;
                }
            }
            catch (IOException ex) {
                throw new InvalidKeyException(ex);
            }
        }
    }

    PKCS11ECPublicKey(Session session, PKCS11Object object, byte[] ID, byte[] subject, String label, byte[] parms, byte[] ecpoint) throws InvalidKeyException {
        this(session, object, ID, subject, label);
        try {
            this.params = PKCS11ECKeyFactory.decodeParameters(parms);
            this.w = PKCS11ECKeyFactory.decodePoint(ecpoint, this.params.getCurve());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse key values", e);
        }
    }

    @Override
    public Boolean getLocal() {
        return this.isLocal;
    }

    @Override
    public byte[] getSubject() {
        return (byte[])this.subject.clone();
    }

    @Override
    public Boolean getEncrypt() {
        return new Boolean(this.isEncrypt);
    }

    @Override
    public Boolean getVerify() {
        return new Boolean(this.isVerify);
    }

    @Override
    public Boolean getVerifyRecover() {
        return new Boolean(this.isVerifyRecover);
    }

    @Override
    public Boolean getWrap() {
        return new Boolean(this.isWrap);
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        if (this.encoded == null) {
            try {
                ECPublicKeyImpl key = new ECPublicKeyImpl(this.w, this.params);
                this.encoded = key.getEncoded();
            }
            catch (InvalidKeyException e) {
                if (debug != null) {
                    debug.exception(16384L, (Object)"PKCS11ECPublicKey", "getEncoded", (Throwable)e);
                }
                return null;
            }
        }
        return (byte[])this.encoded.clone();
    }

    @Override
    public ECPoint getW() {
        return this.w;
    }

    public byte[] getEncodedW() {
        return this.encodedW;
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    private Object getValue(Session session, PKCS11Object pkcs11obj, int attr) {
        return session.getAttrValue(pkcs11obj, attr);
    }

    @Override
    public void rm() {
        Session sess = null;
        if (this.session != null) {
            this.session.removeObject();
        }
        if (this.getObject() != null) {
            try {
                sess = this.sessionManager.getOpSession();
                sess.destroyObject(this.getObject());
                this.object = null;
                this.session = null;
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }

    protected void finalize() throws Throwable {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "finalize");
        }
        if (IBMPKCS11Impl.doMemoryManagement()) {
            if (!this.getToken().booleanValue()) {
                if (debug != null) {
                    debug.text(16384L, (Object)className, "finalize", "Free this PKCS11ECPublicKey object since it is a session key.");
                }
                this.rm();
                super.finalize();
            } else if (debug != null) {
                debug.text(16384L, (Object)className, "finalize", "Do NOT free this PKCS11ECPublicKey object since it is a token.");
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "finalize");
        }
    }

    @Override
    public PKCS11Object getObject() {
        return this.object;
    }

    @Override
    public Integer getKeyType() {
        return this.keyType;
    }

    void setSession(Session sess) {
        this.session = sess;
    }

    @Override
    public byte[] getID() {
        return (byte[])this.ID.clone();
    }

    @Override
    public Boolean getDerive() {
        return this.isDerive;
    }

    @Override
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    public Date getEndDate() {
        return this.endDate;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Boolean getModifiable() {
        return this.isModifiable;
    }

    @Override
    public Boolean getPrivate() {
        return this.isPrivate;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    @Override
    public Boolean getToken() {
        return this.isToken;
    }

    public String toString() {
        return "IBMPKCS11Impl EC Public Key " + this.object.toString();
    }
}

