/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Exception;
import java.security.DigestException;

final class Hash
implements Cloneable {
    private static final int MAX_HASH_LENGTH = 64;
    private byte[] digest;
    private byte[] buffer;
    private byte[] checksum;
    private byte[] mdBuffer;
    private int bufferIndex;
    private int bufferLeft;
    private int mechanism;
    private Session session;
    private SessionManager sessionManager;
    private boolean initObject = false;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.Hash";

    protected Hash(int mechanism, SessionManager sessManager) {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "Hash", (Object)("mechanism: " + mechanism));
        }
        this.mechanism = mechanism;
        this.sessionManager = sessManager;
        this.init();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "Hash");
        }
    }

    private void init() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "init");
        }
        if (this.initObject) {
            byte[] buffer = new byte[64];
            if (this.session != null) {
                try {
                    this.session.digestFinal(buffer, 0);
                    this.sessionManager.releaseSession(this.session);
                    this.session = null;
                }
                catch (PKCS11Exception ex) {
                    if (debug != null) {
                        debug.exception(16384L, (Object)"Hash", "init", (Throwable)ex);
                    }
                    this.sessionManager.closeSession(this.session);
                    this.session = null;
                }
            }
        }
        this.initObject = false;
        if (debug != null) {
            debug.exit(16384L, (Object)className, "init");
        }
    }

    protected void engineReset() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineReset");
        }
        this.init();
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineReset");
        }
    }

    protected synchronized void engineUpdate(byte[] input, int offset, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(offset).toString(), new Integer(len).toString()};
            debug.entry(16384L, (Object)className, "engineUpdate", parms);
        }
        if (!this.initObject) {
            if (this.session == null) {
                this.session = this.sessionManager.getOpSession();
            }
            this.session.digestInit(this.mechanism, null);
            this.initObject = true;
        }
        try {
            this.session.digestUpdate(input, offset, len);
        }
        catch (PKCS11Exception ex) {
            this.sessionManager.closeSession(this.session);
            this.session = null;
            throw ex;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineUpdate");
        }
    }

    protected byte[] engineDigest() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "engineDigest");
        }
        if (!this.initObject) {
            if (this.session == null) {
                this.session = this.sessionManager.getOpSession();
            }
            this.session.digestInit(this.mechanism, null);
            this.initObject = true;
        }
        int resultLen = 0;
        byte[] buffer = new byte[64];
        try {
            resultLen = this.session.digestFinal(buffer, 0);
        }
        finally {
            this.sessionManager.releaseSession(this.session);
            this.session = null;
            this.initObject = false;
        }
        byte[] result = new byte[resultLen];
        System.arraycopy(buffer, 0, result, 0, resultLen);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDigest");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        if (debug != null) {
            Object[] parms = new Object[]{buf, new Integer(offset).toString(), new Integer(len).toString()};
            debug.entry(16384L, (Object)className, "engineDigest", parms);
        }
        if (!this.initObject) {
            if (this.session == null) {
                this.session = this.sessionManager.getOpSession();
            }
            this.session.digestInit(this.mechanism, null);
            this.initObject = true;
        }
        int resultLen = 0;
        byte[] buffer = new byte[64];
        try {
            resultLen = this.session.digestFinal(buffer, 0);
        }
        finally {
            this.sessionManager.releaseSession(this.session);
            this.session = null;
            this.initObject = false;
        }
        if (len < resultLen) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineDigest", "partial digests not returned");
            }
            throw new DigestException("partial digests not returned");
        }
        if (buf.length - offset < resultLen) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "engineDigest", "insufficient space in the output buffer to store the digest");
            }
            throw new DigestException("insufficient space in the output buffer to store the digest");
        }
        System.arraycopy(buffer, 0, buf, offset, resultLen);
        if (debug != null) {
            debug.exit(16384L, (Object)className, "engineDigest");
        }
        return resultLen;
    }

    public Object clone() {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "clone");
        }
        Hash that = null;
        try {
            that = (Hash)super.clone();
            that.digest = (byte[])(this.digest != null ? (byte[])this.digest.clone() : null);
            that.buffer = (byte[])(this.buffer != null ? (byte[])this.buffer.clone() : null);
            that.checksum = (byte[])(this.checksum != null ? (byte[])this.checksum.clone() : null);
            that.mdBuffer = (byte[])(this.mdBuffer != null ? (byte[])this.mdBuffer.clone() : null);
            that.bufferIndex = this.bufferIndex;
            that.bufferLeft = this.bufferLeft;
            that.session = this.session;
            that.initObject = this.initObject;
            if (debug != null) {
                debug.exit(16384L, (Object)className, "clone");
            }
            return that;
        }
        catch (CloneNotSupportedException e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "clone", (Throwable)e);
            }
            return that;
        }
    }
}

